/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.metrics;

import com.github.wnameless.json.unflattener.JsonUnflattener;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.opensearch.observability.metrics.BasicCounter;
import org.opensearch.observability.metrics.Counter;
import org.opensearch.observability.metrics.RollingCounter;
import org.opensearch.observability.model.ObservabilityObjectType;
import org.opensearch.observability.util.HelpersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b@\b\u0086\u0001\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002CDB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bB\u00a8\u0006E"}, d2={"Lorg/opensearch/observability/metrics/Metrics;", "", "metricName", "", "counter", "Lorg/opensearch/observability/metrics/Counter;", "(Ljava/lang/String;ILjava/lang/String;Lorg/opensearch/observability/metrics/Counter;)V", "getCounter", "()Lorg/opensearch/observability/metrics/Counter;", "getMetricName", "()Ljava/lang/String;", "REQUEST_TOTAL", "REQUEST_INTERVAL_COUNT", "REQUEST_SUCCESS", "REQUEST_USER_ERROR", "REQUEST_SYSTEM_ERROR", "OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION", "OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR", "OBSERVABILITY_CREATE_TOTAL", "OBSERVABILITY_CREATE_INTERVAL_COUNT", "OBSERVABILITY_CREATE_USER_ERROR", "OBSERVABILITY_CREATE_SYSTEM_ERROR", "OBSERVABILITY_GET_TOTAL", "OBSERVABILITY_GET_INTERVAL_COUNT", "OBSERVABILITY_GET_USER_ERROR", "OBSERVABILITY_GET_SYSTEM_ERROR", "OBSERVABILITY_UPDATE_TOTAL", "OBSERVABILITY_UPDATE_INTERVAL_COUNT", "OBSERVABILITY_UPDATE_USER_ERROR", "OBSERVABILITY_UPDATE_SYSTEM_ERROR", "OBSERVABILITY_DELETE_TOTAL", "OBSERVABILITY_DELETE_INTERVAL_COUNT", "OBSERVABILITY_DELETE_USER_ERROR", "OBSERVABILITY_DELETE_SYSTEM_ERROR", "NOTEBOOK_CREATE_TOTAL", "NOTEBOOK_CREATE_INTERVAL_COUNT", "NOTEBOOK_UPDATE_TOTAL", "NOTEBOOK_UPDATE_INTERVAL_COUNT", "SAVED_QUERY_CREATE_TOTAL", "SAVED_QUERY_CREATE_INTERVAL_COUNT", "SAVED_QUERY_UPDATE_TOTAL", "SAVED_QUERY_UPDATE_INTERVAL_COUNT", "SAVED_VISUALIZATION_CREATE_TOTAL", "SAVED_VISUALIZATION_CREATE_INTERVAL_COUNT", "SAVED_VISUALIZATION_UPDATE_TOTAL", "SAVED_VISUALIZATION_UPDATE_INTERVAL_COUNT", "OPERATIONAL_PANEL_CREATE_TOTAL", "OPERATIONAL_PANEL_CREATE_INTERVAL_COUNT", "OPERATIONAL_PANEL_UPDATE_TOTAL", "OPERATIONAL_PANEL_UPDATE_INTERVAL_COUNT", "APPLICATION_CREATE_TOTAL", "APPLICATION_CREATE_INTERVAL_COUNT", "APPLICATION_UPDATE_TOTAL", "APPLICATION_UPDATE_INTERVAL_COUNT", "TIMESTAMP_CREATE_TOTAL", "TIMESTAMP_CREATE_INTERVAL_COUNT", "TIMESTAMP_UPDATE_TOTAL", "TIMESTAMP_UPDATE_INTERVAL_COUNT", "OBSERVABILITY_SECURITY_PERMISSION_ERROR", "OBSERVABILITY_PERMISSION_USER_ERROR", "Action", "Companion", "opensearch-observability"})
public final class Metrics
extends Enum<Metrics> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String metricName;
    @NotNull
    private final Counter<?> counter;
    @NotNull
    private static final Lazy<Logger> log$delegate;
    @NotNull
    private static final Metrics[] values;
    public static final /* enum */ Metrics REQUEST_TOTAL;
    public static final /* enum */ Metrics REQUEST_INTERVAL_COUNT;
    public static final /* enum */ Metrics REQUEST_SUCCESS;
    public static final /* enum */ Metrics REQUEST_USER_ERROR;
    public static final /* enum */ Metrics REQUEST_SYSTEM_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION;
    public static final /* enum */ Metrics OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_CREATE_TOTAL;
    public static final /* enum */ Metrics OBSERVABILITY_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OBSERVABILITY_CREATE_USER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_CREATE_SYSTEM_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_GET_TOTAL;
    public static final /* enum */ Metrics OBSERVABILITY_GET_INTERVAL_COUNT;
    public static final /* enum */ Metrics OBSERVABILITY_GET_USER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_GET_SYSTEM_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_UPDATE_TOTAL;
    public static final /* enum */ Metrics OBSERVABILITY_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OBSERVABILITY_UPDATE_USER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_UPDATE_SYSTEM_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_DELETE_TOTAL;
    public static final /* enum */ Metrics OBSERVABILITY_DELETE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OBSERVABILITY_DELETE_USER_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_DELETE_SYSTEM_ERROR;
    public static final /* enum */ Metrics NOTEBOOK_CREATE_TOTAL;
    public static final /* enum */ Metrics NOTEBOOK_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics NOTEBOOK_UPDATE_TOTAL;
    public static final /* enum */ Metrics NOTEBOOK_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics SAVED_QUERY_CREATE_TOTAL;
    public static final /* enum */ Metrics SAVED_QUERY_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics SAVED_QUERY_UPDATE_TOTAL;
    public static final /* enum */ Metrics SAVED_QUERY_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics SAVED_VISUALIZATION_CREATE_TOTAL;
    public static final /* enum */ Metrics SAVED_VISUALIZATION_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics SAVED_VISUALIZATION_UPDATE_TOTAL;
    public static final /* enum */ Metrics SAVED_VISUALIZATION_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OPERATIONAL_PANEL_CREATE_TOTAL;
    public static final /* enum */ Metrics OPERATIONAL_PANEL_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OPERATIONAL_PANEL_UPDATE_TOTAL;
    public static final /* enum */ Metrics OPERATIONAL_PANEL_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics APPLICATION_CREATE_TOTAL;
    public static final /* enum */ Metrics APPLICATION_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics APPLICATION_UPDATE_TOTAL;
    public static final /* enum */ Metrics APPLICATION_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics TIMESTAMP_CREATE_TOTAL;
    public static final /* enum */ Metrics TIMESTAMP_CREATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics TIMESTAMP_UPDATE_TOTAL;
    public static final /* enum */ Metrics TIMESTAMP_UPDATE_INTERVAL_COUNT;
    public static final /* enum */ Metrics OBSERVABILITY_SECURITY_PERMISSION_ERROR;
    public static final /* enum */ Metrics OBSERVABILITY_PERMISSION_USER_ERROR;
    private static final /* synthetic */ Metrics[] $VALUES;

    private Metrics(String metricName, Counter<?> counter) {
        this.metricName = metricName;
        this.counter = counter;
    }

    @NotNull
    public final String getMetricName() {
        return this.metricName;
    }

    @NotNull
    public final Counter<?> getCounter() {
        return this.counter;
    }

    public static Metrics[] values() {
        return (Metrics[])$VALUES.clone();
    }

    public static Metrics valueOf(String value) {
        return Enum.valueOf(Metrics.class, value);
    }

    static {
        REQUEST_TOTAL = new Metrics("request_total", new BasicCounter());
        REQUEST_INTERVAL_COUNT = new Metrics("request_count", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_SUCCESS = new Metrics("success_count", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_USER_ERROR = new Metrics("failed_request_count_user_error", new RollingCounter(0L, 0L, null, 7, null));
        REQUEST_SYSTEM_ERROR = new Metrics("failed_request_count_system_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION = new Metrics("exception.opensearch_status", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION = new Metrics("exception.opensearch_security", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION = new Metrics("exception.version_conflict_engine", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION = new Metrics("exception.index_not_found", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION = new Metrics("exception.invalid_index_name", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION = new Metrics("exception.illegal_argument", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION = new Metrics("exception.illegal_state", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION = new Metrics("exception.io", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR = new Metrics("exception.internal_server_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_CREATE_TOTAL = new Metrics("observability.create.total", new BasicCounter());
        OBSERVABILITY_CREATE_INTERVAL_COUNT = new Metrics("observability.create.count", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_CREATE_USER_ERROR = new Metrics("observability.create.user_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_CREATE_SYSTEM_ERROR = new Metrics("observability.create.system_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_GET_TOTAL = new Metrics("observability.get.total", new BasicCounter());
        OBSERVABILITY_GET_INTERVAL_COUNT = new Metrics("observability.get.count", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_GET_USER_ERROR = new Metrics("observability.get.user_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_GET_SYSTEM_ERROR = new Metrics("observability.get.system_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_UPDATE_TOTAL = new Metrics("observability.update.total", new BasicCounter());
        OBSERVABILITY_UPDATE_INTERVAL_COUNT = new Metrics("observability.update.count", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_UPDATE_USER_ERROR = new Metrics("observability.update.user_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_UPDATE_SYSTEM_ERROR = new Metrics("observability.update.system_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_DELETE_TOTAL = new Metrics("observability.delete.total", new BasicCounter());
        OBSERVABILITY_DELETE_INTERVAL_COUNT = new Metrics("observability.delete.count", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_DELETE_USER_ERROR = new Metrics("observability.delete.user_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_DELETE_SYSTEM_ERROR = new Metrics("observability.delete.system_error", new RollingCounter(0L, 0L, null, 7, null));
        NOTEBOOK_CREATE_TOTAL = new Metrics("notebook.create.total", new BasicCounter());
        NOTEBOOK_CREATE_INTERVAL_COUNT = new Metrics("notebook.create.count", new RollingCounter(0L, 0L, null, 7, null));
        NOTEBOOK_UPDATE_TOTAL = new Metrics("notebook.update.total", new BasicCounter());
        NOTEBOOK_UPDATE_INTERVAL_COUNT = new Metrics("notebook.update.count", new RollingCounter(0L, 0L, null, 7, null));
        SAVED_QUERY_CREATE_TOTAL = new Metrics("saved_query.create.total", new BasicCounter());
        SAVED_QUERY_CREATE_INTERVAL_COUNT = new Metrics("saved_query.create.count", new RollingCounter(0L, 0L, null, 7, null));
        SAVED_QUERY_UPDATE_TOTAL = new Metrics("saved_query.update.total", new BasicCounter());
        SAVED_QUERY_UPDATE_INTERVAL_COUNT = new Metrics("saved_query.update.count", new RollingCounter(0L, 0L, null, 7, null));
        SAVED_VISUALIZATION_CREATE_TOTAL = new Metrics("saved_visualization.create.total", new BasicCounter());
        SAVED_VISUALIZATION_CREATE_INTERVAL_COUNT = new Metrics("saved_visualization.create.count", new RollingCounter(0L, 0L, null, 7, null));
        SAVED_VISUALIZATION_UPDATE_TOTAL = new Metrics("saved_visualization.update.total", new BasicCounter());
        SAVED_VISUALIZATION_UPDATE_INTERVAL_COUNT = new Metrics("saved_visualization.update.count", new RollingCounter(0L, 0L, null, 7, null));
        OPERATIONAL_PANEL_CREATE_TOTAL = new Metrics("operational_panel.create.total", new BasicCounter());
        OPERATIONAL_PANEL_CREATE_INTERVAL_COUNT = new Metrics("operational_panel.create.count", new RollingCounter(0L, 0L, null, 7, null));
        OPERATIONAL_PANEL_UPDATE_TOTAL = new Metrics("operational_panel.update.total", new BasicCounter());
        OPERATIONAL_PANEL_UPDATE_INTERVAL_COUNT = new Metrics("operational_panel.update.count", new RollingCounter(0L, 0L, null, 7, null));
        APPLICATION_CREATE_TOTAL = new Metrics("application.create.total", new BasicCounter());
        APPLICATION_CREATE_INTERVAL_COUNT = new Metrics("application.create.count", new RollingCounter(0L, 0L, null, 7, null));
        APPLICATION_UPDATE_TOTAL = new Metrics("application.update.total", new BasicCounter());
        APPLICATION_UPDATE_INTERVAL_COUNT = new Metrics("application.update.count", new RollingCounter(0L, 0L, null, 7, null));
        TIMESTAMP_CREATE_TOTAL = new Metrics("timestamp.create.total", new BasicCounter());
        TIMESTAMP_CREATE_INTERVAL_COUNT = new Metrics("timestamp.create.count", new RollingCounter(0L, 0L, null, 7, null));
        TIMESTAMP_UPDATE_TOTAL = new Metrics("timestamp.update.total", new BasicCounter());
        TIMESTAMP_UPDATE_INTERVAL_COUNT = new Metrics("timestamp.update.count", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_SECURITY_PERMISSION_ERROR = new Metrics("security_permission_error", new RollingCounter(0L, 0L, null, 7, null));
        OBSERVABILITY_PERMISSION_USER_ERROR = new Metrics("permission_user_error", new RollingCounter(0L, 0L, null, 7, null));
        $VALUES = metricsArray = new Metrics[]{Metrics.REQUEST_TOTAL, Metrics.REQUEST_INTERVAL_COUNT, Metrics.REQUEST_SUCCESS, Metrics.REQUEST_USER_ERROR, Metrics.REQUEST_SYSTEM_ERROR, Metrics.OBSERVABILITY_EXCEPTIONS_OPENSEARCH_STATUS_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_OPENSEARCH_SECURITY_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_IO_EXCEPTION, Metrics.OBSERVABILITY_EXCEPTIONS_INTERNAL_SERVER_ERROR, Metrics.OBSERVABILITY_CREATE_TOTAL, Metrics.OBSERVABILITY_CREATE_INTERVAL_COUNT, Metrics.OBSERVABILITY_CREATE_USER_ERROR, Metrics.OBSERVABILITY_CREATE_SYSTEM_ERROR, Metrics.OBSERVABILITY_GET_TOTAL, Metrics.OBSERVABILITY_GET_INTERVAL_COUNT, Metrics.OBSERVABILITY_GET_USER_ERROR, Metrics.OBSERVABILITY_GET_SYSTEM_ERROR, Metrics.OBSERVABILITY_UPDATE_TOTAL, Metrics.OBSERVABILITY_UPDATE_INTERVAL_COUNT, Metrics.OBSERVABILITY_UPDATE_USER_ERROR, Metrics.OBSERVABILITY_UPDATE_SYSTEM_ERROR, Metrics.OBSERVABILITY_DELETE_TOTAL, Metrics.OBSERVABILITY_DELETE_INTERVAL_COUNT, Metrics.OBSERVABILITY_DELETE_USER_ERROR, Metrics.OBSERVABILITY_DELETE_SYSTEM_ERROR, Metrics.NOTEBOOK_CREATE_TOTAL, Metrics.NOTEBOOK_CREATE_INTERVAL_COUNT, Metrics.NOTEBOOK_UPDATE_TOTAL, Metrics.NOTEBOOK_UPDATE_INTERVAL_COUNT, Metrics.SAVED_QUERY_CREATE_TOTAL, Metrics.SAVED_QUERY_CREATE_INTERVAL_COUNT, Metrics.SAVED_QUERY_UPDATE_TOTAL, Metrics.SAVED_QUERY_UPDATE_INTERVAL_COUNT, Metrics.SAVED_VISUALIZATION_CREATE_TOTAL, Metrics.SAVED_VISUALIZATION_CREATE_INTERVAL_COUNT, Metrics.SAVED_VISUALIZATION_UPDATE_TOTAL, Metrics.SAVED_VISUALIZATION_UPDATE_INTERVAL_COUNT, Metrics.OPERATIONAL_PANEL_CREATE_TOTAL, Metrics.OPERATIONAL_PANEL_CREATE_INTERVAL_COUNT, Metrics.OPERATIONAL_PANEL_UPDATE_TOTAL, Metrics.OPERATIONAL_PANEL_UPDATE_INTERVAL_COUNT, Metrics.APPLICATION_CREATE_TOTAL, Metrics.APPLICATION_CREATE_INTERVAL_COUNT, Metrics.APPLICATION_UPDATE_TOTAL, Metrics.APPLICATION_UPDATE_INTERVAL_COUNT, Metrics.TIMESTAMP_CREATE_TOTAL, Metrics.TIMESTAMP_CREATE_INTERVAL_COUNT, Metrics.TIMESTAMP_UPDATE_TOTAL, Metrics.TIMESTAMP_UPDATE_INTERVAL_COUNT, Metrics.OBSERVABILITY_SECURITY_PERMISSION_ERROR, Metrics.OBSERVABILITY_PERMISSION_USER_ERROR};
        Companion = new Companion(null);
        log$delegate = HelpersKt.logger(Metrics.class);
        values = Metrics.values();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/observability/metrics/Metrics$Action;", "", "(Ljava/lang/String;I)V", "CREATE", "UPDATE", "opensearch-observability"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action CREATE = new Action();
        public static final /* enum */ Action UPDATE = new Action();
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        static {
            $VALUES = actionArray = new Action[]{Action.CREATE, Action.UPDATE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/observability/metrics/Metrics$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "values", "", "Lorg/opensearch/observability/metrics/Metrics;", "[Lorg/opensearch/observability/metrics/Metrics;", "collectToFlattenedJSON", "", "collectToJSON", "incrementObservabilityObjectActionCounter", "", "type", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "action", "Lorg/opensearch/observability/metrics/Metrics$Action;", "opensearch-observability"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final String collectToJSON() {
            JSONObject metricsJSONObject = new JSONObject();
            for (Metrics metric : values) {
                metricsJSONObject.put(metric.getMetricName(), metric.getCounter().getValue());
            }
            String string = metricsJSONObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metricsJSONObject.toString()");
            return string;
        }

        @NotNull
        public final String collectToFlattenedJSON() {
            String string = JsonUnflattener.unflatten((String)this.collectToJSON());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unflatten(collectToJSON())");
            return string;
        }

        public final void incrementObservabilityObjectActionCounter(@NotNull ObservabilityObjectType type, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            try {
                Metrics.valueOf(type.name() + "_" + action.name() + "_TOTAL").getCounter().increment();
                Metrics.valueOf(type.name() + "_" + action.name() + "_INTERVAL_COUNT").getCounter().increment();
            }
            catch (IllegalArgumentException e) {
                this.getLog().warn("observability:IllegalArgumentException invalid type or action for counter metric", (Throwable)e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

