/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api;

public class Resources {

    public static enum State {
        HEALTHY("healthy"),
        UNHEALTHY("unhealthy"),
        CONTENDED("contended"),
        STARVED("starved"),
        UNKNOWN("unknown");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String HEALTHY_VALUE = "healthy";
            public static final String UNHEALTHY_VALUE = "unhealthy";
            public static final String CONTENDED_VALUE = "contended";
            public static final String STARVED_VALUE = "starved";
            public static final String UNKOWN_VALUE = "unknown";
        }
    }

    public static enum OpenSearch implements ResourceType
    {
        INDEXES("indexes"),
        SHARDS("shards"),
        QUEUES("queues"),
        LOCKS("locks"),
        THREADS("threads");

        private final String value;

        private OpenSearch(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEXES_VALUE = "indexes";
            public static final String SHARDS_VALUE = "shards";
            public static final String QUEUES_VALUE = "queues";
            public static final String LOCKS_VALUE = "locks";
            public static final String THREADS_VALUE = "threads";
        }
    }

    public static enum JVM implements ResourceType
    {
        HEAP("heap"),
        GARBAGE_COLLECTOR("garbage collector"),
        CODE("code"),
        JIT("JIT"),
        OLD_GEN("old generation"),
        YOUNG_GEN("young generation");

        private final String value;

        private JVM(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String HEAP_VALUE = "heap";
            public static final String GC_VALUE = "garbage collector";
            public static final String CODE_VALUE = "code";
            public static final String JIT_VALUE = "JIT";
            public static final String OLD_GEN_VALUE = "old generation";
            public static final String YOUNG_GEN_VALUE = "young generation";
        }
    }

    public static enum OS implements ResourceType
    {
        SCHEDULER("scheduler"),
        MEMORY_MANAGER("memory manager");

        private final String value;

        private OS(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String SCHEDULER_VALUE = "scheduler";
            public static final String MM_VALUE = "memory manager";
        }
    }

    public static enum Hardware implements ResourceType
    {
        CPU("cpu"),
        MEMORY("memory"),
        DISKS("disk"),
        NICS("nic");

        private final String value;

        private Hardware(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CPU_VALUE = "cpu";
            public static final String MEMORY_VALUE = "memory";
            public static final String DISKS_VALUE = "disk";
            public static final String NICS_VALUE = "nic";
        }
    }

    public static enum Network implements ResourceType
    {
        TCP("TCP");

        private final String value;

        private Network(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String TCP_VALUE = "TCP";
        }
    }

    public static interface ResourceType {
    }
}

