/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hot_node;

import java.util.function.Predicate;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.store.rca.hot_node.ThreadMetricsSlidingWindow;

public class ThreadAnalysis {
    private final ThreadMetricsSlidingWindow blockedTimeWindow;
    private final ThreadMetricsSlidingWindow waitedTimeWindow;
    private final Predicate<String> typeFilter;
    private final RcaRuntimeMetrics blockedThreadCountMetric;
    private final RcaRuntimeMetrics waitedThreadCountMetric;
    private final RcaRuntimeMetrics maxBlockedTimeMetric;
    private final RcaRuntimeMetrics maxWaitedTimeMetric;

    public ThreadAnalysis(Predicate<String> typeFilter, RcaRuntimeMetrics blockedThreadCountMetric, RcaRuntimeMetrics waitedThreadCount, RcaRuntimeMetrics maxBlockedTime, RcaRuntimeMetrics maxWaitedTimeMetric) {
        this.typeFilter = typeFilter;
        this.blockedThreadCountMetric = blockedThreadCountMetric;
        this.waitedThreadCountMetric = waitedThreadCount;
        this.maxBlockedTimeMetric = maxBlockedTime;
        this.maxWaitedTimeMetric = maxWaitedTimeMetric;
        this.blockedTimeWindow = new ThreadMetricsSlidingWindow();
        this.waitedTimeWindow = new ThreadMetricsSlidingWindow();
    }

    public ThreadMetricsSlidingWindow getBlockedTimeWindow() {
        return this.blockedTimeWindow;
    }

    public ThreadMetricsSlidingWindow getWaitedTimeWindow() {
        return this.waitedTimeWindow;
    }

    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    public RcaRuntimeMetrics getBlockedThreadCountMetric() {
        return this.blockedThreadCountMetric;
    }

    public RcaRuntimeMetrics getWaitedThreadCountMetric() {
        return this.waitedThreadCountMetric;
    }

    public RcaRuntimeMetrics getMaxBlockedTimeMetric() {
        return this.maxBlockedTimeMetric;
    }

    public RcaRuntimeMetrics getMaxWaitedTimeMetric() {
        return this.maxWaitedTimeMetric;
    }
}

