/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statement;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.session.SessionId;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.StateModel;
import org.opensearch.sql.spark.rest.model.LangType;

public class StatementModel
extends StateModel {
    public static final String VERSION = "version";
    public static final String TYPE = "type";
    public static final String STATEMENT_STATE = "state";
    public static final String STATEMENT_ID = "statementId";
    public static final String SESSION_ID = "sessionId";
    public static final String LANG = "lang";
    public static final String QUERY = "query";
    public static final String QUERY_ID = "queryId";
    public static final String SUBMIT_TIME = "submitTime";
    public static final String ERROR = "error";
    public static final String UNKNOWN = "";
    public static final String STATEMENT_DOC_TYPE = "statement";
    private final String version;
    private final StatementState statementState;
    private final StatementId statementId;
    private final SessionId sessionId;
    private final String applicationId;
    private final String jobId;
    private final LangType langType;
    private final String datasourceName;
    private final String query;
    private final String queryId;
    private final long submitTime;
    private final String error;
    private final long seqNo;
    private final long primaryTerm;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(VERSION, this.version).field(TYPE, STATEMENT_DOC_TYPE).field(STATEMENT_STATE, this.statementState.getState()).field(STATEMENT_ID, this.statementId.getId()).field(SESSION_ID, this.sessionId.getSessionId()).field("applicationId", this.applicationId).field("jobId", this.jobId).field(LANG, this.langType.getText()).field("dataSourceName", this.datasourceName).field(QUERY, this.query).field(QUERY_ID, this.queryId).field(SUBMIT_TIME, this.submitTime).field(ERROR, this.error).endObject();
        return builder;
    }

    public static StatementModel copy(StatementModel copy, long seqNo, long primaryTerm) {
        return StatementModel.builder().version("1.0").statementState(copy.statementState).statementId(copy.statementId).sessionId(copy.sessionId).applicationId(copy.applicationId).jobId(copy.jobId).langType(copy.langType).datasourceName(copy.datasourceName).query(copy.query).queryId(copy.queryId).submitTime(copy.submitTime).error(copy.error).seqNo(seqNo).primaryTerm(primaryTerm).build();
    }

    public static StatementModel copyWithState(StatementModel copy, StatementState state, long seqNo, long primaryTerm) {
        return StatementModel.builder().version("1.0").statementState(state).statementId(copy.statementId).sessionId(copy.sessionId).applicationId(copy.applicationId).jobId(copy.jobId).langType(copy.langType).datasourceName(copy.datasourceName).query(copy.query).queryId(copy.queryId).submitTime(copy.submitTime).error(copy.error).seqNo(seqNo).primaryTerm(primaryTerm).build();
    }

    public static StatementModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        StatementModelBuilder builder = StatementModel.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "version": {
                    builder.version(parser.text());
                    break;
                }
                case "type": {
                    break;
                }
                case "state": {
                    builder.statementState(StatementState.fromString(parser.text()));
                    break;
                }
                case "statementId": {
                    builder.statementId(new StatementId(parser.text()));
                    break;
                }
                case "sessionId": {
                    builder.sessionId(new SessionId(parser.text()));
                    break;
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    break;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    break;
                }
                case "lang": {
                    builder.langType(LangType.fromString(parser.text()));
                    break;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    break;
                }
                case "query": {
                    builder.query(parser.text());
                    break;
                }
                case "queryId": {
                    builder.queryId(parser.text());
                    break;
                }
                case "submitTime": {
                    builder.submitTime(parser.longValue());
                    break;
                }
                case "error": {
                    builder.error(parser.text());
                }
            }
        }
        builder.seqNo(seqNo);
        builder.primaryTerm(primaryTerm);
        return builder.build();
    }

    public static StatementModel submitStatement(SessionId sid, String applicationId, String jobId, StatementId statementId, LangType langType, String datasourceName, String query, String queryId) {
        return StatementModel.builder().version("1.0").statementState(StatementState.WAITING).statementId(statementId).sessionId(sid).applicationId(applicationId).jobId(jobId).langType(langType).datasourceName(datasourceName).query(query).queryId(queryId).submitTime(System.currentTimeMillis()).error(UNKNOWN).seqNo(-2L).primaryTerm(0L).build();
    }

    @Override
    public String getId() {
        return this.statementId.getId();
    }

    @Generated
    StatementModel(String version, StatementState statementState, StatementId statementId, SessionId sessionId, String applicationId, String jobId, LangType langType, String datasourceName, String query, String queryId, long submitTime, String error, long seqNo, long primaryTerm) {
        this.version = version;
        this.statementState = statementState;
        this.statementId = statementId;
        this.sessionId = sessionId;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.langType = langType;
        this.datasourceName = datasourceName;
        this.query = query;
        this.queryId = queryId;
        this.submitTime = submitTime;
        this.error = error;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    @Generated
    public static StatementModelBuilder builder() {
        return new StatementModelBuilder();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public StatementState getStatementState() {
        return this.statementState;
    }

    @Generated
    public StatementId getStatementId() {
        return this.statementId;
    }

    @Generated
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public LangType getLangType() {
        return this.langType;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public long getSubmitTime() {
        return this.submitTime;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Override
    @Generated
    public long getSeqNo() {
        return this.seqNo;
    }

    @Override
    @Generated
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatementModel)) {
            return false;
        }
        StatementModel other = (StatementModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubmitTime() != other.getSubmitTime()) {
            return false;
        }
        if (this.getSeqNo() != other.getSeqNo()) {
            return false;
        }
        if (this.getPrimaryTerm() != other.getPrimaryTerm()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        StatementState this$statementState = this.getStatementState();
        StatementState other$statementState = other.getStatementState();
        if (this$statementState == null ? other$statementState != null : !((Object)((Object)this$statementState)).equals((Object)other$statementState)) {
            return false;
        }
        StatementId this$statementId = this.getStatementId();
        StatementId other$statementId = other.getStatementId();
        if (this$statementId == null ? other$statementId != null : !((Object)this$statementId).equals(other$statementId)) {
            return false;
        }
        SessionId this$sessionId = this.getSessionId();
        SessionId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        LangType this$langType = this.getLangType();
        LangType other$langType = other.getLangType();
        if (this$langType == null ? other$langType != null : !((Object)((Object)this$langType)).equals((Object)other$langType)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatementModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $submitTime = this.getSubmitTime();
        result = result * 59 + (int)($submitTime >>> 32 ^ $submitTime);
        long $seqNo = this.getSeqNo();
        result = result * 59 + (int)($seqNo >>> 32 ^ $seqNo);
        long $primaryTerm = this.getPrimaryTerm();
        result = result * 59 + (int)($primaryTerm >>> 32 ^ $primaryTerm);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        StatementState $statementState = this.getStatementState();
        result = result * 59 + ($statementState == null ? 43 : ((Object)((Object)$statementState)).hashCode());
        StatementId $statementId = this.getStatementId();
        result = result * 59 + ($statementId == null ? 43 : ((Object)$statementId).hashCode());
        SessionId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        LangType $langType = this.getLangType();
        result = result * 59 + ($langType == null ? 43 : ((Object)((Object)$langType)).hashCode());
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StatementModel(version=" + this.getVersion() + ", statementState=" + this.getStatementState() + ", statementId=" + this.getStatementId() + ", sessionId=" + this.getSessionId() + ", applicationId=" + this.getApplicationId() + ", jobId=" + this.getJobId() + ", langType=" + this.getLangType() + ", datasourceName=" + this.getDatasourceName() + ", query=" + this.getQuery() + ", queryId=" + this.getQueryId() + ", submitTime=" + this.getSubmitTime() + ", error=" + this.getError() + ", seqNo=" + this.getSeqNo() + ", primaryTerm=" + this.getPrimaryTerm() + ")";
    }

    @Generated
    public static class StatementModelBuilder {
        @Generated
        private String version;
        @Generated
        private StatementState statementState;
        @Generated
        private StatementId statementId;
        @Generated
        private SessionId sessionId;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private LangType langType;
        @Generated
        private String datasourceName;
        @Generated
        private String query;
        @Generated
        private String queryId;
        @Generated
        private long submitTime;
        @Generated
        private String error;
        @Generated
        private long seqNo;
        @Generated
        private long primaryTerm;

        @Generated
        StatementModelBuilder() {
        }

        @Generated
        public StatementModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public StatementModelBuilder statementState(StatementState statementState) {
            this.statementState = statementState;
            return this;
        }

        @Generated
        public StatementModelBuilder statementId(StatementId statementId) {
            this.statementId = statementId;
            return this;
        }

        @Generated
        public StatementModelBuilder sessionId(SessionId sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public StatementModelBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public StatementModelBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public StatementModelBuilder langType(LangType langType) {
            this.langType = langType;
            return this;
        }

        @Generated
        public StatementModelBuilder datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        @Generated
        public StatementModelBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public StatementModelBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        public StatementModelBuilder submitTime(long submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        @Generated
        public StatementModelBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public StatementModelBuilder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        @Generated
        public StatementModelBuilder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        @Generated
        public StatementModel build() {
            return new StatementModel(this.version, this.statementState, this.statementId, this.sessionId, this.applicationId, this.jobId, this.langType, this.datasourceName, this.query, this.queryId, this.submitTime, this.error, this.seqNo, this.primaryTerm);
        }

        @Generated
        public String toString() {
            return "StatementModel.StatementModelBuilder(version=" + this.version + ", statementState=" + this.statementState + ", statementId=" + this.statementId + ", sessionId=" + this.sessionId + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", langType=" + this.langType + ", datasourceName=" + this.datasourceName + ", query=" + this.query + ", queryId=" + this.queryId + ", submitTime=" + this.submitTime + ", error=" + this.error + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ")";
        }
    }
}

