/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalSleep;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Sleep;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;

public class Drowsy
extends Buff {
    public static final float DURATION = 5.0f;

    public Drowsy() {
        this.type = Buff.buffType.NEUTRAL;
        this.announced = true;
    }

    @Override
    public int icon() {
        return 29;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (5.0f - this.visualcooldown()) / 5.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.visualcooldown());
    }

    @Override
    public boolean attachTo(Char target) {
        if (!target.isImmune(Sleep.class) && super.attachTo(target)) {
            if (this.cooldown() == 0.0f) {
                this.spend(5.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean act() {
        Buff.affect(this.target, MagicalSleep.class);
        this.detach();
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
    }
}

