/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Timer;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.host.Host;

public abstract class ApplicationFinder {
    private static final int DEFAULT_TIMEOUT = Integer.getInteger("visualvm.search.process.timeout", 5000);
    private final int pid;
    private final String id;
    private final Host host;
    private final int timeout;

    public ApplicationFinder(int pid) {
        this(pid, null);
    }

    public ApplicationFinder(String id) {
        this(-1, id);
    }

    public ApplicationFinder(int pid, String id) {
        this(pid, id, Host.LOCALHOST, DEFAULT_TIMEOUT);
    }

    public ApplicationFinder(int pid, String id, Host host, int timeout) {
        this.pid = pid;
        this.id = id;
        this.host = host;
        this.timeout = timeout;
    }

    public abstract void found(Application var1);

    public void notFound(int pid, String id) {
    }

    public final void find() {
        if (this.timeout <= 0) {
            this.findImmediately();
        } else {
            new FindLater().find();
        }
    }

    private void findImmediately() {
        Application application = ApplicationFinder.findInSet(this.pid, this.id, this.host.getRepository().getDataSources(Application.class));
        if (application != null) {
            this.found(application);
        } else {
            this.notFound(this.pid, this.id);
        }
    }

    private static Application findInSet(int pid, String id, Set<Application> applications) {
        for (Application application : applications) {
            String args;
            Jvm jvm;
            if (pid != -1 && application.getPid() == pid) {
                return application;
            }
            if (id == null || !(jvm = JvmFactory.getJVMFor(application)).isBasicInfoSupported() || (args = jvm.getJvmArgs()) == null || !args.contains(id)) continue;
            return application;
        }
        return null;
    }

    private class FindLater
    implements DataChangeListener<Application>,
    ActionListener {
        private volatile boolean removed;
        private final Timer timer;

        FindLater() {
            this.timer = new Timer(ApplicationFinder.this.timeout, this);
        }

        synchronized void find() {
            this.removed = false;
            this.timer.start();
            ApplicationFinder.this.host.getRepository().addDataChangeListener((DataChangeListener)this, Application.class);
        }

        public synchronized void dataChanged(DataChangeEvent<Application> event) {
            Application application;
            Set applications = event.getAdded();
            if (applications.isEmpty()) {
                applications = event.getCurrent();
            }
            if ((application = ApplicationFinder.findInSet(ApplicationFinder.this.pid, ApplicationFinder.this.id, applications)) != null) {
                if (!this.removed) {
                    this.cleanup();
                    this.timer.stop();
                }
                ApplicationFinder.this.found(application);
            }
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (!this.removed) {
                this.cleanup();
                ApplicationFinder.this.notFound(ApplicationFinder.this.pid, ApplicationFinder.this.id);
            }
        }

        private void cleanup() {
            ApplicationFinder.this.host.getRepository().removeDataChangeListener((DataChangeListener)this);
            this.removed = true;
        }
    }
}

