"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    monitorService
  } = services;
  router.get({
    path: '/api/alerting/monitors',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        state: _configSchema.schema.string(),
        monitorIds: _configSchema.schema.maybe(_configSchema.schema.any())
      })
    }
  }, monitorService.getMonitors);
  router.post({
    path: '/api/alerting/monitors/_search',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.searchMonitors);
  router.post({
    path: '/api/alerting/monitors',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.createMonitor);
  router.post({
    path: '/api/alerting/workflows',
    validate: {
      body: _configSchema.schema.any()
    }
  }, monitorService.createWorkflow);
  router.post({
    path: '/api/alerting/monitors/_execute',
    validate: {
      query: _configSchema.schema.object({
        dryrun: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.executeMonitor);
  router.get({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, monitorService.getWorkflow);
  router.get({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, monitorService.getMonitor);
  router.put({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.put({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ifSeqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        ifPrimaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.updateMonitor);
  router.delete({
    path: '/api/alerting/monitors/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteMonitor);
  router.delete({
    path: '/api/alerting/workflows/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        version: _configSchema.schema.number()
      })
    }
  }, monitorService.deleteWorkflow);
  router.post({
    path: '/api/alerting/monitors/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.acknowledgeAlerts);
  router.post({
    path: '/api/alerting/workflows/{id}/_acknowledge/alerts',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, monitorService.acknowledgeChainedAlerts);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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