"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_ALERTS_SORT_FILTERS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const GET_ALERTS_SORT_FILTERS = exports.GET_ALERTS_SORT_FILTERS = {
  MONITOR_NAME: 'monitor_name',
  TRIGGER_NAME: 'trigger_name',
  START_TIME: 'start_time',
  END_TIME: 'end_time',
  ACKNOWLEDGE_TIME: 'acknowledged_time'
};
class AlertService {
  constructor(esDriver) {
    _defineProperty(this, "getAlerts", async (context, req, res) => {
      const {
        from = 0,
        size = 20,
        search = '',
        sortDirection = 'desc',
        sortField = GET_ALERTS_SORT_FILTERS.START_TIME,
        severityLevel = 'ALL',
        alertState = 'ALL',
        monitorIds = [],
        monitorType = 'monitor'
      } = req.query;
      var params;
      switch (sortField) {
        case GET_ALERTS_SORT_FILTERS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.TRIGGER_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_ALERTS_SORT_FILTERS.END_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: sortDirection === 'asc' ? '_last' : '_first'
          };
          break;
        case GET_ALERTS_SORT_FILTERS.ACKNOWLEDGE_TIME:
          params = {
            sortString: sortField,
            sortOrder: sortDirection,
            missing: '_last'
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_ALERTS_SORT_FILTERS.START_TIME,
            sortOrder: sortDirection
          };
      }
      params.startIndex = from;
      params.size = size;
      params.severityLevel = severityLevel;
      params.alertState = alertState;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      if (monitorIds.length > 0) {
        const idField = monitorType === 'composite' ? 'workflowIds' : 'monitorId';
        params[idField] = !Array.isArray(monitorIds) ? monitorIds : monitorIds[0];
      }
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);
      try {
        const resp = await callAsCurrentUser('alerting.getAlerts', params);
        const alerts = resp.alerts.map(hit => {
          const alert = hit;
          const id = hit.alert_id;
          const version = hit.alert_version;
          return {
            id,
            ...alert,
            version,
            alert_source: !!alert.workflow_id ? 'workflow' : 'monitor'
          };
        });
        const totalAlerts = resp.totalAlerts;
        return res.ok({
          body: {
            ok: true,
            alerts,
            totalAlerts
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    _defineProperty(this, "getWorkflowAlerts", async (context, req, res) => {
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);
      try {
        const resp = await callAsCurrentUser('alerting.getWorkflowAlerts', req.query);
        return res.ok({
          body: {
            ok: true,
            resp
          }
        });
      } catch (err) {
        console.error(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
    this.esDriver = esDriver;
  }
}
exports.default = AlertService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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