/// <reference types="node" />
import { Zh, Ota, KeyValueAny } from '../types';
export declare const upgradeFileIdentifier: Buffer;
type IsNewImageAvailable = (current: Ota.ImageInfo, device: Zh.Device, getImageMeta: Ota.GetImageMeta) => Promise<{
    available: number;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
type DownloadImage = (meta: Ota.ImageMeta) => Promise<{
    data: Buffer;
}>;
type GetNewImage = (current: Ota.Version, device: Zh.Device, getImageMeta: Ota.GetImageMeta, downloadImage: DownloadImage, suppressElementImageParseFailure: boolean) => Promise<Ota.Image>;
/**
 * Helper functions
 */
export declare const setDataDir: (dir: string) => void;
export declare function isValidUrl(url: string): boolean;
export declare function readLocalFile(fileName: string): Buffer;
export declare function getFirmwareFile(image: KeyValueAny): Promise<import("axios").AxiosResponse<any, any> | {
    data: Buffer;
}>;
export declare function processCustomCaBundle(uri: string): Promise<string[]>;
export declare function getOverrideIndexFile(urlOrName: string): Promise<any>;
export declare function parseImage(buffer: Buffer, suppressElementImageParseFailure?: boolean): Ota.Image;
export declare function isUpdateAvailable(device: Zh.Device, requestPayload: Ota.ImageInfo, isNewImageAvailable?: IsNewImageAvailable, getImageMeta?: Ota.GetImageMeta): Promise<{
    available: boolean;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
export declare function isNewImageAvailable(current: Ota.ImageInfo, device: Zh.Device, getImageMeta: Ota.GetImageMeta): Promise<{
    available: number;
    currentFileVersion: number;
    otaFileVersion: number;
}>;
export declare function updateToLatest(device: Zh.Device, onProgress: Ota.OnProgress, getNewImage: GetNewImage, getImageMeta?: Ota.GetImageMeta, downloadImage?: DownloadImage, suppressElementImageParseFailure?: boolean): Promise<number>;
export declare function getNewImage(current: Ota.ImageInfo, device: Zh.Device, getImageMeta: Ota.GetImageMeta, downloadImage: DownloadImage, suppressElementImageParseFailure: boolean): Promise<Ota.Image>;
export declare function getAxios(caBundle?: string[]): import("axios").AxiosInstance;
export {};
//# sourceMappingURL=common.d.ts.map