/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import sun.net.NetProperties;
import sun.util.logging.PlatformLogger;

public class HttpCapture {
    private File file = null;
    private boolean incoming = true;
    private BufferedWriter out = null;
    private static boolean initialized = false;
    private static volatile ArrayList<Pattern> patterns = null;
    private static volatile ArrayList<String> capFiles = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void init() {
        initialized = true;
        String rulesFile = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return NetProperties.get("sun.net.http.captureRules");
            }
        });
        if (rulesFile != null && !rulesFile.isEmpty()) {
            BufferedReader in;
            try {
                in = new BufferedReader(new FileReader(rulesFile));
            }
            catch (FileNotFoundException ex) {
                return;
            }
            try {
                String line = in.readLine();
                while (line != null) {
                    String[] s;
                    if (!(line = line.trim()).startsWith("#") && (s = line.split(",")).length == 2) {
                        if (patterns == null) {
                            patterns = new ArrayList();
                            capFiles = new ArrayList();
                        }
                        patterns.add(Pattern.compile(s[0].trim()));
                        capFiles.add(s[1].trim());
                    }
                    line = in.readLine();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static synchronized boolean isInitialized() {
        return initialized;
    }

    private HttpCapture(File f, URL url) {
        this.file = f;
        try {
            this.out = new BufferedWriter(new FileWriter(this.file, true));
            this.out.write("URL: " + url + "\n");
        }
        catch (IOException ex) {
            PlatformLogger.getLogger(HttpCapture.class.getName()).severe(null, ex);
        }
    }

    public synchronized void sent(int c) throws IOException {
        if (this.incoming) {
            this.out.write("\n------>\n");
            this.incoming = false;
            this.out.flush();
        }
        this.out.write(c);
    }

    public synchronized void received(int c) throws IOException {
        if (!this.incoming) {
            this.out.write("\n<------\n");
            this.incoming = true;
            this.out.flush();
        }
        this.out.write(c);
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public static HttpCapture getCapture(URL url) {
        if (!HttpCapture.isInitialized()) {
            HttpCapture.init();
        }
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        String s = url.toString();
        for (int i = 0; i < patterns.size(); ++i) {
            File fi;
            Pattern p = patterns.get(i);
            if (!p.matcher(s).find()) continue;
            String f = capFiles.get(i);
            if (f.indexOf("%d") >= 0) {
                String f2;
                Random rand = new Random();
                while ((fi = new File(f2 = f.replace("%d", Integer.toString(rand.nextInt())))).exists()) {
                }
            } else {
                fi = new File(f);
            }
            return new HttpCapture(fi, url);
        }
        return null;
    }
}

