/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class HomeFurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private TextureChoiceController textureController;
    private ModelMaterialsController modelMaterialsController;
    private DialogView homeFurnitureView;
    private Content icon;
    private String name;
    private String description;
    private Map<ObjectProperty, Object> additionalProperties;
    private boolean priceEditable;
    private BigDecimal price;
    private boolean valueAddedTaxPercentageEditable;
    private BigDecimal valueAddedTaxPercentage;
    private Boolean nameVisible;
    private Float x;
    private Float y;
    private Float elevation;
    private Integer angleInDegrees;
    private Float angle;
    private boolean rollAndPitchEditable;
    private Float roll;
    private Float pitch;
    private FurnitureHorizontalAxis horizontalAxis;
    private Float width;
    private Float proportionalWidth;
    private Float depth;
    private Float proportionalDepth;
    private Float height;
    private Float proportionalHeight;
    private boolean proportional;
    private Transformation[] modelTransformations;
    private List<String> modelPresetTransformationsNames;
    private List<Transformation[]> modelPresetTransformations;
    private Integer color;
    private FurniturePaint paint;
    private FurnitureShininess shininess;
    private Boolean visible;
    private Boolean modelMirrored;
    private Boolean basePlanItem;
    private boolean basePlanItemEnabled;
    private boolean lightPowerEditable;
    private Float lightPower;
    private boolean resizable;
    private boolean deformable;
    private boolean widthDepthDeformable;
    private boolean texturable;
    private boolean visibleEditable;
    private boolean doorOrWindow;
    private float wallThickness;
    private float wallDistance;
    private float wallWidth;
    private float wallLeft;
    private float wallHeight;
    private float wallTop;
    private Sash[] sashes;

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this(home, userPreferences, viewFactory, null, undoableEditSupport);
    }

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getTextureController() {
        if (this.textureController == null) {
            this.textureController = new TextureChoiceController(this.preferences.getLocalizedString(HomeFurnitureController.class, "textureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.textureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.TEXTURED);
                }
            });
        }
        return this.textureController;
    }

    public ModelMaterialsController getModelMaterialsController() {
        if (this.modelMaterialsController == null) {
            this.modelMaterialsController = new ModelMaterialsController(this.preferences.getLocalizedString(HomeFurnitureController.class, "modelMaterialsTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.modelMaterialsController.addPropertyChangeListener(ModelMaterialsController.Property.MATERIALS, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.MODEL_MATERIALS);
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeFurnitureController.this.getWidth() != null && HomeFurnitureController.this.getDepth() != null && HomeFurnitureController.this.getHeight() != null) {
                        HomeFurnitureController.this.modelMaterialsController.setModelSize(HomeFurnitureController.this.getWidth().floatValue(), HomeFurnitureController.this.getDepth().floatValue(), HomeFurnitureController.this.getHeight().floatValue());
                    }
                }
            };
            this.addPropertyChangeListener(Property.WIDTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.DEPTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.HEIGHT, propertyChangeListener);
            this.addPropertyChangeListener(Property.MODEL_TRANSFORMATIONS, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeFurnitureController.this.getModelTransformations() != null) {
                        HomeFurnitureController.this.modelMaterialsController.setModelTransformations(HomeFurnitureController.this.getModelTransformations());
                    }
                }
            });
        }
        return this.modelMaterialsController;
    }

    @Override
    public DialogView getView() {
        if (this.homeFurnitureView == null) {
            this.homeFurnitureView = this.viewFactory.createHomeFurnitureView(this.preferences, this);
        }
        return this.homeFurnitureView;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateProperties() {
        List<HomePieceOfFurniture> list = Home.getFurnitureSubList(this.home.getSelectedItems());
        TextureChoiceController textureChoiceController = this.getTextureController();
        ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
        if (list.isEmpty()) {
            this.setIcon(null);
            this.setName(null);
            this.setNameVisible(null);
            this.setDescription(null);
            this.setAdditionalProperties(null);
            this.setPrice(null, false);
            this.priceEditable = false;
            this.setValueAddedTaxPercentage(null);
            this.valueAddedTaxPercentageEditable = false;
            this.setX(null);
            this.setY(null);
            this.setElevation(null);
            this.basePlanItemEnabled = false;
            this.setAngleInDegrees(null);
            this.setRoll(null);
            this.setPitch(null);
            this.setHorizontalAxis(null);
            this.rollAndPitchEditable = false;
            this.setWidth(null, true, false, false);
            this.setDepth(null, true, false, false);
            this.setHeight(null, true, false);
            this.setColor(null);
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(null);
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials(null);
                modelMaterialsController.setModel(null);
                modelMaterialsController.setModelCreator(null);
            }
            this.setPaint(null);
            this.setModelTransformations(null);
            this.modelPresetTransformationsNames = Collections.emptyList();
            this.modelPresetTransformations = Collections.emptyList();
            this.doorOrWindow = false;
            this.wallThickness = 1.0f;
            this.wallDistance = 0.0f;
            this.wallWidth = 1.0f;
            this.wallLeft = 0.0f;
            this.wallHeight = 1.0f;
            this.wallTop = 0.0f;
            this.sashes = new Sash[0];
            this.setShininess(null);
            this.visibleEditable = false;
            this.setVisible(null);
            this.setModelMirrored(null);
            this.lightPowerEditable = false;
            this.setLightPower(null);
            this.setResizable(true);
            this.setDeformable(true);
            this.setTexturable(true);
            this.setProportional(false);
        } else {
            HomePieceOfFurniture homePieceOfFurniture;
            int n;
            int n2;
            boolean bl;
            void var34_75;
            int n3;
            int n4;
            String[] stringArray;
            Object object;
            Object object2;
            int n5;
            int n6;
            Serializable serializable;
            int n7;
            int n8;
            void var11_28;
            void var11_25;
            Object object3;
            boolean bl2;
            HomePieceOfFurniture homePieceOfFurniture2 = list.get(0);
            Content content = homePieceOfFurniture2.getIcon();
            if (content != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (content.equals(list.get(i).getIcon())) continue;
                    content = null;
                    break;
                }
            }
            this.setIcon(content);
            String string = homePieceOfFurniture2.getName();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getName())) continue;
                    string = null;
                    break;
                }
            }
            this.setName(string);
            Boolean bl22 = homePieceOfFurniture2.isNameVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl22.booleanValue() == list.get(i).isNameVisible()) continue;
                bl22 = null;
                break;
            }
            this.setNameVisible(bl22);
            String string2 = homePieceOfFurniture2.getDescription();
            if (string2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string2.equals(list.get(i).getDescription())) continue;
                    string2 = null;
                    break;
                }
            }
            this.setDescription(string2);
            if (list.size() == 1) {
                LinkedHashMap<ObjectProperty, Object> linkedHashMap = new LinkedHashMap<ObjectProperty, Object>();
                for (ObjectProperty serializable2 : this.home.getFurnitureAdditionalProperties()) {
                    String string3 = serializable2.getName();
                    if (!serializable2.isModifiable()) continue;
                    linkedHashMap.put(serializable2, homePieceOfFurniture2.isContentProperty(string3) ? homePieceOfFurniture2.getContentProperty(string3) : homePieceOfFurniture2.getProperty(string3));
                }
                this.setAdditionalProperties(linkedHashMap.size() > 0 ? linkedHashMap : null);
            } else {
                this.setAdditionalProperties(null);
            }
            boolean bl3 = bl2 = this.preferences.getCurrency() != null;
            if (bl2) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof HomeFurnitureGroup)) continue;
                    bl2 = false;
                    break;
                }
            }
            this.priceEditable = bl2;
            if (bl2) {
                void var11_22;
                object3 = homePieceOfFurniture2.getPrice();
                if (object3 != null) {
                    boolean i = true;
                    while (i < list.size()) {
                        if (!((BigDecimal)object3).equals(list.get((int)i).getPrice())) {
                            object3 = null;
                            break;
                        }
                        ++i;
                    }
                }
                this.setPrice((BigDecimal)object3, false);
                this.valueAddedTaxPercentageEditable = this.preferences.isValueAddedTaxEnabled();
                BigDecimal f = homePieceOfFurniture2.getValueAddedTaxPercentage();
                if (f != null) {
                    for (int i = 1; i < list.size(); ++i) {
                        if (f.equals(list.get(i).getValueAddedTaxPercentage())) continue;
                        Object var11_21 = null;
                        break;
                    }
                }
                this.setValueAddedTaxPercentage((BigDecimal)var11_22);
            } else {
                this.setPrice(null, false);
                this.setValueAddedTaxPercentage(null);
                this.valueAddedTaxPercentageEditable = false;
            }
            object3 = Float.valueOf(homePieceOfFurniture2.getX());
            boolean bl4 = true;
            while (var11_25 < list.size()) {
                if (((Float)object3).floatValue() != list.get((int)var11_25).getX()) {
                    object3 = null;
                    break;
                }
                ++var11_25;
            }
            this.setX((Float)object3);
            Float f = Float.valueOf(homePieceOfFurniture2.getY());
            for (int i = 1; i < list.size(); ++i) {
                if (f.floatValue() == list.get(i).getY()) continue;
                Object var11_27 = null;
                break;
            }
            this.setY((Float)var11_28);
            Float f2 = Float.valueOf(homePieceOfFurniture2.getElevation());
            for (n8 = 1; n8 < list.size(); ++n8) {
                if (f2.floatValue() == list.get(n8).getElevation()) continue;
                f2 = null;
                break;
            }
            this.setElevation(f2);
            n8 = !homePieceOfFurniture2.isDoorOrWindow() ? 1 : 0;
            for (int i = 1; n8 == 0 && i < list.size(); ++i) {
                if (list.get(i).isDoorOrWindow()) continue;
                n8 = 1;
            }
            this.basePlanItemEnabled = n8;
            Boolean bl5 = !homePieceOfFurniture2.isMovable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl5 == !list.get(i).isMovable()) continue;
                bl5 = null;
                break;
            }
            this.setBasePlanItem(bl5);
            Float f3 = Float.valueOf(homePieceOfFurniture2.getAngle());
            for (n7 = 1; n7 < list.size(); ++n7) {
                if (f3.floatValue() == list.get(n7).getAngle()) continue;
                f3 = null;
                break;
            }
            this.setAngle(f3);
            n7 = 1;
            for (int i = 0; n7 != 0 && i < list.size(); ++i) {
                serializable = list.get(i);
                n7 = ((HomePieceOfFurniture)serializable).isHorizontallyRotatable() && ((HomePieceOfFurniture)serializable).getStaircaseCutOutShape() == null ? 1 : 0;
            }
            this.rollAndPitchEditable = n7;
            if (this.rollAndPitchEditable) {
                Float f4 = Float.valueOf(homePieceOfFurniture2.getRoll());
                for (int i = 1; i < list.size(); ++i) {
                    if (f4.floatValue() == list.get(i).getRoll()) continue;
                    f4 = null;
                    break;
                }
                this.setRoll(f4);
                serializable = Float.valueOf(homePieceOfFurniture2.getPitch());
                for (n6 = 1; n6 < list.size(); ++n6) {
                    if (((Float)serializable).floatValue() == list.get(n6).getPitch()) continue;
                    serializable = null;
                    break;
                }
                this.setPitch((Float)serializable);
                if (f4 == null && serializable == null || f4 != null && f4.floatValue() != 0.0f && serializable != null && ((Float)serializable).floatValue() != 0.0f || f4 != null && f4.floatValue() == 0.0f && serializable != null && ((Float)serializable).floatValue() == 0.0f) {
                    this.setHorizontalAxis(null);
                } else if (f4 == null && serializable != null && ((Float)serializable).floatValue() == 0.0f || f4 != null && f4.floatValue() != 0.0f) {
                    this.setHorizontalAxis(FurnitureHorizontalAxis.ROLL);
                } else {
                    this.setHorizontalAxis(FurnitureHorizontalAxis.PITCH);
                }
            } else {
                this.setRoll(null);
                this.setPitch(null);
                this.setHorizontalAxis(null);
            }
            Float f5 = Float.valueOf(homePieceOfFurniture2.getWidth());
            for (int i = 1; i < list.size(); ++i) {
                if (f5.floatValue() == list.get(i).getWidth()) continue;
                f5 = null;
                break;
            }
            this.setWidth(f5, true, false, false);
            Float f6 = Float.valueOf(homePieceOfFurniture2.getDepth());
            for (n6 = 1; n6 < list.size(); ++n6) {
                if (f6.floatValue() == list.get(n6).getDepth()) continue;
                f6 = null;
                break;
            }
            this.setDepth(f6, true, false, false);
            Float f7 = Float.valueOf(homePieceOfFurniture2.getHeight());
            for (int i = 1; i < list.size(); ++i) {
                if (f7.floatValue() == list.get(i).getHeight()) continue;
                f7 = null;
                break;
            }
            this.setHeight(f7, true, false);
            List<HomePieceOfFurniture> list2 = this.getFurnitureWithoutGroups(list);
            HomePieceOfFurniture homePieceOfFurniture3 = list2.get(0);
            Integer n9 = homePieceOfFurniture3.getColor();
            if (n9 != null) {
                for (int i = 1; i < list2.size(); ++i) {
                    if (n9.equals(list2.get(i).getColor())) continue;
                    n9 = null;
                    break;
                }
            }
            this.setColor(n9);
            HomeTexture homeTexture = homePieceOfFurniture3.getTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list2.size(); ++i) {
                    if (homeTexture.equals(list2.get(i).getTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(homeTexture);
            }
            Object[] objectArray = homePieceOfFurniture3.getModelMaterials();
            Content content2 = homePieceOfFurniture3.getModel();
            String string4 = homePieceOfFurniture3.getCreator();
            if (content2 != null) {
                for (n5 = 1; n5 < list2.size(); ++n5) {
                    HomePieceOfFurniture homePieceOfFurniture4 = list2.get(n5);
                    if (Arrays.equals(objectArray, homePieceOfFurniture4.getModelMaterials()) && content2 == homePieceOfFurniture4.getModel()) continue;
                    objectArray = null;
                    content2 = null;
                    string4 = null;
                    break;
                }
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials((HomeMaterial[])objectArray);
                modelMaterialsController.setModel(content2);
                modelMaterialsController.setModelCreator(string4);
                modelMaterialsController.setModelSize(homePieceOfFurniture3.getWidth(), homePieceOfFurniture3.getDepth(), homePieceOfFurniture3.getHeight());
                modelMaterialsController.setModelRotation(homePieceOfFurniture3.getModelRotation());
                modelMaterialsController.setModelTransformations(homePieceOfFurniture3.getModelTransformations());
                modelMaterialsController.setModelFlags(homePieceOfFurniture3.getModelFlags());
            }
            n5 = 1;
            for (int i = 0; i < list2.size(); ++i) {
                object2 = list2.get(i);
                if (((HomePieceOfFurniture)object2).getColor() == null && ((HomePieceOfFurniture)object2).getTexture() == null && ((HomePieceOfFurniture)object2).getModelMaterials() == null) continue;
                n5 = 0;
                break;
            }
            if (n9 != null) {
                this.setPaint(FurniturePaint.COLORED);
            } else if (homeTexture != null) {
                this.setPaint(FurniturePaint.TEXTURED);
            } else if (objectArray != null) {
                this.setPaint(FurniturePaint.MODEL_MATERIALS);
            } else if (n5 != 0) {
                this.setPaint(FurniturePaint.DEFAULT);
            } else {
                this.setPaint(null);
            }
            Transformation[] transformationArray = homePieceOfFurniture2.getModelTransformations();
            if (list.size() != 1 || homePieceOfFurniture2 instanceof HomeFurnitureGroup) {
                transformationArray = null;
            } else {
                if (transformationArray == null) {
                    transformationArray = new Transformation[]{};
                }
                if (homePieceOfFurniture2 instanceof HomeDoorOrWindow) {
                    object2 = (HomeDoorOrWindow)homePieceOfFurniture2;
                    this.doorOrWindow = true;
                    this.wallThickness = ((HomeDoorOrWindow)object2).getWallThickness();
                    this.wallDistance = ((HomeDoorOrWindow)object2).getWallDistance();
                    this.wallWidth = ((HomeDoorOrWindow)object2).getWallWidth();
                    this.wallLeft = ((HomeDoorOrWindow)object2).getWallLeft();
                    this.wallHeight = ((HomeDoorOrWindow)object2).getWallHeight();
                    this.wallTop = ((HomeDoorOrWindow)object2).getWallTop();
                    this.sashes = ((HomeDoorOrWindow)object2).getSashes();
                }
            }
            this.setModelTransformations(transformationArray);
            this.modelPresetTransformationsNames = new ArrayList<String>();
            this.modelPresetTransformations = new ArrayList<Transformation[]>();
            if (list.size() == 1 && !(homePieceOfFurniture2 instanceof HomeFurnitureGroup) && homePieceOfFurniture2.getCatalogId() != null && (object2 = this.preferences.getFurnitureCatalog().getPieceOfFurnitureWithId(homePieceOfFurniture2.getCatalogId())) != null) {
                int n10 = 1;
                String string5 = ((CatalogPieceOfFurniture)object2).getProperty("modelPresetTransformationsName_" + n10);
                while (string5 != null) {
                    object = ((CatalogPieceOfFurniture)object2).getProperty("modelPresetTransformations_" + n10);
                    if (object != null && (stringArray = ((String)object).trim().split("\\s+")).length % 13 == 0) {
                        Transformation[] transformationArray2 = new Transformation[stringArray.length / 13];
                        try {
                            for (n4 = 0; n4 < stringArray.length; n4 += 12) {
                                String string6 = stringArray[n4++];
                                float[][] fArrayArray = new float[][]{{Float.parseFloat(stringArray[n4 + 0]), Float.parseFloat(stringArray[n4 + 1]), Float.parseFloat(stringArray[n4 + 2]), Float.parseFloat(stringArray[n4 + 3])}, {Float.parseFloat(stringArray[n4 + 4]), Float.parseFloat(stringArray[n4 + 5]), Float.parseFloat(stringArray[n4 + 6]), Float.parseFloat(stringArray[n4 + 7])}, {Float.parseFloat(stringArray[n4 + 8]), Float.parseFloat(stringArray[n4 + 9]), Float.parseFloat(stringArray[n4 + 10]), Float.parseFloat(stringArray[n4 + 11])}};
                                transformationArray2[n4 / 13] = new Transformation(string6, fArrayArray);
                            }
                            this.modelPresetTransformationsNames.add(string5);
                            this.modelPresetTransformations.add(transformationArray2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("Invalid value in preset transformations matrices for " + homePieceOfFurniture2.getCatalogId() + "\n" + numberFormatException);
                        }
                    }
                    string5 = ((CatalogPieceOfFurniture)object2).getProperty("modelPresetTransformationsName_" + ++n10);
                }
            }
            FurnitureShininess furnitureShininess = (object2 = homePieceOfFurniture3.getShininess()) == null ? FurnitureShininess.DEFAULT : (((Float)object2).floatValue() == 0.0f ? FurnitureShininess.MATT : FurnitureShininess.SHINY);
            for (n3 = 1; n3 < list2.size(); ++n3) {
                object = list2.get(n3);
                if (object2 == ((HomePieceOfFurniture)object).getShininess() && (object2 == null || ((Float)object2).equals(((HomePieceOfFurniture)object).getShininess()))) continue;
                furnitureShininess = null;
                break;
            }
            this.setShininess(furnitureShininess);
            n3 = 1;
            object = this.home.getFurniture();
            for (HomePieceOfFurniture homePieceOfFurniture5 : list) {
                if (object.contains(homePieceOfFurniture5)) continue;
                n3 = 0;
                break;
            }
            this.visibleEditable = n3;
            if (n3 != 0) {
                void var34_73;
                stringArray = homePieceOfFurniture2.isVisible();
                boolean bl6 = true;
                while (var34_73 < list.size()) {
                    if (stringArray.booleanValue() != list.get((int)var34_73).isVisible()) {
                        stringArray = null;
                        break;
                    }
                    ++var34_73;
                }
                this.setVisible((Boolean)stringArray);
            } else {
                this.setVisible(null);
            }
            stringArray = homePieceOfFurniture2.isModelMirrored();
            boolean bl7 = true;
            while (var34_75 < list.size()) {
                if (stringArray.booleanValue() != list.get((int)var34_75).isModelMirrored()) {
                    stringArray = null;
                    break;
                }
                ++var34_75;
            }
            this.setModelMirrored((Boolean)stringArray);
            boolean bl8 = homePieceOfFurniture2 instanceof HomeLight;
            for (n4 = 1; bl && n4 < list.size(); ++n4) {
                bl = list.get(n4) instanceof HomeLight;
            }
            this.lightPowerEditable = bl;
            if (bl) {
                Float f8 = Float.valueOf(((HomeLight)homePieceOfFurniture2).getPower());
                for (int i = 1; i < list.size(); ++i) {
                    if (f8.floatValue() == ((HomeLight)list.get(i)).getPower()) continue;
                    f8 = null;
                    break;
                }
                this.setLightPower(f8);
            } else {
                this.setLightPower(null);
            }
            Boolean bl9 = homePieceOfFurniture2.isResizable();
            for (n2 = 1; n2 < list.size(); n2 += 1) {
                if (bl9.booleanValue() == list.get(n2).isResizable()) continue;
                bl9 = null;
                break;
            }
            this.setResizable(bl9 != null && bl9 != false);
            n2 = 1;
            block35: for (n = 0; n2 && n < list.size(); ++n) {
                homePieceOfFurniture = list.get(n);
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    for (HomePieceOfFurniture homePieceOfFurniture6 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                        if (homePieceOfFurniture6.isDeformable() && !homePieceOfFurniture6.isHorizontallyRotated() && homePieceOfFurniture6.getModelTransformations() == null) continue;
                        n2 = 0;
                        continue block35;
                    }
                    continue;
                }
                n2 = homePieceOfFurniture.isDeformable() && homePieceOfFurniture.getModelTransformations() == null ? 1 : 0;
            }
            this.setDeformable(n2 != 0);
            if (!this.isDeformable()) {
                this.setProportional(true);
            }
            this.widthDepthDeformable = true;
            for (n = 0; this.widthDepthDeformable && n < list.size(); ++n) {
                homePieceOfFurniture = list.get(n);
                this.widthDepthDeformable = homePieceOfFurniture.isWidthDepthDeformable();
            }
            Boolean bl10 = homePieceOfFurniture2.isTexturable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl10.booleanValue() == list.get(i).isTexturable()) continue;
                bl10 = null;
                break;
            }
            this.setTexturable(bl10 == null || bl10 != false);
        }
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getFurnitureWithoutGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public boolean isPropertyEditable(Property property) {
        switch (property.ordinal()) {
            case 4: {
                return this.getAdditionalProperties() != null;
            }
            case 5: {
                return this.isPriceEditable();
            }
            case 6: {
                return this.isValueAddedTaxPercentageEditable();
            }
            case 13: 
            case 14: {
                return this.isRollAndPitchEditable();
            }
            case 25: {
                return this.getModelTransformations() != null;
            }
            case 26: {
                return this.isLightPowerEditable();
            }
            case 23: {
                return this.visibleEditable;
            }
        }
        return true;
    }

    private void setIcon(Content content) {
        if (content != this.icon) {
            Content content2 = this.icon;
            this.icon = content;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), content2, content);
        }
    }

    public Content getIcon() {
        return this.icon;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setNameVisible(Boolean bl) {
        if (bl != this.nameVisible) {
            Boolean bl2 = this.nameVisible;
            this.nameVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getNameVisible() {
        return this.nameVisible;
    }

    public void setDescription(String string) {
        if (string != this.description) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setAdditionalProperties(Map<ObjectProperty, Object> map) {
        if (!(map == this.additionalProperties || map != null && map.equals(this.additionalProperties))) {
            Map<ObjectProperty, Object> map2 = this.additionalProperties;
            this.additionalProperties = map != null ? new LinkedHashMap<ObjectProperty, Object>(map) : null;
            this.propertyChangeSupport.firePropertyChange(Property.ADDITIONAL_PROPERTIES.name(), map2, map);
        }
    }

    public Map<ObjectProperty, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setPrice(BigDecimal bigDecimal) {
        this.setPrice(bigDecimal, true);
    }

    private void setPrice(BigDecimal bigDecimal, boolean bl) {
        if (!(bigDecimal == this.price || bigDecimal != null && bigDecimal.equals(this.price))) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.PRICE.name(), bigDecimal2, bigDecimal);
            if (bl && bigDecimal != null && this.isValueAddedTaxPercentageEditable() && this.getValueAddedTaxPercentage() == null && Home.getFurnitureSubList(this.home.getSelectedItems()).size() == 1) {
                this.setValueAddedTaxPercentage(this.preferences.getDefaultValueAddedTaxPercentage());
            }
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public boolean isPriceEditable() {
        return this.priceEditable;
    }

    public void setValueAddedTaxPercentage(BigDecimal bigDecimal) {
        if (!(bigDecimal == this.valueAddedTaxPercentage || bigDecimal != null && bigDecimal.equals(this.valueAddedTaxPercentage))) {
            BigDecimal bigDecimal2 = this.valueAddedTaxPercentage;
            this.valueAddedTaxPercentage = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.VALUE_ADDED_TAX_PERCENTAGE.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getValueAddedTaxPercentage() {
        return this.valueAddedTaxPercentage;
    }

    public boolean isValueAddedTaxPercentageEditable() {
        return this.valueAddedTaxPercentageEditable;
    }

    public void setX(Float f) {
        if (f != this.x) {
            Float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), f2, f);
        }
    }

    public Float getX() {
        return this.x;
    }

    public void setY(Float f) {
        if (f != this.y) {
            Float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), f2, f);
        }
    }

    public Float getY() {
        return this.y;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setAngleInDegrees(Integer n) {
        this.setAngleInDegrees(n, true);
    }

    private void setAngleInDegrees(Integer n, boolean bl) {
        if (n != this.angleInDegrees) {
            Integer n2 = this.angleInDegrees;
            this.angleInDegrees = n;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE_IN_DEGREES.name(), n2, n);
            if (bl) {
                if (this.angleInDegrees == null) {
                    this.setAngle(null, false);
                } else {
                    this.setAngle(new Float(Math.toRadians(this.angleInDegrees.intValue())), false);
                }
            }
        }
    }

    public Integer getAngleInDegrees() {
        return this.angleInDegrees;
    }

    public void setAngle(Float f) {
        this.setAngle(f, true);
    }

    public void setAngle(Float f, boolean bl) {
        if (f != this.angle) {
            Float f2 = this.angle;
            this.angle = f;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE.name(), f2, f);
            if (bl) {
                if (f == null) {
                    this.setAngleInDegrees(null, false);
                } else {
                    this.setAngleInDegrees((int)(Math.round(Math.toDegrees(f.floatValue())) + 360L) % 360, false);
                }
            }
        }
    }

    public Float getAngle() {
        return this.angle;
    }

    public boolean isRollAndPitchEditable() {
        return this.rollAndPitchEditable;
    }

    public void setRoll(Float f) {
        if (f != this.roll) {
            Float f2 = this.roll;
            this.roll = f;
            this.propertyChangeSupport.firePropertyChange(Property.ROLL.name(), f2, f);
        }
    }

    public Float getRoll() {
        return this.roll;
    }

    public void setPitch(Float f) {
        if (f != this.pitch) {
            Float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), f2, f);
        }
    }

    public Float getPitch() {
        return this.pitch;
    }

    public void setHorizontalAxis(FurnitureHorizontalAxis furnitureHorizontalAxis) {
        if (furnitureHorizontalAxis != this.horizontalAxis) {
            FurnitureHorizontalAxis furnitureHorizontalAxis2 = this.horizontalAxis;
            this.horizontalAxis = furnitureHorizontalAxis;
            this.propertyChangeSupport.firePropertyChange(Property.HORIZONTAL_AXIS.name(), (Object)furnitureHorizontalAxis2, (Object)furnitureHorizontalAxis);
        }
    }

    public FurnitureHorizontalAxis getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public boolean isBasePlanItemEnabled() {
        return this.basePlanItemEnabled;
    }

    public boolean isBasePlanItemEditable() {
        return this.basePlanItemEnabled;
    }

    public void setBasePlanItem(Boolean bl) {
        if (bl != this.basePlanItem) {
            Boolean bl2 = this.basePlanItem;
            this.basePlanItem = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_ITEM.name(), bl2, bl);
        }
    }

    public Boolean getBasePlanItem() {
        return this.basePlanItem;
    }

    public void setWidth(Float f) {
        this.setWidth(f, false, this.isProportional() || !this.widthDepthDeformable, this.isProportional());
    }

    private void setWidth(Float f, boolean bl, boolean bl2, boolean bl3) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 == null && this.width != null || f2 != null && !f2.equals(this.width)) {
            Float f4 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), f4, f2);
            if (f4 != null && f2 != null) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (bl2 && this.proportionalDepth != null) {
                    this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false, false);
                }
                if (bl3 && this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            } else {
                if (bl2) {
                    this.setDepth(null, false, false, false);
                }
                if (bl3) {
                    this.setHeight(null, false, false);
                }
            }
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public void setDepth(Float f) {
        this.setDepth(f, false, this.isProportional() || !this.widthDepthDeformable, this.isProportional());
    }

    private void setDepth(Float f, boolean bl, boolean bl2, boolean bl3) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 == null && this.depth != null || f2 != null && !f2.equals(this.depth)) {
            Float f4 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), f4, f2);
            if (f4 != null && f2 != null) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (bl2 && this.proportionalWidth != null) {
                    this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false, false);
                }
                if (bl3 && this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            } else {
                if (bl2) {
                    this.setWidth(null, false, false, false);
                }
                if (bl3) {
                    this.setHeight(null, false, false);
                }
            }
        }
    }

    public Float getDepth() {
        return this.depth;
    }

    public void setHeight(Float f) {
        this.setHeight(f, false, this.isProportional());
    }

    private void setHeight(Float f, boolean bl, boolean bl2) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 == null && this.height != null || f2 != null && !f2.equals(this.height)) {
            Float f4 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f4, f2);
            if (bl2) {
                if (f4 != null && f2 != null) {
                    float f5 = f2.floatValue() / f4.floatValue();
                    if (this.proportionalWidth != null) {
                        this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false, false);
                    }
                    if (this.proportionalDepth != null) {
                        this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false, false);
                    }
                } else {
                    this.setWidth(null, false, false, false);
                    this.setDepth(null, false, false, false);
                }
            }
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            boolean bl2 = this.proportional;
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), bl2, bl);
        }
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setPaint(FurniturePaint furniturePaint) {
        if (furniturePaint != this.paint) {
            FurniturePaint furniturePaint2 = this.paint;
            this.paint = furniturePaint;
            this.propertyChangeSupport.firePropertyChange(Property.PAINT.name(), (Object)furniturePaint2, (Object)furniturePaint);
        }
    }

    public FurniturePaint getPaint() {
        return this.paint;
    }

    public void setModelTransformations(Transformation[] transformationArray) {
        if (!Arrays.equals(transformationArray, this.modelTransformations)) {
            Transformation[] transformationArray2 = this.modelTransformations;
            this.modelTransformations = transformationArray;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_TRANSFORMATIONS.name(), transformationArray2, transformationArray);
            this.setDeformable(transformationArray == null || transformationArray.length == 0);
            this.setProportional(transformationArray != null && transformationArray.length > 0);
        }
    }

    public void setModelTransformations(Transformation[] transformationArray, float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.doorOrWindow) {
            float f7;
            float f8;
            float f9 = this.getX().floatValue();
            float f10 = this.getY().floatValue();
            float f11 = this.getElevation().floatValue();
            float f12 = this.getWidth().floatValue();
            float f13 = this.getDepth().floatValue();
            float f14 = this.getHeight().floatValue();
            float f15 = -this.getAngle().floatValue();
            float f16 = (float)((double)f9 * Math.cos(f15) - (double)f10 * Math.sin(f15));
            float f17 = (float)((double)f * Math.cos(f15) - (double)f2 * Math.sin(f15));
            float f18 = this.wallLeft * f12;
            float f19 = this.wallWidth * f12;
            if (this.getModelMirrored().booleanValue()) {
                f8 = f18 - f16 - f12 / 2.0f;
                f7 = f8 + f17 + f4 / 2.0f;
            } else {
                f8 = f18 + f16 - f12 / 2.0f;
                f7 = f8 - f17 + f4 / 2.0f;
            }
            f8 = (float)((double)f9 * Math.sin(f15) + (double)f10 * Math.cos(f15));
            float f20 = (float)((double)f * Math.sin(f15) + (double)f2 * Math.cos(f15));
            float f21 = this.wallDistance * f13;
            float f22 = this.wallThickness * f13;
            float f23 = f8 - f13 / 2.0f + f21;
            float f24 = f23 - f20 + f5 / 2.0f;
            float f25 = this.wallTop * f14;
            float f26 = this.wallHeight * f14;
            float f27 = f25 + f3 + f6 - (f11 + f14);
            Sash[] sashArray = this.sashes;
            for (int i = 0; i < sashArray.length; ++i) {
                Sash sash = sashArray[i];
                float f28 = sash.getXAxis() * f12;
                float f29 = sash.getYAxis() * f13;
                sashArray[i] = new Sash((f28 += f7 - f18) / f4, (f29 += f24 - f21) / f5, sash.getWidth() * f12 / f4, sash.getStartAngle(), sash.getEndAngle());
            }
            this.wallThickness = f22 / f5;
            this.wallDistance = f24 / f5;
            this.wallWidth = f19 / f4;
            this.wallLeft = f7 / f4;
            this.wallHeight = f26 / f6;
            this.wallTop = f27 / f6;
            this.sashes = sashArray;
        }
        this.setModelTransformations(transformationArray);
        this.setX(Float.valueOf(f));
        this.setY(Float.valueOf(f2));
        this.setWidth(Float.valueOf(f4), false, false, false);
        this.setDepth(Float.valueOf(f5), false, false, false);
        this.setHeight(Float.valueOf(f6), false, false);
    }

    public Transformation[] getModelTransformations() {
        return this.modelTransformations;
    }

    public List<String> getModelPresetTransformationsNames() {
        return Collections.unmodifiableList(this.modelPresetTransformationsNames);
    }

    public Transformation[] getModelPresetTransformations(int n) {
        return this.modelPresetTransformations.get(n);
    }

    public void setShininess(FurnitureShininess furnitureShininess) {
        if (furnitureShininess != this.shininess) {
            FurnitureShininess furnitureShininess2 = this.shininess;
            this.shininess = furnitureShininess;
            this.propertyChangeSupport.firePropertyChange(Property.SHININESS.name(), (Object)furnitureShininess2, (Object)furnitureShininess);
        }
    }

    public FurnitureShininess getShininess() {
        return this.shininess;
    }

    public void setVisible(Boolean bl) {
        if (bl != this.visible) {
            Boolean bl2 = this.visible;
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setModelMirrored(Boolean bl) {
        if (bl != this.modelMirrored) {
            Boolean bl2 = this.modelMirrored;
            this.modelMirrored = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_MIRRORED.name(), bl2, bl);
        }
    }

    public Boolean getModelMirrored() {
        return this.modelMirrored;
    }

    public boolean isLightPowerEditable() {
        return this.lightPowerEditable;
    }

    public Float getLightPower() {
        return this.lightPower;
    }

    public void setLightPower(Float f) {
        if (f != this.lightPower) {
            Float f2 = this.lightPower;
            this.lightPower = f;
            this.propertyChangeSupport.firePropertyChange(Property.LIGHT_POWER.name(), f2, f);
        }
    }

    private void setResizable(boolean bl) {
        if (bl != this.resizable) {
            boolean bl2 = this.resizable;
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), bl2, bl);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    private void setDeformable(boolean bl) {
        if (bl != this.deformable) {
            boolean bl2 = this.deformable;
            this.deformable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DEFORMABLE.name(), bl2, bl);
        }
    }

    public boolean isDeformable() {
        return this.deformable;
    }

    private void setTexturable(boolean bl) {
        if (bl != this.texturable) {
            boolean bl2 = this.texturable;
            this.texturable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURABLE.name(), bl2, bl);
        }
    }

    public boolean isTexturable() {
        return this.texturable;
    }

    public void modifyFurniture() {
        List<Selectable> list = this.home.getSelectedItems();
        List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
        if (!list2.isEmpty()) {
            boolean bl;
            HashMap<String, Object> hashMap;
            String string = this.getName();
            Boolean bl2 = this.getNameVisible();
            String string2 = this.getDescription();
            Map<ObjectProperty, Object> map = this.getAdditionalProperties();
            if (map == null) {
                hashMap = null;
            } else {
                hashMap = new HashMap<String, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    hashMap.put(((ObjectProperty)entry.getKey()).getName(), entry.getValue());
                }
            }
            BigDecimal bigDecimal = this.getPrice();
            boolean bl3 = list2.size() == 1 && bigDecimal == null;
            BigDecimal bigDecimal2 = this.getValueAddedTaxPercentage();
            boolean bl4 = list2.size() == 1 && bigDecimal2 == null;
            String string3 = this.preferences.getCurrency();
            Float f = this.getX();
            Float f2 = this.getY();
            Float f3 = this.getElevation();
            Float f4 = this.getAngle();
            Float f5 = this.getRoll();
            Float f6 = this.getPitch();
            FurnitureHorizontalAxis furnitureHorizontalAxis = this.getHorizontalAxis();
            Boolean bl5 = this.getBasePlanItem();
            Float f7 = this.getWidth();
            Float f8 = this.getDepth();
            Float f9 = this.getHeight();
            boolean bl6 = this.isProportional() && (f7 == null || f8 == null || f9 == null);
            FurniturePaint furniturePaint = this.getPaint();
            Integer n = furniturePaint == FurniturePaint.COLORED ? this.getColor() : null;
            TextureChoiceController textureChoiceController = this.getTextureController();
            HomeTexture homeTexture = textureChoiceController != null && furniturePaint == FurniturePaint.TEXTURED ? textureChoiceController.getTexture() : null;
            ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
            HomeMaterial[] homeMaterialArray = modelMaterialsController != null && furniturePaint == FurniturePaint.MODEL_MATERIALS ? modelMaterialsController.getMaterials() : null;
            Transformation[] transformationArray = this.getModelTransformations();
            boolean bl7 = bl = this.getShininess() == FurnitureShininess.DEFAULT;
            Float f10 = this.getShininess() == FurnitureShininess.SHINY ? new Float(0.5f) : (this.getShininess() == FurnitureShininess.MATT ? new Float(0.0f) : null);
            Boolean bl8 = this.getVisible();
            Boolean bl9 = this.getModelMirrored();
            Float f11 = this.getLightPower();
            ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray = new ModifiedPieceOfFurniture[list2.size()];
            for (int i = 0; i < modifiedPieceOfFurnitureArray.length; ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list2.get(i);
                modifiedPieceOfFurnitureArray[i] = homePieceOfFurniture instanceof HomeLight ? new ModifiedLight((HomeLight)homePieceOfFurniture) : (homePieceOfFurniture instanceof HomeDoorOrWindow ? new ModifiedDoorOrWindow((HomeDoorOrWindow)homePieceOfFurniture) : (homePieceOfFurniture instanceof HomeFurnitureGroup ? new ModifiedFurnitureGroup((HomeFurnitureGroup)homePieceOfFurniture) : new ModifiedPieceOfFurniture(homePieceOfFurniture)));
            }
            HomeFurnitureController.doModifyFurniture(modifiedPieceOfFurnitureArray, string, bl2, string2, hashMap, bigDecimal, bl3, bigDecimal2, bl4, string3, f, f2, f3, f4, f5, f6, furnitureHorizontalAxis, bl5, f7, f8, f9, bl6, transformationArray, this.wallThickness, this.wallDistance, this.wallWidth, this.wallLeft, this.wallHeight, this.wallTop, this.sashes, furniturePaint, n, homeTexture, homeMaterialArray, bl, f10, bl8, bl9, f11);
            if (this.undoSupport != null) {
                List<Selectable> list3 = this.home.getSelectedItems();
                this.undoSupport.postEdit(new FurnitureModificationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), list3.toArray(new Selectable[list3.size()]), modifiedPieceOfFurnitureArray, string, bl2, string2, hashMap, bigDecimal, bl3, bigDecimal2, bl4, string3, f, f2, f3, f4, f5, f6, furnitureHorizontalAxis, bl5, f7, f8, f9, bl6, transformationArray, this.wallThickness, this.wallDistance, this.wallWidth, this.wallLeft, this.wallHeight, this.wallTop, this.sashes, furniturePaint, n, homeTexture, homeMaterialArray, bl, f10, bl8, bl9, f11));
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureName", string);
            }
            if (string2 != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureDescription", string2);
            }
            if (bigDecimal2 != null) {
                this.preferences.setDefaultValueAddedTaxPercentage(bigDecimal2);
            }
        }
    }

    private static void doModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, Map<String, Object> map, BigDecimal bigDecimal, boolean bl2, BigDecimal bigDecimal2, boolean bl3, String string3, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, FurnitureHorizontalAxis furnitureHorizontalAxis, Boolean bl4, Float f7, Float f8, Float f9, boolean bl5, Transformation[] transformationArray, float f10, float f11, float f12, float f13, float f14, float f15, Sash[] sashArray, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl6, Float f16, Boolean bl7, Boolean bl8, Float f17) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = modifiedPieceOfFurniture.getPieceOfFurniture();
            if (string != null) {
                homePieceOfFurniture.setName(string);
            }
            if (bl != null) {
                homePieceOfFurniture.setNameVisible(bl);
            }
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    homePieceOfFurniture.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if (string2 != null) {
                homePieceOfFurniture.setDescription(string2);
            }
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
                if (bigDecimal != null || bl2) {
                    if (!(bigDecimal == homePieceOfFurniture.getPrice() || bigDecimal != null && bigDecimal.equals(homePieceOfFurniture.getPrice()))) {
                        homePieceOfFurniture.setCurrency(bigDecimal != null ? string3 : null);
                    }
                    if (bigDecimal != null) {
                        try {
                            bigDecimal = bigDecimal.setScale(Currency.getInstance(string3).getDefaultFractionDigits(), RoundingMode.HALF_UP);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    homePieceOfFurniture.setPrice(bigDecimal);
                }
                if (bigDecimal2 != null || bl3) {
                    homePieceOfFurniture.setValueAddedTaxPercentage(bigDecimal2);
                }
            }
            if (f != null) {
                homePieceOfFurniture.setX(f.floatValue());
            }
            if (f2 != null) {
                homePieceOfFurniture.setY(f2.floatValue());
            }
            if (f3 != null) {
                homePieceOfFurniture.setElevation(f3.floatValue());
            }
            if (f4 != null) {
                homePieceOfFurniture.setAngle(f4.floatValue());
            }
            if (furnitureHorizontalAxis != null) {
                switch (furnitureHorizontalAxis.ordinal()) {
                    case 0: {
                        if (f5 == null) break;
                        homePieceOfFurniture.setRoll(f5.floatValue());
                        homePieceOfFurniture.setPitch(0.0f);
                        break;
                    }
                    case 1: {
                        if (f6 == null) break;
                        homePieceOfFurniture.setPitch(f6.floatValue());
                        homePieceOfFurniture.setRoll(0.0f);
                    }
                }
            }
            if (bl4 != null && !homePieceOfFurniture.isDoorOrWindow()) {
                homePieceOfFurniture.setMovable(bl4 == false);
            }
            if (homePieceOfFurniture.isResizable()) {
                boolean bl9;
                float f18 = homePieceOfFurniture.getWidth();
                float f19 = homePieceOfFurniture.getDepth();
                boolean bl10 = bl9 = !bl5 && homePieceOfFurniture.isDeformable();
                if (bl9) {
                    if (f7 != null) {
                        homePieceOfFurniture.setWidth(f7.floatValue());
                    } else if (f8 != null && !homePieceOfFurniture.isWidthDepthDeformable()) {
                        homePieceOfFurniture.setWidth(homePieceOfFurniture.getWidth() * f8.floatValue() / f19);
                    }
                    if (f8 != null) {
                        homePieceOfFurniture.setDepth(f8.floatValue());
                    } else if (f7 != null && !homePieceOfFurniture.isWidthDepthDeformable()) {
                        homePieceOfFurniture.setDepth(homePieceOfFurniture.getDepth() * f7.floatValue() / f18);
                    }
                    if (f9 != null) {
                        homePieceOfFurniture.setHeight(f9.floatValue());
                    }
                } else if (f7 != null) {
                    homePieceOfFurniture.scale(f7.floatValue() / homePieceOfFurniture.getWidth());
                } else if (f8 != null) {
                    homePieceOfFurniture.scale(f8.floatValue() / homePieceOfFurniture.getDepth());
                } else if (f9 != null) {
                    homePieceOfFurniture.scale(f9.floatValue() / homePieceOfFurniture.getHeight());
                }
                if (bl8 != null) {
                    homePieceOfFurniture.setModelMirrored(bl8);
                }
                if (homePieceOfFurniture instanceof HomeDoorOrWindow && modifiedPieceOfFurnitureArray.length == 1 && !Arrays.deepEquals(homePieceOfFurniture.getModelTransformations(), transformationArray != null && transformationArray.length > 0 ? transformationArray : null)) {
                    HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)homePieceOfFurniture;
                    homeDoorOrWindow.setWallThickness(f10);
                    homeDoorOrWindow.setWallDistance(f11);
                    homeDoorOrWindow.setWallWidth(f12);
                    homeDoorOrWindow.setWallLeft(f13);
                    homeDoorOrWindow.setWallHeight(f14);
                    homeDoorOrWindow.setWallTop(f15);
                    homeDoorOrWindow.setSashes(sashArray);
                }
            }
            if (homePieceOfFurniture.isTexturable()) {
                if (furniturePaint != null) {
                    switch (furniturePaint.ordinal()) {
                        case 0: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case 1: {
                            homePieceOfFurniture.setColor(n);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case 2: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(homeTexture);
                            homePieceOfFurniture.setModelMaterials(null);
                            break;
                        }
                        case 3: {
                            homePieceOfFurniture.setColor(null);
                            homePieceOfFurniture.setTexture(null);
                            homePieceOfFurniture.setModelMaterials(homeMaterialArray);
                        }
                    }
                }
                if (bl6) {
                    homePieceOfFurniture.setShininess(null);
                } else if (f16 != null) {
                    homePieceOfFurniture.setShininess(f16);
                }
            }
            if (transformationArray != null) {
                homePieceOfFurniture.setModelTransformations((Transformation[])(transformationArray.length > 0 ? transformationArray : null));
            }
            if (bl7 != null) {
                homePieceOfFurniture.setVisible(bl7);
            }
            if (f17 == null) continue;
            ((HomeLight)homePieceOfFurniture).setPower(f17.floatValue());
        }
    }

    private static void undoModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            modifiedPieceOfFurniture.reset();
        }
    }

    private static class ModifiedPieceOfFurniture {
        private final HomePieceOfFurniture piece;
        private final String name;
        private final boolean nameVisible;
        private final String description;
        private final Map<String, Object> properties;
        private final BigDecimal price;
        private final BigDecimal valueAddedTaxPercentage;
        private final String currency;
        private final float x;
        private final float y;
        private final float elevation;
        private final float angle;
        private final float roll;
        private final float pitch;
        private final boolean movable;
        private final float width;
        private final float depth;
        private final float height;
        private final float widthInPlan;
        private final float depthInPlan;
        private final float heightInPlan;
        private final Transformation[] modelTransformations;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final Float shininess;
        private final boolean visible;
        private final boolean modelMirrored;

        public ModifiedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.name = homePieceOfFurniture.getName();
            this.nameVisible = homePieceOfFurniture.isNameVisible();
            this.description = homePieceOfFurniture.getDescription();
            Collection<String> collection = homePieceOfFurniture.getPropertyNames();
            if (collection.size() == 0) {
                this.properties = Collections.emptyMap();
            } else if (collection.size() == 1) {
                String string;
                this.properties = Collections.singletonMap(string, homePieceOfFurniture.isContentProperty(string = collection.iterator().next()) ? homePieceOfFurniture.getContentProperty(string) : homePieceOfFurniture.getProperty(string));
            } else {
                this.properties = new HashMap<String, Object>();
                for (String string : collection) {
                    this.properties.put(string, homePieceOfFurniture.isContentProperty(string) ? homePieceOfFurniture.getContentProperty(string) : homePieceOfFurniture.getProperty(string));
                }
            }
            this.price = homePieceOfFurniture.getPrice();
            this.valueAddedTaxPercentage = homePieceOfFurniture.getValueAddedTaxPercentage();
            this.currency = homePieceOfFurniture.getCurrency();
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.elevation = homePieceOfFurniture.getElevation();
            this.angle = homePieceOfFurniture.getAngle();
            this.roll = homePieceOfFurniture.getRoll();
            this.pitch = homePieceOfFurniture.getPitch();
            this.movable = homePieceOfFurniture.isMovable();
            this.width = homePieceOfFurniture.getWidth();
            this.depth = homePieceOfFurniture.getDepth();
            this.height = homePieceOfFurniture.getHeight();
            this.widthInPlan = homePieceOfFurniture.getWidthInPlan();
            this.depthInPlan = homePieceOfFurniture.getDepthInPlan();
            this.heightInPlan = homePieceOfFurniture.getHeightInPlan();
            this.modelTransformations = homePieceOfFurniture.getModelTransformations();
            this.color = homePieceOfFurniture.getColor();
            this.texture = homePieceOfFurniture.getTexture();
            this.modelMaterials = homePieceOfFurniture.getModelMaterials();
            this.shininess = homePieceOfFurniture.getShininess();
            this.visible = homePieceOfFurniture.isVisible();
            this.modelMirrored = homePieceOfFurniture.isModelMirrored();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public void reset() {
            this.piece.setName(this.name);
            this.piece.setNameVisible(this.nameVisible);
            this.piece.setDescription(this.description);
            Collection<String> collection = this.piece.getPropertyNames();
            for (String object : collection) {
                this.piece.setProperty(object, this.properties.get(object));
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                if (collection.contains(entry.getKey())) continue;
                this.piece.setProperty((String)entry.getKey(), entry.getValue());
            }
            if (!(this.piece instanceof HomeFurnitureGroup)) {
                this.piece.setPrice(this.price);
                this.piece.setValueAddedTaxPercentage(this.valueAddedTaxPercentage);
                this.piece.setCurrency(this.currency);
            }
            this.piece.setX(this.x);
            this.piece.setY(this.y);
            this.piece.setElevation(this.elevation);
            this.piece.setAngle(this.angle);
            if (this.piece.isHorizontallyRotatable()) {
                this.piece.setRoll(this.roll);
                this.piece.setPitch(this.pitch);
            }
            this.piece.setMovable(this.movable);
            if (this.piece.isResizable()) {
                this.piece.setWidth(this.width);
                this.piece.setDepth(this.depth);
                this.piece.setHeight(this.height);
                this.piece.setModelMirrored(this.modelMirrored);
            }
            this.piece.setWidthInPlan(this.widthInPlan);
            this.piece.setDepthInPlan(this.depthInPlan);
            this.piece.setHeightInPlan(this.heightInPlan);
            this.piece.setModelTransformations(this.modelTransformations);
            if (this.piece.isTexturable()) {
                this.piece.setColor(this.color);
                this.piece.setTexture(this.texture);
                this.piece.setModelMaterials(this.modelMaterials);
                this.piece.setShininess(this.shininess);
            }
            this.piece.setVisible(this.visible);
        }
    }

    public static enum FurnitureHorizontalAxis {
        ROLL,
        PITCH;

    }

    public static enum FurniturePaint {
        DEFAULT,
        COLORED,
        TEXTURED,
        MODEL_MATERIALS;

    }

    public static enum Property {
        ICON,
        NAME,
        NAME_VISIBLE,
        DESCRIPTION,
        ADDITIONAL_PROPERTIES,
        PRICE,
        VALUE_ADDED_TAX_PERCENTAGE,
        X,
        Y,
        ELEVATION,
        BASE_PLAN_ITEM,
        ANGLE,
        ANGLE_IN_DEGREES,
        ROLL,
        PITCH,
        HORIZONTAL_AXIS,
        WIDTH,
        DEPTH,
        HEIGHT,
        PROPORTIONAL,
        COLOR,
        PAINT,
        SHININESS,
        VISIBLE,
        MODEL_MIRRORED,
        MODEL_TRANSFORMATIONS,
        LIGHT_POWER,
        RESIZABLE,
        DEFORMABLE,
        TEXTURABLE;

    }

    public static enum FurnitureShininess {
        DEFAULT,
        MATT,
        SHINY;

    }

    private static class ModifiedLight
    extends ModifiedPieceOfFurniture {
        private final float power;

        public ModifiedLight(HomeLight homeLight) {
            super(homeLight);
            this.power = homeLight.getPower();
        }

        @Override
        public void reset() {
            super.reset();
            ((HomeLight)this.getPieceOfFurniture()).setPower(this.power);
        }
    }

    private static class ModifiedDoorOrWindow
    extends ModifiedPieceOfFurniture {
        private final boolean boundToWall;
        private final float wallThickness;
        private final float wallDistance;
        private final float wallWidth;
        private final float wallLeft;
        private final float wallHeight;
        private final float wallTop;
        private final Sash[] sashes;

        public ModifiedDoorOrWindow(HomeDoorOrWindow homeDoorOrWindow) {
            super(homeDoorOrWindow);
            this.boundToWall = homeDoorOrWindow.isBoundToWall();
            this.wallThickness = homeDoorOrWindow.getWallThickness();
            this.wallDistance = homeDoorOrWindow.getWallDistance();
            this.wallWidth = homeDoorOrWindow.getWallWidth();
            this.wallLeft = homeDoorOrWindow.getWallLeft();
            this.wallHeight = homeDoorOrWindow.getWallHeight();
            this.wallTop = homeDoorOrWindow.getWallTop();
            this.sashes = homeDoorOrWindow.getSashes();
        }

        @Override
        public void reset() {
            super.reset();
            HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)this.getPieceOfFurniture();
            homeDoorOrWindow.setBoundToWall(this.boundToWall);
            homeDoorOrWindow.setWallThickness(this.wallThickness);
            homeDoorOrWindow.setWallDistance(this.wallDistance);
            homeDoorOrWindow.setWallWidth(this.wallWidth);
            homeDoorOrWindow.setWallLeft(this.wallLeft);
            homeDoorOrWindow.setWallHeight(this.wallHeight);
            homeDoorOrWindow.setWallTop(this.wallTop);
            homeDoorOrWindow.setSashes(this.sashes);
        }
    }

    private static class ModifiedFurnitureGroup
    extends ModifiedPieceOfFurniture {
        private final float[] groupFurnitureX;
        private final float[] groupFurnitureY;
        private final float[] groupFurnitureWidth;
        private final float[] groupFurnitureDepth;
        private final Integer[] groupFurnitureColor;
        private final HomeTexture[] groupFurnitureTexture;
        private final HomeMaterial[][] groupFurnitureModelMaterials;
        private final Float[] groupFurnitureShininess;

        public ModifiedFurnitureGroup(HomeFurnitureGroup homeFurnitureGroup) {
            super(homeFurnitureGroup);
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            this.groupFurnitureX = new float[list.size()];
            this.groupFurnitureY = new float[list.size()];
            this.groupFurnitureWidth = new float[list.size()];
            this.groupFurnitureDepth = new float[list.size()];
            this.groupFurnitureColor = new Integer[list.size()];
            this.groupFurnitureTexture = new HomeTexture[list.size()];
            this.groupFurnitureShininess = new Float[list.size()];
            this.groupFurnitureModelMaterials = new HomeMaterial[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                this.groupFurnitureX[i] = homePieceOfFurniture.getX();
                this.groupFurnitureY[i] = homePieceOfFurniture.getY();
                this.groupFurnitureWidth[i] = homePieceOfFurniture.getWidth();
                this.groupFurnitureDepth[i] = homePieceOfFurniture.getDepth();
                this.groupFurnitureColor[i] = homePieceOfFurniture.getColor();
                this.groupFurnitureTexture[i] = homePieceOfFurniture.getTexture();
                this.groupFurnitureShininess[i] = homePieceOfFurniture.getShininess();
                this.groupFurnitureModelMaterials[i] = homePieceOfFurniture.getModelMaterials();
            }
        }

        @Override
        public void reset() {
            super.reset();
            HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)this.getPieceOfFurniture();
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                if (homeFurnitureGroup.isResizable()) {
                    homePieceOfFurniture.setX(this.groupFurnitureX[i]);
                    homePieceOfFurniture.setY(this.groupFurnitureY[i]);
                    homePieceOfFurniture.setWidth(this.groupFurnitureWidth[i]);
                    homePieceOfFurniture.setDepth(this.groupFurnitureDepth[i]);
                }
                if (!homeFurnitureGroup.isTexturable() || homePieceOfFurniture instanceof HomeFurnitureGroup) continue;
                homePieceOfFurniture.setColor(this.groupFurnitureColor[i]);
                homePieceOfFurniture.setTexture(this.groupFurnitureTexture[i]);
                homePieceOfFurniture.setModelMaterials(this.groupFurnitureModelMaterials[i]);
                homePieceOfFurniture.setShininess(this.groupFurnitureShininess[i]);
            }
        }

        private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
                arrayList.add(homePieceOfFurniture);
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
            }
            return arrayList;
        }
    }

    private static class FurnitureModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final ModifiedPieceOfFurniture[] modifiedFurniture;
        private final Selectable[] oldSelection;
        private final Selectable[] newSelection;
        private final String name;
        private final Boolean nameVisible;
        private final String description;
        private final Map<String, Object> additionalProperties;
        private final BigDecimal price;
        private final boolean removePrice;
        private final String currency;
        private final BigDecimal valueAddedTaxPercentage;
        private final boolean removeValueAddedTaxPercentage;
        private final Float x;
        private final Float y;
        private final Float elevation;
        private final Float angle;
        private final Float roll;
        private final Float pitch;
        private final FurnitureHorizontalAxis horizontalAxis;
        private final Boolean basePlanItem;
        private final Float width;
        private final Float depth;
        private final Float height;
        private final boolean proportional;
        private final Transformation[] modelTransformations;
        private final FurniturePaint paint;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final boolean defaultShininess;
        private final Float shininess;
        private final Boolean visible;
        private final Boolean modelMirrored;
        private final Float lightPower;
        private final float wallThickness;
        private final float wallDistance;
        private final float wallWidth;
        private final float wallLeft;
        private final float wallHeight;
        private final float wallTop;
        private final Sash[] sashes;
        private final float[] widthsInPlan;
        private final float[] depthsInPlan;
        private final float[] heightsInPlan;

        private FurnitureModificationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, Selectable[] selectableArray2, ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, Map<String, Object> map, BigDecimal bigDecimal, boolean bl2, BigDecimal bigDecimal2, boolean bl3, String string3, Float f, Float f2, Float f3, Float f4, Float f5, Float f6, FurnitureHorizontalAxis furnitureHorizontalAxis, Boolean bl4, Float f7, Float f8, Float f9, boolean bl5, Transformation[] transformationArray, float f10, float f11, float f12, float f13, float f14, float f15, Sash[] sashArray, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl6, Float f16, Boolean bl7, Boolean bl8, Float f17) {
            super(userPreferences, HomeFurnitureController.class, "undoModifyFurnitureName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.newSelection = selectableArray2;
            this.modifiedFurniture = modifiedPieceOfFurnitureArray;
            this.name = string;
            this.nameVisible = bl;
            this.description = string2;
            this.additionalProperties = map;
            this.price = bigDecimal;
            this.removePrice = bl2;
            this.valueAddedTaxPercentage = bigDecimal2;
            this.removeValueAddedTaxPercentage = bl3;
            this.currency = string3;
            this.x = f;
            this.y = f2;
            this.elevation = f3;
            this.angle = f4;
            this.roll = f5;
            this.pitch = f6;
            this.horizontalAxis = furnitureHorizontalAxis;
            this.basePlanItem = bl4;
            this.width = f7;
            this.depth = f8;
            this.height = f9;
            this.proportional = bl5;
            this.modelTransformations = transformationArray;
            this.wallThickness = f10;
            this.wallDistance = f11;
            this.wallWidth = f12;
            this.wallLeft = f13;
            this.wallHeight = f14;
            this.wallTop = f15;
            this.sashes = sashArray;
            this.paint = furniturePaint;
            this.color = n;
            this.texture = homeTexture;
            this.modelMaterials = homeMaterialArray;
            this.defaultShininess = bl6;
            this.shininess = f16;
            this.visible = bl7;
            this.modelMirrored = bl8;
            this.lightPower = f17;
            this.widthsInPlan = new float[modifiedPieceOfFurnitureArray.length];
            this.depthsInPlan = new float[modifiedPieceOfFurnitureArray.length];
            this.heightsInPlan = new float[modifiedPieceOfFurnitureArray.length];
            for (int i = 0; i < modifiedPieceOfFurnitureArray.length; ++i) {
                HomePieceOfFurniture homePieceOfFurniture = modifiedPieceOfFurnitureArray[i].getPieceOfFurniture();
                this.widthsInPlan[i] = homePieceOfFurniture.getWidthInPlan();
                this.depthsInPlan[i] = homePieceOfFurniture.getDepthInPlan();
                this.heightsInPlan[i] = homePieceOfFurniture.getHeightInPlan();
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            HomeFurnitureController.undoModifyFurniture(this.modifiedFurniture);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            HomeFurnitureController.doModifyFurniture(this.modifiedFurniture, this.name, this.nameVisible, this.description, this.additionalProperties, this.price, this.removePrice, this.valueAddedTaxPercentage, this.removeValueAddedTaxPercentage, this.currency, this.x, this.y, this.elevation, this.angle, this.roll, this.pitch, this.horizontalAxis, this.basePlanItem, this.width, this.depth, this.height, this.proportional, this.modelTransformations, this.wallThickness, this.wallDistance, this.wallWidth, this.wallLeft, this.wallHeight, this.wallTop, this.sashes, this.paint, this.color, this.texture, this.modelMaterials, this.defaultShininess, this.shininess, this.visible, this.modelMirrored, this.lightPower);
            for (int i = 0; i < this.modifiedFurniture.length; ++i) {
                HomePieceOfFurniture homePieceOfFurniture = this.modifiedFurniture[i].getPieceOfFurniture();
                homePieceOfFurniture.setWidthInPlan(this.widthsInPlan[i]);
                homePieceOfFurniture.setDepthInPlan(this.depthsInPlan[i]);
                homePieceOfFurniture.setHeightInPlan(this.heightsInPlan[i]);
            }
            this.home.setSelectedItems(Arrays.asList(this.newSelection));
        }
    }
}

