/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.session.SessionId;
import org.opensearch.sql.spark.execution.session.SessionState;
import org.opensearch.sql.spark.execution.session.SessionType;
import org.opensearch.sql.spark.execution.statestore.StateModel;

public class SessionModel
extends StateModel {
    public static final String VERSION = "version";
    public static final String TYPE = "type";
    public static final String SESSION_TYPE = "sessionType";
    public static final String SESSION_ID = "sessionId";
    public static final String SESSION_STATE = "state";
    public static final String DATASOURCE_NAME = "dataSourceName";
    public static final String LAST_UPDATE_TIME = "lastUpdateTime";
    public static final String APPLICATION_ID = "applicationId";
    public static final String JOB_ID = "jobId";
    public static final String ERROR = "error";
    public static final String UNKNOWN = "unknown";
    public static final String SESSION_DOC_TYPE = "session";
    private final String version;
    private final SessionType sessionType;
    private final SessionId sessionId;
    private final SessionState sessionState;
    private final String applicationId;
    private final String jobId;
    private final String datasourceName;
    private final String error;
    private final long lastUpdateTime;
    private final long seqNo;
    private final long primaryTerm;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(VERSION, this.version).field(TYPE, SESSION_DOC_TYPE).field(SESSION_TYPE, this.sessionType.getSessionType()).field(SESSION_ID, this.sessionId.getSessionId()).field(SESSION_STATE, this.sessionState.getSessionState()).field(DATASOURCE_NAME, this.datasourceName).field(APPLICATION_ID, this.applicationId).field(JOB_ID, this.jobId).field(LAST_UPDATE_TIME, this.lastUpdateTime).field(ERROR, this.error).endObject();
        return builder;
    }

    public static SessionModel of(SessionModel copy, long seqNo, long primaryTerm) {
        return SessionModel.builder().version(copy.version).sessionType(copy.sessionType).sessionId(new SessionId(copy.sessionId.getSessionId())).sessionState(copy.sessionState).datasourceName(copy.datasourceName).applicationId(copy.getApplicationId()).jobId(copy.jobId).error(UNKNOWN).lastUpdateTime(copy.getLastUpdateTime()).seqNo(seqNo).primaryTerm(primaryTerm).build();
    }

    public static SessionModel copyWithState(SessionModel copy, SessionState state, long seqNo, long primaryTerm) {
        return SessionModel.builder().version(copy.version).sessionType(copy.sessionType).sessionId(new SessionId(copy.sessionId.getSessionId())).sessionState(state).datasourceName(copy.datasourceName).applicationId(copy.getApplicationId()).jobId(copy.jobId).error(UNKNOWN).lastUpdateTime(copy.getLastUpdateTime()).seqNo(seqNo).primaryTerm(primaryTerm).build();
    }

    public static SessionModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        SessionModelBuilder builder = new SessionModelBuilder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "version": {
                    builder.version(parser.text());
                    break;
                }
                case "sessionType": {
                    builder.sessionType(SessionType.fromString(parser.text()));
                    break;
                }
                case "sessionId": {
                    builder.sessionId(new SessionId(parser.text()));
                    break;
                }
                case "state": {
                    builder.sessionState(SessionState.fromString(parser.text()));
                    break;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    break;
                }
                case "error": {
                    builder.error(parser.text());
                    break;
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    break;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    break;
                }
                case "lastUpdateTime": {
                    builder.lastUpdateTime(parser.longValue());
                    break;
                }
            }
        }
        builder.seqNo(seqNo);
        builder.primaryTerm(primaryTerm);
        return builder.build();
    }

    public static SessionModel initInteractiveSession(String applicationId, String jobId, SessionId sid, String datasourceName) {
        return SessionModel.builder().version("1.0").sessionType(SessionType.INTERACTIVE).sessionId(sid).sessionState(SessionState.NOT_STARTED).datasourceName(datasourceName).applicationId(applicationId).jobId(jobId).error(UNKNOWN).lastUpdateTime(System.currentTimeMillis()).seqNo(-2L).primaryTerm(0L).build();
    }

    @Override
    public String getId() {
        return this.sessionId.getSessionId();
    }

    @Generated
    SessionModel(String version, SessionType sessionType, SessionId sessionId, SessionState sessionState, String applicationId, String jobId, String datasourceName, String error, long lastUpdateTime, long seqNo, long primaryTerm) {
        this.version = version;
        this.sessionType = sessionType;
        this.sessionId = sessionId;
        this.sessionState = sessionState;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.datasourceName = datasourceName;
        this.error = error;
        this.lastUpdateTime = lastUpdateTime;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    @Generated
    public static SessionModelBuilder builder() {
        return new SessionModelBuilder();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Generated
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Generated
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Generated
    public long getSeqNo() {
        return this.seqNo;
    }

    @Override
    @Generated
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionModel)) {
            return false;
        }
        SessionModel other = (SessionModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        if (this.getSeqNo() != other.getSeqNo()) {
            return false;
        }
        if (this.getPrimaryTerm() != other.getPrimaryTerm()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        SessionType this$sessionType = this.getSessionType();
        SessionType other$sessionType = other.getSessionType();
        if (this$sessionType == null ? other$sessionType != null : !((Object)((Object)this$sessionType)).equals((Object)other$sessionType)) {
            return false;
        }
        SessionId this$sessionId = this.getSessionId();
        SessionId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        SessionState this$sessionState = this.getSessionState();
        SessionState other$sessionState = other.getSessionState();
        if (this$sessionState == null ? other$sessionState != null : !((Object)((Object)this$sessionState)).equals((Object)other$sessionState)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SessionModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        long $seqNo = this.getSeqNo();
        result = result * 59 + (int)($seqNo >>> 32 ^ $seqNo);
        long $primaryTerm = this.getPrimaryTerm();
        result = result * 59 + (int)($primaryTerm >>> 32 ^ $primaryTerm);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        SessionType $sessionType = this.getSessionType();
        result = result * 59 + ($sessionType == null ? 43 : ((Object)((Object)$sessionType)).hashCode());
        SessionId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        SessionState $sessionState = this.getSessionState();
        result = result * 59 + ($sessionState == null ? 43 : ((Object)((Object)$sessionState)).hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SessionModel(version=" + this.getVersion() + ", sessionType=" + this.getSessionType() + ", sessionId=" + this.getSessionId() + ", sessionState=" + this.getSessionState() + ", applicationId=" + this.getApplicationId() + ", jobId=" + this.getJobId() + ", datasourceName=" + this.getDatasourceName() + ", error=" + this.getError() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", seqNo=" + this.getSeqNo() + ", primaryTerm=" + this.getPrimaryTerm() + ")";
    }

    @Generated
    public static class SessionModelBuilder {
        @Generated
        private String version;
        @Generated
        private SessionType sessionType;
        @Generated
        private SessionId sessionId;
        @Generated
        private SessionState sessionState;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private String datasourceName;
        @Generated
        private String error;
        @Generated
        private long lastUpdateTime;
        @Generated
        private long seqNo;
        @Generated
        private long primaryTerm;

        @Generated
        SessionModelBuilder() {
        }

        @Generated
        public SessionModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public SessionModelBuilder sessionType(SessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        @Generated
        public SessionModelBuilder sessionId(SessionId sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public SessionModelBuilder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        @Generated
        public SessionModelBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public SessionModelBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public SessionModelBuilder datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        @Generated
        public SessionModelBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public SessionModelBuilder lastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public SessionModelBuilder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        @Generated
        public SessionModelBuilder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        @Generated
        public SessionModel build() {
            return new SessionModel(this.version, this.sessionType, this.sessionId, this.sessionState, this.applicationId, this.jobId, this.datasourceName, this.error, this.lastUpdateTime, this.seqNo, this.primaryTerm);
        }

        @Generated
        public String toString() {
            return "SessionModel.SessionModelBuilder(version=" + this.version + ", sessionType=" + this.sessionType + ", sessionId=" + this.sessionId + ", sessionState=" + this.sessionState + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", datasourceName=" + this.datasourceName + ", error=" + this.error + ", lastUpdateTime=" + this.lastUpdateTime + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ")";
        }
    }
}

