"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;
var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));
var _services = require("./services");
var _routes = require("../server/routes");
var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class IndexPatternManagementPlugin {
  async setup(core) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    });

    // Initialize services
    const indexService = new _services.IndexService(osDriver);
    const dataStreamService = new _services.DataStreamService(osDriver);
    const policyService = new _services.PolicyService(osDriver);
    const managedIndexService = new _services.ManagedIndexService(osDriver);
    const rollupService = new _services.RollupService(osDriver);
    const transformService = new _services.TransformService(osDriver);
    const notificationService = new _services.NotificationService(osDriver);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver);
    const commonService = new _services.CommonService(osDriver);
    const aliasService = new _services.AliasServices(osDriver);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService,
      commonService,
      aliasService
    };

    // create router
    const router = core.http.createRouter();
    // Add server routes
    (0, _routes.indices)(services, router);
    (0, _dataStreams.default)(services, router);
    (0, _routes.policies)(services, router);
    (0, _routes.managedIndices)(services, router);
    (0, _routes.rollups)(services, router);
    (0, _routes.transforms)(services, router);
    (0, _routes.notifications)(services, router);
    (0, _routes.snapshotManagement)(services, router);
    (0, _routes.common)(services, router);
    (0, _routes.aliases)(services, router);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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