"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.TRANSFORMS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string()
      })
    }
  }, transformService.getTransforms);
  router.get({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.getTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.stopTransform);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.startTransform);
  router.delete({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, transformService.deleteTransform);
  router.put({
    path: `${_constants.NODE_API.TRANSFORMS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.putTransform);
  router.post({
    path: `${_constants.NODE_API._SEARCH_SAMPLE_DATA}/{index}`,
    validate: {
      params: _configSchema.schema.object({
        index: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number()
      }),
      body: _configSchema.schema.any()
    }
  }, transformService.searchSampleData);
  router.post({
    path: `${_constants.NODE_API.TRANSFORMS}/_preview`,
    validate: {
      body: _configSchema.schema.object({
        transform: _configSchema.schema.any()
      })
    }
  }, transformService.previewTransform);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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