/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b9\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 n2\u00020\u00012\u00020\u0002:\u0001nB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u00c1\u0001\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0007\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u001c\u001a\u00020\f\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018\u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\t\u0010E\u001a\u00020\u0007H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\t\u0010G\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u00c6\u0003J\t\u0010J\u001a\u00020\u001aH\u00c6\u0003J\u0010\u0010K\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010'J\t\u0010L\u001a\u00020\fH\u00c6\u0003J\u000f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\"H\u00c6\u0003J\t\u0010P\u001a\u00020\tH\u00c6\u0003J\t\u0010Q\u001a\u00020\tH\u00c6\u0003J\t\u0010R\u001a\u00020\fH\u00c6\u0003J\t\u0010S\u001a\u00020\tH\u00c6\u0003J\t\u0010T\u001a\u00020\u000fH\u00c6\u0003J\t\u0010U\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010V\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010W\u001a\u00020\u0007H\u00c6\u0003J\u00e6\u0001\u0010X\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u001c\u001a\u00020\f2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00182\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u00c6\u0001\u00a2\u0006\u0002\u0010YJ\u0013\u0010Z\u001a\u00020\f2\b\u0010[\u001a\u0004\u0018\u00010\\H\u00d6\u0003J\n\u0010]\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010^\u001a\u00020\u0011H\u0016J\r\u0010_\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010'J\b\u0010`\u001a\u00020\u0007H\u0016J\b\u0010a\u001a\u00020\u000fH\u0016J\t\u0010b\u001a\u00020\u001aH\u00d6\u0001J\b\u0010c\u001a\u00020\fH\u0016J\t\u0010d\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020mH\u0016R\u0011\u0010\u001c\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0015\u0010\u001b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010%R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010*R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00100R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010*R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010,R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b<\u0010=\u001a\u0004\b>\u0010,R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010;R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010;R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010*R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010*R\u0013\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006o"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "id", "", "seqNo", "", "primaryTerm", "enabled", "", "schemaVersion", "jobSchedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "jobLastUpdatedTime", "Ljava/time/Instant;", "jobEnabledTime", "description", "sourceIndex", "targetIndex", "metadataID", "roles", "", "pageSize", "", "delay", "continuous", "dimensions", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "metrics", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "user", "Lorg/opensearch/commons/authuser/User;", "(Ljava/lang/String;JJZJLorg/opensearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;Lorg/opensearch/commons/authuser/User;)V", "getContinuous", "()Z", "getDelay", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDescription", "()Ljava/lang/String;", "getDimensions", "()Ljava/util/List;", "getEnabled", "getId", "getJobEnabledTime", "()Ljava/time/Instant;", "getJobLastUpdatedTime", "getJobSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "setJobSchedule", "(Lorg/opensearch/jobscheduler/spi/schedule/Schedule;)V", "getMetadataID", "getMetrics", "getPageSize", "()I", "getPrimaryTerm", "()J", "getRoles$annotations", "()V", "getRoles", "getSchemaVersion", "getSeqNo", "getSourceIndex", "getTargetIndex", "getUser", "()Lorg/opensearch/commons/authuser/User;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;JJZJLorg/opensearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;Lorg/opensearch/commons/authuser/User;)Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "equals", "other", "", "getEnabledTime", "getLastUpdateTime", "getLockDurationSeconds", "getName", "getSchedule", "hashCode", "isEnabled", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,371:1\n1#2:372\n766#3:373\n857#3,2:374\n37#4,2:376\n37#4,2:378\n37#4,2:380\n*S KotlinDebug\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup\n*L\n89#1:373\n89#1:374,2\n174#1:376,2\n175#1:378,2\n200#1:380,2\n*E\n"})
public final class Rollup
implements ScheduledJobParameter,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean enabled;
    private final long schemaVersion;
    @NotNull
    private Schedule jobSchedule;
    @NotNull
    private final Instant jobLastUpdatedTime;
    @Nullable
    private final Instant jobEnabledTime;
    @NotNull
    private final String description;
    @NotNull
    private final String sourceIndex;
    @NotNull
    private final String targetIndex;
    @Nullable
    private final String metadataID;
    @NotNull
    private final List<String> roles;
    private final int pageSize;
    @Nullable
    private final Long delay;
    private final boolean continuous;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;
    @Nullable
    private final User user;
    public static final long ROLLUP_LOCK_DURATION_SECONDS = 1800L;
    @NotNull
    public static final String ROLLUP_TYPE = "rollup";
    @NotNull
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String SOURCE_INDEX_FIELD = "source_index";
    @NotNull
    public static final String TARGET_INDEX_FIELD = "target_index";
    @NotNull
    public static final String METADATA_ID_FIELD = "metadata_id";
    @NotNull
    public static final String ROLES_FIELD = "roles";
    @NotNull
    public static final String PAGE_SIZE_FIELD = "page_size";
    @NotNull
    public static final String DELAY_FIELD = "delay";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String DIMENSIONS_FIELD = "dimensions";
    @NotNull
    public static final String METRICS_FIELD = "metrics";
    public static final int MINIMUM_JOB_INTERVAL = 1;
    public static final int MINIMUM_DELAY = 0;
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    @NotNull
    public static final String ROLLUP_DOC_ID_FIELD = "rollup._id";
    @NotNull
    public static final String ROLLUP_DOC_COUNT_FIELD = "_doc_count";
    @NotNull
    public static final String ROLLUP_DOC_SCHEMA_VERSION_FIELD = "rollup._schema_version";
    @NotNull
    public static final String USER_FIELD = "user";

    /*
     * WARNING - void declaration
     */
    public Rollup(@NotNull String id2, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable User user) {
        void $this$filterTo$iv$iv;
        Schedule schedule;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        this.id = id2;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.enabled = enabled;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.jobLastUpdatedTime = jobLastUpdatedTime;
        this.jobEnabledTime = jobEnabledTime;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.metadataID = metadataID;
        this.roles = roles;
        this.pageSize = pageSize;
        this.delay = delay;
        this.continuous = continuous;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.user = user;
        if (this.enabled) {
            if (this.jobEnabledTime == null) {
                boolean $i$a$-requireNotNull-Rollup$22 = false;
                String $i$a$-requireNotNull-Rollup$22 = "Job enabled time must be present if the job is enabled";
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$22.toString());
            }
        } else if (!(this.jobEnabledTime == null)) {
            boolean $i$a$-require-Rollup$52 = false;
            String $i$a$-require-Rollup$52 = "Job enabled time must not be present if the job is disabled";
            throw new IllegalArgumentException($i$a$-require-Rollup$52.toString());
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule.getDelay(), (Object)this.delay) && this.continuous) {
            Schedule schedule2;
            schedule = this.jobSchedule;
            if (schedule instanceof CronSchedule) {
                Schedule schedule3 = this.jobSchedule;
                Intrinsics.checkNotNull((Object)schedule3, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.CronSchedule");
                CronSchedule cronSchedule = (CronSchedule)schedule3;
                Long l = this.delay;
                schedule2 = (Schedule)new CronSchedule(cronSchedule.getCronExpression(), cronSchedule.getTimeZone(), l != null ? l : 0L);
            } else if (schedule instanceof IntervalSchedule) {
                Schedule schedule4 = this.jobSchedule;
                Intrinsics.checkNotNull((Object)schedule4, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.IntervalSchedule");
                IntervalSchedule intervalSchedule = (IntervalSchedule)schedule4;
                Long l = this.delay;
                schedule2 = (Schedule)new IntervalSchedule(intervalSchedule.getStartTime(), intervalSchedule.getInterval(), intervalSchedule.getUnit(), l != null ? l : 0L);
            } else {
                schedule2 = this.jobSchedule = this.jobSchedule;
            }
        }
        if (!((schedule = this.jobSchedule) instanceof CronSchedule) && schedule instanceof IntervalSchedule) {
            Schedule schedule5 = this.jobSchedule;
            Intrinsics.checkNotNull((Object)schedule5, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.IntervalSchedule");
            if (!(((IntervalSchedule)schedule5).getInterval() >= 1)) {
                boolean $i$a$-require-Rollup$112 = false;
                String $i$a$-require-Rollup$112 = "Rollup job schedule interval must be greater than 0";
                throw new IllegalArgumentException($i$a$-require-Rollup$112.toString());
            }
        }
        if (!(!Intrinsics.areEqual((Object)this.sourceIndex, (Object)this.targetIndex))) {
            boolean $i$a$-require-Rollup$122 = false;
            String $i$a$-require-Rollup$122 = "Your source and target index cannot be the same";
            throw new IllegalArgumentException($i$a$-require-Rollup$122.toString());
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable $i$a$-require-Rollup$112 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!(((List)destination$iv$iv).size() == 1)) {
            boolean $i$a$-require-Rollup$132 = false;
            String $i$a$-require-Rollup$132 = "Must specify precisely one date histogram dimension";
            throw new IllegalArgumentException($i$a$-require-Rollup$132.toString());
        }
        if (!(((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM)) {
            boolean $i$a$-require-Rollup$142 = false;
            String $i$a$-require-Rollup$142 = "The first dimension must be a date histogram";
            throw new IllegalArgumentException($i$a$-require-Rollup$142.toString());
        }
        int n = this.pageSize;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean $i$a$-require-Rollup$152 = false;
            String $i$a$-require-Rollup$152 = "Page size must be between 1 and 10,000";
            throw new IllegalArgumentException($i$a$-require-Rollup$152.toString());
        }
        if (this.delay != null) {
            if (!(this.delay >= 0L)) {
                boolean $i$a$-require-Rollup$162 = false;
                String $i$a$-require-Rollup$162 = "Delay must be non-negative if set";
                throw new IllegalArgumentException($i$a$-require-Rollup$162.toString());
            }
            if (!(this.delay <= Instant.now().toEpochMilli())) {
                boolean bl = false;
                String string = "Delay must be less than the current unix time";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Rollup(String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, User user, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            l = -2L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x1000) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40000) != 0) {
            user = null;
        }
        this(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, string5, list, n, l4, bl2, list2, list3, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public final void setJobSchedule(@NotNull Schedule schedule) {
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"<set-?>");
        this.jobSchedule = schedule;
    }

    @NotNull
    public final Instant getJobLastUpdatedTime() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    @Nullable
    public final String getMetadataID() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    @Deprecated(message="Will be ignored, to check the roles use user field")
    public static /* synthetic */ void getRoles$annotations() {
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Nullable
    public final Long getDelay() {
        return this.delay;
    }

    public final boolean getContinuous() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.jobLastUpdatedTime;
    }

    @NotNull
    public Long getLockDurationSeconds() {
        return 1800L;
    }

    public Rollup(@NotNull StreamInput sin) throws IOException {
        Schedule schedule;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        StreamInput streamInput = sin;
        long l = sin.readLong();
        boolean bl = sin.readBoolean();
        long l2 = sin.readLong();
        long l3 = sin.readLong();
        String string2 = string;
        Rollup rollup2 = this;
        boolean bl2 = false;
        Enum enum_ = sin.readEnum(Companion.ScheduleType.class);
        if (enum_ == null) {
            boolean $i$a$-requireNotNull-Rollup$11$22 = false;
            String $i$a$-requireNotNull-Rollup$11$22 = "ScheduleType cannot be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$11$22.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((Companion.ScheduleType)enum_).ordinal()]) {
            case 1: {
                schedule = (Schedule)new CronSchedule(sin);
                break;
            }
            case 2: {
                schedule = (Schedule)new IntervalSchedule(sin);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Schedule schedule2 = schedule;
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        Instant instant2 = sin.readOptionalInstant();
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sin.readString()");
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sin.readString()");
        String string5 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"sin.readString()");
        String string6 = sin.readOptionalString();
        String[] stringArray = sin.readStringArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"sin.readStringArray()");
        StreamInput it = sin;
        boolean bl3 = sin.readBoolean();
        Long l4 = sin.readOptionalLong();
        int n = sin.readInt();
        List list = ArraysKt.toList((Object[])stringArray);
        String string7 = string6;
        String string8 = string5;
        String string9 = string4;
        String string10 = string3;
        Instant instant3 = instant2;
        Instant instant4 = instant;
        boolean bl4 = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            Dimension dimension;
            boolean bl5 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list2 = dimensionsList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list3 = list2;
                boolean bl6 = false;
                List list4 = list3;
                String string11 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string11.toString());
            }
            switch (WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    dimension = new DateHistogram(sin);
                    break;
                }
                case 2: {
                    dimension = new Terms(sin);
                    break;
                }
                case 3: {
                    dimension = new Histogram(sin);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            list2.add(dimension);
        }
        List list5 = CollectionsKt.toList((Iterable)dimensionsList);
        List list6 = sin.readList(RollupMetrics::new);
        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"sin.readList(::RollupMetrics)");
        rollup2(string2, l3, l2, bl, l, schedule2, instant4, instant3, string10, string9, string8, string7, list, n, l4, bl3, list5, list6, sin.readBoolean() ? new User(sin) : null);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(ROLLUP_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field(ROLLUP_ID_FIELD, this.id).field(ENABLED_FIELD, this.enabled).field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(ROLLUP_ID_\u2026EDULE_FIELD, jobSchedule)");
        Collection $this$toTypedArray$iv = this.dimensions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField(OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdatedTime), ENABLED_TIME_FIELD, this.jobEnabledTime).field(DESCRIPTION_FIELD, this.description).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(SOURCE_INDEX_FIELD, this.sourceIndex).field(TARGET_INDEX_FIELD, this.targetIndex).field(METADATA_ID_FIELD, this.metadataID).field(PAGE_SIZE_FIELD, this.pageSize).field(DELAY_FIELD, this.delay).field(CONTINUOUS_FIELD, this.continuous).field(DIMENSIONS_FIELD, (Object)thisCollection$iv.toArray(new Dimension[0]));
        $this$toTypedArray$iv = this.metrics;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        xContentBuilder2.field(METRICS_FIELD, (Object)thisCollection$iv.toArray(new RollupMetrics[0]));
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeBoolean(this.enabled);
            out.writeLong(this.schemaVersion);
            if (this.getSchedule() instanceof CronSchedule) {
                out.writeEnum((Enum)Companion.ScheduleType.CRON);
            } else {
                out.writeEnum((Enum)Companion.ScheduleType.INTERVAL);
            }
            this.getSchedule().writeTo(out);
            out.writeInstant(this.jobLastUpdatedTime);
            out.writeOptionalInstant(this.jobEnabledTime);
            out.writeString(this.description);
            out.writeString(this.sourceIndex);
            out.writeString(this.targetIndex);
            out.writeOptionalString(this.metadataID);
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            out.writeStringArray(thisCollection$iv.toArray(new String[0]));
            out.writeInt(this.pageSize);
            out.writeOptionalLong(this.delay);
            out.writeBoolean(this.continuous);
            out.writeVInt(this.dimensions.size());
            for (Dimension dimension : this.dimensions) {
                out.writeEnum((Enum)dimension.getType());
                Dimension dimension2 = dimension;
                if (dimension2 instanceof DateHistogram) {
                    dimension.writeTo(out);
                    continue;
                }
                if (dimension2 instanceof Terms) {
                    dimension.writeTo(out);
                    continue;
                }
                if (!(dimension2 instanceof Histogram)) continue;
                dimension.writeTo(out);
            }
            out.writeCollection((Collection)this.metrics);
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user == null) break block5;
            user.writeTo(out);
        }
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    public final boolean component4() {
        return this.enabled;
    }

    public final long component5() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule component6() {
        return this.jobSchedule;
    }

    @NotNull
    public final Instant component7() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant component8() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String component9() {
        return this.description;
    }

    @NotNull
    public final String component10() {
        return this.sourceIndex;
    }

    @NotNull
    public final String component11() {
        return this.targetIndex;
    }

    @Nullable
    public final String component12() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> component13() {
        return this.roles;
    }

    public final int component14() {
        return this.pageSize;
    }

    @Nullable
    public final Long component15() {
        return this.delay;
    }

    public final boolean component16() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> component17() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component18() {
        return this.metrics;
    }

    @Nullable
    public final User component19() {
        return this.user;
    }

    @NotNull
    public final Rollup copy(@NotNull String id2, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        return new Rollup(id2, seqNo, primaryTerm, enabled, schemaVersion, jobSchedule, jobLastUpdatedTime, jobEnabledTime, description, sourceIndex, targetIndex, metadataID, roles, pageSize, delay, continuous, dimensions, metrics, user);
    }

    public static /* synthetic */ Rollup copy$default(Rollup rollup2, String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, User user, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = rollup2.id;
        }
        if ((n2 & 2) != 0) {
            l = rollup2.seqNo;
        }
        if ((n2 & 4) != 0) {
            l2 = rollup2.primaryTerm;
        }
        if ((n2 & 8) != 0) {
            bl = rollup2.enabled;
        }
        if ((n2 & 0x10) != 0) {
            l3 = rollup2.schemaVersion;
        }
        if ((n2 & 0x20) != 0) {
            schedule = rollup2.jobSchedule;
        }
        if ((n2 & 0x40) != 0) {
            instant = rollup2.jobLastUpdatedTime;
        }
        if ((n2 & 0x80) != 0) {
            instant2 = rollup2.jobEnabledTime;
        }
        if ((n2 & 0x100) != 0) {
            string2 = rollup2.description;
        }
        if ((n2 & 0x200) != 0) {
            string3 = rollup2.sourceIndex;
        }
        if ((n2 & 0x400) != 0) {
            string4 = rollup2.targetIndex;
        }
        if ((n2 & 0x800) != 0) {
            string5 = rollup2.metadataID;
        }
        if ((n2 & 0x1000) != 0) {
            list = rollup2.roles;
        }
        if ((n2 & 0x2000) != 0) {
            n = rollup2.pageSize;
        }
        if ((n2 & 0x4000) != 0) {
            l4 = rollup2.delay;
        }
        if ((n2 & 0x8000) != 0) {
            bl2 = rollup2.continuous;
        }
        if ((n2 & 0x10000) != 0) {
            list2 = rollup2.dimensions;
        }
        if ((n2 & 0x20000) != 0) {
            list3 = rollup2.metrics;
        }
        if ((n2 & 0x40000) != 0) {
            user = rollup2.user;
        }
        return rollup2.copy(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, string5, list, n, l4, bl2, list2, list3, user);
    }

    @NotNull
    public String toString() {
        return "Rollup(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", enabled=" + this.enabled + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + this.jobSchedule + ", jobLastUpdatedTime=" + this.jobLastUpdatedTime + ", jobEnabledTime=" + this.jobEnabledTime + ", description=" + this.description + ", sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", metadataID=" + this.metadataID + ", roles=" + this.roles + ", pageSize=" + this.pageSize + ", delay=" + this.delay + ", continuous=" + this.continuous + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        int n = this.enabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + Long.hashCode(this.schemaVersion);
        result2 = result2 * 31 + this.jobSchedule.hashCode();
        result2 = result2 * 31 + this.jobLastUpdatedTime.hashCode();
        result2 = result2 * 31 + (this.jobEnabledTime == null ? 0 : this.jobEnabledTime.hashCode());
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + this.sourceIndex.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + (this.metadataID == null ? 0 : this.metadataID.hashCode());
        result2 = result2 * 31 + ((Object)this.roles).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + (this.delay == null ? 0 : ((Object)this.delay).hashCode());
        int n2 = this.continuous ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + ((Object)this.dimensions).hashCode();
        result2 = result2 * 31 + ((Object)this.metrics).hashCode();
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rollup)) {
            return false;
        }
        Rollup rollup2 = (Rollup)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rollup2.id)) {
            return false;
        }
        if (this.seqNo != rollup2.seqNo) {
            return false;
        }
        if (this.primaryTerm != rollup2.primaryTerm) {
            return false;
        }
        if (this.enabled != rollup2.enabled) {
            return false;
        }
        if (this.schemaVersion != rollup2.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule, (Object)rollup2.jobSchedule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobLastUpdatedTime, (Object)rollup2.jobLastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobEnabledTime, (Object)rollup2.jobEnabledTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)rollup2.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceIndex, (Object)rollup2.sourceIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)rollup2.targetIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadataID, (Object)rollup2.metadataID)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.roles, rollup2.roles)) {
            return false;
        }
        if (this.pageSize != rollup2.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.delay, (Object)rollup2.delay)) {
            return false;
        }
        if (this.continuous != rollup2.continuous) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dimensions, rollup2.dimensions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metrics, rollup2.metrics)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)rollup2.user);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id2, seqNo, primaryTerm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo) throws IOException {
        return Companion.parse(xcp, id2, seqNo);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2) throws IOException {
        return Companion.parse(xcp, id2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00192\b\b\u0002\u0010&\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup$Companion;", "", "()V", "CONTINUOUS_FIELD", "", "DELAY_FIELD", "DESCRIPTION_FIELD", "DIMENSIONS_FIELD", "ENABLED_FIELD", "ENABLED_TIME_FIELD", "LAST_UPDATED_TIME_FIELD", "MAXIMUM_PAGE_SIZE", "", "METADATA_ID_FIELD", "METRICS_FIELD", "MINIMUM_DELAY", "MINIMUM_JOB_INTERVAL", "MINIMUM_PAGE_SIZE", "PAGE_SIZE_FIELD", "ROLES_FIELD", "ROLLUP_DOC_COUNT_FIELD", "ROLLUP_DOC_ID_FIELD", "ROLLUP_DOC_SCHEMA_VERSION_FIELD", "ROLLUP_ID_FIELD", "ROLLUP_LOCK_DURATION_SECONDS", "", "ROLLUP_TYPE", "SCHEDULE_FIELD", "SCHEMA_VERSION_FIELD", "SOURCE_INDEX_FIELD", "TARGET_INDEX_FIELD", "USER_FIELD", "parse", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "primaryTerm", "ScheduleType", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n1#2:372\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Schedule schedule = null;
            long schemaVersion = 1L;
            Instant lastUpdatedTime = null;
            Instant enabledTime = null;
            boolean enabled = true;
            String description = null;
            String sourceIndex = null;
            String targetIndex = null;
            String metadataID = null;
            Integer pageSize = null;
            Long delay = null;
            boolean continuous = false;
            List dimensions = new ArrayList();
            List metrics = new ArrayList();
            User user = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block38: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block69: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block69;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1219796725: {
                            if (string.equals(Rollup.ENABLED_TIME_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -207303516: {
                            if (string.equals(Rollup.TARGET_INDEX_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 108695229: {
                            if (string.equals(Rollup.ROLES_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals(Rollup.DESCRIPTION_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 1661088686: {
                            if (string.equals(Rollup.SOURCE_INDEX_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1609594047: {
                            if (string.equals(Rollup.ENABLED_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 556621538: {
                            if (string.equals(Rollup.ROLLUP_ID_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 1684719674: {
                            if (string.equals(Rollup.SCHEMA_VERSION_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case -697920873: {
                            if (string.equals(Rollup.SCHEDULE_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                        case 95467907: {
                            if (string.equals(Rollup.DELAY_FIELD)) {
                                n = 10;
                            }
                            break;
                        }
                        case -1670470950: {
                            if (string.equals(Rollup.LAST_UPDATED_TIME_FIELD)) {
                                n = 11;
                            }
                            break;
                        }
                        case 379114255: {
                            if (string.equals(Rollup.CONTINUOUS_FIELD)) {
                                n = 12;
                            }
                            break;
                        }
                        case -1481411541: {
                            if (string.equals(Rollup.METADATA_ID_FIELD)) {
                                n = 13;
                            }
                            break;
                        }
                        case 955826371: {
                            if (string.equals(Rollup.METRICS_FIELD)) {
                                n = 14;
                            }
                            break;
                        }
                        case 3599307: {
                            if (string.equals(Rollup.USER_FIELD)) {
                                n = 15;
                            }
                            break;
                        }
                        case 883849137: {
                            if (string.equals(Rollup.PAGE_SIZE_FIELD)) {
                                n = 16;
                            }
                            break;
                        }
                        case 414334925: {
                            if (string.equals(Rollup.DIMENSIONS_FIELD)) {
                                n = 17;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 7: {
                            if (xcp.text() != null) continue block38;
                            boolean bl = false;
                            String string2 = "The rollup_id field is null";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        case 6: {
                            enabled = xcp.booleanValue();
                            continue block38;
                        }
                        case 9: {
                            schedule = ScheduleParser.parse((XContentParser)xcp);
                            continue block38;
                        }
                        case 8: {
                            schemaVersion = xcp.longValue();
                            continue block38;
                        }
                        case 1: {
                            enabledTime = OpenSearchExtensionsKt.instant(xcp);
                            continue block38;
                        }
                        case 11: {
                            lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                            continue block38;
                        }
                        case 4: {
                            description = xcp.text();
                            continue block38;
                        }
                        case 5: {
                            sourceIndex = xcp.text();
                            continue block38;
                        }
                        case 2: {
                            targetIndex = xcp.text();
                            continue block38;
                        }
                        case 13: {
                            metadataID = xcp.textOrNull();
                            continue block38;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                xcp.text();
                            }
                            continue block38;
                        }
                        case 16: {
                            pageSize = xcp.intValue();
                            continue block38;
                        }
                        case 10: {
                            delay = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                            continue block38;
                        }
                        case 12: {
                            continuous = xcp.booleanValue();
                            continue block38;
                        }
                        case 17: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                dimensions.add(Dimension.Companion.parse(xcp));
                            }
                            continue block38;
                        }
                        case 14: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(RollupMetrics.Companion.parse(xcp));
                            }
                            continue block38;
                        }
                        case 15: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                            continue block38;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Rollup.");
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            if ((seqNo == -2L || primaryTerm == 0L) && schedule instanceof IntervalSchedule) {
                Long l = ((IntervalSchedule)schedule).getDelay();
                schedule = (Schedule)new IntervalSchedule(((IntervalSchedule)schedule).getStartTime(), ((IntervalSchedule)schedule).getInterval(), ((IntervalSchedule)schedule).getUnit(), l == null ? 0L : l);
            }
            String string = id2;
            long l = seqNo;
            long l2 = primaryTerm;
            boolean bl = enabled;
            long l3 = schemaVersion;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                long l4 = l3;
                boolean bl2 = bl;
                long l5 = l2;
                long l6 = l;
                String string3 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$72 = false;
                String string4 = "Rollup schedule is null";
                String string5 = string3;
                long l7 = l6;
                long l8 = l5;
                boolean bl3 = bl2;
                long l9 = l4;
                String $i$a$-requireNotNull-Rollup$Companion$parse$72 = string4;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$72.toString());
            }
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastUpdatedTime ?: Instant.now()");
            Instant instant2 = enabledTime;
            String string6 = description;
            if (string6 == null) {
                Instant instant3 = instant2;
                Instant instant4 = instant;
                Schedule schedule3 = schedule2;
                long l10 = l3;
                boolean bl4 = bl;
                long l11 = l2;
                long l12 = l;
                String string7 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$82 = false;
                String string8 = "Rollup description is null";
                String string9 = string7;
                long l13 = l12;
                long l14 = l11;
                boolean bl5 = bl4;
                long l15 = l10;
                Schedule schedule4 = schedule3;
                Instant instant5 = instant4;
                Instant instant6 = instant3;
                String $i$a$-requireNotNull-Rollup$Companion$parse$82 = string8;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$82.toString());
            }
            String string10 = sourceIndex;
            if (string10 == null) {
                String string11 = string6;
                Instant instant7 = instant2;
                Instant instant8 = instant;
                Schedule schedule5 = schedule2;
                long l16 = l3;
                boolean bl6 = bl;
                long l17 = l2;
                long l18 = l;
                String string12 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$92 = false;
                String string13 = "Rollup source index is null";
                String string14 = string12;
                long l19 = l18;
                long l20 = l17;
                boolean bl7 = bl6;
                long l21 = l16;
                Schedule schedule6 = schedule5;
                Instant instant9 = instant8;
                Instant instant10 = instant7;
                String string15 = string11;
                String $i$a$-requireNotNull-Rollup$Companion$parse$92 = string13;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$92.toString());
            }
            String string16 = targetIndex;
            if (string16 == null) {
                String string17 = string10;
                String string18 = string6;
                Instant instant11 = instant2;
                Instant instant12 = instant;
                Schedule schedule7 = schedule2;
                long l22 = l3;
                boolean bl8 = bl;
                long l23 = l2;
                long l24 = l;
                String string19 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$102 = false;
                String string20 = "Rollup target index is null";
                String string21 = string19;
                long l25 = l24;
                long l26 = l23;
                boolean bl9 = bl8;
                long l27 = l22;
                Schedule schedule8 = schedule7;
                Instant instant13 = instant12;
                Instant instant14 = instant11;
                String string22 = string18;
                String string23 = string17;
                String $i$a$-requireNotNull-Rollup$Companion$parse$102 = string20;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$102.toString());
            }
            String string24 = metadataID;
            Integer n = pageSize;
            if (n == null) {
                List list = null;
                String string25 = string24;
                String string26 = string16;
                String string27 = string10;
                String string28 = string6;
                Instant instant15 = instant2;
                Instant instant16 = instant;
                Schedule schedule9 = schedule2;
                long l28 = l3;
                boolean bl10 = bl;
                long l29 = l2;
                long l30 = l;
                String string29 = string;
                boolean bl11 = false;
                String string30 = "Rollup page size is null";
                String string31 = string29;
                long l31 = l30;
                long l32 = l29;
                boolean bl12 = bl10;
                long l33 = l28;
                Schedule schedule10 = schedule9;
                Instant instant17 = instant16;
                Instant instant18 = instant15;
                String string32 = string28;
                String string33 = string27;
                String string34 = string26;
                String string35 = string25;
                List list2 = list;
                String string36 = string30;
                throw new IllegalArgumentException(string36.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 4096;
            User user2 = user;
            List list = metrics;
            List list3 = dimensions;
            boolean bl13 = continuous;
            Long l34 = delay;
            int n3 = ((Number)n).intValue();
            List list4 = null;
            String string37 = string24;
            String string38 = string16;
            String string39 = string10;
            String string40 = string6;
            Instant instant19 = instant2;
            Instant instant20 = instant;
            Schedule schedule11 = schedule2;
            long l35 = l3;
            boolean bl14 = bl;
            long l36 = l2;
            long l37 = l;
            String string41 = string;
            return new Rollup(string41, l37, l36, bl14, l35, schedule11, instant20, instant19, string40, string39, string38, string37, list4, n3, l34, bl13, list3, list, user2, n2, defaultConstructorMarker);
        }

        public static /* synthetic */ Rollup parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id2, seqNo, 0L, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id2, 0L, 0L, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, null, 0L, 0L, 14, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup$Companion$ScheduleType;", "", "(Ljava/lang/String;I)V", "CRON", "INTERVAL", "opensearch-index-management"})
        public static final class ScheduleType
        extends Enum<ScheduleType> {
            public static final /* enum */ ScheduleType CRON = new ScheduleType();
            public static final /* enum */ ScheduleType INTERVAL = new ScheduleType();
            private static final /* synthetic */ ScheduleType[] $VALUES;

            public static ScheduleType[] values() {
                return (ScheduleType[])$VALUES.clone();
            }

            public static ScheduleType valueOf(String value) {
                return Enum.valueOf(ScheduleType.class, value);
            }

            static {
                $VALUES = scheduleTypeArray = new ScheduleType[]{ScheduleType.CRON, ScheduleType.INTERVAL};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Companion.ScheduleType.values().length];
            try {
                nArray[Companion.ScheduleType.CRON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.ScheduleType.INTERVAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

