/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;

public class NoLoggingImpl
implements Log {
    private int infoCount;
    private int errorCount;
    private int warnCount;
    private int debugCount;
    private String loggerName;

    public NoLoggingImpl(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void error(String s, Throwable e) {
        this.error(s);
        if (e != null) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        if (s != null) {
            System.err.println(this.loggerName + " : " + s);
        }
    }

    @Override
    public void debug(String s) {
        ++this.debugCount;
    }

    @Override
    public void debug(String s, Throwable e) {
        ++this.debugCount;
    }

    @Override
    public void warn(String s) {
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        ++this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public void info(String s) {
        ++this.infoCount;
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }
}

