"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    indexService
  } = services;
  router.post({
    path: _constants.NODE_API._SEARCH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.search);
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean(),
        expandWildcards: _configSchema.schema.maybe(_configSchema.schema.string()),
        exactSearch: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.editRolloverAlias);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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