/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.http.HttpChannel;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpServerTransport;
import org.opensearch.http.netty4.Netty4HttpServerTransport;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.netty4.ssl.SslUtils;

public class SecureNetty4HttpServerTransport
extends Netty4HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SecureNetty4HttpServerTransport.class);
    private final SecureTransportSettingsProvider secureTransportSettingsProvider;
    private final SecureTransportSettingsProvider.ServerExceptionHandler exceptionHandler;

    public SecureNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, tracer);
        this.secureTransportSettingsProvider = secureTransportSettingsProvider;
        this.exceptionHandler = secureTransportSettingsProvider.buildHttpServerExceptionHandler(settings, (HttpServerTransport)this).orElse(SecureTransportSettingsProvider.ServerExceptionHandler.NOOP);
    }

    @Override
    public ChannelHandler configureServerChannelHandler() {
        return new SslHttpChannelHandler(this, this.handlingSettings);
    }

    @Override
    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException && cause0 != null) {
            cause = cause0.getCause();
        }
        this.exceptionHandler.onError(cause);
        logger.error("Exception during establishing a SSL connection: " + String.valueOf(cause), cause);
        super.onException(channel, cause0);
    }

    protected class SslHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SslHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            super(transport, handlingSettings);
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SSLEngine sslEngine = SecureNetty4HttpServerTransport.this.secureTransportSettingsProvider.buildSecureHttpServerEngine(SecureNetty4HttpServerTransport.this.settings, (HttpServerTransport)SecureNetty4HttpServerTransport.this).orElseGet(SslUtils::createDefaultServerSSLEngine);
            SslHandler sslHandler = new SslHandler(sslEngine);
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }
    }
}

