import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeResourceScanCommand, se_DescribeResourceScanCommand } from "../protocols/Aws_query";
export { $Command };
export class DescribeResourceScanCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DescribeResourceScan", {})
    .n("CloudFormationClient", "DescribeResourceScanCommand")
    .f(void 0, void 0)
    .ser(se_DescribeResourceScanCommand)
    .de(de_DescribeResourceScanCommand)
    .build() {
}
