import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListExportsCommand, se_ListExportsCommand } from "../protocols/Aws_query";
export { $Command };
export class ListExportsCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListExports", {})
    .n("CloudFormationClient", "ListExportsCommand")
    .f(void 0, void 0)
    .ser(se_ListExportsCommand)
    .de(de_ListExportsCommand)
    .build() {
}
