import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListStackSetsCommand, se_ListStackSetsCommand } from "../protocols/Aws_query";
export { $Command };
export class ListStackSetsCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListStackSets", {})
    .n("CloudFormationClient", "ListStackSetsCommand")
    .f(void 0, void 0)
    .ser(se_ListStackSetsCommand)
    .de(de_ListStackSetsCommand)
    .build() {
}
