import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_TestTypeCommand, se_TestTypeCommand } from "../protocols/Aws_query";
export { $Command };
export class TestTypeCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "TestType", {})
    .n("CloudFormationClient", "TestTypeCommand")
    .f(void 0, void 0)
    .ser(se_TestTypeCommand)
    .de(de_TestTypeCommand)
    .build() {
}
