import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DescribeStackSetOperationInput, DescribeStackSetOperationOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeStackSetOperationCommand}.
 */
export interface DescribeStackSetOperationCommandInput extends DescribeStackSetOperationInput {
}
/**
 * @public
 *
 * The output of {@link DescribeStackSetOperationCommand}.
 */
export interface DescribeStackSetOperationCommandOutput extends DescribeStackSetOperationOutput, __MetadataBearer {
}
declare const DescribeStackSetOperationCommand_base: {
    new (input: DescribeStackSetOperationCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStackSetOperationCommandInput, DescribeStackSetOperationCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DescribeStackSetOperationCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStackSetOperationCommandInput, DescribeStackSetOperationCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns the description of the specified StackSet operation.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DescribeStackSetOperationCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DescribeStackSetOperationCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // DescribeStackSetOperationInput
 *   StackSetName: "STRING_VALUE", // required
 *   OperationId: "STRING_VALUE", // required
 *   CallAs: "SELF" || "DELEGATED_ADMIN",
 * };
 * const command = new DescribeStackSetOperationCommand(input);
 * const response = await client.send(command);
 * // { // DescribeStackSetOperationOutput
 * //   StackSetOperation: { // StackSetOperation
 * //     OperationId: "STRING_VALUE",
 * //     StackSetId: "STRING_VALUE",
 * //     Action: "CREATE" || "UPDATE" || "DELETE" || "DETECT_DRIFT",
 * //     Status: "RUNNING" || "SUCCEEDED" || "FAILED" || "STOPPING" || "STOPPED" || "QUEUED",
 * //     OperationPreferences: { // StackSetOperationPreferences
 * //       RegionConcurrencyType: "SEQUENTIAL" || "PARALLEL",
 * //       RegionOrder: [ // RegionList
 * //         "STRING_VALUE",
 * //       ],
 * //       FailureToleranceCount: Number("int"),
 * //       FailureTolerancePercentage: Number("int"),
 * //       MaxConcurrentCount: Number("int"),
 * //       MaxConcurrentPercentage: Number("int"),
 * //       ConcurrencyMode: "STRICT_FAILURE_TOLERANCE" || "SOFT_FAILURE_TOLERANCE",
 * //     },
 * //     RetainStacks: true || false,
 * //     AdministrationRoleARN: "STRING_VALUE",
 * //     ExecutionRoleName: "STRING_VALUE",
 * //     CreationTimestamp: new Date("TIMESTAMP"),
 * //     EndTimestamp: new Date("TIMESTAMP"),
 * //     DeploymentTargets: { // DeploymentTargets
 * //       Accounts: [ // AccountList
 * //         "STRING_VALUE",
 * //       ],
 * //       AccountsUrl: "STRING_VALUE",
 * //       OrganizationalUnitIds: [ // OrganizationalUnitIdList
 * //         "STRING_VALUE",
 * //       ],
 * //       AccountFilterType: "NONE" || "INTERSECTION" || "DIFFERENCE" || "UNION",
 * //     },
 * //     StackSetDriftDetectionDetails: { // StackSetDriftDetectionDetails
 * //       DriftStatus: "DRIFTED" || "IN_SYNC" || "NOT_CHECKED",
 * //       DriftDetectionStatus: "COMPLETED" || "FAILED" || "PARTIAL_SUCCESS" || "IN_PROGRESS" || "STOPPED",
 * //       LastDriftCheckTimestamp: new Date("TIMESTAMP"),
 * //       TotalStackInstancesCount: Number("int"),
 * //       DriftedStackInstancesCount: Number("int"),
 * //       InSyncStackInstancesCount: Number("int"),
 * //       InProgressStackInstancesCount: Number("int"),
 * //       FailedStackInstancesCount: Number("int"),
 * //     },
 * //     StatusReason: "STRING_VALUE",
 * //     StatusDetails: { // StackSetOperationStatusDetails
 * //       FailedStackInstancesCount: Number("int"),
 * //     },
 * //   },
 * // };
 *
 * ```
 *
 * @param DescribeStackSetOperationCommandInput - {@link DescribeStackSetOperationCommandInput}
 * @returns {@link DescribeStackSetOperationCommandOutput}
 * @see {@link DescribeStackSetOperationCommandInput} for command's `input` shape.
 * @see {@link DescribeStackSetOperationCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link OperationNotFoundException} (client fault)
 *  <p>The specified ID refers to an operation that doesn't exist.</p>
 *
 * @throws {@link StackSetNotFoundException} (client fault)
 *  <p>The specified stack set doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 */
export declare class DescribeStackSetOperationCommand extends DescribeStackSetOperationCommand_base {
}
