import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { SetTypeConfigurationInput } from "../models/models_0";
import { SetTypeConfigurationOutput } from "../models/models_1";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link SetTypeConfigurationCommand}.
 */
export interface SetTypeConfigurationCommandInput extends SetTypeConfigurationInput {
}
/**
 * @public
 *
 * The output of {@link SetTypeConfigurationCommand}.
 */
export interface SetTypeConfigurationCommandOutput extends SetTypeConfigurationOutput, __MetadataBearer {
}
declare const SetTypeConfigurationCommand_base: {
    new (input: SetTypeConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<SetTypeConfigurationCommandInput, SetTypeConfigurationCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: SetTypeConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<SetTypeConfigurationCommandInput, SetTypeConfigurationCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Specifies the configuration data for a registered CloudFormation extension, in the given account and Region.</p>
 *          <p>To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element
 *    of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-private.html#registry-set-configuration">Configuring extensions at
 *     the account level</a> in the <i>CloudFormation User Guide</i>.</p>
 *          <important>
 *             <p>It's strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
 *     as third-party credentials. For more details on dynamic references, see <a href="https://docs.aws.amazon.com/">Using
 *     dynamic references to specify template values</a> in the <i>CloudFormation User Guide</i>.</p>
 *          </important>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, SetTypeConfigurationCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, SetTypeConfigurationCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // SetTypeConfigurationInput
 *   TypeArn: "STRING_VALUE",
 *   Configuration: "STRING_VALUE", // required
 *   ConfigurationAlias: "STRING_VALUE",
 *   TypeName: "STRING_VALUE",
 *   Type: "RESOURCE" || "MODULE" || "HOOK",
 * };
 * const command = new SetTypeConfigurationCommand(input);
 * const response = await client.send(command);
 * // { // SetTypeConfigurationOutput
 * //   ConfigurationArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param SetTypeConfigurationCommandInput - {@link SetTypeConfigurationCommandInput}
 * @returns {@link SetTypeConfigurationCommandOutput}
 * @see {@link SetTypeConfigurationCommandInput} for command's `input` shape.
 * @see {@link SetTypeConfigurationCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link TypeNotFoundException} (client fault)
 *  <p>The specified extension doesn't exist in the CloudFormation registry.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 */
export declare class SetTypeConfigurationCommand extends SetTypeConfigurationCommand_base {
}
