import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
export declare const AccountFilterType: {
  readonly DIFFERENCE: "DIFFERENCE";
  readonly INTERSECTION: "INTERSECTION";
  readonly NONE: "NONE";
  readonly UNION: "UNION";
};
export type AccountFilterType =
  (typeof AccountFilterType)[keyof typeof AccountFilterType];
export declare const AccountGateStatus: {
  readonly FAILED: "FAILED";
  readonly SKIPPED: "SKIPPED";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type AccountGateStatus =
  (typeof AccountGateStatus)[keyof typeof AccountGateStatus];
export interface AccountGateResult {
  Status?: AccountGateStatus;
  StatusReason?: string;
}
export interface AccountLimit {
  Name?: string;
  Value?: number;
}
export interface ActivateOrganizationsAccessInput {}
export interface ActivateOrganizationsAccessOutput {}
export declare class InvalidOperationException extends __BaseException {
  readonly name: "InvalidOperationException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidOperationException, __BaseException>
  );
}
export declare class OperationNotFoundException extends __BaseException {
  readonly name: "OperationNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<OperationNotFoundException, __BaseException>
  );
}
export interface LoggingConfig {
  LogRoleArn: string | undefined;
  LogGroupName: string | undefined;
}
export declare const ThirdPartyType: {
  readonly HOOK: "HOOK";
  readonly MODULE: "MODULE";
  readonly RESOURCE: "RESOURCE";
};
export type ThirdPartyType =
  (typeof ThirdPartyType)[keyof typeof ThirdPartyType];
export declare const VersionBump: {
  readonly MAJOR: "MAJOR";
  readonly MINOR: "MINOR";
};
export type VersionBump = (typeof VersionBump)[keyof typeof VersionBump];
export interface ActivateTypeInput {
  Type?: ThirdPartyType;
  PublicTypeArn?: string;
  PublisherId?: string;
  TypeName?: string;
  TypeNameAlias?: string;
  AutoUpdate?: boolean;
  LoggingConfig?: LoggingConfig;
  ExecutionRoleArn?: string;
  VersionBump?: VersionBump;
  MajorVersion?: number;
}
export interface ActivateTypeOutput {
  Arn?: string;
}
export declare class CFNRegistryException extends __BaseException {
  readonly name: "CFNRegistryException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<CFNRegistryException, __BaseException>
  );
}
export declare class TypeNotFoundException extends __BaseException {
  readonly name: "TypeNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<TypeNotFoundException, __BaseException>
  );
}
export declare class AlreadyExistsException extends __BaseException {
  readonly name: "AlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>
  );
}
export declare const AttributeChangeType: {
  readonly Add: "Add";
  readonly Modify: "Modify";
  readonly Remove: "Remove";
};
export type AttributeChangeType =
  (typeof AttributeChangeType)[keyof typeof AttributeChangeType];
export interface AutoDeployment {
  Enabled?: boolean;
  RetainStacksOnAccountRemoval?: boolean;
}
export interface TypeConfigurationIdentifier {
  TypeArn?: string;
  TypeConfigurationAlias?: string;
  TypeConfigurationArn?: string;
  Type?: ThirdPartyType;
  TypeName?: string;
}
export interface BatchDescribeTypeConfigurationsInput {
  TypeConfigurationIdentifiers: TypeConfigurationIdentifier[] | undefined;
}
export interface BatchDescribeTypeConfigurationsError {
  ErrorCode?: string;
  ErrorMessage?: string;
  TypeConfigurationIdentifier?: TypeConfigurationIdentifier;
}
export interface TypeConfigurationDetails {
  Arn?: string;
  Alias?: string;
  Configuration?: string;
  LastUpdated?: Date;
  TypeArn?: string;
  TypeName?: string;
  IsDefaultConfiguration?: boolean;
}
export interface BatchDescribeTypeConfigurationsOutput {
  Errors?: BatchDescribeTypeConfigurationsError[];
  UnprocessedTypeConfigurations?: TypeConfigurationIdentifier[];
  TypeConfigurations?: TypeConfigurationDetails[];
}
export declare class TypeConfigurationNotFoundException extends __BaseException {
  readonly name: "TypeConfigurationNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      TypeConfigurationNotFoundException,
      __BaseException
    >
  );
}
export declare const CallAs: {
  readonly DELEGATED_ADMIN: "DELEGATED_ADMIN";
  readonly SELF: "SELF";
};
export type CallAs = (typeof CallAs)[keyof typeof CallAs];
export interface CancelUpdateStackInput {
  StackName: string | undefined;
  ClientRequestToken?: string;
}
export declare class TokenAlreadyExistsException extends __BaseException {
  readonly name: "TokenAlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<TokenAlreadyExistsException, __BaseException>
  );
}
export declare const Capability: {
  readonly CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND";
  readonly CAPABILITY_IAM: "CAPABILITY_IAM";
  readonly CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM";
};
export type Capability = (typeof Capability)[keyof typeof Capability];
export declare const Category: {
  readonly ACTIVATED: "ACTIVATED";
  readonly AWS_TYPES: "AWS_TYPES";
  readonly REGISTERED: "REGISTERED";
  readonly THIRD_PARTY: "THIRD_PARTY";
};
export type Category = (typeof Category)[keyof typeof Category];
export declare const ChangeAction: {
  readonly Add: "Add";
  readonly Dynamic: "Dynamic";
  readonly Import: "Import";
  readonly Modify: "Modify";
  readonly Remove: "Remove";
};
export type ChangeAction = (typeof ChangeAction)[keyof typeof ChangeAction];
export declare const ChangeSource: {
  readonly Automatic: "Automatic";
  readonly DirectModification: "DirectModification";
  readonly ParameterReference: "ParameterReference";
  readonly ResourceAttribute: "ResourceAttribute";
  readonly ResourceReference: "ResourceReference";
};
export type ChangeSource = (typeof ChangeSource)[keyof typeof ChangeSource];
export declare const EvaluationType: {
  readonly Dynamic: "Dynamic";
  readonly Static: "Static";
};
export type EvaluationType =
  (typeof EvaluationType)[keyof typeof EvaluationType];
export declare const ResourceAttribute: {
  readonly CreationPolicy: "CreationPolicy";
  readonly DeletionPolicy: "DeletionPolicy";
  readonly Metadata: "Metadata";
  readonly Properties: "Properties";
  readonly Tags: "Tags";
  readonly UpdatePolicy: "UpdatePolicy";
  readonly UpdateReplacePolicy: "UpdateReplacePolicy";
};
export type ResourceAttribute =
  (typeof ResourceAttribute)[keyof typeof ResourceAttribute];
export declare const RequiresRecreation: {
  readonly Always: "Always";
  readonly Conditionally: "Conditionally";
  readonly Never: "Never";
};
export type RequiresRecreation =
  (typeof RequiresRecreation)[keyof typeof RequiresRecreation];
export interface ResourceTargetDefinition {
  Attribute?: ResourceAttribute;
  Name?: string;
  RequiresRecreation?: RequiresRecreation;
  Path?: string;
  BeforeValue?: string;
  AfterValue?: string;
  AttributeChangeType?: AttributeChangeType;
}
export interface ResourceChangeDetail {
  Target?: ResourceTargetDefinition;
  Evaluation?: EvaluationType;
  ChangeSource?: ChangeSource;
  CausingEntity?: string;
}
export interface ModuleInfo {
  TypeHierarchy?: string;
  LogicalIdHierarchy?: string;
}
export declare const PolicyAction: {
  readonly Delete: "Delete";
  readonly ReplaceAndDelete: "ReplaceAndDelete";
  readonly ReplaceAndRetain: "ReplaceAndRetain";
  readonly ReplaceAndSnapshot: "ReplaceAndSnapshot";
  readonly Retain: "Retain";
  readonly Snapshot: "Snapshot";
};
export type PolicyAction = (typeof PolicyAction)[keyof typeof PolicyAction];
export declare const Replacement: {
  readonly Conditional: "Conditional";
  readonly False: "False";
  readonly True: "True";
};
export type Replacement = (typeof Replacement)[keyof typeof Replacement];
export interface ResourceChange {
  PolicyAction?: PolicyAction;
  Action?: ChangeAction;
  LogicalResourceId?: string;
  PhysicalResourceId?: string;
  ResourceType?: string;
  Replacement?: Replacement;
  Scope?: ResourceAttribute[];
  Details?: ResourceChangeDetail[];
  ChangeSetId?: string;
  ModuleInfo?: ModuleInfo;
  BeforeContext?: string;
  AfterContext?: string;
}
export declare const ChangeType: {
  readonly Resource: "Resource";
};
export type ChangeType = (typeof ChangeType)[keyof typeof ChangeType];
export interface Change {
  Type?: ChangeType;
  HookInvocationCount?: number;
  ResourceChange?: ResourceChange;
}
export declare const HookFailureMode: {
  readonly FAIL: "FAIL";
  readonly WARN: "WARN";
};
export type HookFailureMode =
  (typeof HookFailureMode)[keyof typeof HookFailureMode];
export declare const HookInvocationPoint: {
  readonly PRE_PROVISION: "PRE_PROVISION";
};
export type HookInvocationPoint =
  (typeof HookInvocationPoint)[keyof typeof HookInvocationPoint];
export interface ChangeSetHookResourceTargetDetails {
  LogicalResourceId?: string;
  ResourceType?: string;
  ResourceAction?: ChangeAction;
}
export declare const HookTargetType: {
  readonly RESOURCE: "RESOURCE";
};
export type HookTargetType =
  (typeof HookTargetType)[keyof typeof HookTargetType];
export interface ChangeSetHookTargetDetails {
  TargetType?: HookTargetType;
  ResourceTargetDetails?: ChangeSetHookResourceTargetDetails;
}
export interface ChangeSetHook {
  InvocationPoint?: HookInvocationPoint;
  FailureMode?: HookFailureMode;
  TypeName?: string;
  TypeVersionId?: string;
  TypeConfigurationVersionId?: string;
  TargetDetails?: ChangeSetHookTargetDetails;
}
export declare const ChangeSetHooksStatus: {
  readonly PLANNED: "PLANNED";
  readonly PLANNING: "PLANNING";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type ChangeSetHooksStatus =
  (typeof ChangeSetHooksStatus)[keyof typeof ChangeSetHooksStatus];
export declare class ChangeSetNotFoundException extends __BaseException {
  readonly name: "ChangeSetNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ChangeSetNotFoundException, __BaseException>
  );
}
export declare const ChangeSetStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly CREATE_PENDING: "CREATE_PENDING";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_PENDING: "DELETE_PENDING";
  readonly FAILED: "FAILED";
};
export type ChangeSetStatus =
  (typeof ChangeSetStatus)[keyof typeof ChangeSetStatus];
export declare const ExecutionStatus: {
  readonly AVAILABLE: "AVAILABLE";
  readonly EXECUTE_COMPLETE: "EXECUTE_COMPLETE";
  readonly EXECUTE_FAILED: "EXECUTE_FAILED";
  readonly EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS";
  readonly OBSOLETE: "OBSOLETE";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type ExecutionStatus =
  (typeof ExecutionStatus)[keyof typeof ExecutionStatus];
export interface ChangeSetSummary {
  StackId?: string;
  StackName?: string;
  ChangeSetId?: string;
  ChangeSetName?: string;
  ExecutionStatus?: ExecutionStatus;
  Status?: ChangeSetStatus;
  StatusReason?: string;
  CreationTime?: Date;
  Description?: string;
  IncludeNestedStacks?: boolean;
  ParentChangeSetId?: string;
  RootChangeSetId?: string;
  ImportExistingResources?: boolean;
}
export declare const ChangeSetType: {
  readonly CREATE: "CREATE";
  readonly IMPORT: "IMPORT";
  readonly UPDATE: "UPDATE";
};
export type ChangeSetType = (typeof ChangeSetType)[keyof typeof ChangeSetType];
export interface ContinueUpdateRollbackInput {
  StackName: string | undefined;
  RoleARN?: string;
  ResourcesToSkip?: string[];
  ClientRequestToken?: string;
}
export interface ContinueUpdateRollbackOutput {}
export declare const OnStackFailure: {
  readonly DELETE: "DELETE";
  readonly DO_NOTHING: "DO_NOTHING";
  readonly ROLLBACK: "ROLLBACK";
};
export type OnStackFailure =
  (typeof OnStackFailure)[keyof typeof OnStackFailure];
export interface Parameter {
  ParameterKey?: string;
  ParameterValue?: string;
  UsePreviousValue?: boolean;
  ResolvedValue?: string;
}
export interface ResourceToImport {
  ResourceType: string | undefined;
  LogicalResourceId: string | undefined;
  ResourceIdentifier: Record<string, string> | undefined;
}
export interface RollbackTrigger {
  Arn: string | undefined;
  Type: string | undefined;
}
export interface RollbackConfiguration {
  RollbackTriggers?: RollbackTrigger[];
  MonitoringTimeInMinutes?: number;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateChangeSetInput {
  StackName: string | undefined;
  TemplateBody?: string;
  TemplateURL?: string;
  UsePreviousTemplate?: boolean;
  Parameters?: Parameter[];
  Capabilities?: Capability[];
  ResourceTypes?: string[];
  RoleARN?: string;
  RollbackConfiguration?: RollbackConfiguration;
  NotificationARNs?: string[];
  Tags?: Tag[];
  ChangeSetName: string | undefined;
  ClientToken?: string;
  Description?: string;
  ChangeSetType?: ChangeSetType;
  ResourcesToImport?: ResourceToImport[];
  IncludeNestedStacks?: boolean;
  OnStackFailure?: OnStackFailure;
  ImportExistingResources?: boolean;
}
export interface CreateChangeSetOutput {
  Id?: string;
  StackId?: string;
}
export declare class InsufficientCapabilitiesException extends __BaseException {
  readonly name: "InsufficientCapabilitiesException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InsufficientCapabilitiesException,
      __BaseException
    >
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class ConcurrentResourcesLimitExceededException extends __BaseException {
  readonly name: "ConcurrentResourcesLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ConcurrentResourcesLimitExceededException,
      __BaseException
    >
  );
}
export interface ResourceDefinition {
  ResourceType: string | undefined;
  LogicalResourceId?: string;
  ResourceIdentifier: Record<string, string> | undefined;
}
export declare const GeneratedTemplateDeletionPolicy: {
  readonly DELETE: "DELETE";
  readonly RETAIN: "RETAIN";
};
export type GeneratedTemplateDeletionPolicy =
  (typeof GeneratedTemplateDeletionPolicy)[keyof typeof GeneratedTemplateDeletionPolicy];
export declare const GeneratedTemplateUpdateReplacePolicy: {
  readonly DELETE: "DELETE";
  readonly RETAIN: "RETAIN";
};
export type GeneratedTemplateUpdateReplacePolicy =
  (typeof GeneratedTemplateUpdateReplacePolicy)[keyof typeof GeneratedTemplateUpdateReplacePolicy];
export interface TemplateConfiguration {
  DeletionPolicy?: GeneratedTemplateDeletionPolicy;
  UpdateReplacePolicy?: GeneratedTemplateUpdateReplacePolicy;
}
export interface CreateGeneratedTemplateInput {
  Resources?: ResourceDefinition[];
  GeneratedTemplateName: string | undefined;
  StackName?: string;
  TemplateConfiguration?: TemplateConfiguration;
}
export interface CreateGeneratedTemplateOutput {
  GeneratedTemplateId?: string;
}
export declare const OnFailure: {
  readonly DELETE: "DELETE";
  readonly DO_NOTHING: "DO_NOTHING";
  readonly ROLLBACK: "ROLLBACK";
};
export type OnFailure = (typeof OnFailure)[keyof typeof OnFailure];
export interface CreateStackInput {
  StackName: string | undefined;
  TemplateBody?: string;
  TemplateURL?: string;
  Parameters?: Parameter[];
  DisableRollback?: boolean;
  RollbackConfiguration?: RollbackConfiguration;
  TimeoutInMinutes?: number;
  NotificationARNs?: string[];
  Capabilities?: Capability[];
  ResourceTypes?: string[];
  RoleARN?: string;
  OnFailure?: OnFailure;
  StackPolicyBody?: string;
  StackPolicyURL?: string;
  Tags?: Tag[];
  ClientRequestToken?: string;
  EnableTerminationProtection?: boolean;
  RetainExceptOnCreate?: boolean;
}
export interface CreateStackOutput {
  StackId?: string;
}
export interface DeploymentTargets {
  Accounts?: string[];
  AccountsUrl?: string;
  OrganizationalUnitIds?: string[];
  AccountFilterType?: AccountFilterType;
}
export declare const ConcurrencyMode: {
  readonly SOFT_FAILURE_TOLERANCE: "SOFT_FAILURE_TOLERANCE";
  readonly STRICT_FAILURE_TOLERANCE: "STRICT_FAILURE_TOLERANCE";
};
export type ConcurrencyMode =
  (typeof ConcurrencyMode)[keyof typeof ConcurrencyMode];
export declare const RegionConcurrencyType: {
  readonly PARALLEL: "PARALLEL";
  readonly SEQUENTIAL: "SEQUENTIAL";
};
export type RegionConcurrencyType =
  (typeof RegionConcurrencyType)[keyof typeof RegionConcurrencyType];
export interface StackSetOperationPreferences {
  RegionConcurrencyType?: RegionConcurrencyType;
  RegionOrder?: string[];
  FailureToleranceCount?: number;
  FailureTolerancePercentage?: number;
  MaxConcurrentCount?: number;
  MaxConcurrentPercentage?: number;
  ConcurrencyMode?: ConcurrencyMode;
}
export interface CreateStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[];
  DeploymentTargets?: DeploymentTargets;
  Regions: string[] | undefined;
  ParameterOverrides?: Parameter[];
  OperationPreferences?: StackSetOperationPreferences;
  OperationId?: string;
  CallAs?: CallAs;
}
export interface CreateStackInstancesOutput {
  OperationId?: string;
}
export declare class OperationIdAlreadyExistsException extends __BaseException {
  readonly name: "OperationIdAlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      OperationIdAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class OperationInProgressException extends __BaseException {
  readonly name: "OperationInProgressException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<OperationInProgressException, __BaseException>
  );
}
export declare class StackSetNotFoundException extends __BaseException {
  readonly name: "StackSetNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<StackSetNotFoundException, __BaseException>
  );
}
export declare class StaleRequestException extends __BaseException {
  readonly name: "StaleRequestException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<StaleRequestException, __BaseException>
  );
}
export declare class CreatedButModifiedException extends __BaseException {
  readonly name: "CreatedButModifiedException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<CreatedButModifiedException, __BaseException>
  );
}
export interface ManagedExecution {
  Active?: boolean;
}
export declare const PermissionModels: {
  readonly SELF_MANAGED: "SELF_MANAGED";
  readonly SERVICE_MANAGED: "SERVICE_MANAGED";
};
export type PermissionModels =
  (typeof PermissionModels)[keyof typeof PermissionModels];
export interface CreateStackSetInput {
  StackSetName: string | undefined;
  Description?: string;
  TemplateBody?: string;
  TemplateURL?: string;
  StackId?: string;
  Parameters?: Parameter[];
  Capabilities?: Capability[];
  Tags?: Tag[];
  AdministrationRoleARN?: string;
  ExecutionRoleName?: string;
  PermissionModel?: PermissionModels;
  AutoDeployment?: AutoDeployment;
  CallAs?: CallAs;
  ClientRequestToken?: string;
  ManagedExecution?: ManagedExecution;
}
export interface CreateStackSetOutput {
  StackSetId?: string;
}
export declare class NameAlreadyExistsException extends __BaseException {
  readonly name: "NameAlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<NameAlreadyExistsException, __BaseException>
  );
}
export interface DeactivateOrganizationsAccessInput {}
export interface DeactivateOrganizationsAccessOutput {}
export interface DeactivateTypeInput {
  TypeName?: string;
  Type?: ThirdPartyType;
  Arn?: string;
}
export interface DeactivateTypeOutput {}
export interface DeleteChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string;
}
export interface DeleteChangeSetOutput {}
export declare class InvalidChangeSetStatusException extends __BaseException {
  readonly name: "InvalidChangeSetStatusException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidChangeSetStatusException,
      __BaseException
    >
  );
}
export interface DeleteGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
}
export declare class GeneratedTemplateNotFoundException extends __BaseException {
  readonly name: "GeneratedTemplateNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      GeneratedTemplateNotFoundException,
      __BaseException
    >
  );
}
export interface DeleteStackInput {
  StackName: string | undefined;
  RetainResources?: string[];
  RoleARN?: string;
  ClientRequestToken?: string;
}
export interface DeleteStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[];
  DeploymentTargets?: DeploymentTargets;
  Regions: string[] | undefined;
  OperationPreferences?: StackSetOperationPreferences;
  RetainStacks: boolean | undefined;
  OperationId?: string;
  CallAs?: CallAs;
}
export interface DeleteStackInstancesOutput {
  OperationId?: string;
}
export interface DeleteStackSetInput {
  StackSetName: string | undefined;
  CallAs?: CallAs;
}
export interface DeleteStackSetOutput {}
export declare class StackSetNotEmptyException extends __BaseException {
  readonly name: "StackSetNotEmptyException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<StackSetNotEmptyException, __BaseException>
  );
}
export declare const RegistryType: {
  readonly HOOK: "HOOK";
  readonly MODULE: "MODULE";
  readonly RESOURCE: "RESOURCE";
};
export type RegistryType = (typeof RegistryType)[keyof typeof RegistryType];
export interface DeregisterTypeInput {
  Arn?: string;
  Type?: RegistryType;
  TypeName?: string;
  VersionId?: string;
}
export interface DeregisterTypeOutput {}
export interface DescribeAccountLimitsInput {
  NextToken?: string;
}
export interface DescribeAccountLimitsOutput {
  AccountLimits?: AccountLimit[];
  NextToken?: string;
}
export interface DescribeChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string;
  NextToken?: string;
  IncludePropertyValues?: boolean;
}
export interface DescribeChangeSetOutput {
  ChangeSetName?: string;
  ChangeSetId?: string;
  StackId?: string;
  StackName?: string;
  Description?: string;
  Parameters?: Parameter[];
  CreationTime?: Date;
  ExecutionStatus?: ExecutionStatus;
  Status?: ChangeSetStatus;
  StatusReason?: string;
  NotificationARNs?: string[];
  RollbackConfiguration?: RollbackConfiguration;
  Capabilities?: Capability[];
  Tags?: Tag[];
  Changes?: Change[];
  NextToken?: string;
  IncludeNestedStacks?: boolean;
  ParentChangeSetId?: string;
  RootChangeSetId?: string;
  OnStackFailure?: OnStackFailure;
  ImportExistingResources?: boolean;
}
export interface DescribeChangeSetHooksInput {
  ChangeSetName: string | undefined;
  StackName?: string;
  NextToken?: string;
  LogicalResourceId?: string;
}
export interface DescribeChangeSetHooksOutput {
  ChangeSetId?: string;
  ChangeSetName?: string;
  Hooks?: ChangeSetHook[];
  Status?: ChangeSetHooksStatus;
  NextToken?: string;
  StackId?: string;
  StackName?: string;
}
export interface DescribeGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
}
export interface TemplateProgress {
  ResourcesSucceeded?: number;
  ResourcesFailed?: number;
  ResourcesProcessing?: number;
  ResourcesPending?: number;
}
export declare const GeneratedTemplateResourceStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PENDING: "PENDING";
};
export type GeneratedTemplateResourceStatus =
  (typeof GeneratedTemplateResourceStatus)[keyof typeof GeneratedTemplateResourceStatus];
export interface WarningProperty {
  PropertyPath?: string;
  Required?: boolean;
  Description?: string;
}
export declare const WarningType: {
  readonly MUTUALLY_EXCLUSIVE_PROPERTIES: "MUTUALLY_EXCLUSIVE_PROPERTIES";
  readonly MUTUALLY_EXCLUSIVE_TYPES: "MUTUALLY_EXCLUSIVE_TYPES";
  readonly UNSUPPORTED_PROPERTIES: "UNSUPPORTED_PROPERTIES";
};
export type WarningType = (typeof WarningType)[keyof typeof WarningType];
export interface WarningDetail {
  Type?: WarningType;
  Properties?: WarningProperty[];
}
export interface ResourceDetail {
  ResourceType?: string;
  LogicalResourceId?: string;
  ResourceIdentifier?: Record<string, string>;
  ResourceStatus?: GeneratedTemplateResourceStatus;
  ResourceStatusReason?: string;
  Warnings?: WarningDetail[];
}
export declare const GeneratedTemplateStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly CREATE_PENDING: "CREATE_PENDING";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_PENDING: "DELETE_PENDING";
  readonly FAILED: "FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_PENDING: "UPDATE_PENDING";
};
export type GeneratedTemplateStatus =
  (typeof GeneratedTemplateStatus)[keyof typeof GeneratedTemplateStatus];
export interface DescribeGeneratedTemplateOutput {
  GeneratedTemplateId?: string;
  GeneratedTemplateName?: string;
  Resources?: ResourceDetail[];
  Status?: GeneratedTemplateStatus;
  StatusReason?: string;
  CreationTime?: Date;
  LastUpdatedTime?: Date;
  Progress?: TemplateProgress;
  StackId?: string;
  TemplateConfiguration?: TemplateConfiguration;
  TotalWarnings?: number;
}
export interface DescribeOrganizationsAccessInput {
  CallAs?: CallAs;
}
export declare const OrganizationStatus: {
  readonly DISABLED: "DISABLED";
  readonly DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY";
  readonly ENABLED: "ENABLED";
};
export type OrganizationStatus =
  (typeof OrganizationStatus)[keyof typeof OrganizationStatus];
export interface DescribeOrganizationsAccessOutput {
  Status?: OrganizationStatus;
}
export interface DescribePublisherInput {
  PublisherId?: string;
}
export declare const IdentityProvider: {
  readonly AWS_Marketplace: "AWS_Marketplace";
  readonly Bitbucket: "Bitbucket";
  readonly GitHub: "GitHub";
};
export type IdentityProvider =
  (typeof IdentityProvider)[keyof typeof IdentityProvider];
export declare const PublisherStatus: {
  readonly UNVERIFIED: "UNVERIFIED";
  readonly VERIFIED: "VERIFIED";
};
export type PublisherStatus =
  (typeof PublisherStatus)[keyof typeof PublisherStatus];
export interface DescribePublisherOutput {
  PublisherId?: string;
  PublisherStatus?: PublisherStatus;
  IdentityProvider?: IdentityProvider;
  PublisherProfile?: string;
}
export interface DescribeResourceScanInput {
  ResourceScanId: string | undefined;
}
export declare const ResourceScanStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly EXPIRED: "EXPIRED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type ResourceScanStatus =
  (typeof ResourceScanStatus)[keyof typeof ResourceScanStatus];
export interface DescribeResourceScanOutput {
  ResourceScanId?: string;
  Status?: ResourceScanStatus;
  StatusReason?: string;
  StartTime?: Date;
  EndTime?: Date;
  PercentageCompleted?: number;
  ResourceTypes?: string[];
  ResourcesScanned?: number;
  ResourcesRead?: number;
}
export declare class ResourceScanNotFoundException extends __BaseException {
  readonly name: "ResourceScanNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceScanNotFoundException, __BaseException>
  );
}
export interface DescribeStackDriftDetectionStatusInput {
  StackDriftDetectionId: string | undefined;
}
export declare const StackDriftDetectionStatus: {
  readonly DETECTION_COMPLETE: "DETECTION_COMPLETE";
  readonly DETECTION_FAILED: "DETECTION_FAILED";
  readonly DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS";
};
export type StackDriftDetectionStatus =
  (typeof StackDriftDetectionStatus)[keyof typeof StackDriftDetectionStatus];
export declare const StackDriftStatus: {
  readonly DRIFTED: "DRIFTED";
  readonly IN_SYNC: "IN_SYNC";
  readonly NOT_CHECKED: "NOT_CHECKED";
  readonly UNKNOWN: "UNKNOWN";
};
export type StackDriftStatus =
  (typeof StackDriftStatus)[keyof typeof StackDriftStatus];
export interface DescribeStackDriftDetectionStatusOutput {
  StackId: string | undefined;
  StackDriftDetectionId: string | undefined;
  StackDriftStatus?: StackDriftStatus;
  DetectionStatus: StackDriftDetectionStatus | undefined;
  DetectionStatusReason?: string;
  DriftedStackResourceCount?: number;
  Timestamp: Date | undefined;
}
export interface DescribeStackEventsInput {
  StackName?: string;
  NextToken?: string;
}
export declare const DetailedStatus: {
  readonly CONFIGURATION_COMPLETE: "CONFIGURATION_COMPLETE";
  readonly VALIDATION_FAILED: "VALIDATION_FAILED";
};
export type DetailedStatus =
  (typeof DetailedStatus)[keyof typeof DetailedStatus];
export declare const HookStatus: {
  readonly HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED";
  readonly HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED";
  readonly HOOK_FAILED: "HOOK_FAILED";
  readonly HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS";
};
export type HookStatus = (typeof HookStatus)[keyof typeof HookStatus];
export declare const ResourceStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_SKIPPED: "DELETE_SKIPPED";
  readonly IMPORT_COMPLETE: "IMPORT_COMPLETE";
  readonly IMPORT_FAILED: "IMPORT_FAILED";
  readonly IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS";
  readonly IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE";
  readonly IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED";
  readonly IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS";
  readonly ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE";
  readonly UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED";
  readonly UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS";
};
export type ResourceStatus =
  (typeof ResourceStatus)[keyof typeof ResourceStatus];
export interface StackEvent {
  StackId: string | undefined;
  EventId: string | undefined;
  StackName: string | undefined;
  LogicalResourceId?: string;
  PhysicalResourceId?: string;
  ResourceType?: string;
  Timestamp: Date | undefined;
  ResourceStatus?: ResourceStatus;
  ResourceStatusReason?: string;
  ResourceProperties?: string;
  ClientRequestToken?: string;
  HookType?: string;
  HookStatus?: HookStatus;
  HookStatusReason?: string;
  HookInvocationPoint?: HookInvocationPoint;
  HookFailureMode?: HookFailureMode;
  DetailedStatus?: DetailedStatus;
}
export interface DescribeStackEventsOutput {
  StackEvents?: StackEvent[];
  NextToken?: string;
}
export interface DescribeStackInstanceInput {
  StackSetName: string | undefined;
  StackInstanceAccount: string | undefined;
  StackInstanceRegion: string | undefined;
  CallAs?: CallAs;
}
export declare const StackInstanceDetailedStatus: {
  readonly CANCELLED: "CANCELLED";
  readonly FAILED: "FAILED";
  readonly FAILED_IMPORT: "FAILED_IMPORT";
  readonly INOPERABLE: "INOPERABLE";
  readonly PENDING: "PENDING";
  readonly RUNNING: "RUNNING";
  readonly SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackInstanceDetailedStatus =
  (typeof StackInstanceDetailedStatus)[keyof typeof StackInstanceDetailedStatus];
export interface StackInstanceComprehensiveStatus {
  DetailedStatus?: StackInstanceDetailedStatus;
}
export declare const StackInstanceStatus: {
  readonly CURRENT: "CURRENT";
  readonly INOPERABLE: "INOPERABLE";
  readonly OUTDATED: "OUTDATED";
};
export type StackInstanceStatus =
  (typeof StackInstanceStatus)[keyof typeof StackInstanceStatus];
export interface StackInstance {
  StackSetId?: string;
  Region?: string;
  Account?: string;
  StackId?: string;
  ParameterOverrides?: Parameter[];
  Status?: StackInstanceStatus;
  StackInstanceStatus?: StackInstanceComprehensiveStatus;
  StatusReason?: string;
  OrganizationalUnitId?: string;
  DriftStatus?: StackDriftStatus;
  LastDriftCheckTimestamp?: Date;
  LastOperationId?: string;
}
export interface DescribeStackInstanceOutput {
  StackInstance?: StackInstance;
}
export declare class StackInstanceNotFoundException extends __BaseException {
  readonly name: "StackInstanceNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<StackInstanceNotFoundException, __BaseException>
  );
}
export interface DescribeStackResourceInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
}
export declare const StackResourceDriftStatus: {
  readonly DELETED: "DELETED";
  readonly IN_SYNC: "IN_SYNC";
  readonly MODIFIED: "MODIFIED";
  readonly NOT_CHECKED: "NOT_CHECKED";
};
export type StackResourceDriftStatus =
  (typeof StackResourceDriftStatus)[keyof typeof StackResourceDriftStatus];
export interface StackResourceDriftInformation {
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  LastCheckTimestamp?: Date;
}
export interface StackResourceDetail {
  StackName?: string;
  StackId?: string;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string;
  ResourceType: string | undefined;
  LastUpdatedTimestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string;
  Description?: string;
  Metadata?: string;
  DriftInformation?: StackResourceDriftInformation;
  ModuleInfo?: ModuleInfo;
}
export interface DescribeStackResourceOutput {
  StackResourceDetail?: StackResourceDetail;
}
export interface DescribeStackResourceDriftsInput {
  StackName: string | undefined;
  StackResourceDriftStatusFilters?: StackResourceDriftStatus[];
  NextToken?: string;
  MaxResults?: number;
}
export interface PhysicalResourceIdContextKeyValuePair {
  Key: string | undefined;
  Value: string | undefined;
}
export declare const DifferenceType: {
  readonly ADD: "ADD";
  readonly NOT_EQUAL: "NOT_EQUAL";
  readonly REMOVE: "REMOVE";
};
export type DifferenceType =
  (typeof DifferenceType)[keyof typeof DifferenceType];
export interface PropertyDifference {
  PropertyPath: string | undefined;
  ExpectedValue: string | undefined;
  ActualValue: string | undefined;
  DifferenceType: DifferenceType | undefined;
}
export interface StackResourceDrift {
  StackId: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string;
  PhysicalResourceIdContext?: PhysicalResourceIdContextKeyValuePair[];
  ResourceType: string | undefined;
  ExpectedProperties?: string;
  ActualProperties?: string;
  PropertyDifferences?: PropertyDifference[];
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  Timestamp: Date | undefined;
  ModuleInfo?: ModuleInfo;
}
export interface DescribeStackResourceDriftsOutput {
  StackResourceDrifts: StackResourceDrift[] | undefined;
  NextToken?: string;
}
export interface DescribeStackResourcesInput {
  StackName?: string;
  LogicalResourceId?: string;
  PhysicalResourceId?: string;
}
export interface StackResource {
  StackName?: string;
  StackId?: string;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string;
  ResourceType: string | undefined;
  Timestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string;
  Description?: string;
  DriftInformation?: StackResourceDriftInformation;
  ModuleInfo?: ModuleInfo;
}
export interface DescribeStackResourcesOutput {
  StackResources?: StackResource[];
}
export interface DescribeStacksInput {
  StackName?: string;
  NextToken?: string;
}
export interface StackDriftInformation {
  StackDriftStatus: StackDriftStatus | undefined;
  LastCheckTimestamp?: Date;
}
export interface Output {
  OutputKey?: string;
  OutputValue?: string;
  Description?: string;
  ExportName?: string;
}
export declare const StackStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly IMPORT_COMPLETE: "IMPORT_COMPLETE";
  readonly IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS";
  readonly IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE";
  readonly IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED";
  readonly IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS";
  readonly REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS";
  readonly ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
  readonly UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE";
  readonly UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED";
  readonly UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS";
};
export type StackStatus = (typeof StackStatus)[keyof typeof StackStatus];
export interface Stack {
  StackId?: string;
  StackName: string | undefined;
  ChangeSetId?: string;
  Description?: string;
  Parameters?: Parameter[];
  CreationTime: Date | undefined;
  DeletionTime?: Date;
  LastUpdatedTime?: Date;
  RollbackConfiguration?: RollbackConfiguration;
  StackStatus: StackStatus | undefined;
  StackStatusReason?: string;
  DisableRollback?: boolean;
  NotificationARNs?: string[];
  TimeoutInMinutes?: number;
  Capabilities?: Capability[];
  Outputs?: Output[];
  RoleARN?: string;
  Tags?: Tag[];
  EnableTerminationProtection?: boolean;
  ParentId?: string;
  RootId?: string;
  DriftInformation?: StackDriftInformation;
  RetainExceptOnCreate?: boolean;
  DetailedStatus?: DetailedStatus;
}
export interface DescribeStacksOutput {
  Stacks?: Stack[];
  NextToken?: string;
}
export interface DescribeStackSetInput {
  StackSetName: string | undefined;
  CallAs?: CallAs;
}
export declare const StackSetDriftDetectionStatus: {
  readonly COMPLETED: "COMPLETED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PARTIAL_SUCCESS: "PARTIAL_SUCCESS";
  readonly STOPPED: "STOPPED";
};
export type StackSetDriftDetectionStatus =
  (typeof StackSetDriftDetectionStatus)[keyof typeof StackSetDriftDetectionStatus];
export declare const StackSetDriftStatus: {
  readonly DRIFTED: "DRIFTED";
  readonly IN_SYNC: "IN_SYNC";
  readonly NOT_CHECKED: "NOT_CHECKED";
};
export type StackSetDriftStatus =
  (typeof StackSetDriftStatus)[keyof typeof StackSetDriftStatus];
export interface StackSetDriftDetectionDetails {
  DriftStatus?: StackSetDriftStatus;
  DriftDetectionStatus?: StackSetDriftDetectionStatus;
  LastDriftCheckTimestamp?: Date;
  TotalStackInstancesCount?: number;
  DriftedStackInstancesCount?: number;
  InSyncStackInstancesCount?: number;
  InProgressStackInstancesCount?: number;
  FailedStackInstancesCount?: number;
}
export declare const StackSetStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DELETED: "DELETED";
};
export type StackSetStatus =
  (typeof StackSetStatus)[keyof typeof StackSetStatus];
export interface StackSet {
  StackSetName?: string;
  StackSetId?: string;
  Description?: string;
  Status?: StackSetStatus;
  TemplateBody?: string;
  Parameters?: Parameter[];
  Capabilities?: Capability[];
  Tags?: Tag[];
  StackSetARN?: string;
  AdministrationRoleARN?: string;
  ExecutionRoleName?: string;
  StackSetDriftDetectionDetails?: StackSetDriftDetectionDetails;
  AutoDeployment?: AutoDeployment;
  PermissionModel?: PermissionModels;
  OrganizationalUnitIds?: string[];
  ManagedExecution?: ManagedExecution;
  Regions?: string[];
}
export interface DescribeStackSetOutput {
  StackSet?: StackSet;
}
export interface DescribeStackSetOperationInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs;
}
export declare const StackSetOperationAction: {
  readonly CREATE: "CREATE";
  readonly DELETE: "DELETE";
  readonly DETECT_DRIFT: "DETECT_DRIFT";
  readonly UPDATE: "UPDATE";
};
export type StackSetOperationAction =
  (typeof StackSetOperationAction)[keyof typeof StackSetOperationAction];
export declare const StackSetOperationStatus: {
  readonly FAILED: "FAILED";
  readonly QUEUED: "QUEUED";
  readonly RUNNING: "RUNNING";
  readonly STOPPED: "STOPPED";
  readonly STOPPING: "STOPPING";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackSetOperationStatus =
  (typeof StackSetOperationStatus)[keyof typeof StackSetOperationStatus];
export interface StackSetOperationStatusDetails {
  FailedStackInstancesCount?: number;
}
export interface StackSetOperation {
  OperationId?: string;
  StackSetId?: string;
  Action?: StackSetOperationAction;
  Status?: StackSetOperationStatus;
  OperationPreferences?: StackSetOperationPreferences;
  RetainStacks?: boolean;
  AdministrationRoleARN?: string;
  ExecutionRoleName?: string;
  CreationTimestamp?: Date;
  EndTimestamp?: Date;
  DeploymentTargets?: DeploymentTargets;
  StackSetDriftDetectionDetails?: StackSetDriftDetectionDetails;
  StatusReason?: string;
  StatusDetails?: StackSetOperationStatusDetails;
}
export interface DescribeStackSetOperationOutput {
  StackSetOperation?: StackSetOperation;
}
export interface DescribeTypeInput {
  Type?: RegistryType;
  TypeName?: string;
  Arn?: string;
  VersionId?: string;
  PublisherId?: string;
  PublicVersionNumber?: string;
}
export declare const DeprecatedStatus: {
  readonly DEPRECATED: "DEPRECATED";
  readonly LIVE: "LIVE";
};
export type DeprecatedStatus =
  (typeof DeprecatedStatus)[keyof typeof DeprecatedStatus];
export declare const ProvisioningType: {
  readonly FULLY_MUTABLE: "FULLY_MUTABLE";
  readonly IMMUTABLE: "IMMUTABLE";
  readonly NON_PROVISIONABLE: "NON_PROVISIONABLE";
};
export type ProvisioningType =
  (typeof ProvisioningType)[keyof typeof ProvisioningType];
export interface RequiredActivatedType {
  TypeNameAlias?: string;
  OriginalTypeName?: string;
  PublisherId?: string;
  SupportedMajorVersions?: number[];
}
export declare const TypeTestsStatus: {
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly NOT_TESTED: "NOT_TESTED";
  readonly PASSED: "PASSED";
};
export type TypeTestsStatus =
  (typeof TypeTestsStatus)[keyof typeof TypeTestsStatus];
export declare const Visibility: {
  readonly PRIVATE: "PRIVATE";
  readonly PUBLIC: "PUBLIC";
};
export type Visibility = (typeof Visibility)[keyof typeof Visibility];
export interface DescribeTypeOutput {
  Arn?: string;
  Type?: RegistryType;
  TypeName?: string;
  DefaultVersionId?: string;
  IsDefaultVersion?: boolean;
  TypeTestsStatus?: TypeTestsStatus;
  TypeTestsStatusDescription?: string;
  Description?: string;
  Schema?: string;
  ProvisioningType?: ProvisioningType;
  DeprecatedStatus?: DeprecatedStatus;
  LoggingConfig?: LoggingConfig;
  RequiredActivatedTypes?: RequiredActivatedType[];
  ExecutionRoleArn?: string;
  Visibility?: Visibility;
  SourceUrl?: string;
  DocumentationUrl?: string;
  LastUpdated?: Date;
  TimeCreated?: Date;
  ConfigurationSchema?: string;
  PublisherId?: string;
  OriginalTypeName?: string;
  OriginalTypeArn?: string;
  PublicVersionNumber?: string;
  LatestPublicVersion?: string;
  IsActivated?: boolean;
  AutoUpdate?: boolean;
}
export interface DescribeTypeRegistrationInput {
  RegistrationToken: string | undefined;
}
export declare const RegistrationStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type RegistrationStatus =
  (typeof RegistrationStatus)[keyof typeof RegistrationStatus];
export interface DescribeTypeRegistrationOutput {
  ProgressStatus?: RegistrationStatus;
  Description?: string;
  TypeArn?: string;
  TypeVersionArn?: string;
}
export interface DetectStackDriftInput {
  StackName: string | undefined;
  LogicalResourceIds?: string[];
}
export interface DetectStackDriftOutput {
  StackDriftDetectionId: string | undefined;
}
export interface DetectStackResourceDriftInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
}
export interface DetectStackResourceDriftOutput {
  StackResourceDrift: StackResourceDrift | undefined;
}
export interface DetectStackSetDriftInput {
  StackSetName: string | undefined;
  OperationPreferences?: StackSetOperationPreferences;
  OperationId?: string;
  CallAs?: CallAs;
}
export interface DetectStackSetDriftOutput {
  OperationId?: string;
}
export interface EstimateTemplateCostInput {
  TemplateBody?: string;
  TemplateURL?: string;
  Parameters?: Parameter[];
}
export interface EstimateTemplateCostOutput {
  Url?: string;
}
export interface ExecuteChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string;
  ClientRequestToken?: string;
  DisableRollback?: boolean;
  RetainExceptOnCreate?: boolean;
}
export interface ExecuteChangeSetOutput {}
export declare const TemplateFormat: {
  readonly JSON: "JSON";
  readonly YAML: "YAML";
};
export type TemplateFormat =
  (typeof TemplateFormat)[keyof typeof TemplateFormat];
export interface GetGeneratedTemplateInput {
  Format?: TemplateFormat;
  GeneratedTemplateName: string | undefined;
}
export interface GetGeneratedTemplateOutput {
  Status?: GeneratedTemplateStatus;
  TemplateBody?: string;
}
export interface GetStackPolicyInput {
  StackName: string | undefined;
}
export interface GetStackPolicyOutput {
  StackPolicyBody?: string;
}
export declare const TemplateStage: {
  readonly Original: "Original";
  readonly Processed: "Processed";
};
export type TemplateStage = (typeof TemplateStage)[keyof typeof TemplateStage];
export interface GetTemplateInput {
  StackName?: string;
  ChangeSetName?: string;
  TemplateStage?: TemplateStage;
}
export interface GetTemplateOutput {
  TemplateBody?: string;
  StagesAvailable?: TemplateStage[];
}
export interface TemplateSummaryConfig {
  TreatUnrecognizedResourceTypesAsWarnings?: boolean;
}
export interface GetTemplateSummaryInput {
  TemplateBody?: string;
  TemplateURL?: string;
  StackName?: string;
  StackSetName?: string;
  CallAs?: CallAs;
  TemplateSummaryConfig?: TemplateSummaryConfig;
}
export interface ParameterConstraints {
  AllowedValues?: string[];
}
export interface ParameterDeclaration {
  ParameterKey?: string;
  DefaultValue?: string;
  ParameterType?: string;
  NoEcho?: boolean;
  Description?: string;
  ParameterConstraints?: ParameterConstraints;
}
export interface ResourceIdentifierSummary {
  ResourceType?: string;
  LogicalResourceIds?: string[];
  ResourceIdentifiers?: string[];
}
export interface Warnings {
  UnrecognizedResourceTypes?: string[];
}
export interface GetTemplateSummaryOutput {
  Parameters?: ParameterDeclaration[];
  Description?: string;
  Capabilities?: Capability[];
  CapabilitiesReason?: string;
  ResourceTypes?: string[];
  Version?: string;
  Metadata?: string;
  DeclaredTransforms?: string[];
  ResourceIdentifierSummaries?: ResourceIdentifierSummary[];
  Warnings?: Warnings;
}
export interface ImportStacksToStackSetInput {
  StackSetName: string | undefined;
  StackIds?: string[];
  StackIdsUrl?: string;
  OrganizationalUnitIds?: string[];
  OperationPreferences?: StackSetOperationPreferences;
  OperationId?: string;
  CallAs?: CallAs;
}
export interface ImportStacksToStackSetOutput {
  OperationId?: string;
}
export declare class StackNotFoundException extends __BaseException {
  readonly name: "StackNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<StackNotFoundException, __BaseException>
  );
}
export interface ListChangeSetsInput {
  StackName: string | undefined;
  NextToken?: string;
}
export interface ListChangeSetsOutput {
  Summaries?: ChangeSetSummary[];
  NextToken?: string;
}
export interface ListExportsInput {
  NextToken?: string;
}
export interface Export {
  ExportingStackId?: string;
  Name?: string;
  Value?: string;
}
export interface ListExportsOutput {
  Exports?: Export[];
  NextToken?: string;
}
export interface ListGeneratedTemplatesInput {
  NextToken?: string;
  MaxResults?: number;
}
export interface TemplateSummary {
  GeneratedTemplateId?: string;
  GeneratedTemplateName?: string;
  Status?: GeneratedTemplateStatus;
  StatusReason?: string;
  CreationTime?: Date;
  LastUpdatedTime?: Date;
  NumberOfResources?: number;
}
export interface ListGeneratedTemplatesOutput {
  Summaries?: TemplateSummary[];
  NextToken?: string;
}
export interface ListImportsInput {
  ExportName: string | undefined;
  NextToken?: string;
}
export interface ListImportsOutput {
  Imports?: string[];
  NextToken?: string;
}
export interface ScannedResourceIdentifier {
  ResourceType: string | undefined;
  ResourceIdentifier: Record<string, string> | undefined;
}
export interface ListResourceScanRelatedResourcesInput {
  ResourceScanId: string | undefined;
  Resources: ScannedResourceIdentifier[] | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export interface ScannedResource {
  ResourceType?: string;
  ResourceIdentifier?: Record<string, string>;
  ManagedByStack?: boolean;
}
export interface ListResourceScanRelatedResourcesOutput {
  RelatedResources?: ScannedResource[];
  NextToken?: string;
}
export declare class ResourceScanInProgressException extends __BaseException {
  readonly name: "ResourceScanInProgressException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceScanInProgressException,
      __BaseException
    >
  );
}
export interface ListResourceScanResourcesInput {
  ResourceScanId: string | undefined;
  ResourceIdentifier?: string;
  ResourceTypePrefix?: string;
  TagKey?: string;
  TagValue?: string;
  NextToken?: string;
  MaxResults?: number;
}
export interface ListResourceScanResourcesOutput {
  Resources?: ScannedResource[];
  NextToken?: string;
}
export interface ListResourceScansInput {
  NextToken?: string;
  MaxResults?: number;
}
export interface ResourceScanSummary {
  ResourceScanId?: string;
  Status?: ResourceScanStatus;
  StatusReason?: string;
  StartTime?: Date;
  EndTime?: Date;
  PercentageCompleted?: number;
}
export interface ListResourceScansOutput {
  ResourceScanSummaries?: ResourceScanSummary[];
  NextToken?: string;
}
export interface ListStackInstanceResourceDriftsInput {
  StackSetName: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  StackInstanceResourceDriftStatuses?: StackResourceDriftStatus[];
  StackInstanceAccount: string | undefined;
  StackInstanceRegion: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs;
}
export interface StackInstanceResourceDriftsSummary {
  StackId: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string;
  PhysicalResourceIdContext?: PhysicalResourceIdContextKeyValuePair[];
  ResourceType: string | undefined;
  PropertyDifferences?: PropertyDifference[];
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  Timestamp: Date | undefined;
}
export interface ListStackInstanceResourceDriftsOutput {
  Summaries?: StackInstanceResourceDriftsSummary[];
  NextToken?: string;
}
export declare const StackInstanceFilterName: {
  readonly DETAILED_STATUS: "DETAILED_STATUS";
  readonly DRIFT_STATUS: "DRIFT_STATUS";
  readonly LAST_OPERATION_ID: "LAST_OPERATION_ID";
};
export type StackInstanceFilterName =
  (typeof StackInstanceFilterName)[keyof typeof StackInstanceFilterName];
export interface StackInstanceFilter {
  Name?: StackInstanceFilterName;
  Values?: string;
}
export interface ListStackInstancesInput {
  StackSetName: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  Filters?: StackInstanceFilter[];
  StackInstanceAccount?: string;
  StackInstanceRegion?: string;
  CallAs?: CallAs;
}
export interface StackInstanceSummary {
  StackSetId?: string;
  Region?: string;
  Account?: string;
  StackId?: string;
  Status?: StackInstanceStatus;
  StatusReason?: string;
  StackInstanceStatus?: StackInstanceComprehensiveStatus;
  OrganizationalUnitId?: string;
  DriftStatus?: StackDriftStatus;
  LastDriftCheckTimestamp?: Date;
  LastOperationId?: string;
}
export interface ListStackInstancesOutput {
  Summaries?: StackInstanceSummary[];
  NextToken?: string;
}
export interface ListStackResourcesInput {
  StackName: string | undefined;
  NextToken?: string;
}
export interface StackResourceDriftInformationSummary {
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  LastCheckTimestamp?: Date;
}
export interface StackResourceSummary {
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string;
  ResourceType: string | undefined;
  LastUpdatedTimestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string;
  DriftInformation?: StackResourceDriftInformationSummary;
  ModuleInfo?: ModuleInfo;
}
export interface ListStackResourcesOutput {
  StackResourceSummaries?: StackResourceSummary[];
  NextToken?: string;
}
export interface ListStacksInput {
  NextToken?: string;
  StackStatusFilter?: StackStatus[];
}
export interface StackDriftInformationSummary {
  StackDriftStatus: StackDriftStatus | undefined;
  LastCheckTimestamp?: Date;
}
export interface StackSummary {
  StackId?: string;
  StackName: string | undefined;
  TemplateDescription?: string;
  CreationTime: Date | undefined;
  LastUpdatedTime?: Date;
  DeletionTime?: Date;
  StackStatus: StackStatus | undefined;
  StackStatusReason?: string;
  ParentId?: string;
  RootId?: string;
  DriftInformation?: StackDriftInformationSummary;
}
export interface ListStacksOutput {
  StackSummaries?: StackSummary[];
  NextToken?: string;
}
export interface ListStackSetAutoDeploymentTargetsInput {
  StackSetName: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  CallAs?: CallAs;
}
export interface StackSetAutoDeploymentTargetSummary {
  OrganizationalUnitId?: string;
  Regions?: string[];
}
export interface ListStackSetAutoDeploymentTargetsOutput {
  Summaries?: StackSetAutoDeploymentTargetSummary[];
  NextToken?: string;
}
export declare const OperationResultFilterName: {
  readonly OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS";
};
export type OperationResultFilterName =
  (typeof OperationResultFilterName)[keyof typeof OperationResultFilterName];
export interface OperationResultFilter {
  Name?: OperationResultFilterName;
  Values?: string;
}
export interface ListStackSetOperationResultsInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  CallAs?: CallAs;
  Filters?: OperationResultFilter[];
}
export declare const StackSetOperationResultStatus: {
  readonly CANCELLED: "CANCELLED";
  readonly FAILED: "FAILED";
  readonly PENDING: "PENDING";
  readonly RUNNING: "RUNNING";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackSetOperationResultStatus =
  (typeof StackSetOperationResultStatus)[keyof typeof StackSetOperationResultStatus];
export interface StackSetOperationResultSummary {
  Account?: string;
  Region?: string;
  Status?: StackSetOperationResultStatus;
  StatusReason?: string;
  AccountGateResult?: AccountGateResult;
  OrganizationalUnitId?: string;
}
export interface ListStackSetOperationResultsOutput {
  Summaries?: StackSetOperationResultSummary[];
  NextToken?: string;
}
export interface ListStackSetOperationsInput {
  StackSetName: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  CallAs?: CallAs;
}
export interface StackSetOperationSummary {
  OperationId?: string;
  Action?: StackSetOperationAction;
  Status?: StackSetOperationStatus;
  CreationTimestamp?: Date;
  EndTimestamp?: Date;
  StatusReason?: string;
  StatusDetails?: StackSetOperationStatusDetails;
  OperationPreferences?: StackSetOperationPreferences;
}
export interface ListStackSetOperationsOutput {
  Summaries?: StackSetOperationSummary[];
  NextToken?: string;
}
export interface ListStackSetsInput {
  NextToken?: string;
  MaxResults?: number;
  Status?: StackSetStatus;
  CallAs?: CallAs;
}
export interface StackSetSummary {
  StackSetName?: string;
  StackSetId?: string;
  Description?: string;
  Status?: StackSetStatus;
  AutoDeployment?: AutoDeployment;
  PermissionModel?: PermissionModels;
  DriftStatus?: StackDriftStatus;
  LastDriftCheckTimestamp?: Date;
  ManagedExecution?: ManagedExecution;
}
export interface ListStackSetsOutput {
  Summaries?: StackSetSummary[];
  NextToken?: string;
}
export interface ListTypeRegistrationsInput {
  Type?: RegistryType;
  TypeName?: string;
  TypeArn?: string;
  RegistrationStatusFilter?: RegistrationStatus;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListTypeRegistrationsOutput {
  RegistrationTokenList?: string[];
  NextToken?: string;
}
export interface TypeFilters {
  Category?: Category;
  PublisherId?: string;
  TypeNamePrefix?: string;
}
export interface ListTypesInput {
  Visibility?: Visibility;
  ProvisioningType?: ProvisioningType;
  DeprecatedStatus?: DeprecatedStatus;
  Type?: RegistryType;
  Filters?: TypeFilters;
  MaxResults?: number;
  NextToken?: string;
}
export interface TypeSummary {
  Type?: RegistryType;
  TypeName?: string;
  DefaultVersionId?: string;
  TypeArn?: string;
  LastUpdated?: Date;
  Description?: string;
  PublisherId?: string;
  OriginalTypeName?: string;
  PublicVersionNumber?: string;
  LatestPublicVersion?: string;
  PublisherIdentity?: IdentityProvider;
  PublisherName?: string;
  IsActivated?: boolean;
}
export interface ListTypesOutput {
  TypeSummaries?: TypeSummary[];
  NextToken?: string;
}
export interface ListTypeVersionsInput {
  Type?: RegistryType;
  TypeName?: string;
  Arn?: string;
  MaxResults?: number;
  NextToken?: string;
  DeprecatedStatus?: DeprecatedStatus;
  PublisherId?: string;
}
export interface TypeVersionSummary {
  Type?: RegistryType;
  TypeName?: string;
  VersionId?: string;
  IsDefaultVersion?: boolean;
  Arn?: string;
  TimeCreated?: Date;
  Description?: string;
  PublicVersionNumber?: string;
}
export interface ListTypeVersionsOutput {
  TypeVersionSummaries?: TypeVersionSummary[];
  NextToken?: string;
}
export interface PublishTypeInput {
  Type?: ThirdPartyType;
  Arn?: string;
  TypeName?: string;
  PublicVersionNumber?: string;
}
export interface PublishTypeOutput {
  PublicTypeArn?: string;
}
export declare class InvalidStateTransitionException extends __BaseException {
  readonly name: "InvalidStateTransitionException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidStateTransitionException,
      __BaseException
    >
  );
}
export declare class OperationStatusCheckFailedException extends __BaseException {
  readonly name: "OperationStatusCheckFailedException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      OperationStatusCheckFailedException,
      __BaseException
    >
  );
}
export declare const OperationStatus: {
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PENDING: "PENDING";
  readonly SUCCESS: "SUCCESS";
};
export type OperationStatus =
  (typeof OperationStatus)[keyof typeof OperationStatus];
export declare const HandlerErrorCode: {
  readonly AccessDenied: "AccessDenied";
  readonly AlreadyExists: "AlreadyExists";
  readonly GeneralServiceException: "GeneralServiceException";
  readonly HandlerInternalFailure: "HandlerInternalFailure";
  readonly InternalFailure: "InternalFailure";
  readonly InvalidCredentials: "InvalidCredentials";
  readonly InvalidRequest: "InvalidRequest";
  readonly InvalidTypeConfiguration: "InvalidTypeConfiguration";
  readonly NetworkFailure: "NetworkFailure";
  readonly NonCompliant: "NonCompliant";
  readonly NotFound: "NotFound";
  readonly NotUpdatable: "NotUpdatable";
  readonly ResourceConflict: "ResourceConflict";
  readonly ServiceInternalError: "ServiceInternalError";
  readonly ServiceLimitExceeded: "ServiceLimitExceeded";
  readonly ServiceTimeout: "NotStabilized";
  readonly Throttling: "Throttling";
  readonly Unknown: "Unknown";
  readonly UnsupportedTarget: "UnsupportedTarget";
};
export type HandlerErrorCode =
  (typeof HandlerErrorCode)[keyof typeof HandlerErrorCode];
export interface RecordHandlerProgressInput {
  BearerToken: string | undefined;
  OperationStatus: OperationStatus | undefined;
  CurrentOperationStatus?: OperationStatus;
  StatusMessage?: string;
  ErrorCode?: HandlerErrorCode;
  ResourceModel?: string;
  ClientRequestToken?: string;
}
export interface RecordHandlerProgressOutput {}
export interface RegisterPublisherInput {
  AcceptTermsAndConditions?: boolean;
  ConnectionArn?: string;
}
export interface RegisterPublisherOutput {
  PublisherId?: string;
}
export interface RegisterTypeInput {
  Type?: RegistryType;
  TypeName: string | undefined;
  SchemaHandlerPackage: string | undefined;
  LoggingConfig?: LoggingConfig;
  ExecutionRoleArn?: string;
  ClientRequestToken?: string;
}
export interface RegisterTypeOutput {
  RegistrationToken?: string;
}
export interface RollbackStackInput {
  StackName: string | undefined;
  RoleARN?: string;
  ClientRequestToken?: string;
  RetainExceptOnCreate?: boolean;
}
export interface RollbackStackOutput {
  StackId?: string;
}
export interface SetStackPolicyInput {
  StackName: string | undefined;
  StackPolicyBody?: string;
  StackPolicyURL?: string;
}
export interface SetTypeConfigurationInput {
  TypeArn?: string;
  Configuration: string | undefined;
  ConfigurationAlias?: string;
  TypeName?: string;
  Type?: ThirdPartyType;
}
