/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class ParenthesizedExpression
extends Expression {
    public ParenthesizedExpression(Expression expression) {
        super(expression.getOffset());
        this.setExpression(expression);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitParenthesizedExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ParenthesizedExpression && this.getExpression().matches(((ParenthesizedExpression)other).getExpression(), match);
    }
}

