/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.CorrosiveGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM200;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.MetalShard;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.DM201Sprite;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class DM201
extends DM200 {
    private boolean threatened;

    public DM201() {
        this.spriteClass = DM201Sprite.class;
        this.HT = 120;
        this.HP = 120;
        this.properties.add(Char.Property.IMMOVABLE);
        this.HUNTING = new Hunting();
        this.threatened = false;
    }

    @Override
    public int damageRoll() {
        return Char.combatRoll(15, 25);
    }

    @Override
    public void damage(int dmg, Object src) {
        if (src instanceof Char && !Dungeon.level.adjacent(this.pos, ((Char)src).pos) || this.enemy == null || !Dungeon.level.adjacent(this.pos, this.enemy.pos)) {
            this.threatened = true;
        }
        super.damage(dmg, src);
    }

    @Override
    public void onZapComplete() {
        this.zap();
        this.next();
    }

    private void zap() {
        this.threatened = false;
        this.spend(1.0f);
        GameScene.add(Blob.seed(this.enemy.pos, 15, CorrosiveGas.class).setStrength(8));
        for (int i : PathFinder.NEIGHBOURS8) {
            if (Dungeon.level.solid[this.enemy.pos + i]) continue;
            GameScene.add(Blob.seed(this.enemy.pos + i, 5, CorrosiveGas.class).setStrength(8));
        }
    }

    @Override
    protected boolean canVent(int target) {
        return false;
    }

    @Override
    protected boolean getCloser(int target) {
        return false;
    }

    @Override
    protected boolean getFurther(int target) {
        return false;
    }

    @Override
    public void rollToDropLoot() {
        int ofs;
        if (Dungeon.hero.lvl > this.maxLvl + 2) {
            return;
        }
        super.rollToDropLoot();
        while (Dungeon.level.solid[this.pos + (ofs = PathFinder.NEIGHBOURS8[Random.Int(8)])] && !Dungeon.level.passable[this.pos + ofs]) {
        }
        Dungeon.level.drop((Item)new MetalShard(), (int)(this.pos + ofs)).sprite.drop(this.pos);
    }

    private class Hunting
    extends Mob.Hunting {
        private Hunting() {
            super(DM201.this);
        }

        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            if (DM201.this.threatened && enemyInFOV) {
                if (DM201.this.sprite != null && (DM201.this.sprite.visible || DM201.this.enemy.sprite.visible)) {
                    DM201.this.sprite.zap(DM201.this.enemy.pos);
                    return false;
                }
                DM201.this.zap();
                return true;
            }
            return super.act(enemyInFOV, justAlerted);
        }
    }
}

