/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.poi;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.plus.api.SQLiteAPI;
import net.osmand.plus.poi.NominatimPoiFilter;
import net.osmand.plus.poi.PoiUIFilter;
import net.osmand.plus.poi.SearchByNameFilter;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class PoiFiltersHelper {
    private final OsmWindow application;
    private NominatimPoiFilter nominatimPOIFilter;
    private NominatimPoiFilter nominatimAddresFilter;
    private PoiUIFilter searchByNamePOIFilter;
    private PoiUIFilter customPOIFilter;
    private PoiUIFilter showAllPOIFilter;
    private PoiUIFilter localWikiPoiFilter;
    private List<PoiUIFilter> cacheTopStandardFilters;
    private static final String UDF_CAR_AID = "car_aid";
    private static final String UDF_FOR_TOURISTS = "for_tourists";
    private static final String UDF_FOOD_SHOP = "food_shop";
    private static final String UDF_FUEL = "fuel";
    private static final String UDF_SIGHTSEEING = "sightseeing";
    private static final String UDF_EMERGENCY = "emergency";
    private static final String UDF_PUBLIC_TRANSPORT = "public_transport";
    private static final String UDF_ACCOMMODATION = "accomodation";
    private static final String UDF_RESTAURANTS = "restaurants";
    private static final String UDF_PARKING = "parking";
    private static final String[] DEL = new String[]{"car_aid", "for_tourists", "food_shop", "fuel", "sightseeing", "emergency", "public_transport", "accomodation", "restaurants", "parking"};

    public PoiFiltersHelper(OsmWindow application) {
        this.application = application;
    }

    public NominatimPoiFilter getNominatimPOIFilter() {
        if (this.nominatimPOIFilter == null) {
            this.nominatimPOIFilter = new NominatimPoiFilter(this.application, false);
        }
        return this.nominatimPOIFilter;
    }

    public NominatimPoiFilter getNominatimAddressFilter() {
        if (this.nominatimAddresFilter == null) {
            this.nominatimAddresFilter = new NominatimPoiFilter(this.application, true);
        }
        return this.nominatimAddresFilter;
    }

    public PoiUIFilter getSearchByNamePOIFilter() {
        if (this.searchByNamePOIFilter == null) {
            SearchByNameFilter filter = new SearchByNameFilter(this.application);
            filter.setStandardFilter(true);
            this.searchByNamePOIFilter = filter;
        }
        return this.searchByNamePOIFilter;
    }

    public PoiUIFilter getCustomPOIFilter() {
        if (this.customPOIFilter == null) {
            PoiUIFilter filter = new PoiUIFilter(this.application.getString(549), "user_custom_id", new LinkedHashMap<PoiCategory, LinkedHashSet<String>>(), this.application);
            filter.setStandardFilter(true);
            this.customPOIFilter = filter;
        }
        return this.customPOIFilter;
    }

    public PoiUIFilter getLocalWikiPOIFilter() {
        PoiType place;
        if (this.localWikiPoiFilter == null && (place = this.application.getPoiTypes().getPoiTypeByKey("wiki_place")) != null && !Algorithms.isEmpty(this.application.getLanguage())) {
            PoiUIFilter filter = new PoiUIFilter(place, this.application, " " + this.application.getLangTranslation(this.application.getLanguage()));
            filter.setSavedFilterByName("wiki:lang:" + this.application.getLanguage());
            filter.setStandardFilter(true);
            this.localWikiPoiFilter = filter;
        }
        return this.localWikiPoiFilter;
    }

    public PoiUIFilter getShowAllPOIFilter() {
        if (this.showAllPOIFilter == null) {
            PoiUIFilter filter = new PoiUIFilter(null, this.application, "");
            filter.setStandardFilter(true);
            this.showAllPOIFilter = filter;
        }
        return this.showAllPOIFilter;
    }

    private PoiUIFilter getFilterById(String filterId, PoiUIFilter ... filters) {
        for (PoiUIFilter pf : filters) {
            if (!pf.getFilterId().equals(filterId)) continue;
            return pf;
        }
        return null;
    }

    public PoiUIFilter getFilterById(String filterId) {
        if (filterId == null) {
            return null;
        }
        for (PoiUIFilter f : this.getTopDefinedPoiFilters()) {
            if (!f.getFilterId().equals(filterId)) continue;
            return f;
        }
        PoiUIFilter ff = this.getFilterById(filterId, this.getCustomPOIFilter(), this.getSearchByNamePOIFilter(), this.getLocalWikiPOIFilter(), this.getShowAllPOIFilter(), this.getNominatimPOIFilter(), this.getNominatimAddressFilter());
        if (ff != null) {
            return ff;
        }
        if (filterId.startsWith("std_")) {
            String typeId = filterId.substring("std_".length());
            AbstractPoiType tp = this.application.getPoiTypes().getAnyPoiTypeByKey(typeId);
            if (tp != null) {
                PoiUIFilter lf = new PoiUIFilter(tp, this.application, "");
                ArrayList<PoiUIFilter> copy = new ArrayList<PoiUIFilter>(this.cacheTopStandardFilters);
                copy.add(lf);
                this.sortListOfFilters(copy);
                this.cacheTopStandardFilters = copy;
                return lf;
            }
            AbstractPoiType lt = this.application.getPoiTypes().getAnyPoiAdditionalTypeByKey(typeId);
            if (lt != null) {
                PoiUIFilter lf = new PoiUIFilter(lt, this.application, "");
                ArrayList<PoiUIFilter> copy = new ArrayList<PoiUIFilter>(this.cacheTopStandardFilters);
                copy.add(lf);
                this.sortListOfFilters(copy);
                this.cacheTopStandardFilters = copy;
                return lf;
            }
        }
        return null;
    }

    public void reloadAllPoiFilters() {
        this.showAllPOIFilter = null;
        this.getShowAllPOIFilter();
        this.cacheTopStandardFilters = null;
        this.getTopDefinedPoiFilters();
    }

    private List<PoiUIFilter> getUserDefinedPoiFilters() {
        ArrayList<PoiUIFilter> userDefinedFilters = new ArrayList<PoiUIFilter>();
        PoiFilterDbHelper helper = this.openDbHelper();
        if (helper != null) {
            List<PoiUIFilter> userDefined = helper.getFilters(helper.getReadableDatabase());
            userDefinedFilters.addAll(userDefined);
            helper.close();
        }
        return userDefinedFilters;
    }

    public void sortListOfFilters(List<PoiUIFilter> list) {
        final Collator instance = Collator.getInstance();
        Collections.sort(list, new Comparator<PoiUIFilter>(){

            @Override
            public int compare(PoiUIFilter lhs, PoiUIFilter rhs) {
                return instance.compare(lhs.getName(), rhs.getName());
            }
        });
    }

    public List<PoiUIFilter> getTopDefinedPoiFilters() {
        if (this.cacheTopStandardFilters == null) {
            ArrayList<PoiUIFilter> top = new ArrayList<PoiUIFilter>();
            top.addAll(this.getUserDefinedPoiFilters());
            if (this.getLocalWikiPOIFilter() != null) {
                top.add(this.getLocalWikiPOIFilter());
            }
            MapPoiTypes poiTypes = this.application.getPoiTypes();
            for (PoiFilter t : poiTypes.getTopVisibleFilters()) {
                top.add(new PoiUIFilter(t, this.application, ""));
            }
            this.sortListOfFilters(top);
            this.cacheTopStandardFilters = top;
        }
        ArrayList<PoiUIFilter> result = new ArrayList<PoiUIFilter>();
        result.addAll(this.cacheTopStandardFilters);
        result.add(this.getShowAllPOIFilter());
        return result;
    }

    private PoiFilterDbHelper openDbHelper() {
        if (!this.application.getPoiTypes().isInit()) {
            return null;
        }
        return new PoiFilterDbHelper(this.application.getPoiTypes(), this.application);
    }

    public boolean removePoiFilter(PoiUIFilter filter) {
        if (filter.getFilterId().equals("user_custom_id") || filter.getFilterId().equals("user_by_name") || filter.getFilterId().startsWith("std_")) {
            return false;
        }
        PoiFilterDbHelper helper = this.openDbHelper();
        if (helper == null) {
            return false;
        }
        boolean res = helper.deleteFilter(helper.getWritableDatabase(), filter);
        if (res) {
            ArrayList<PoiUIFilter> copy = new ArrayList<PoiUIFilter>(this.cacheTopStandardFilters);
            copy.remove(filter);
            this.cacheTopStandardFilters = copy;
        }
        helper.close();
        return res;
    }

    public boolean createPoiFilter(PoiUIFilter filter) {
        PoiFilterDbHelper helper = this.openDbHelper();
        if (helper == null) {
            return false;
        }
        boolean res = helper.deleteFilter(helper.getWritableDatabase(), filter);
        Iterator<PoiUIFilter> it = this.cacheTopStandardFilters.iterator();
        while (it.hasNext()) {
            if (!it.next().getFilterId().equals(filter.getFilterId())) continue;
            it.remove();
        }
        res = helper.addFilter(filter, helper.getWritableDatabase(), false);
        if (res) {
            ArrayList<PoiUIFilter> copy = new ArrayList<PoiUIFilter>(this.cacheTopStandardFilters);
            copy.add(filter);
            this.sortListOfFilters(copy);
            this.cacheTopStandardFilters = copy;
        }
        helper.close();
        return res;
    }

    public boolean editPoiFilter(PoiUIFilter filter) {
        if (filter.getFilterId().equals("user_custom_id") || filter.getFilterId().equals("user_by_name") || filter.getFilterId().startsWith("std_")) {
            return false;
        }
        PoiFilterDbHelper helper = this.openDbHelper();
        if (helper != null) {
            boolean res = helper.editFilter(helper.getWritableDatabase(), filter);
            helper.close();
            return res;
        }
        return false;
    }

    public class PoiFilterDbHelper {
        public static final String DATABASE_NAME = "poi_filters";
        private static final int DATABASE_VERSION = 5;
        private static final String FILTER_NAME = "poi_filters";
        private static final String FILTER_COL_NAME = "name";
        private static final String FILTER_COL_ID = "id";
        private static final String FILTER_COL_FILTERBYNAME = "filterbyname";
        private static final String FILTER_TABLE_CREATE = "CREATE TABLE poi_filters (name, id, filterbyname);";
        private static final String CATEGORIES_NAME = "categories";
        private static final String CATEGORIES_FILTER_ID = "filter_id";
        private static final String CATEGORIES_COL_CATEGORY = "category";
        private static final String CATEGORIES_COL_SUBCATEGORY = "subcategory";
        private static final String CATEGORIES_TABLE_CREATE = "CREATE TABLE categories (filter_id, category, subcategory);";
        private OsmWindow context;
        private SQLiteAPI.SQLiteConnection conn;
        private MapPoiTypes mapPoiTypes;

        PoiFilterDbHelper(MapPoiTypes mapPoiTypes, OsmWindow context) {
            this.mapPoiTypes = mapPoiTypes;
            this.context = context;
        }

        public SQLiteAPI.SQLiteConnection getWritableDatabase() {
            return this.openConnection(false);
        }

        public void close() {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }

        public SQLiteAPI.SQLiteConnection getReadableDatabase() {
            return this.openConnection(true);
        }

        private SQLiteAPI.SQLiteConnection openConnection(boolean readonly) {
            this.conn = this.context.getSQLiteAPI().getOrCreateDatabase("poi_filters", readonly);
            if (this.conn.getVersion() == 0 || 5 != this.conn.getVersion()) {
                if (readonly) {
                    this.conn.close();
                    this.conn = this.context.getSQLiteAPI().getOrCreateDatabase("poi_filters", false);
                }
                if (this.conn.getVersion() == 0) {
                    this.conn.setVersion(5);
                    this.onCreate(this.conn);
                } else {
                    this.onUpgrade(this.conn, this.conn.getVersion(), 5);
                }
            }
            return this.conn;
        }

        public void onCreate(SQLiteAPI.SQLiteConnection conn) {
            conn.execSQL(FILTER_TABLE_CREATE);
            conn.execSQL(CATEGORIES_TABLE_CREATE);
        }

        public void onUpgrade(SQLiteAPI.SQLiteConnection conn, int oldVersion, int newVersion) {
            if (newVersion <= 5) {
                this.deleteOldFilters(conn);
            }
            conn.setVersion(newVersion);
        }

        private void deleteOldFilters(SQLiteAPI.SQLiteConnection conn) {
            for (String toDel : DEL) {
                this.deleteFilter(conn, "user_" + toDel);
            }
        }

        protected boolean addFilter(PoiUIFilter p, SQLiteAPI.SQLiteConnection db, boolean addOnlyCategories) {
            if (db != null) {
                if (!addOnlyCategories) {
                    db.execSQL("INSERT INTO poi_filters VALUES (?, ?, ?)", new Object[]{p.getName(), p.getFilterId(), p.getFilterByName()});
                }
                Map<PoiCategory, LinkedHashSet<String>> types = p.getAcceptedTypes();
                SQLiteAPI.SQLiteStatement insertCategories = db.compileStatement("INSERT INTO categories VALUES (?, ?, ?)");
                for (PoiCategory a : types.keySet()) {
                    if (types.get(a) == null) {
                        insertCategories.bindString(1, p.getFilterId());
                        insertCategories.bindString(2, a.getKeyName());
                        insertCategories.bindNull(3);
                        insertCategories.execute();
                        continue;
                    }
                    for (String s : types.get(a)) {
                        insertCategories.bindString(1, p.getFilterId());
                        insertCategories.bindString(2, a.getKeyName());
                        insertCategories.bindString(3, s);
                        insertCategories.execute();
                    }
                }
                insertCategories.close();
                return true;
            }
            return false;
        }

        protected List<PoiUIFilter> getFilters(SQLiteAPI.SQLiteConnection conn) {
            ArrayList<PoiUIFilter> list = new ArrayList<PoiUIFilter>();
            if (conn != null) {
                String filterId;
                SQLiteAPI.SQLiteCursor query = conn.rawQuery("SELECT filter_id, category,subcategory FROM categories", null);
                LinkedHashMap map = new LinkedHashMap();
                if (query.moveToFirst()) {
                    do {
                        if (!map.containsKey(filterId = query.getString(0))) {
                            map.put(filterId, new LinkedHashMap());
                        }
                        Map m = (Map)map.get(filterId);
                        PoiCategory a = this.mapPoiTypes.getPoiCategoryByName(query.getString(1).toLowerCase(), false);
                        String subCategory = query.getString(2);
                        if (subCategory == null) {
                            m.put(a, null);
                            continue;
                        }
                        if (m.get(a) == null) {
                            m.put(a, new LinkedHashSet());
                        }
                        ((LinkedHashSet)m.get(a)).add(subCategory);
                    } while (query.moveToNext());
                }
                query.close();
                query = conn.rawQuery("SELECT id, name,filterbyname FROM poi_filters", null);
                if (query.moveToFirst()) {
                    do {
                        if (!map.containsKey(filterId = query.getString(0))) continue;
                        PoiUIFilter filter = new PoiUIFilter(query.getString(1), filterId, (Map)map.get(filterId), PoiFiltersHelper.this.application);
                        filter.setSavedFilterByName(query.getString(2));
                        list.add(filter);
                    } while (query.moveToNext());
                }
                query.close();
            }
            return list;
        }

        protected boolean editFilter(SQLiteAPI.SQLiteConnection conn, PoiUIFilter filter) {
            if (conn != null) {
                conn.execSQL("DELETE FROM categories WHERE filter_id = ?", new Object[]{filter.getFilterId()});
                this.addFilter(filter, conn, true);
                this.updateName(conn, filter);
                return true;
            }
            return false;
        }

        private void updateName(SQLiteAPI.SQLiteConnection db, PoiUIFilter filter) {
            db.execSQL("UPDATE poi_filters SET filterbyname = ?, name = ?  WHERE id= ?", new Object[]{filter.getFilterByName(), filter.getName(), filter.getFilterId()});
        }

        protected boolean deleteFilter(SQLiteAPI.SQLiteConnection db, PoiUIFilter p) {
            String key = p.getFilterId();
            return this.deleteFilter(db, key);
        }

        private boolean deleteFilter(SQLiteAPI.SQLiteConnection db, String key) {
            if (db != null) {
                db.execSQL("DELETE FROM poi_filters WHERE id = ?", new Object[]{key});
                db.execSQL("DELETE FROM categories WHERE filter_id = ?", new Object[]{key});
                return true;
            }
            return false;
        }
    }
}

