/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kgp extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "\u00d3ra Mirinj\u1ef9n\u0169 Grin\u0169visi t\u00e1",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "\u00d3ra P\u00e3 Akre t\u00e1",
               "ACT",
               "R\u1ef9 K\u00e3 \u00f3ra Akre t\u00e1",
               "ACST",
               "Akre t\u00e1 \u00f3ra",
               "ACT",
            };
        final String[] Apia = new String[] {
               "\u00d3ra P\u00e3 Apija t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Apija t\u00e1",
               "",
               "\u00d3ra Apija t\u00e1",
               "",
            };
        final String[] Cook = new String[] {
               "\u00d3ra P\u00e3 Kuki Goj-v\u1ebdso t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Kuki Goj-v\u1ebdso t\u00e1",
               "",
               "\u00d3ra Kuki Goj-v\u1ebdso t\u00e1",
               "",
            };
        final String[] Cuba = new String[] {
               "\u00d3ra P\u00e3 Kuma t\u00e1",
               "CST",
               "R\u1ef9 K\u00e3 \u00f3ra Kuma t\u00e1",
               "CDT",
               "\u00d3ra Kuma t\u00e1",
               "CT",
            };
        final String[] Fiji = new String[] {
               "\u00d3ra P\u00e3 Fiji t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Fiji t\u00e1",
               "",
               "\u00d3ra Fiji t\u00e1",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00d3ra Gorfu t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "\u00d3ra P\u00e3 H\u00f3vin t\u00e1",
               "",
               "R\u1ef9 k\u00e3 \u00f3ra H\u00f3vin t\u00e1",
               "",
               "\u00d3ra H\u00f3vin t\u00e1",
               "",
            };
        final String[] Iran = new String[] {
               "\u00d3ra P\u00e3 Ir\u1ef9 t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Ir\u1ef9 t\u00e1",
               "",
               "\u00d3ra Ir\u1ef9 t\u00e1",
               "",
            };
        final String[] Niue = new String[] {
               "\u00d3ra N\u0129ve t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "\u00d3ra P\u00e3 Om\u0129nhki t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Om\u0129nhki t\u00e1",
               "",
               "\u00d3ra Om\u0129nhki t\u00e1",
               "",
            };
        final String[] Peru = new String[] {
               "\u00d3ra P\u00e3 Piru t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Piru t\u00e1",
               "",
               "\u00d3ra Piru t\u00e1",
               "",
            };
        final String[] Truk = new String[] {
               "\u00d3ra Suuki t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u00d3ra Vejki Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u00d3ra P\u00e3 Sire t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Sire t\u00e1",
               "",
               "\u00d3ra Sire t\u00e1",
               "",
            };
        final String[] China = new String[] {
               "\u00d3ra P\u00e3 S\u0129n\u1ef9 t\u00e1",
               "CST",
               "R\u1ef9 K\u00e3 \u00f3ra S\u0129n\u1ef9 t\u00e1",
               "CDT",
               "\u00d3ra S\u0129n\u1ef9 t\u00e1",
               "CT",
            };
        final String[] Cocos = new String[] {
               "\u00d3ra Kokonh Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "\u00d3ra Navinh t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u00d3ra P\u00e3 \u0128nija t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "\u00d3ra P\u00e3 Jap\u00e3 t\u00e1",
               "JST",
               "R\u1ef9 K\u00e3 \u00f3ra Jap\u00e3 t\u00e1",
               "JDT",
               "\u00d3ra Jap\u00e3 t\u00e1",
               "JT",
            };
        final String[] Korea = new String[] {
               "\u00d3ra P\u00e3 Kor\u00e9ja t\u00e1",
               "KST",
               "R\u1ef9 K\u00e3 \u00f3ra Kor\u00e9ja t\u00e1",
               "KST",
               "\u00d3ra Kor\u00e9ja t\u00e1",
               "KST",
            };
        final String[] Nauru = new String[] {
               "\u00d3ra N\u1ef9vuru t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "\u00d3ra N\u1ebdpar t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "\u00d3ra Paravu t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "\u00d3ra P\u00e3 Sam\u00e3va t\u00e1",
               "SST",
               "R\u1ef9 K\u00e3 \u00f3ra Sam\u00e3va t\u00e1",
               "SST",
               "\u00d3ra Sam\u00e3va t\u00e1",
               "SST",
            };
        final String[] Syowa = new String[] {
               "\u00d3ra Siova t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "\u00d3ra P\u00e3 T\u00e3ga t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra T\u00e3ga t\u00e1",
               "",
               "\u00d3ra T\u00e3ga t\u00e1",
               "",
            };
        final String[] Alaska = new String[] {
               "\u00d3ra P\u00e3 Aranhka t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Aranhka t\u00e1",
               "",
               "Aranhka t\u00e1 \u00f3ra",
               "",
            };
        final String[] Amazon = new String[] {
               "\u00d3ra P\u00e3 Am\u1ef9jon\u1ef9 t\u00e1",
               "AMT",
               "R\u1ef9 K\u00e3 \u00f3ra Am\u1ef9jon\u1ef9 t\u00e1",
               "AMST",
               "Am\u1ef9jon\u1ef9 t\u00e1 \u00f3ra",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "\u00d3ra P\u00e3 An\u1ef9nhyr t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra An\u1ef9nhyr t\u00e1",
               "",
               "\u00d3ra An\u1ef9nnyr t\u00e1",
               "",
            };
        final String[] Azores = new String[] {
               "\u00d3ra P\u00e3 Asor-ag t\u00e1",
               "HMT",
               "R\u1ef9 K\u00e3 \u00f3ra Aso-ag t\u00e1",
               "HMT",
               "\u00d3ra Asor-ag t\u00e1",
               "HMT",
            };
        final String[] Bhutan = new String[] {
               "\u00d3ra Mut\u1ef9v t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "\u00d3ra Mrun\u1ebdj Narusar\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u00d3ra P\u00e3 Panhkuva Goj-v\u1ebdso t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Panhkuva Goj-v\u1ebdso t\u00e1",
               "",
               "\u00d3ra Panhkuva Goj-v\u1ebdso t\u00e1",
               "",
            };
        final String[] Guyana = new String[] {
               "\u00d3ra Gij\u1ef9n\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u00d3ra P\u00e3 Isiha\u00e9 t\u00e1",
               "IST",
               "R\u1ef9 K\u00e3 \u00f3ra Isiha\u00e9 t\u00e1",
               "IDT",
               "\u00d3ra Isiha\u00e9 t\u00e1",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "\u00d3ra de Kosiraje t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "\u00d3ra M\u1ef9us\u00e3n t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "\u00d3ra P\u00e3 M\u00e3nhkov t\u00e1",
               "MSK",
               "R\u1ef9 K\u00e3 \u00f3ra M\u00e3nhkov t\u00e1",
               "MSK",
               "\u00d3ra M\u00e3nhkov t\u00e1",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "\u00d3ra Pon\u1ef9pe t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "\u00d3ra P\u00e3 Sam\u1ef9ra t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Sam\u1ef9ra t\u00e1",
               "",
               "\u00d3ra Sam\u1ef9ra t\u00e1",
               "",
            };
        final String[] Tahiti = new String[] {
               "\u00d3ra Tajti t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "\u00d3ra P\u00e3 Tajpej t\u00e1",
               "CST",
               "R\u1ef9 K\u00e3 \u00f3ra Tajpej t\u00e1",
               "CDT",
               "\u00d3ra Tajpej t\u00e1",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "\u00d3ra Tuvaru t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "\u00d3ra Vonht\u00f3ki t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u00d3ra Varinh kar Futun\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "\u00d3ra P\u00e3 Aramija t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Aramija t\u00e1",
               "",
               "\u00d3ra Aramija t\u00e1",
               "",
            };
        final String[] Armenia = new String[] {
               "\u00d3ra P\u00e3 Arm\u1ebdn\u0129ja t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Arm\u1ebdn\u0129ja t\u00e1",
               "",
               "\u00d3ra Arm\u1ebdn\u0129ja t\u00e1",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u00d3ra Morivia t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "\u00d3ra P\u00e3 San-h\u1ef9m t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra San-h\u1ef9m t\u00e1",
               "",
               "\u00d3ra San-h\u1ef9m t\u00e1",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ga-kar \u00d3ra V\u1ebdnh-kr\u00e9n-ja",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u00d3ra Ekuvanor t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "\u00d3ra G\u1ef9mmijer",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "\u00d3ra P\u00e3 Je\u00f3rja t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Je\u00f3rja t\u00e1",
               "",
               "\u00d3ra Je\u00f3rja t\u00e1",
               "",
            };
        final String[] Irkutsk = new String[] {
               "\u00d3ra P\u00e3 Irkutinhki t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Irkutinhki t\u00e1",
               "",
               "\u00d3ra Irkutinhki t\u00e1",
               "",
            };
        final String[] Magadan = new String[] {
               "\u00d3ra P\u00e3 M\u1ef9ganan t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra M\u1ef9ganan t\u00e1",
               "",
               "\u00d3ra M\u1ef9ganan t\u00e1",
               "",
            };
        final String[] Myanmar = new String[] {
               "\u00d3ra M\u0129j\u1ef9m\u1ef9r t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "\u00d3ra P\u00e3 N\u00e3rforki Goj-v\u1ebdso t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra N\u00e3rforki Goj-v\u1ebdso t\u00e1",
               "",
               "\u00d3ra N\u00e3rforki Goj-v\u1ebdso t\u00e1",
               "",
            };
        final String[] Noronha = new String[] {
               "\u00d3ra P\u00e3 Fern\u1ef9nu N\u00e3r\u00e3ja-t\u00e1 t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Fern\u1ef9nu N\u00e3r\u00e3ja-t\u00e1 t\u00e1",
               "",
               "\u00d3ra Fern\u1ef9nu N\u00e3r\u00e3ja-t\u00e1 t\u00e1",
               "",
            };
        final String[] Reunion = new String[] {
               "\u00d3ra Huj\u00e1v t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u00d3ra Rotera t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u00d3ra Sarom\u1ef9v Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u00d3ra Tokeravu t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u00d3ra P\u00e3 Uruguvaj t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Uruguvaj t\u00e1",
               "",
               "\u00d3ra Uruguvaj t\u00e1",
               "",
            };
        final String[] Vanuatu = new String[] {
               "\u00d3ra P\u00e3 Van\u0169vatu t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Van\u0169vatu t\u00e1",
               "",
               "\u00d3ra Van\u0169vatu t\u00e1",
               "",
            };
        final String[] Yakutsk = new String[] {
               "\u00d3ra P\u00e3 Yjakutinhkii t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Yjakutinhki t\u00e1",
               "",
               "\u00d3ra Yjakutinhki t\u00e1",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u00d3ra P\u00e3 Atr\u1ef9tiku t\u00e1",
               "AST",
               "R\u1ef9 K\u00e3 \u00f3ra Atr\u1ef9tiku t\u00e1",
               "ADT",
               "\u00d3ra Atr\u1ef9tiku t\u00e1",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "\u00d3ra P\u00e3 Mrasirja t\u00e1",
               "BRT",
               "R\u1ef9 K\u00e3 \u00f3ra Mrasirja t\u00e1",
               "BRST",
               "\u00d3ra Mrasirja t\u00e1",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "\u00d3ra Sam\u00e3ho t\u00e1",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "\u00d3ra P\u00e3 Kor\u00e3mija t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Kor\u00e3mija t\u00e1",
               "",
               "\u00d3ra Kor\u00e3mija t\u00e1",
               "",
            };
        final String[] Falkland = new String[] {
               "\u00d3r P\u00e3 M\u1ef9rv\u0129n\u1ef9 Goj-v\u1ebdso t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra M\u1ef9rv\u0129n\u1ef9 Goj-v\u1ebdso t\u00e1",
               "",
               "\u00d3ra M\u1ef9rv\u0129n\u1ef9 Goj-v\u1ebdso t\u00e1",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u00d3ra M\u1ef9raja t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "\u00d3ra Goj V\u1ebdso M\u1ef9rniva t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "\u00d3ra P\u00e3 Uran Mator t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Uran Mator t\u00e1",
               "",
               "\u00d3ra Uran Mator t\u00e1",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u00d3ra P\u00e3 Pakinht\u1ef9v t\u00e1",
               "PKT",
               "R\u1ef9 K\u00e3 \u00f3ra Pakinht\u1ef9v t\u00e1",
               "PKST",
               "\u00d3ra Pakinht\u1ef9v t\u00e1",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "\u00d3ra P\u00e3 Paraguvaj t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Paraguvaj t\u00e1",
               "",
               "\u00d3ra Paraguvaj t\u00e1",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u00d3ra Pinkajir Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "\u00d3ra P\u00e3 Sakarin\u1ef9 t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Sakarin\u1ef9 t\u00e1",
               "",
               "\u00d3ra Sakarin\u1ef9 t\u00e1",
               "",
            };
        final String[] Suriname = new String[] {
               "\u00d3ra Surin\u1ef9m\u0129 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "\u00d3ra Op\u00e3 Arj\u1ebdt\u0129n\u1ef9 t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Arj\u1ebdt\u0129n\u1ef9 t\u00e1",
               "",
               "\u00d3ra Arj\u1ebdt\u0129n\u1ef9 t\u00e1",
               "",
            };
        final String[] Christmas = new String[] {
               "\u00d3ra Kr\u0129tim\u1ef9nh Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u00d3ra Gara Pago t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "\u00d3ra P\u00e3 H\u00e3g K\u00e3g t\u00e1",
               "HKT",
               "R\u1ef9 K\u00e3 \u00f3ra H\u00e3g K\u00e3g t\u00e1",
               "HKST",
               "\u00d3ra H\u00e3g K\u00e3g t\u00e1",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "\u00d3ra \u0128nos\u0129n\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "\u00d3ra P\u00e3 Petrupavir\u00f3vinhki-K\u1ef9msatinhki",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Petrupavir\u00f3vinhki-K\u1ef9msatinhki",
               "",
               "\u00d3ra Petrupavir\u00f3vinhki-K\u1ef9msatinhki",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u00d3ra Kirginht\u1ef9v t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u00d3ra P\u00e3 R\u00f3rni Hove t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra R\u00f3rni Hove t\u00e1",
               "",
               "\u00d3ra R\u00f3rni Hove t\u00e1",
               "",
            };
        final String[] Marquesas = new String[] {
               "\u00d3ra M\u1ef9rkeja Fag t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "\u00d3ra P\u00e3 M\u00e3riso t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra M\u00e3riso t\u00e1",
               "",
               "\u00d3ra M\u00e3riso t\u00e1",
               "",
            };
        final String[] Singapore = new String[] {
               "\u00d3ra P\u00e3 S\u0129gapura t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u00d3ra Ven\u1ebdjuv\u00e9ra t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "\u00d3ra P\u00e3 Vorgugrano t\u00e1",
               "MSK",
               "R\u1ef9 K\u00e3 \u00f3ra Vorgugrano t\u00e1",
               "MSK",
               "\u00d3ra Vorgugrano t\u00e1",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "\u00d3ra P\u00e3 Ajermajj\u00e1v t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Ajermajj\u00e1v t\u00e1",
               "",
               "\u00d3ra Ajermajj\u00e1v t\u00e1",
               "",
            };
        final String[] Bangladesh = new String[] {
               "\u00d3ra P\u00e3 M\u1ef9ngran\u00e9si t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra M\u1ef9ngran\u00e9si t\u00e1",
               "",
               "\u00d3ra M\u1ef9ngran\u00e9si t\u00e1",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "\u00d3ra P\u00e3 Pu T\u00e1nh t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Pu t\u00e1nh t\u00e1",
               "",
               "\u00d3ra Pu T\u00e1nh t\u00e1",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00d3ra T\u0129m\u00e3r-R\u00e3jur t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u00d3ra Sejserenh t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u00d3ra Tajikinht\u1ef9v t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u00d3ra P\u00e3 Unnmekinht\u1ef9v t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Unhmekinht\u1ef9v t\u00e1",
               "",
               "\u00d3ra Unhmekinht\u1ef9v t\u00e1",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afegan\u0129t\u00e3 t\u00e1 \u00f3ra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u00d3ra P\u00e3 Kranhn\u00e3jarki t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Kranhn\u00e3jarki t\u00e1",
               "",
               "\u00d3ra Kranhn\u00e3jarki t\u00e1",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u00d3ra P\u00e3 Jer\u1ef9nija T\u00e3g t\u00e1",
               "NZST",
               "R\u1ef9 K\u00e3 \u00f3ra Jer\u1ef9nija T\u00e3g t\u00e1",
               "NZDT",
               "\u00d3ra Jer\u1ef9nija T\u00e3g t\u00e1",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "\u00d3ra P\u00e3 Simirsiki T\u00e3g t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra P\u00e3 Simirsiki T\u00e3g t\u00e1",
               "",
               "\u00d3ra Simirsiki T\u00e3g t\u00e1",
               "",
            };
        final String[] Philippines = new String[] {
               "\u00d3ra P\u00e3 Firipin\u1ef9 t\u00e1",
               "PST",
               "R\u1ef9 K\u00e3 Firipin\u1ef9 t\u00e1",
               "PDT",
               "\u00d3ra Firipin\u1ef9 t\u00e1",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "\u00d3ra P\u00e3 Uraniv\u00f3nht\u00f3ki t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Uraniv\u00f3nht\u00f3ki t\u00e1",
               "",
               "\u00d3ra Uraniv\u00f3nht\u00f3kii t\u00e1",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00d3ra Osi\u1ef9no \u0128niko t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u00d3ra V\u00e3fe Goj-v\u1ebdso t\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u00d3ra P\u00e3 Ga T\u00e3g t\u00e1",
               "NST",
               "R\u1ef9 K\u00e3 \u00f3ra Ga T\u00e3g t\u00e1",
               "NDT",
               "\u00d3ra Ga t\u00e3g t\u00e1",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "\u00d3ra P\u00e3 Turkom\u1ebdn\u0129nht\u1ef9v t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Turkom\u1ebdn\u0129nht\u1ef9v t\u00e1",
               "",
               "\u00d3ra Turkom\u1ebdn\u0129nht\u1ef9v t\u00e1",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u00d3ra Fr\u1ef9sa Gijan\u1ef9 t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "\u00d3ra P\u00e3 Karenon\u0129ja T\u00e3g t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Karenon\u0129ja T\u00e3g t\u00e1",
               "",
               "\u00d3ra Karenon\u0129ja T\u00e3g t\u00e1",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u00d3ra Ji\u00f3rja t\u1ef9 Sur t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "\u00d3ra P\u00e3 Ekater\u0129nmurgu t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Ekater\u0129nmurgu t\u00e1",
               "",
               "\u00d3ra Ekater\u0129nmurgu t\u00e1",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afrika-Kuju t\u00e1 \u00f3ra",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrika R\u00e3jur t\u00e1 \u00f3ra",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "\u00d3ra P\u00e3 Afrika R\u00e3pur t\u00e1",
               "WAT",
               "R\u1ef9 K\u00e3 \u00f3ra Afrika R\u00e3pur t\u00e1",
               "WAT",
               "Afrika R\u00e3pur t\u00e1 \u00f3ra",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "\u00d3ra Num\u00e3-Nurviri t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u00d3ra P\u00e3 Or\u00f3pa Kuju t\u00e1",
               "CET",
               "R\u1ef9 K\u00e3 \u00f3ra Or\u00f3pa Kuju t\u00e1",
               "CEST",
               "\u00d3ra Or\u00f3pa Kuju t\u00e1",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00d3ra P\u00e3 Or\u00f3pa R\u00e3jur t\u00e1",
               "EET",
               "R\u1ef9 K\u00e3 \u00f3ra Or\u00f3pa R\u00e3jur t\u00e1",
               "EEST",
               "\u00d3ra Or\u00f3pa R\u00e3jur t\u00e1",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "\u00d3ra P\u00e3 Or\u00f3pa R\u00e3pur t\u00e1",
               "FMT",
               "R\u1ef9 K\u00e3 \u00f3ra Or\u00f3pa R\u00e3pur t\u00e1",
               "FMT",
               "\u00d3ra Or\u00f3pa R\u00e3pur t\u00e1",
               "FMT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u00d3ra P\u00e3 M\u1ebdsiku Pasifiku t\u00e1",
               "MST",
               "R\u1ef9 K\u00e3 \u00f3ra M\u1ebdsiku Pasifiku t\u00e1",
               "MDT",
               "\u00d3ra M\u1ebdsiku Pasifiku t\u00e1",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Sur-Afrika t\u00e1 \u00f3ra",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "\u00d3ra P\u00e3 Kuju t\u00e1",
               "CST",
               "R\u1ef9 K\u00e3 \u00f3ra Kuju t\u00e1",
               "CDT",
               "Kuju t\u00e1 \u00f3ra",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u00d3ra P\u00e3 R\u00e3jur t\u00e1",
               "EST",
               "R\u1ef9 K\u00e3 \u00f3ra R\u00e3jur t\u00e1",
               "EST",
               "\u00d3ra R\u00e3jur t\u00e1",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "\u00d3ra P\u00e3 R\u00e3pur t\u00e1",
               "PST",
               "R\u1ef9 K\u00e3 \u00f3ra R\u00e3pur t\u00e1",
               "PDT",
               "\u00d3ra R\u00e3pur t\u00e1",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "\u00d3ra Fr\u1ef9sa Ga Sur kar \u1ef8tartina t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u00d3ra Jirm\u00e9rtu Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u00d3ra P\u00e3 Hava\u2019i kar Arevta Goj-v\u1ebdso t\u00e1",
               "HST",
               "R\u1ef9 k\u00e3 \u00f3ra Hava\u2019i kar Arevta Goj-v\u1ebdso t\u00e1",
               "HST",
               "\u00d3ra Hava\u2019i kar Arevta Goj-v\u1ebdso t\u00e1",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u00d3ra F\u1ebdn\u0129g Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u00d3ra P\u00e3 S\u1ef9 Pedro kar M\u0129ker\u1ef9v t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra S\u1ef9 Pedro kar M\u0129ker\u1ef9v t\u00e1",
               "",
               "\u00d3ra S\u1ef9 Penru kar M\u0129ker\u1ef9v t\u00e1",
               "",
            };
        final String[] America_Mountain = new String[] {
               "\u00d3ra P\u00e3 Kr\u0129 t\u00e1",
               "MST",
               "R\u1ef9 K\u00e3 \u00f3ra Kr\u0129 t\u00e1",
               "MDT",
               "\u00d3ra Kr\u0129 t\u00e1",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "\u00d3ra M\u1ef9rSar Goj-v\u1ebdso t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u00d3ra P\u00e3 M\u1ebdsiku N\u00e3rti-R\u00e3pur t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra M\u1ebdsiku N\u00e3rti-R\u00e3pur t\u00e1",
               "",
               "\u00d3ra M\u1ebdsiku N\u00e3rti-R\u00e3pur t\u00e1",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u00d3ra Papuva-Gin\u1ebd T\u00e3g t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u00d3ra P\u00e3 Avotyraria Kuju t\u00e1",
               "ACST",
               "R\u1ef9 K\u00e3 \u00f3ra Avotyraria Kuju t\u00e1",
               "ACDT",
               "\u00d3ra Avotyraria Kuju t\u00e1",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00d3ra P\u00e3 Avotyraria R\u00e3jur t\u00e1",
               "AEST",
               "R\u1ef9 K\u00e3 \u00f3ra Avotyraria R\u00e3jur t\u00e1",
               "AEDT",
               "\u00d3ra Avotyraria R\u00e3jur t\u00e1",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "\u00d3ra P\u00e3 Avotyraria R\u00e3pur t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Avotyraria R\u00e3pur t\u00e1",
               "",
               "\u00d3ra Avotyraria R\u00e3pur t\u00e1",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u00d3ra P\u00e3 Gro\u1ebdr\u1ef9nija R\u00e3jur t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Gro\u1ebdr\u1ef9nija R\u00e3jur t\u00e1",
               "",
               "\u00d3ra Gro\u1ebdr\u1ef9nija R\u00e3jur t\u00e1",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "\u00d3ra P\u00e3 Gro\u1ebdr\u1ef9nija R\u00e3pur t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Gro\u1ebdr\u1ef9nija R\u00e3pur t\u00e1",
               "",
               "\u00d3ra Gro\u1ebdr\u1ef9nija R\u00e3pur t\u00e1",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "\u00d3ra \u0128non\u1ebdja Kuju t\u00e1",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00d3ra \u0128non\u1ebdja R\u00e3jur t\u00e1",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u00d3ra \u0128non\u1ebdja R\u00e3pur t\u00e1",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00d3ra Kajakinht\u1ef9v R\u00e3jur t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u00d3ra Kajakinht\u1ef9v R\u00e3pur t\u00e1",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u00d3ra P\u00e3 Avotyraria Kuju-R\u00e3pur t\u00e1",
               "",
               "R\u1ef9 K\u00e3 \u00f3ra Avotyraria Kuju-R\u00e3pur t\u00e1",
               "",
               "\u00d3ra Avotyaria Kuju-R\u00e3pur t\u00e1",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "\u00d3ra Mirinj\u1ef9n\u0169 Grin\u0169visi t\u00e1",
                    "GMT",
                    "\u00d3ra P\u00e3 Ir\u1ef9na",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "\u00d3ra Mirinj\u1ef9n\u0169 Grin\u0169visi t\u00e1",
                    "GMT",
                    "\u00d3ra Mrit\u1ef9n\u0129ku R\u1ef9 K\u00e3",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "\u00d3ra Mirinj\u1ef9n\u0169 Grin\u0169visi t\u00e1",
                    "GMT",
                    "\u00d3ra Mrit\u1ef9n\u0129ku R\u1ef9 K\u00e3",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Anen" },
            { "timezone.excity.Asia/Baku", "Maku" },
            { "timezone.excity.Asia/Dili", "Niri" },
            { "timezone.excity.Asia/Gaza", "Gaja" },
            { "timezone.excity.Asia/Hovd", "Hovin" },
            { "timezone.excity.Asia/Omsk", "Om\u0129nhki" },
            { "timezone.excity.Asia/Oral", "Orar" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u1ef9" },
            { "timezone.excity.Asia/Aqtau", "Akitau" },
            { "timezone.excity.Asia/Chita", "Sita" },
            { "timezone.excity.Asia/Dhaka", "Naka" },
            { "timezone.excity.Asia/Dubai", "Numaj" },
            { "timezone.excity.Asia/Kabul", "Kamur" },
            { "timezone.excity.Asia/Macau", "M\u1ef9kau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Se\u2019ur" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3kijo" },
            { "timezone.excity.Asia/Tomsk", "Tom\u0129nhki" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juma" },
            { "timezone.excity.Africa/Lome", "R\u00f3m\u1ebd" },
            { "timezone.excity.Asia/Almaty", "Arm\u1ef9ti" },
            { "timezone.excity.Asia/Anadyr", "An\u1ef9nhir" },
            { "timezone.excity.Asia/Aqtobe", "Akitome" },
            { "timezone.excity.Asia/Atyrau", "Atirav" },
            { "timezone.excity.Asia/Beirut", "Mejruti" },
            { "timezone.excity.Asia/Brunei", "Mrun\u1ebdj" },
            { "timezone.excity.Asia/Hebron", "Hemron" },
            { "timezone.excity.Asia/Kuwait", "Kuvajti" },
            { "timezone.excity.Asia/Manila", "M\u1ef9n\u0129ra" },
            { "timezone.excity.Asia/Riyadh", "Rijane" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Te\u2019er\u1ef9" },
            { "timezone.excity.Asia/Urumqi", "Ur\u0169mki" },
            { "timezone.excity.Etc/Unknown", "Jam\u00e3 Vejat\u0169" },
            { "timezone.excity.Europe/Kiev", "Kij\u00e9vi" },
            { "timezone.excity.Europe/Oslo", "\u00d3siro" },
            { "timezone.excity.Europe/Rome", "Rom\u1ef9" },
            { "timezone.excity.Indian/Mahe", "M\u1ef9h\u00e9" },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kajro" },
            { "timezone.excity.Africa/Ceuta", "Sevuta" },
            { "timezone.excity.Africa/Dakar", "Nakar" },
            { "timezone.excity.Africa/Lagos", "Rago" },
            { "timezone.excity.Africa/Tunis", "Tun\u0129nh" },
            { "timezone.excity.America/Adak", "Anaki" },
            { "timezone.excity.America/Lima", "Rim\u1ef9" },
            { "timezone.excity.America/Nome", "Jyjy" },
            { "timezone.excity.Asia/Baghdad", "Magina" },
            { "timezone.excity.Asia/Bahrain", "Mar\u1ebdj" },
            { "timezone.excity.Asia/Bangkok", "Mygk\u00f3ki" },
            { "timezone.excity.Asia/Barnaul", "Marn\u1ef9ur" },
            { "timezone.excity.Asia/Bishkek", "Misik\u00e9ki" },
            { "timezone.excity.Asia/Colombo", "Kor\u00e3mmu" },
            { "timezone.excity.Asia/Irkutsk", "Irkutinhki" },
            { "timezone.excity.Asia/Karachi", "Karasi" },
            { "timezone.excity.Asia/Kuching", "Kus\u0129g" },
            { "timezone.excity.Asia/Magadan", "M\u1ef9ganan" },
            { "timezone.excity.Asia/Nicosia", "N\u0129k\u00f3jia" },
            { "timezone.excity.Asia/Rangoon", "Rang\u0169m" },
            { "timezone.excity.Asia/Tbilisi", "Timiriji" },
            { "timezone.excity.Asia/Thimphu", "T\u0129mfu" },
            { "timezone.excity.Asia/Yakutsk", "Yjakutinhki" },
            { "timezone.excity.Asia/Yerevan", "Jerev\u1ef9" },
            { "timezone.excity.Europe/Kirov", "Kir\u00f3vi" },
            { "timezone.excity.Europe/Malta", "Marta" },
            { "timezone.excity.Europe/Minsk", "M\u0129gsiki" },
            { "timezone.excity.Europe/Paris", "Parinh" },
            { "timezone.excity.Europe/Sofia", "S\u00f3fija" },
            { "timezone.excity.Europe/Vaduz", "Vanuj" },
            { "timezone.excity.Indian/Cocos", "K\u00f3ko Ag" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Guam", "Guv\u1ef9m" },
            { "timezone.excity.Pacific/Niue", "N\u0129ve" },
            { "timezone.excity.Pacific/Wake", "Vaki" },
            { "timezone.excity.Africa/Asmera", "Asim\u1ef9ra" },
            { "timezone.excity.Africa/Bamako", "Mam\u1ef9ko" },
            { "timezone.excity.Africa/Bangui", "Magi" },
            { "timezone.excity.Africa/Banjul", "Manjur" },
            { "timezone.excity.Africa/Bissau", "Misav" },
            { "timezone.excity.Africa/Douala", "Novara" },
            { "timezone.excity.Africa/Harare", "Harari" },
            { "timezone.excity.Africa/Kigali", "Kigari" },
            { "timezone.excity.Africa/Luanda", "Ruv\u1ef9na" },
            { "timezone.excity.Africa/Lusaka", "Rusaka" },
            { "timezone.excity.Africa/Malabo", "M\u1ef9ramo" },
            { "timezone.excity.Africa/Maputo", "M\u1ef9putu" },
            { "timezone.excity.Africa/Maseru", "M\u1ef9seru" },
            { "timezone.excity.Africa/Niamey", "N\u0129am\u1ebdj" },
            { "timezone.excity.America/Aruba", "Aruma" },
            { "timezone.excity.America/Bahia", "Majia" },
            { "timezone.excity.America/Belem", "Mer\u1ebdj" },
            { "timezone.excity.America/Boise", "Mojse" },
            { "timezone.excity.America/Jujuy", "Jujuj" },
            { "timezone.excity.America/Sitka", "Sinka" },
            { "timezone.excity.America/Thule", "Ture" },
            { "timezone.excity.Asia/Ashgabat", "Anhgamati" },
            { "timezone.excity.Asia/Calcutta", "Karkuta" },
            { "timezone.excity.Asia/Damascus", "Nam\u1ef9nhko" },
            { "timezone.excity.Asia/Dushanbe", "Nus\u00e1gme" },
            { "timezone.excity.Asia/Jayapura", "Jaiapura" },
            { "timezone.excity.Asia/Katmandu", "Katim\u1ef9nnu" },
            { "timezone.excity.Asia/Khandyga", "K\u1ef9nyga" },
            { "timezone.excity.Asia/Qostanay", "Kojtan\u1ef9j" },
            { "timezone.excity.Asia/Sakhalin", "Sakar\u0129n\u1ef9" },
            { "timezone.excity.Asia/Shanghai", "S\u1ef9ggaj" },
            { "timezone.excity.Asia/Tashkent", "Tanhk\u1ebdnti" },
            { "timezone.excity.Asia/Ust-Nera", "Unhti-N\u1ebdra" },
            { "timezone.excity.Europe/Athens", "Aten\u1ef9" },
            { "timezone.excity.Europe/Berlin", "Mer-r\u0129g" },
            { "timezone.excity.Europe/Dublin", "Numrin" },
            { "timezone.excity.Europe/Jersey", "J\u00e9rsej" },
            { "timezone.excity.Europe/Lisbon", "Rinhmova" },
            { "timezone.excity.Europe/London", "R\u00e3nere" },
            { "timezone.excity.Europe/Madrid", "M\u1ef9niri" },
            { "timezone.excity.Europe/Monaco", "M\u00e3n\u1ef9ko" },
            { "timezone.excity.Europe/Moscow", "M\u00e3nhkov" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Samara", "Sam\u1ef9ra" },
            { "timezone.excity.Europe/Skopje", "Sikopije" },
            { "timezone.excity.Europe/Tirane", "Tir\u1ef9n\u1ef9" },
            { "timezone.excity.Europe/Vienna", "Vien\u1ef9" },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3vija" },
            { "timezone.excity.Europe/Zagreb", "Jagr\u00e9me" },
            { "timezone.excity.Europe/Zurich", "Jurike" },
            { "timezone.excity.Indian/Chagos", "Sago" },
            { "timezone.excity.Indian/Comoro", "Kom\u00e3re" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Pacific/Nauru", "N\u1ef9vuru" },
            { "timezone.excity.Pacific/Palau", "Parav" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Aminjan" },
            { "timezone.excity.Africa/Algiers", "Arj\u00e9r" },
            { "timezone.excity.Africa/Conakry", "Kon\u1ef9kri" },
            { "timezone.excity.Africa/Kampala", "K\u00e3mpara" },
            { "timezone.excity.Africa/Mbabane", "M\u0129maman\u1ebd" },
            { "timezone.excity.Africa/Nairobi", "N\u1ef9jr\u00f3mi" },
            { "timezone.excity.Africa/Tripoli", "Tripori" },
            { "timezone.excity.America/Belize", "Merise" },
            { "timezone.excity.America/Bogota", "Mogota" },
            { "timezone.excity.America/Cancun", "K\u1ef9k\u0169n" },
            { "timezone.excity.America/Cayman", "Kajm\u1ef9n" },
            { "timezone.excity.America/Cuiaba", "Kujama" },
            { "timezone.excity.America/Dawson", "Navs\u00e3n" },
            { "timezone.excity.America/Denver", "Nenver" },
            { "timezone.excity.America/Guyana", "Guj\u00e1n\u1ef9" },
            { "timezone.excity.America/Havana", "Hav\u00e1n\u1ef9" },
            { "timezone.excity.America/Inuvik", "In\u0169viki" },
            { "timezone.excity.America/Juneau", "Jun\u1ef9vo" },
            { "timezone.excity.America/La_Paz", "Ra Pasi" },
            { "timezone.excity.America/Maceio", "M\u1ef9sej\u00f3" },
            { "timezone.excity.America/Manaus", "M\u1ef9n\u1ef9vo" },
            { "timezone.excity.America/Merida", "M\u1ebdrina" },
            { "timezone.excity.America/Nassau", "N\u1ef9sav" },
            { "timezone.excity.America/Panama", "Pan\u1ef9m\u1ef9" },
            { "timezone.excity.America/Recife", "Risifi" },
            { "timezone.excity.America/Regina", "Rijin\u1ef9" },
            { "timezone.excity.Asia/Famagusta", "Fam\u1ef9gujta" },
            { "timezone.excity.Asia/Hong_Kong", "H\u00e3g K\u00e3g" },
            { "timezone.excity.Asia/Jerusalem", "Jerujar\u1ebdj" },
            { "timezone.excity.Asia/Kamchatka", "K\u1ef9msanka" },
            { "timezone.excity.Asia/Pontianak", "P\u00e3nti\u1ef9n\u1ef9ki" },
            { "timezone.excity.Asia/Pyongyang", "Pi\u00e3g-j\u1ef9g" },
            { "timezone.excity.Asia/Qyzylorda", "Kyjyrorna" },
            { "timezone.excity.Asia/Samarkand", "Sam\u1ef9rk\u1ef9nna" },
            { "timezone.excity.Asia/Singapore", "S\u0129gapura" },
            { "timezone.excity.Asia/Vientiane", "Vij\u1ebdtij\u1ef9n\u0129" },
            { "timezone.excity.Europe/Andorra", "\u1ef8noha" },
            { "timezone.excity.Europe/Saratov", "Sarat\u00f3vi" },
            { "timezone.excity.Europe/Tallinn", "Tar\u0129n" },
            { "timezone.excity.Europe/Vatican", "Vatik\u1ef9n\u0169" },
            { "timezone.excity.Europe/Vilnius", "Virn\u0129jusi" },
            { "timezone.excity.Indian/Mayotte", "M\u1ef9j\u00f3ti" },
            { "timezone.excity.Indian/Reunion", "R\u0169nj\u0169v" },
            { "timezone.excity.Pacific/Easter", "Pasikuva Goj-v\u1ebdso" },
            { "timezone.excity.Pacific/Kosrae", "Kosiraje" },
            { "timezone.excity.Pacific/Majuro", "M\u1ef9juro" },
            { "timezone.excity.Pacific/Midway", "M\u0129nnuvej" },
            { "timezone.excity.Pacific/Noumea", "N\u00e3um\u1ebda" },
            { "timezone.excity.Pacific/Saipan", "Sajp\u1ef9" },
            { "timezone.excity.Pacific/Tahiti", "Tajti" },
            { "timezone.excity.Pacific/Tarawa", "Tarauva" },
            { "timezone.excity.Pacific/Wallis", "Varinh" },
            { "timezone.excity.Africa/Blantyre", "Mrantyre" },
            { "timezone.excity.Africa/Djibouti", "Nhimuti" },
            { "timezone.excity.Africa/El_Aaiun", "Er A\u2019ajun" },
            { "timezone.excity.Africa/Freetown", "\u1ebcm\u00e3-fri" },
            { "timezone.excity.Africa/Gaborone", "Gamoron\u0129" },
            { "timezone.excity.Africa/Khartoum", "Kart\u0169m" },
            { "timezone.excity.Africa/Kinshasa", "K\u0129saja" },
            { "timezone.excity.Africa/Monrovia", "M\u00e3nr\u00f3vija" },
            { "timezone.excity.Africa/Ndjamena", "Ni\u2019nijam\u1ebdn\u1ef9" },
            { "timezone.excity.Africa/Sao_Tome", "S\u1ef9 Tum\u1ebd" },
            { "timezone.excity.Africa/Windhoek", "V\u0129nno\u00e9ki" },
            { "timezone.excity.America/Antigua", "\u1ef8tiguva" },
            { "timezone.excity.America/Caracas", "Karakanh" },
            { "timezone.excity.America/Cayenne", "Kajen\u1ef9" },
            { "timezone.excity.America/Chicago", "Sikagu" },
            { "timezone.excity.America/Cordoba", "K\u00f3rnoma" },
            { "timezone.excity.America/Creston", "Kr\u00e9sit\u00e3n" },
            { "timezone.excity.America/Curacao", "Kurasavo" },
            { "timezone.excity.America/Detroit", "Netor\u00f3jti" },
            { "timezone.excity.America/Godthab", "N\u0169g" },
            { "timezone.excity.America/Grenada", "Gran\u1ef9na" },
            { "timezone.excity.America/Halifax", "Harifag" },
            { "timezone.excity.America/Iqaluit", "Ikarujin" },
            { "timezone.excity.America/Jamaica", "Jam\u1ef9jk\u1ef9" },
            { "timezone.excity.America/Managua", "M\u1ef9n\u1ef9guva" },
            { "timezone.excity.America/Marigot", "M\u1ef9rig\u00f3ti" },
            { "timezone.excity.America/Mendoza", "M\u1ebdnosa" },
            { "timezone.excity.America/Moncton", "M\u00e3gt\u00e3n" },
            { "timezone.excity.America/Nipigon", "N\u0129pig\u00e3n" },
            { "timezone.excity.America/Noronha", "Fern\u1ef9nu N\u00e3r\u00e3ja-t\u00e1" },
            { "timezone.excity.America/Ojinaga", "Ojin\u1ef9ga" },
            { "timezone.excity.America/Phoenix", "Fuen\u0129nh" },
            { "timezone.excity.America/Tijuana", "Tiv\u1ef9n\u1ef9" },
            { "timezone.excity.America/Toronto", "Tor\u00e3to" },
            { "timezone.excity.America/Tortola", "Tortora" },
            { "timezone.excity.America/Yakutat", "Yjakutati" },
            { "timezone.excity.Asia/Choibalsan", "Sojmars\u1ef9" },
            { "timezone.excity.Asia/Phnom_Penh", "Fyn\u00e3g P\u1ebdj" },
            { "timezone.excity.Atlantic/Azores", "Asorenh" },
            { "timezone.excity.Atlantic/Canary", "Kan\u1ef9rija Ag" },
            { "timezone.excity.Australia/Eucla", "Eukra" },
            { "timezone.excity.Australia/Perth", "P\u00e9rti" },
            { "timezone.excity.Europe/Belgrade", "Mergrano" },
            { "timezone.excity.Europe/Brussels", "Mrus\u00e9ra" },
            { "timezone.excity.Europe/Budapest", "Munapenhte" },
            { "timezone.excity.Europe/Busingen", "Myjingen" },
            { "timezone.excity.Europe/Chisinau", "Sijin\u1ef9vo" },
            { "timezone.excity.Europe/Guernsey", "G\u00e9rn\u0129sej" },
            { "timezone.excity.Europe/Helsinki", "H\u00e9rs\u0129gke" },
            { "timezone.excity.Europe/Istanbul", "Inhtamur" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo/Sarajevu" },
            { "timezone.excity.Europe/Uzhgorod", "Ungoron" },
            { "timezone.excity.Indian/Maldives", "M\u1ef9rniva" },
            { "timezone.excity.Pacific/Chatham", "Satin\u1ef9m" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofu" },
            { "timezone.excity.Pacific/Gambier", "G\u1ef9mmi\u00e9r" },
            { "timezone.excity.Pacific/Norfolk", "N\u00e3rfoki" },
            { "timezone.excity.Africa/Bujumbura", "Muj\u0169mura" },
            { "timezone.excity.Africa/Mogadishu", "M\u0169ganinhsu" },
            { "timezone.excity.America/Anguilla", "\u1ef8gira" },
            { "timezone.excity.America/Asuncion", "As\u0169gs\u1ef9" },
            { "timezone.excity.America/Barbados", "Marmanu" },
            { "timezone.excity.America/Dominica", "Nom\u0129n\u0129ka" },
            { "timezone.excity.America/Edmonton", "Enim\u00e3nt\u00e3" },
            { "timezone.excity.America/Eirunepe", "Ejrun\u1ebdp\u00e9" },
            { "timezone.excity.America/Mazatlan", "M\u1ef9jatr\u1ef9n" },
            { "timezone.excity.America/Miquelon", "M\u0129keron" },
            { "timezone.excity.America/New_York", "Yj\u00f3rki T\u00e3g" },
            { "timezone.excity.America/Resolute", "Rijorute" },
            { "timezone.excity.America/Santarem", "S\u1ef9tar\u1ebdj" },
            { "timezone.excity.America/Santiago", "S\u1ef9tijagu" },
            { "timezone.excity.America/St_Johns", "S\u1ef9n Jonh" },
            { "timezone.excity.America/St_Kitts", "S\u1ef9 Krit\u00f3v\u1ef9" },
            { "timezone.excity.America/St_Lucia", "S\u1ef9ta Rusa" },
            { "timezone.excity.America/Winnipeg", "V\u0129n\u0129p\u00e9g" },
            { "timezone.excity.Antarctica/Casey", "Kasej" },
            { "timezone.excity.Antarctica/Davis", "Navisi" },
            { "timezone.excity.Antarctica/Syowa", "Siova" },
            { "timezone.excity.Antarctica/Troll", "Tor\u00f3r" },
            { "timezone.excity.Asia/Krasnoyarsk", "Kranhn\u00e3jarki" },
            { "timezone.excity.Asia/Novosibirsk", "Simirsiki T\u00e3g" },
            { "timezone.excity.Asia/Ulaanbaatar", "Uran Mator" },
            { "timezone.excity.Asia/Vladivostok", "Uraniv\u00f3nht\u00f3ki" },
            { "timezone.excity.Atlantic/Bermuda", "Merm\u0169na" },
            { "timezone.excity.Atlantic/Madeira", "Ka" },
            { "timezone.excity.Atlantic/Stanley", "Sit\u1ef9rej" },
            { "timezone.excity.Australia/Currie", "Kurije" },
            { "timezone.excity.Australia/Darwin", "Narv\u0129n" },
            { "timezone.excity.Australia/Hobart", "Homarti" },
            { "timezone.excity.Australia/Sydney", "Sininej" },
            { "timezone.excity.Europe/Amsterdam", "Am\u0129nhtern\u00e1" },
            { "timezone.excity.Europe/Astrakhan", "Anhtak\u1ef9" },
            { "timezone.excity.Europe/Bucharest", "Mukar\u00e9nhti" },
            { "timezone.excity.Europe/Gibraltar", "Jimratar" },
            { "timezone.excity.Europe/Ljubljana", "Rimri\u1ef9n\u1ef9" },
            { "timezone.excity.Europe/Mariehamn", "M\u1ef9rieh\u1ef9m" },
            { "timezone.excity.Europe/Podgorica", "Pong\u00f3rika" },
            { "timezone.excity.Europe/Stockholm", "Enhtukorm\u0169" },
            { "timezone.excity.Europe/Ulyanovsk", "Urijan\u00e3vinhki" },
            { "timezone.excity.Europe/Volgograd", "Vorgugrano" },
            { "timezone.excity.Indian/Christmas", "Krinhtim\u1ef9" },
            { "timezone.excity.Indian/Kerguelen", "Kirg\u00e9ren" },
            { "timezone.excity.Indian/Mauritius", "M\u00e3risiv" },
            { "timezone.excity.Pacific/Auckland", "\u00d3g-r\u1ef9n" },
            { "timezone.excity.Pacific/Funafuti", "Fun\u1ef9futi" },
            { "timezone.excity.Pacific/Honolulu", "Hon\u00e3ruru" },
            { "timezone.excity.Pacific/Johnston", "Nhionht\u00e3n" },
            { "timezone.excity.Pacific/Pitcairn", "Pitikair" },
            { "timezone.excity.Africa/Casablanca", "\u0128nkupri" },
            { "timezone.excity.Africa/Libreville", "Rimreviri" },
            { "timezone.excity.Africa/Lubumbashi", "Rumumasi" },
            { "timezone.excity.Africa/Nouakchott", "N\u00e3vags\u00f3ti" },
            { "timezone.excity.Africa/Porto-Novo", "Porto T\u00e3g" },
            { "timezone.excity.America/Anchorage", "\u1ef8koragi" },
            { "timezone.excity.America/Araguaina", "Araguain\u1ef9" },
            { "timezone.excity.America/Boa_Vista", "Veja H\u00e1" },
            { "timezone.excity.America/Catamarca", "Katam\u1ef9rka" },
            { "timezone.excity.America/Chihuahua", "Sihuvahuva" },
            { "timezone.excity.America/Fortaleza", "Fortareja" },
            { "timezone.excity.America/Glace_Bay", "Grase Mej" },
            { "timezone.excity.America/Goose_Bay", "G\u1ef9so Mej" },
            { "timezone.excity.America/Guatemala", "Guratem\u1ef9ra" },
            { "timezone.excity.America/Guayaquil", "Guvajakir" },
            { "timezone.excity.America/Matamoros", "M\u00e3ro-ag T\u00e3nh" },
            { "timezone.excity.America/Menominee", "M\u1ebdn\u00e3m\u0129n\u0129" },
            { "timezone.excity.America/Monterrey", "M\u00e3tehej" },
            { "timezone.excity.America/Sao_Paulo", "S\u1ef9 Pavoru" },
            { "timezone.excity.America/St_Thomas", "S\u1ef9 Tomaj" },
            { "timezone.excity.America/Vancouver", "V\u1ef9gkuver" },
            { "timezone.excity.Antarctica/Mawson", "M\u1ef9us\u00e3n" },
            { "timezone.excity.Antarctica/Palmer", "Parm\u1ebdr" },
            { "timezone.excity.Antarctica/Vostok", "Vonht\u00f3ki" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuvara R\u0169pur" },
            { "timezone.excity.Asia/Novokuznetsk", "Kunhn\u1ebdtinhki T\u00e3g" },
            { "timezone.excity.Europe/Bratislava", "Mratinhrava" },
            { "timezone.excity.Europe/Copenhagen", "Kop\u1ebdnh\u1ef9ge" },
            { "timezone.excity.Europe/Luxembourg", "Rus\u1ebdgmurgo" },
            { "timezone.excity.Europe/San_Marino", "S\u1ef9 M\u1ef9r\u0129n\u0169" },
            { "timezone.excity.Europe/Simferopol", "S\u0129gfiripor" },
            { "timezone.excity.Europe/Zaporozhye", "Japorisija" },
            { "timezone.excity.Pacific/Enderbury", "\u1ebcnnermuri" },
            { "timezone.excity.Pacific/Galapagos", "Gara Pago" },
            { "timezone.excity.Pacific/Kwajalein", "Kuvajar\u1ebdj" },
            { "timezone.excity.Pacific/Marquesas", "M\u1ef9rkeja Fag" },
            { "timezone.excity.Pacific/Rarotonga", "Rar\u00e3t\u00e3ga" },
            { "timezone.excity.Pacific/Tongatapu", "T\u00e3ngatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Anisi Amema" },
            { "timezone.excity.Africa/Brazzaville", "Mrajavire" },
            { "timezone.excity.Africa/Ouagadougou", "Ovaganogov" },
            { "timezone.excity.America/Costa_Rica", "P\u00e3n\u0129 T\u0169 M\u00e1g" },
            { "timezone.excity.America/Grand_Turk", "Turki M\u00e1g" },
            { "timezone.excity.America/Guadeloupe", "Guvanarupe" },
            { "timezone.excity.America/Hermosillo", "H\u00e9rmosiro" },
            { "timezone.excity.America/Kralendijk", "Krar\u1ebdnike" },
            { "timezone.excity.America/Louisville", "Ruinhviri" },
            { "timezone.excity.America/Martinique", "M\u1ef9rtin\u0129ka" },
            { "timezone.excity.America/Metlakatla", "M\u1ebdtarakatara" },
            { "timezone.excity.America/Montevideo", "M\u00e3tivin\u00e9v" },
            { "timezone.excity.America/Montserrat", "M\u00e3nser\u00e1ti" },
            { "timezone.excity.America/Paramaribo", "Param\u1ef9rimu" },
            { "timezone.excity.America/Rio_Branco", "Goj Kupri" },
            { "timezone.excity.America/St_Vincent", "S\u1ef9 Vis\u1ebdti" },
            { "timezone.excity.America/Whitehorse", "K\u00e3v\u00e3ru Kupri" },
            { "timezone.excity.Antarctica/McMurdo", "M\u00e9g-M\u0169rno" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Siren\u1ebdkorymsiki" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekater\u0129nmurgu" },
            { "timezone.excity.Atlantic/Reykjavik", "Rejkijaviki" },
            { "timezone.excity.Atlantic/St_Helena", "S\u1ef9ta Eren\u1ef9" },
            { "timezone.excity.Australia/Adelaide", "Anerajni" },
            { "timezone.excity.Australia/Brisbane", "Mrinhman\u1ebd" },
            { "timezone.excity.Australia/Lindeman", "R\u0129nerm\u1ef9n" },
            { "timezone.excity.Europe/Isle_of_Man", "\u0168n-gr\u00e9 Goj-v\u1ebdso" },
            { "timezone.excity.Europe/Kaliningrad", "Karin\u0129ngrano" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritim\u1ef9ti" },
            { "timezone.excity.Africa/Johannesburg", "Juv\u1ef9n\u1ebdnhmurgu" },
            { "timezone.excity.America/El_Salvador", "\u00c9r Sarvanor" },
            { "timezone.excity.America/Fort_Nelson", "F\u00f3rti N\u1ebdrsu" },
            { "timezone.excity.America/Los_Angeles", "Ronh \u1ef8njiri" },
            { "timezone.excity.America/Mexico_City", "\u1ebcm\u00e3 t\u1ef9 M\u1ebdsiko" },
            { "timezone.excity.America/Pangnirtung", "P\u1ef9gn\u0129rt\u0169g" },
            { "timezone.excity.America/Porto_Velho", "Porto K\u00f3fa" },
            { "timezone.excity.America/Puerto_Rico", "Porto Riko" },
            { "timezone.excity.America/Rainy_River", "Tamum\u00e3 Goj" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigarpa" },
            { "timezone.excity.America/Thunder_Bay", "T\u0169nner Mej" },
            { "timezone.excity.America/Yellowknife", "R\u00f3gro M\u1ef9r\u00e9r" },
            { "timezone.excity.Arctic/Longyearbyen", "R\u0169gij\u00e9 Armyj\u1ebdn" },
            { "timezone.excity.Atlantic/Cape_Verde", "Pu T\u00e1nh" },
            { "timezone.excity.Australia/Lord_Howe", "R\u00f3rni Hove" },
            { "timezone.excity.Australia/Melbourne", "M\u1ebdrmurn\u0129" },
            { "timezone.excity.Indian/Antananarivo", "\u1ef8tan\u1ef9n\u1ef9rivo" },
            { "timezone.excity.Pacific/Guadalcanal", "Guvanarkan\u1ef9r" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Nar Enh Sar\u1ef9m" },
            { "timezone.excity.America/Blanc-Sablon", "Samr\u00e3n Kupri" },
            { "timezone.excity.America/Buenos_Aires", "Muen\u0169sairi" },
            { "timezone.excity.America/Campo_Grande", "Re M\u00e1g" },
            { "timezone.excity.America/Danmarkshavn", "N\u00e1nm\u1ef9rkisavyn" },
            { "timezone.excity.America/Dawson_Creek", "Naus\u00e3n Kriki" },
            { "timezone.excity.America/Indiana/Knox", "Kin\u00e3g, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Indianapolis", "\u0128nijan\u1ef9porinh" },
            { "timezone.excity.America/Punta_Arenas", "P\u0169ta Aren\u1ef9" },
            { "timezone.excity.America/Rankin_Inlet", "R\u1ef9gk\u0129g \u0128r\u00e9n" },
            { "timezone.excity.America/Santa_Isabel", "S\u1ef9ta Isam\u00e9" },
            { "timezone.excity.America/Scoresbysund", "Itogkorturm\u0129nti" },
            { "timezone.excity.Antarctica/Macquarie", "M\u1ef9kikuari" },
            { "timezone.excity.Pacific/Bougainville", "Mug\u1ef9nvire" },
            { "timezone.excity.Pacific/Port_Moresby", "P\u00f3r M\u00e3renhmi" },
            { "timezone.excity.America/Cambridge_Bay", "K\u1ebdmrinje Mej" },
            { "timezone.excity.America/Coral_Harbour", "Atikok\u1ef9n" },
            { "timezone.excity.America/Indiana/Vevay", "Vevaj, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Lower_Princes", "Rover Pr\u0129nsi Kuvart\u00e9r" },
            { "timezone.excity.America/Port_of_Spain", "P\u00f3rtofi Inhpajin" },
            { "timezone.excity.America/Santo_Domingo", "S\u1ef9tu Num\u0129ggu" },
            { "timezone.excity.America/St_Barthelemy", "S\u1ef9 Martorom\u1ebd" },
            { "timezone.excity.America/Swift_Current", "Suvifiti Kur\u1ebdti" },
            { "timezone.excity.Australia/Broken_Hill", "Mruken Hir" },
            { "timezone.excity.America/Bahia_Banderas", "Majia M\u00e1nnera Ag" },
            { "timezone.excity.America/Port-au-Prince", "Portu Pr\u0129sipi" },
            { "timezone.excity.Atlantic/South_Georgia", "Ji\u00f3rja t\u1ef9 Sur" },
            { "timezone.excity.America/Argentina/Salta", "Sarta" },
            { "timezone.excity.America/Indiana/Marengo", "M\u1ef9r\u1ebdggu, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Indiana/Winamac", "Vin\u1ef9m\u1ef9ki, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukum\u1ef9" },
            { "timezone.excity.America/Argentina/Ushuaia", "Usuaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Ter siti, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Indiana/Vincennes", "V\u0129sen\u1ebdnh, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ra Rioha" },
            { "timezone.excity.America/Argentina/San_Juan", "S\u1ef9 Juv\u1ef9" },
            { "timezone.excity.America/Argentina/San_Luis", "S\u1ef9 Ruj" },
            { "timezone.excity.America/Indiana/Petersburg", "P\u00e9termurgi, \u0128nij\u1ef9n\u1ef9" },
            { "timezone.excity.America/Kentucky/Monticello", "M\u00e3ntis\u00e9ru, K\u1ebdt\u00e1ki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Meura, Nakota N\u00e3rti" },
            { "timezone.excity.America/North_Dakota/Center", "S\u1ebdnter, Dakota N\u00e3rti" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Garego Goj" },
            { "timezone.excity.America/North_Dakota/New_Salem", "N\u0129u Saren, Nakota N\u00e3rti" },
        };
        return data;
    }
}
