/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.repositories.azure.LocationMode;
import org.opensearch.repositories.azure.ProxySettings;

final class AzureStorageSettings {
    private static final String AZURE_CLIENT_PREFIX_KEY = "azure.client.";
    public static final Setting.AffixSetting<SecureString> ACCOUNT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"account", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> KEY_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> SAS_TOKEN_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"sas_token", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> MAX_RETRIES_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"max_retries", key -> Setting.intSetting((String)key, (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<String> ENDPOINT_SUFFIX_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"endpoint_suffix", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<TimeValue> TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<TimeValue> CONNECT_TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"connect.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<TimeValue> WRITE_TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"write.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"read.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<TimeValue> RESPONSE_TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"response.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<ProxySettings.ProxyType> PROXY_TYPE_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.type", key -> new Setting(key, "direct", s -> ProxySettings.ProxyType.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> KEY_SETTING});
    public static final Setting.AffixSetting<String> PROXY_HOST_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> KEY_SETTING, () -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING});
    public static final Setting.AffixSetting<Integer> PROXY_PORT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.port", key -> Setting.intSetting((String)key, (int)0, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> KEY_SETTING, () -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING});
    static final Setting.AffixSetting<SecureString> PROXY_USERNAME_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.username", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> KEY_SETTING, () -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING});
    static final Setting.AffixSetting<SecureString> PROXY_PASSWORD_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> KEY_SETTING, () -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING, () -> PROXY_USERNAME_SETTING});
    private final String account;
    private final String connectString;
    private final String endpointSuffix;
    private final TimeValue timeout;
    private final int maxRetries;
    private final LocationMode locationMode;
    private final TimeValue connectTimeout;
    private final TimeValue writeTimeout;
    private final TimeValue readTimeout;
    private final TimeValue responseTimeout;
    private final ProxySettings proxySettings;

    private AzureStorageSettings(String account, String connectString, String endpointSuffix, TimeValue timeout, int maxRetries, LocationMode locationMode, TimeValue connectTimeout, TimeValue writeTimeout, TimeValue readTimeout, TimeValue responseTimeout, ProxySettings proxySettings) {
        this.account = account;
        this.connectString = connectString;
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.locationMode = locationMode;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.responseTimeout = responseTimeout;
        this.proxySettings = proxySettings;
    }

    private AzureStorageSettings(String account, String key, String sasToken, String endpointSuffix, TimeValue timeout, int maxRetries, TimeValue connectTimeout, TimeValue writeTimeout, TimeValue readTimeout, TimeValue responseTimeout, ProxySettings proxySettings) {
        this.account = account;
        this.connectString = AzureStorageSettings.buildConnectString(account, key, sasToken, endpointSuffix);
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.locationMode = LocationMode.PRIMARY_ONLY;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.responseTimeout = responseTimeout;
        this.proxySettings = proxySettings;
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public String getConnectString() {
        return this.connectString;
    }

    private static String buildConnectString(String account, @Nullable String key, @Nullable String sasToken, String endpointSuffix) {
        boolean hasSasToken = Strings.hasText((String)sasToken);
        boolean hasKey = Strings.hasText((String)key);
        if (!hasSasToken && !hasKey) {
            throw new SettingsException("Neither a secret key nor a shared access token was set.");
        }
        if (hasSasToken && hasKey) {
            throw new SettingsException("Both a secret as well as a shared access token were set.");
        }
        StringBuilder connectionStringBuilder = new StringBuilder();
        connectionStringBuilder.append("DefaultEndpointsProtocol=https").append(";AccountName=").append(account);
        if (hasKey) {
            connectionStringBuilder.append(";AccountKey=").append(key);
        } else {
            connectionStringBuilder.append(";SharedAccessSignature=").append(sasToken);
        }
        if (Strings.hasText((String)endpointSuffix)) {
            connectionStringBuilder.append(";EndpointSuffix=").append(endpointSuffix);
        }
        return connectionStringBuilder.toString();
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getWriteTimeout() {
        return this.writeTimeout;
    }

    public TimeValue getReadTimeout() {
        return this.readTimeout;
    }

    public TimeValue getResponseTimeout() {
        return this.responseTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AzureStorageSettings{");
        sb.append("account='").append(this.account).append('\'');
        sb.append(", timeout=").append(this.timeout);
        sb.append(", endpointSuffix='").append(this.endpointSuffix).append('\'');
        sb.append(", maxRetries=").append(this.maxRetries);
        sb.append(", proxySettings=").append(this.proxySettings != ProxySettings.NO_PROXY_SETTINGS ? "PROXY_SET" : "PROXY_NOT_SET");
        sb.append(", locationMode='").append((Object)this.locationMode).append('\'');
        sb.append(", connectTimeout='").append(this.connectTimeout).append('\'');
        sb.append(", writeTimeout='").append(this.writeTimeout).append('\'');
        sb.append(", readTimeout='").append(this.readTimeout).append('\'');
        sb.append(", responseTimeout='").append(this.responseTimeout).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static Map<String, AzureStorageSettings> load(Settings settings) {
        HashMap<String, AzureStorageSettings> storageSettings = new HashMap<String, AzureStorageSettings>();
        for (String clientName : ACCOUNT_SETTING.getNamespaces(settings)) {
            storageSettings.put(clientName, AzureStorageSettings.getClientSettings(settings, clientName));
        }
        if (!storageSettings.containsKey("default") && !storageSettings.isEmpty()) {
            AzureStorageSettings defaultSettings = (AzureStorageSettings)storageSettings.values().iterator().next();
            storageSettings.put("default", defaultSettings);
        }
        assert (storageSettings.containsKey("default") || storageSettings.isEmpty()) : "always have 'default' if any";
        return Collections.unmodifiableMap(storageSettings);
    }

    /*
     * Exception decompiling
     */
    private static AzureStorageSettings getClientSettings(Settings settings, String clientName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static ProxySettings validateAndCreateProxySettings(Settings settings, String clientName) {
        ProxySettings.ProxyType proxyType = AzureStorageSettings.getConfigValue(settings, clientName, PROXY_TYPE_SETTING);
        String proxyHost = AzureStorageSettings.getConfigValue(settings, clientName, PROXY_HOST_SETTING);
        int proxyPort = AzureStorageSettings.getConfigValue(settings, clientName, PROXY_PORT_SETTING);
        SecureString proxyUserName = AzureStorageSettings.getConfigValue(settings, clientName, PROXY_USERNAME_SETTING);
        SecureString proxyPassword = AzureStorageSettings.getConfigValue(settings, clientName, PROXY_PASSWORD_SETTING);
        if (proxyType == ProxySettings.ProxyType.DIRECT && (proxyPort != 0 || Strings.hasText((String)proxyHost) || Strings.hasText((CharSequence)proxyUserName) || Strings.hasText((CharSequence)proxyPassword))) {
            throw new SettingsException("Azure proxy port or host or username or password have been set but proxy type is not defined.");
        }
        if (proxyType != ProxySettings.ProxyType.DIRECT && (proxyPort == 0 || Strings.isEmpty((CharSequence)proxyHost))) {
            throw new SettingsException("Azure proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType == ProxySettings.ProxyType.DIRECT) {
            return ProxySettings.NO_PROXY_SETTINGS;
        }
        try {
            InetAddress proxyHostAddress = InetAddress.getByName(proxyHost);
            return new ProxySettings(proxyType, proxyHostAddress, proxyPort, proxyUserName.toString(), proxyPassword.toString());
        }
        catch (UnknownHostException e) {
            throw new SettingsException("Azure proxy host is unknown.", (Throwable)e);
        }
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }

    private static <T> T getValue(Settings settings, String groupName, Setting<T> setting) {
        Setting.AffixKey k = (Setting.AffixKey)setting.getRawKey();
        String fullKey = k.toConcreteKey(groupName).toString();
        return (T)setting.getConcreteSetting(fullKey).get(settings);
    }

    static Map<String, AzureStorageSettings> overrideLocationMode(Map<String, AzureStorageSettings> clientsSettings, LocationMode locationMode) {
        MapBuilder mapBuilder = new MapBuilder();
        for (Map.Entry<String, AzureStorageSettings> entry : clientsSettings.entrySet()) {
            mapBuilder.put((Object)entry.getKey(), (Object)new AzureStorageSettings(entry.getValue().account, entry.getValue().connectString, entry.getValue().endpointSuffix, entry.getValue().timeout, entry.getValue().maxRetries, locationMode, entry.getValue().connectTimeout, entry.getValue().writeTimeout, entry.getValue().readTimeout, entry.getValue().responseTimeout, entry.getValue().getProxySettings()));
        }
        return mapBuilder.immutableMap();
    }
}

