# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
PCDM module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_pcdm.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _PCDM
else:
    import _PCDM

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _PCDM.delete_SwigPyIterator

    def value(self):
        return _PCDM.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _PCDM.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _PCDM.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _PCDM.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _PCDM.SwigPyIterator_equal(self, x)

    def copy(self):
        return _PCDM.SwigPyIterator_copy(self)

    def next(self):
        return _PCDM.SwigPyIterator_next(self)

    def __next__(self):
        return _PCDM.SwigPyIterator___next__(self)

    def previous(self):
        return _PCDM.SwigPyIterator_previous(self)

    def advance(self, n):
        return _PCDM.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _PCDM.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _PCDM.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _PCDM.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _PCDM.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _PCDM.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _PCDM.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _PCDM:
_PCDM.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _PCDM.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Storage
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.CDM
import OCC.Core.Resource

from enum import IntEnum
from OCC.Core.Exception import *

PCDM_RS_OK = _PCDM.PCDM_RS_OK
PCDM_RS_NoDriver = _PCDM.PCDM_RS_NoDriver
PCDM_RS_UnknownFileDriver = _PCDM.PCDM_RS_UnknownFileDriver
PCDM_RS_OpenError = _PCDM.PCDM_RS_OpenError
PCDM_RS_NoVersion = _PCDM.PCDM_RS_NoVersion
PCDM_RS_NoSchema = _PCDM.PCDM_RS_NoSchema
PCDM_RS_NoDocument = _PCDM.PCDM_RS_NoDocument
PCDM_RS_ExtensionFailure = _PCDM.PCDM_RS_ExtensionFailure
PCDM_RS_WrongStreamMode = _PCDM.PCDM_RS_WrongStreamMode
PCDM_RS_FormatFailure = _PCDM.PCDM_RS_FormatFailure
PCDM_RS_TypeFailure = _PCDM.PCDM_RS_TypeFailure
PCDM_RS_TypeNotFoundInSchema = _PCDM.PCDM_RS_TypeNotFoundInSchema
PCDM_RS_UnrecognizedFileFormat = _PCDM.PCDM_RS_UnrecognizedFileFormat
PCDM_RS_MakeFailure = _PCDM.PCDM_RS_MakeFailure
PCDM_RS_PermissionDenied = _PCDM.PCDM_RS_PermissionDenied
PCDM_RS_DriverFailure = _PCDM.PCDM_RS_DriverFailure
PCDM_RS_AlreadyRetrievedAndModified = _PCDM.PCDM_RS_AlreadyRetrievedAndModified
PCDM_RS_AlreadyRetrieved = _PCDM.PCDM_RS_AlreadyRetrieved
PCDM_RS_UnknownDocument = _PCDM.PCDM_RS_UnknownDocument
PCDM_RS_WrongResource = _PCDM.PCDM_RS_WrongResource
PCDM_RS_ReaderException = _PCDM.PCDM_RS_ReaderException
PCDM_RS_NoModel = _PCDM.PCDM_RS_NoModel
PCDM_RS_UserBreak = _PCDM.PCDM_RS_UserBreak
PCDM_SS_OK = _PCDM.PCDM_SS_OK
PCDM_SS_DriverFailure = _PCDM.PCDM_SS_DriverFailure
PCDM_SS_WriteFailure = _PCDM.PCDM_SS_WriteFailure
PCDM_SS_Failure = _PCDM.PCDM_SS_Failure
PCDM_SS_Doc_IsNull = _PCDM.PCDM_SS_Doc_IsNull
PCDM_SS_No_Obj = _PCDM.PCDM_SS_No_Obj
PCDM_SS_Info_Section_Error = _PCDM.PCDM_SS_Info_Section_Error
PCDM_SS_UserBreak = _PCDM.PCDM_SS_UserBreak
PCDM_SS_UnrecognizedFormat = _PCDM.PCDM_SS_UnrecognizedFormat
PCDM_TOFD_File = _PCDM.PCDM_TOFD_File
PCDM_TOFD_CmpFile = _PCDM.PCDM_TOFD_CmpFile
PCDM_TOFD_XmlFile = _PCDM.PCDM_TOFD_XmlFile
PCDM_TOFD_Unknown = _PCDM.PCDM_TOFD_Unknown


class PCDM_ReaderStatus(IntEnum):
	PCDM_RS_OK = 0
	PCDM_RS_NoDriver = 1
	PCDM_RS_UnknownFileDriver = 2
	PCDM_RS_OpenError = 3
	PCDM_RS_NoVersion = 4
	PCDM_RS_NoSchema = 5
	PCDM_RS_NoDocument = 6
	PCDM_RS_ExtensionFailure = 7
	PCDM_RS_WrongStreamMode = 8
	PCDM_RS_FormatFailure = 9
	PCDM_RS_TypeFailure = 10
	PCDM_RS_TypeNotFoundInSchema = 11
	PCDM_RS_UnrecognizedFileFormat = 12
	PCDM_RS_MakeFailure = 13
	PCDM_RS_PermissionDenied = 14
	PCDM_RS_DriverFailure = 15
	PCDM_RS_AlreadyRetrievedAndModified = 16
	PCDM_RS_AlreadyRetrieved = 17
	PCDM_RS_UnknownDocument = 18
	PCDM_RS_WrongResource = 19
	PCDM_RS_ReaderException = 20
	PCDM_RS_NoModel = 21
	PCDM_RS_UserBreak = 22
PCDM_RS_OK = PCDM_ReaderStatus.PCDM_RS_OK
PCDM_RS_NoDriver = PCDM_ReaderStatus.PCDM_RS_NoDriver
PCDM_RS_UnknownFileDriver = PCDM_ReaderStatus.PCDM_RS_UnknownFileDriver
PCDM_RS_OpenError = PCDM_ReaderStatus.PCDM_RS_OpenError
PCDM_RS_NoVersion = PCDM_ReaderStatus.PCDM_RS_NoVersion
PCDM_RS_NoSchema = PCDM_ReaderStatus.PCDM_RS_NoSchema
PCDM_RS_NoDocument = PCDM_ReaderStatus.PCDM_RS_NoDocument
PCDM_RS_ExtensionFailure = PCDM_ReaderStatus.PCDM_RS_ExtensionFailure
PCDM_RS_WrongStreamMode = PCDM_ReaderStatus.PCDM_RS_WrongStreamMode
PCDM_RS_FormatFailure = PCDM_ReaderStatus.PCDM_RS_FormatFailure
PCDM_RS_TypeFailure = PCDM_ReaderStatus.PCDM_RS_TypeFailure
PCDM_RS_TypeNotFoundInSchema = PCDM_ReaderStatus.PCDM_RS_TypeNotFoundInSchema
PCDM_RS_UnrecognizedFileFormat = PCDM_ReaderStatus.PCDM_RS_UnrecognizedFileFormat
PCDM_RS_MakeFailure = PCDM_ReaderStatus.PCDM_RS_MakeFailure
PCDM_RS_PermissionDenied = PCDM_ReaderStatus.PCDM_RS_PermissionDenied
PCDM_RS_DriverFailure = PCDM_ReaderStatus.PCDM_RS_DriverFailure
PCDM_RS_AlreadyRetrievedAndModified = PCDM_ReaderStatus.PCDM_RS_AlreadyRetrievedAndModified
PCDM_RS_AlreadyRetrieved = PCDM_ReaderStatus.PCDM_RS_AlreadyRetrieved
PCDM_RS_UnknownDocument = PCDM_ReaderStatus.PCDM_RS_UnknownDocument
PCDM_RS_WrongResource = PCDM_ReaderStatus.PCDM_RS_WrongResource
PCDM_RS_ReaderException = PCDM_ReaderStatus.PCDM_RS_ReaderException
PCDM_RS_NoModel = PCDM_ReaderStatus.PCDM_RS_NoModel
PCDM_RS_UserBreak = PCDM_ReaderStatus.PCDM_RS_UserBreak

class PCDM_StoreStatus(IntEnum):
	PCDM_SS_OK = 0
	PCDM_SS_DriverFailure = 1
	PCDM_SS_WriteFailure = 2
	PCDM_SS_Failure = 3
	PCDM_SS_Doc_IsNull = 4
	PCDM_SS_No_Obj = 5
	PCDM_SS_Info_Section_Error = 6
	PCDM_SS_UserBreak = 7
	PCDM_SS_UnrecognizedFormat = 8
PCDM_SS_OK = PCDM_StoreStatus.PCDM_SS_OK
PCDM_SS_DriverFailure = PCDM_StoreStatus.PCDM_SS_DriverFailure
PCDM_SS_WriteFailure = PCDM_StoreStatus.PCDM_SS_WriteFailure
PCDM_SS_Failure = PCDM_StoreStatus.PCDM_SS_Failure
PCDM_SS_Doc_IsNull = PCDM_StoreStatus.PCDM_SS_Doc_IsNull
PCDM_SS_No_Obj = PCDM_StoreStatus.PCDM_SS_No_Obj
PCDM_SS_Info_Section_Error = PCDM_StoreStatus.PCDM_SS_Info_Section_Error
PCDM_SS_UserBreak = PCDM_StoreStatus.PCDM_SS_UserBreak
PCDM_SS_UnrecognizedFormat = PCDM_StoreStatus.PCDM_SS_UnrecognizedFormat

class PCDM_TypeOfFileDriver(IntEnum):
	PCDM_TOFD_File = 0
	PCDM_TOFD_CmpFile = 1
	PCDM_TOFD_XmlFile = 2
	PCDM_TOFD_Unknown = 3
PCDM_TOFD_File = PCDM_TypeOfFileDriver.PCDM_TOFD_File
PCDM_TOFD_CmpFile = PCDM_TypeOfFileDriver.PCDM_TOFD_CmpFile
PCDM_TOFD_XmlFile = PCDM_TypeOfFileDriver.PCDM_TOFD_XmlFile
PCDM_TOFD_Unknown = PCDM_TypeOfFileDriver.PCDM_TOFD_Unknown


def Handle_PCDM_ReadWriter_Create():
    return _PCDM.Handle_PCDM_ReadWriter_Create()

def Handle_PCDM_ReadWriter_DownCast(t):
    return _PCDM.Handle_PCDM_ReadWriter_DownCast(t)

def Handle_PCDM_ReadWriter_IsNull(t):
    return _PCDM.Handle_PCDM_ReadWriter_IsNull(t)

def Handle_PCDM_Reader_Create():
    return _PCDM.Handle_PCDM_Reader_Create()

def Handle_PCDM_Reader_DownCast(t):
    return _PCDM.Handle_PCDM_Reader_DownCast(t)

def Handle_PCDM_Reader_IsNull(t):
    return _PCDM.Handle_PCDM_Reader_IsNull(t)

def Handle_PCDM_ReaderFilter_Create():
    return _PCDM.Handle_PCDM_ReaderFilter_Create()

def Handle_PCDM_ReaderFilter_DownCast(t):
    return _PCDM.Handle_PCDM_ReaderFilter_DownCast(t)

def Handle_PCDM_ReaderFilter_IsNull(t):
    return _PCDM.Handle_PCDM_ReaderFilter_IsNull(t)

def Handle_PCDM_ReferenceIterator_Create():
    return _PCDM.Handle_PCDM_ReferenceIterator_Create()

def Handle_PCDM_ReferenceIterator_DownCast(t):
    return _PCDM.Handle_PCDM_ReferenceIterator_DownCast(t)

def Handle_PCDM_ReferenceIterator_IsNull(t):
    return _PCDM.Handle_PCDM_ReferenceIterator_IsNull(t)

def Handle_PCDM_Writer_Create():
    return _PCDM.Handle_PCDM_Writer_Create()

def Handle_PCDM_Writer_DownCast(t):
    return _PCDM.Handle_PCDM_Writer_DownCast(t)

def Handle_PCDM_Writer_IsNull(t):
    return _PCDM.Handle_PCDM_Writer_IsNull(t)

def Handle_PCDM_ReadWriter_1_Create():
    return _PCDM.Handle_PCDM_ReadWriter_1_Create()

def Handle_PCDM_ReadWriter_1_DownCast(t):
    return _PCDM.Handle_PCDM_ReadWriter_1_DownCast(t)

def Handle_PCDM_ReadWriter_1_IsNull(t):
    return _PCDM.Handle_PCDM_ReadWriter_1_IsNull(t)

def Handle_PCDM_RetrievalDriver_Create():
    return _PCDM.Handle_PCDM_RetrievalDriver_Create()

def Handle_PCDM_RetrievalDriver_DownCast(t):
    return _PCDM.Handle_PCDM_RetrievalDriver_DownCast(t)

def Handle_PCDM_RetrievalDriver_IsNull(t):
    return _PCDM.Handle_PCDM_RetrievalDriver_IsNull(t)

def Handle_PCDM_StorageDriver_Create():
    return _PCDM.Handle_PCDM_StorageDriver_Create()

def Handle_PCDM_StorageDriver_DownCast(t):
    return _PCDM.Handle_PCDM_StorageDriver_DownCast(t)

def Handle_PCDM_StorageDriver_IsNull(t):
    return _PCDM.Handle_PCDM_StorageDriver_IsNull(t)
class PCDM_BaseDriverPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _PCDM.PCDM_BaseDriverPointer_swiginit(self, _PCDM.new_PCDM_BaseDriverPointer())
    __swig_destroy__ = _PCDM.delete_PCDM_BaseDriverPointer

# Register PCDM_BaseDriverPointer in _PCDM:
_PCDM.PCDM_BaseDriverPointer_swigregister(PCDM_BaseDriverPointer)
class PCDM_SequenceOfDocument(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _PCDM.PCDM_SequenceOfDocument_begin(self)

    def end(self):
        return _PCDM.PCDM_SequenceOfDocument_end(self)

    def cbegin(self):
        return _PCDM.PCDM_SequenceOfDocument_cbegin(self)

    def cend(self):
        return _PCDM.PCDM_SequenceOfDocument_cend(self)

    def __init__(self, *args):
        _PCDM.PCDM_SequenceOfDocument_swiginit(self, _PCDM.new_PCDM_SequenceOfDocument(*args))

    def Size(self):
        return _PCDM.PCDM_SequenceOfDocument_Size(self)

    def Length(self):
        return _PCDM.PCDM_SequenceOfDocument_Length(self)

    def Lower(self):
        return _PCDM.PCDM_SequenceOfDocument_Lower(self)

    def Upper(self):
        return _PCDM.PCDM_SequenceOfDocument_Upper(self)

    def IsEmpty(self):
        return _PCDM.PCDM_SequenceOfDocument_IsEmpty(self)

    def Reverse(self):
        return _PCDM.PCDM_SequenceOfDocument_Reverse(self)

    def Exchange(self, I, J):
        return _PCDM.PCDM_SequenceOfDocument_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _PCDM.PCDM_SequenceOfDocument_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _PCDM.PCDM_SequenceOfDocument_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _PCDM.PCDM_SequenceOfDocument_Assign(self, theOther)

    def Set(self, theOther):
        return _PCDM.PCDM_SequenceOfDocument_Set(self, theOther)

    def Remove(self, *args):
        return _PCDM.PCDM_SequenceOfDocument_Remove(self, *args)

    def Append(self, *args):
        return _PCDM.PCDM_SequenceOfDocument_Append(self, *args)

    def Prepend(self, *args):
        return _PCDM.PCDM_SequenceOfDocument_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _PCDM.PCDM_SequenceOfDocument_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _PCDM.PCDM_SequenceOfDocument_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _PCDM.PCDM_SequenceOfDocument_Split(self, theIndex, theSeq)

    def First(self):
        return _PCDM.PCDM_SequenceOfDocument_First(self)

    def ChangeFirst(self):
        return _PCDM.PCDM_SequenceOfDocument_ChangeFirst(self)

    def Last(self):
        return _PCDM.PCDM_SequenceOfDocument_Last(self)

    def ChangeLast(self):
        return _PCDM.PCDM_SequenceOfDocument_ChangeLast(self)

    def Value(self, theIndex):
        return _PCDM.PCDM_SequenceOfDocument_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _PCDM.PCDM_SequenceOfDocument_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _PCDM.PCDM_SequenceOfDocument___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _PCDM.PCDM_SequenceOfDocument_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _PCDM.delete_PCDM_SequenceOfDocument

    def __len__(self):
        return self.Size()


# Register PCDM_SequenceOfDocument in _PCDM:
_PCDM.PCDM_SequenceOfDocument_swigregister(PCDM_SequenceOfDocument)
class PCDM_SequenceOfReference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _PCDM.PCDM_SequenceOfReference_begin(self)

    def end(self):
        return _PCDM.PCDM_SequenceOfReference_end(self)

    def cbegin(self):
        return _PCDM.PCDM_SequenceOfReference_cbegin(self)

    def cend(self):
        return _PCDM.PCDM_SequenceOfReference_cend(self)

    def __init__(self, *args):
        _PCDM.PCDM_SequenceOfReference_swiginit(self, _PCDM.new_PCDM_SequenceOfReference(*args))

    def Size(self):
        return _PCDM.PCDM_SequenceOfReference_Size(self)

    def Length(self):
        return _PCDM.PCDM_SequenceOfReference_Length(self)

    def Lower(self):
        return _PCDM.PCDM_SequenceOfReference_Lower(self)

    def Upper(self):
        return _PCDM.PCDM_SequenceOfReference_Upper(self)

    def IsEmpty(self):
        return _PCDM.PCDM_SequenceOfReference_IsEmpty(self)

    def Reverse(self):
        return _PCDM.PCDM_SequenceOfReference_Reverse(self)

    def Exchange(self, I, J):
        return _PCDM.PCDM_SequenceOfReference_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _PCDM.PCDM_SequenceOfReference_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _PCDM.PCDM_SequenceOfReference_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _PCDM.PCDM_SequenceOfReference_Assign(self, theOther)

    def Set(self, theOther):
        return _PCDM.PCDM_SequenceOfReference_Set(self, theOther)

    def Remove(self, *args):
        return _PCDM.PCDM_SequenceOfReference_Remove(self, *args)

    def Append(self, *args):
        return _PCDM.PCDM_SequenceOfReference_Append(self, *args)

    def Prepend(self, *args):
        return _PCDM.PCDM_SequenceOfReference_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _PCDM.PCDM_SequenceOfReference_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _PCDM.PCDM_SequenceOfReference_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _PCDM.PCDM_SequenceOfReference_Split(self, theIndex, theSeq)

    def First(self):
        return _PCDM.PCDM_SequenceOfReference_First(self)

    def ChangeFirst(self):
        return _PCDM.PCDM_SequenceOfReference_ChangeFirst(self)

    def Last(self):
        return _PCDM.PCDM_SequenceOfReference_Last(self)

    def ChangeLast(self):
        return _PCDM.PCDM_SequenceOfReference_ChangeLast(self)

    def Value(self, theIndex):
        return _PCDM.PCDM_SequenceOfReference_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _PCDM.PCDM_SequenceOfReference_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _PCDM.PCDM_SequenceOfReference___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _PCDM.PCDM_SequenceOfReference_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _PCDM.delete_PCDM_SequenceOfReference

    def __len__(self):
        return self.Size()


# Register PCDM_SequenceOfReference in _PCDM:
_PCDM.PCDM_SequenceOfReference_swigregister(PCDM_SequenceOfReference)
class pcdm(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def FileDriverType(*args):
        r"""

        Parameters
        ----------
        aFileName: str
        aBaseDriver: Storage_BaseDriver

        Return
        -------
        PCDM_TypeOfFileDriver

        Description
        -----------
        No available documentation.

        """
        return _PCDM.pcdm_FileDriverType(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _PCDM.pcdm_swiginit(self, _PCDM.new_pcdm())
    __swig_destroy__ = _PCDM.delete_pcdm

# Register pcdm in _PCDM:
_PCDM.pcdm_swigregister(pcdm)
class PCDM_ReadWriter(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def FileFormat(*args):
        r"""

        Parameters
        ----------
        aFileName: str

        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        Tries to get a format in the file. returns an empty string if the file could not be read or does not have a fileformat information.

        """
        return _PCDM.PCDM_ReadWriter_FileFormat(*args)

    @staticmethod
    def Open(*args):
        r"""

        Parameters
        ----------
        aDriver: Storage_BaseDriver
        aFileName: str
        anOpenMode: Storage_OpenMode

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_Open(*args)

    def ReadDocumentVersion(self, *args):
        r"""

        Parameters
        ----------
        aFileName: str
        theMsgDriver: Message_Messenger

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_ReadDocumentVersion(self, *args)

    def ReadExtensions(self, *args):
        r"""

        Parameters
        ----------
        aFileName: str
        theExtensions: TColStd_SequenceOfExtendedString
        theMsgDriver: Message_Messenger

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_ReadExtensions(self, *args)

    def ReadReferenceCounter(self, *args):
        r"""

        Parameters
        ----------
        theFileName: str
        theMsgDriver: Message_Messenger

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_ReadReferenceCounter(self, *args)

    def ReadReferences(self, *args):
        r"""

        Parameters
        ----------
        aFileName: str
        theReferences: PCDM_SequenceOfReference
        theMsgDriver: Message_Messenger

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_ReadReferences(self, *args)

    @staticmethod
    def Reader(*args):
        r"""

        Parameters
        ----------
        aFileName: str

        Return
        -------
        opencascade::handle<PCDM_ReadWriter>

        Description
        -----------
        Returns the convenient reader for a file.

        """
        return _PCDM.PCDM_ReadWriter_Reader(*args)

    def Version(self, *args):
        r"""
        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns pcdm_readwriter_1.

        """
        return _PCDM.PCDM_ReadWriter_Version(self, *args)

    def WriteExtensions(self, *args):
        r"""

        Parameters
        ----------
        aData: Storage_Data
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_WriteExtensions(self, *args)

    @staticmethod
    def WriteFileFormat(*args):
        r"""

        Parameters
        ----------
        aData: Storage_Data
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_WriteFileFormat(*args)

    def WriteReferenceCounter(self, *args):
        r"""

        Parameters
        ----------
        aData: Storage_Data
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_WriteReferenceCounter(self, *args)

    def WriteReferences(self, *args):
        r"""

        Parameters
        ----------
        aData: Storage_Data
        aDocument: CDM_Document
        theReferencerFileName: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_WriteReferences(self, *args)

    def WriteVersion(self, *args):
        r"""

        Parameters
        ----------
        aData: Storage_Data
        aDocument: CDM_Document

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_WriteVersion(self, *args)

    @staticmethod
    def Writer(*args):
        r"""
        Return
        -------
        opencascade::handle<PCDM_ReadWriter>

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReadWriter_Writer(*args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_ReadWriter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_ReadWriter

# Register PCDM_ReadWriter in _PCDM:
_PCDM.PCDM_ReadWriter_swigregister(PCDM_ReadWriter)
class PCDM_Reader(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetStatus(self, *args):
        r"""
        Return
        -------
        PCDM_ReaderStatus

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_Reader_GetStatus(self, *args)

    def Read(self, *args):
        r"""

        Parameters
        ----------
        aFileName: str
        aNewDocument: CDM_Document
        anApplication: CDM_Application
        theFilter: PCDM_ReaderFilter (optional, default to opencascade::handle<PCDM_ReaderFilter>())
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Retrieves the content of the file into a new document.

        """
        return _PCDM.PCDM_Reader_Read(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_Reader_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_Reader

# Register PCDM_Reader in _PCDM:
_PCDM.PCDM_Reader_swigregister(PCDM_Reader)
class PCDM_ReaderFilter(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    AppendMode_Forbid = _PCDM.PCDM_ReaderFilter_AppendMode_Forbid
    AppendMode_Protect = _PCDM.PCDM_ReaderFilter_AppendMode_Protect
    AppendMode_Overwrite = _PCDM.PCDM_ReaderFilter_AppendMode_Overwrite


    class AppendMode(IntEnum):
    	AppendMode_Forbid = 0
    	AppendMode_Protect = 1
    	AppendMode_Overwrite = 2
    AppendMode_Forbid = AppendMode.AppendMode_Forbid
    AppendMode_Protect = AppendMode.AppendMode_Protect
    AppendMode_Overwrite = AppendMode.AppendMode_Overwrite


    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty filter, so, all will be retrieved if nothing else is defined.

        Parameters
        ----------
        theSkipped: Standard_Type

        Return
        -------
        None

        Description
        -----------
        Creates a filter to skip only one type of attributes.

        Parameters
        ----------
        theEntryToRead: str

        Return
        -------
        None

        Description
        -----------
        Creates a filter to read only sub-labels of a label-path. like, for '0:2' it will read all attributes for labels '0:2', '0:2:1', etc.

        Parameters
        ----------
        theAppend: AppendMode

        Return
        -------
        None

        Description
        -----------
        Creates a filter to append the content of file to open to existing document.

        """
        _PCDM.PCDM_ReaderFilter_swiginit(self, _PCDM.new_PCDM_ReaderFilter(*args))

    def AddPath(self, *args):
        r"""

        Parameters
        ----------
        theEntryToRead: str

        Return
        -------
        None

        Description
        -----------
        Adds sub-tree path (like '0:2').

        """
        return _PCDM.PCDM_ReaderFilter_AddPath(self, *args)

    def AddRead(self, *args):
        r"""

        Parameters
        ----------
        theRead: Standard_Type

        Return
        -------
        None

        Description
        -----------
        Adds attribute to read by type. disables the skipped attributes added.

        Parameters
        ----------
        theRead: str

        Return
        -------
        None

        Description
        -----------
        Adds attribute to read by type name. disables the skipped attributes added.

        """
        return _PCDM.PCDM_ReaderFilter_AddRead(self, *args)

    def AddSkipped(self, *args):
        r"""

        Parameters
        ----------
        theSkipped: Standard_Type

        Return
        -------
        None

        Description
        -----------
        Adds skipped attribute by type.

        Parameters
        ----------
        theSkipped: str

        Return
        -------
        None

        Description
        -----------
        Adds skipped attribute by type name.

        """
        return _PCDM.PCDM_ReaderFilter_AddSkipped(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Makes filter pass all data.

        """
        return _PCDM.PCDM_ReaderFilter_Clear(self, *args)

    def Down(self, *args):
        r"""

        Parameters
        ----------
        theTag: int

        Return
        -------
        None

        Description
        -----------
        Iteration to the child with defined tag.

        """
        return _PCDM.PCDM_ReaderFilter_Down(self, *args)

    def IsAppendMode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if appending to the document is performed.

        """
        return _PCDM.PCDM_ReaderFilter_IsAppendMode(self, *args)

    def IsPartTree(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if only part of the document tree will be retrieved.

        """
        return _PCDM.PCDM_ReaderFilter_IsPartTree(self, *args)

    def IsPassed(self, *args):
        r"""

        Parameters
        ----------
        theAttributeID: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns true if attribute must be read.

        Parameters
        ----------
        theEntry: str

        Return
        -------
        bool

        Description
        -----------
        Returns true if content of the label must be read.
        Return
        -------
        bool

        Description
        -----------
        Returns true if content of the currently iterated label must be read.

        """
        return _PCDM.PCDM_ReaderFilter_IsPassed(self, *args)

    def IsPassedAttr(self, *args):
        r"""

        Parameters
        ----------
        theAttributeType: str

        Return
        -------
        bool

        Description
        -----------
        Returns true if attribute must be read.

        """
        return _PCDM.PCDM_ReaderFilter_IsPassedAttr(self, *args)

    def IsSubPassed(self, *args):
        r"""

        Parameters
        ----------
        theEntry: str

        Return
        -------
        bool

        Description
        -----------
        Returns true if some sub-label of the given label is passed.
        Return
        -------
        bool

        Description
        -----------
        Returns true if some sub-label of the currently iterated label is passed.

        """
        return _PCDM.PCDM_ReaderFilter_IsSubPassed(self, *args)

    def Mode(self, *args):
        r"""
        Return
        -------
        PCDM_ReaderFilter::AppendMode

        Description
        -----------
        Returns the append mode.

        """
        return _PCDM.PCDM_ReaderFilter_Mode(self, *args)

    def StartIteration(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Starts the tree iterator. it is used for fast searching of passed labels if the whole tree of labels is parsed. so, on each iteration step the methods up and down must be called after the iteration start.

        """
        return _PCDM.PCDM_ReaderFilter_StartIteration(self, *args)

    def Up(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Iteration to the child label.

        """
        return _PCDM.PCDM_ReaderFilter_Up(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_ReaderFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_ReaderFilter

# Register PCDM_ReaderFilter in _PCDM:
_PCDM.PCDM_ReaderFilter_swigregister(PCDM_ReaderFilter)
class PCDM_Reference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        aReferenceIdentifier: int
        aFileName: str
        aDocumentVersion: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _PCDM.PCDM_Reference_swiginit(self, _PCDM.new_PCDM_Reference(*args))

    def DocumentVersion(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_Reference_DocumentVersion(self, *args)

    def FileName(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_Reference_FileName(self, *args)

    def ReferenceIdentifier(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_Reference_ReferenceIdentifier(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_Reference

# Register PCDM_Reference in _PCDM:
_PCDM.PCDM_Reference_swigregister(PCDM_Reference)
class PCDM_ReferenceIterator(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theMessageDriver: Message_Messenger

        Return
        -------
        None

        Description
        -----------
        Warning! the constructor does not initialization.

        """
        _PCDM.PCDM_ReferenceIterator_swiginit(self, _PCDM.new_PCDM_ReferenceIterator(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        aMetaData: CDM_MetaData

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReferenceIterator_Init(self, *args)

    def LoadReferences(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document
        aMetaData: CDM_MetaData
        anApplication: CDM_Application
        UseStorageConfiguration: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_ReferenceIterator_LoadReferences(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_ReferenceIterator_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_ReferenceIterator

# Register PCDM_ReferenceIterator in _PCDM:
_PCDM.PCDM_ReferenceIterator_swigregister(PCDM_ReferenceIterator)
class PCDM_Writer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Write(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document
        aFileName: str
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_Writer_Write(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_Writer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_Writer

# Register PCDM_Writer in _PCDM:
_PCDM.PCDM_Writer_swigregister(PCDM_Writer)
class PCDM_ReadWriter_1(PCDM_ReadWriter):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _PCDM.PCDM_ReadWriter_1_swiginit(self, _PCDM.new_PCDM_ReadWriter_1(*args))


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_ReadWriter_1_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_ReadWriter_1

# Register PCDM_ReadWriter_1 in _PCDM:
_PCDM.PCDM_ReadWriter_1_swigregister(PCDM_ReadWriter_1)
class PCDM_RetrievalDriver(PCDM_Reader):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def DocumentVersion(*args):
        r"""

        Parameters
        ----------
        theFileName: str
        theMsgDriver: Message_Messenger

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_RetrievalDriver_DocumentVersion(*args)

    def GetFormat(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_RetrievalDriver_GetFormat(self, *args)

    @staticmethod
    def ReferenceCounter(*args):
        r"""

        Parameters
        ----------
        theFileName: str
        theMsgDriver: Message_Messenger

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_RetrievalDriver_ReferenceCounter(*args)

    def SetFormat(self, *args):
        r"""

        Parameters
        ----------
        aformat: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_RetrievalDriver_SetFormat(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_RetrievalDriver_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _PCDM.delete_PCDM_RetrievalDriver

# Register PCDM_RetrievalDriver in _PCDM:
_PCDM.PCDM_RetrievalDriver_swigregister(PCDM_RetrievalDriver)
class PCDM_StorageDriver(PCDM_Writer):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def GetFormat(self, *args):
        r"""
        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_GetFormat(self, *args)

    def GetStoreStatus(self, *args):
        r"""
        Return
        -------
        PCDM_StoreStatus

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_GetStoreStatus(self, *args)

    def IsError(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_IsError(self, *args)

    def Make(self, *args):
        r"""

        Parameters
        ----------
        aDocument: CDM_Document

        Return
        -------
        opencascade::handle<PCDM_Document>

        Description
        -----------
        Raises notimplemented.

        Parameters
        ----------
        aDocument: CDM_Document
        Documents: PCDM_SequenceOfDocument

        Return
        -------
        None

        Description
        -----------
        By default, puts in the sequence the document returns by the previous make method.

        """
        return _PCDM.PCDM_StorageDriver_Make(self, *args)

    def SetFormat(self, *args):
        r"""

        Parameters
        ----------
        aformat: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_SetFormat(self, *args)

    def SetIsError(self, *args):
        r"""

        Parameters
        ----------
        theIsError: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_SetIsError(self, *args)

    def SetStoreStatus(self, *args):
        r"""

        Parameters
        ----------
        theStoreStatus: PCDM_StoreStatus

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _PCDM.PCDM_StorageDriver_SetStoreStatus(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_PCDM_StorageDriver_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _PCDM.PCDM_StorageDriver_swiginit(self, _PCDM.new_PCDM_StorageDriver())
    __swig_destroy__ = _PCDM.delete_PCDM_StorageDriver

# Register PCDM_StorageDriver in _PCDM:
_PCDM.PCDM_StorageDriver_swigregister(PCDM_StorageDriver)

@classnotwrapped
class PCDM_DOMHeaderParser:
	pass

@classnotwrapped
class PCDM_Document:
	pass





@deprecated
def pcdm_FileDriverType(*args):
	return pcdm.FileDriverType(*args)

@deprecated
def PCDM_ReadWriter_FileFormat(*args):
	return PCDM_ReadWriter.FileFormat(*args)

@deprecated
def PCDM_ReadWriter_Open(*args):
	return PCDM_ReadWriter.Open(*args)

@deprecated
def PCDM_ReadWriter_Reader(*args):
	return PCDM_ReadWriter.Reader(*args)

@deprecated
def PCDM_ReadWriter_WriteFileFormat(*args):
	return PCDM_ReadWriter.WriteFileFormat(*args)

@deprecated
def PCDM_ReadWriter_Writer(*args):
	return PCDM_ReadWriter.Writer(*args)

@deprecated
def PCDM_RetrievalDriver_DocumentVersion(*args):
	return PCDM_RetrievalDriver.DocumentVersion(*args)

@deprecated
def PCDM_RetrievalDriver_ReferenceCounter(*args):
	return PCDM_RetrievalDriver.ReferenceCounter(*args)



