/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;

public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    private final Node blockNode;
    private final RubySymbol operatorName;

    public OpElementAsgnNode(int line, Node receiverNode, RubySymbol operatorName, Node argsNode, Node valueNode, Node blockNode) {
        super(line, receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        this.valueNode = valueNode;
        this.operatorName = operatorName;
        this.blockNode = blockNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPELEMENTASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.operatorName.asJavaString();
    }

    public ByteList getOperatorByteName() {
        return this.operatorName.getBytes();
    }

    public RubySymbol getOperatorSymbolName() {
        return this.operatorName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isOr() {
        return CommonByteLists.OR_OR.equals(this.operatorName.getBytes());
    }

    public boolean isAnd() {
        return CommonByteLists.AMPERSAND_AMPERSAND.equals(this.operatorName.getBytes());
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public Node getBlockNode() {
        return this.blockNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

