/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.locks;

import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.MonitorCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.MonitorInfo;
import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadInfo;
import org.graalvm.visualvm.lib.jfluid.results.locks.ThreadLockCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.TopLockCCTNode;

public class LockRuntimeCCTNode
implements RuntimeCCTNode {
    private final Map<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>> threads;
    private final Map<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>> monitors;

    LockRuntimeCCTNode(Map<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>> threadsCopy, Map<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>> monitorCopy) {
        this.threads = threadsCopy;
        this.monitors = monitorCopy;
    }

    public LockCCTNode getThreads() {
        TopLockCCTNode top = new TopLockCCTNode();
        for (Map.Entry<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>> entry : this.threads.entrySet()) {
            top.addChild(new ThreadLockCCTNode(top, entry.getKey(), entry.getValue()));
        }
        return top;
    }

    public LockCCTNode getMonitors() {
        TopLockCCTNode top = new TopLockCCTNode();
        for (Map.Entry<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>> entry : this.monitors.entrySet()) {
            top.addChild(new MonitorCCTNode(top, entry.getKey(), entry.getValue()));
        }
        return top;
    }

    @Override
    public RuntimeCCTNode[] getChildren() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

