/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.lv;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centr\u0101l\u0101frikas laiks",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Maskavas ziemas laiks",
               "MST",
               "Maskavas vasaras laiks",
               "MST",
               "Maskavas laiks",
               "MT",
            };
        final String[] Japan = new String[] {
               "Jap\u0101nas ziemas laiks",
               "JST",
               "Jap\u0101nas vasaras laiks",
               "JDT",
               "Jap\u0101nas laiks",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakist\u0101nas ziemas laiks",
               "PST",
               "Pakist\u0101nas vasaras laiks",
               "PST",
               "Pakist\u0101nas laiks",
               "PT",
            };
        final String[] Hovd = new String[] {
               "Hovdas ziemas laiks",
               "HST",
               "Hovdas vasaras laiks",
               "HST",
               "Hovdas laiks",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magad\u0101nas ziemas laiks",
               "MST",
               "Magad\u0101nas vasaras laiks",
               "MST",
               "Magadanas laiks",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austr\u0101lijas centr\u0101lais rietumu ziemas laiks",
               "ACWST",
               "Austr\u0101lijas centr\u0101lais rietumu vasaras laiks",
               "ACWDT",
               "Austr\u0101lijas centr\u0101lais rietumu laiks",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Centr\u0101leiropas ziemas laiks",
               "CET",
               "Centr\u0101leiropas vasaras laiks",
               "CEST",
               "Centr\u0101leiropas laiks",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahal\u012bnas ziemas laiks",
               "SST",
               "Sahal\u012bnas vasaras laiks",
               "SST",
               "Sahal\u012bnas laiks",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Paragvajas ziemas laiks",
               "PST",
               "Paragvajas vasaras laiks",
               "PST",
               "Paragvajas laiks",
               "PT",
            };
        final String[] America_Eastern = new String[] {
               "Austrumu ziemas laiks",
               "EST",
               "Austrumu vasaras laiks",
               "EDT",
               "Austrumu laiks",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lorda Hava salas standarta laiks",
               "LHST",
               "Lorda Hava salas vasaras laiks",
               "LHDT",
               "Lorda Hava salas laiks",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Janz\u0113landes ziemas laiks",
               "NZST",
               "Jaunz\u0113lamdes vasaras laiks",
               "NZDT",
               "Jaunz\u0113landes laiks",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijas Oke\u0101na laiks",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskas ziemas laiks",
               "YST",
               "Jakutskas vasaras laiks",
               "YST",
               "Jakutskas laiks",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Maur\u012bcijas ziemas laiks",
               "MST",
               "Maur\u012bcijas vasaras laiks",
               "MST",
               "Maur\u012bcijas laiks",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austrum\u0101frikas laiks",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Austrumtimoras laiks",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Solomon = new String[] {
               "Z\u0101lamana salu laiks",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u0101r\u0161ala salu laiks",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Austrumeiropas ziemas laiks",
               "EET",
               "Austrumeiropas vasaras laiks",
               "EEST",
               "Austrumeiropas laiks",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0145\u016bfaundlendas standarta laiks",
               "NST",
               "\u0145\u016bfaundlendas vasaras laiks",
               "NDT",
               "\u0145\u016bfaundlendas laiks",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganist\u0101nas laiks",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongas ziemas laiks",
               "HKST",
               "Honkongas vasaras laiks",
               "HKST",
               "Honkongas laiks",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Rietumu Argent\u012bnas ziemas laiks",
               "WAST",
               "Rietumu Argent\u012bnas vasaras laiks",
               "WAST",
               "Rietumu Argent\u012bnas laiks",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantijas ziemas laiks",
               "AST",
               "Atlantijas vasaras laiks",
               "ADT",
               "Atlantijas laiks",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "Bol\u012bvijas laiks",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgas ziemas laiks",
               "YST",
               "Jekaterinburgas vasaras laiks",
               "YST",
               "Jekaterinburgas laiks",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Mald\u012bvijas laiks",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Tahiti = new String[] {
               "Taiti laiks",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Israel = new String[] {
               "Izra\u0113las ziemas laiks",
               "IST",
               "Izra\u0113las vasaras laiks",
               "IDT",
               "Izra\u0113las laiks",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indon\u0113zijas centr\u0101lais laiks",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Wallis = new String[] {
               "Volisas un Futunas laiks",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Dienvid\u0101frikas laiks",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Omsk = new String[] {
               "Omskas ziemas laiks",
               "OST",
               "Omskas vasaras laiks",
               "OST",
               "Omskas laiks",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161e\u013cu salu laiks",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Uruguay = new String[] {
               "Urugvajas ziemas laiks",
               "UST",
               "Urugvajas vasaras laiks",
               "UST",
               "Urugvajas laiks",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Nep\u0101las laiks",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatoras ziemas laiks",
               "UBST",
               "Ulanbatoras vasaras laiks",
               "UBST",
               "Ulanbatoras laiks",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Centr\u0101lais ziemas laiks",
               "CST",
               "Centr\u0101lais vasaras laiks",
               "CDT",
               "Centr\u0101lais laiks",
               "CT",
            };
        final String[] Falkland = new String[] {
               "Folklenda salu ziemas laiks",
               "FIST",
               "Folklenda salu vasaras laiks",
               "FIST",
               "Folklenda salu laiks",
               "FIT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu ziemas laiks",
               "VST",
               "Vanuatu vasaras laiks",
               "VST",
               "Vanuatu laiks",
               "VT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskas ziemas laiks",
               "NST",
               "Novosibirskas vasaras laiks",
               "NST",
               "Novosibirskas laiks",
               "NT",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bras ziemas laiks",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Azores = new String[] {
               "Azoru salu ziemas laiks",
               "AST",
               "Azoru salu vasaras laiks",
               "AST",
               "Azoru salu laiks",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "But\u0101nas laiks",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Surinamas laiks",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskas ziemas laiks",
               "KST",
               "Krasnojarskas vasaras laiks",
               "KST",
               "Krasnojarskas laiks",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Rietumkazahst\u0101nas laiks",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Christmas = new String[] {
               "Ziemsv\u0113tku Salas laiks",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazones ziemas laiks",
               "AST",
               "Amazones vasaras laiks",
               "AST",
               "Amazones laiks",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Austrumkazahst\u0101nas laiks",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei ziemas laiks",
               "FST",
               "Fid\u017ei vasaras laiks",
               "FST",
               "Fid\u017ei laiks",
               "FT",
            };
        final String[] Reunion = new String[] {
               "Reinjonas laiks",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Kokosa salu laiks",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Argentina = new String[] {
               "Argent\u012bnas ziemas laiks",
               "AST",
               "Argent\u012bnas vasaras laiks",
               "AST",
               "Argent\u012bnas laiks",
               "AT",
            };
        final String[] Galapagos = new String[] {
               "Galapagu laiks",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Makvorija salas laiks",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Venecu\u0113las laiks",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaju\u00a0\u2014 Aleutu ziemas laiks",
               "HAST",
               "Havaju\u00a0\u2014 Aleutu vasaras laiks",
               "HADT",
               "Havaju\u00a0\u2014 Aleutu laiks",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Austr\u0101lijas centr\u0101lais ziemas laiks",
               "ACST",
               "Austr\u0101lijas centr\u0101lais vasaras laiks",
               "ACDT",
               "Austr\u0101lijas centr\u0101lais laiks",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Klus\u0101 oke\u0101na ziemas laiks",
               "PST",
               "Klus\u0101 oke\u0101na vasaras laiks",
               "PDT",
               "Klus\u0101 oke\u0101na laiks",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "Rietumeiropas ziemas laiks",
               "WET",
               "Rietumeiropas vasaras laiks",
               "WEST",
               "Rietumeiropas laiks",
               "WET",
            };
        final String[] Norfolk = new String[] {
               "Norfolkas salu laiks",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Guyana = new String[] {
               "Gvij\u0101nas laiks",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Pitcairn = new String[] {
               "Pitk\u0113rnas laiks",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Samoa = new String[] {
               "Rietumsamoas ziemas laiks",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau laiks",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017e\u0101nas ziemas laiks",
               "AST",
               "Azerbaid\u017e\u0101nas vasaras laiks",
               "AST",
               "Azerbaid\u017e\u0101nas laiks",
               "AT",
            };
        final String[] Cuba = new String[] {
               "Kubas ziemas laiks",
               "CST",
               "Kubas vasaras laiks",
               "CDT",
               "Kubas laiks",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Rietum\u0101frikas ziemas laiks",
               "WAST",
               "Rietum\u0101frikas vasaras laiks",
               "WAST",
               "Rietum\u0101frikas laiks",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Grini\u010das laiks",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "Filip\u012bnu ziemas laiks",
               "PST",
               "Filip\u012bnu vasaras laiks",
               "PST",
               "Filip\u012bnu laiks",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francijas Dienidj\u016bru un Antarktikas teritorijas laiks",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "Dienvidd\u017eord\u017eijas laiks",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Jaunkaledonijas ziemas laiks",
               "NCST",
               "Jaunkaledonijas vasaras laiks",
               "NCST",
               "Jaunkaledonijas laiks",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Volgogradas ziemas laiks",
               "VST",
               "Volgogradas vasaras laiks",
               "VST",
               "Volgogradas laiks",
               "VT",
            };
        final String[] Iran = new String[] {
               "Ir\u0101nas ziemas laiks",
               "IST",
               "Ir\u0101nas vasaras laiks",
               "IDT",
               "Ir\u0101nas laiks",
               "IT",
            };
        final String[] Easter = new String[] {
               "Lieldienu salas ziemas laiks",
               "EIST",
               "Lieldienu salas vasaras laiks",
               "EIST",
               "Lieldienu salas laiks",
               "EIT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161as ziemas laiks",
               "BST",
               "Banglade\u0161as vasaras laiks",
               "BST",
               "Banglade\u0161as laiks",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peru ziemas laiks",
               "PST",
               "Peru vasaras laiks",
               "PST",
               "Peru laiks",
               "PT",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoras laiks",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indon\u0113zijas austrumu laiks",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Korejas ziemas laiks",
               "KST",
               "Korejas vasaras laiks",
               "KDT",
               "Korejas laiks",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Austr\u0101lijas rietumu ziemas laiks",
               "AWST",
               "Austr\u0101lijas rietumu vasaras laiks",
               "AWDT",
               "Rietumaustr\u0101lijas laiks",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indon\u0113zijas rietumu laiks",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Austr\u0101lijas austrumu ziemas laiks",
               "AEST",
               "Austr\u0101lijas austrumu vasaras laiks",
               "AEDT",
               "Austr\u0101lijas austrumu laiks",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Fran\u010du Gvi\u0101nas laiks",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijas ziemas laiks",
               "CST",
               "Kolumbijas vasaras laiks",
               "CST",
               "Kolumbijas laiks",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u010c\u012bles ziemas laiks",
               "CST",
               "\u010c\u012bles vasaras laiks",
               "CST",
               "\u010c\u012bles laiks",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "Kalnu ziemas laiks",
               "MST",
               "Kalnu vasaras laiks",
               "MDT",
               "Kalnu laiks",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Ar\u0101bu ziemas laiks",
               "AST",
               "Ar\u0101bu vasaras laiks",
               "ADT",
               "Ar\u0101bu laiks",
               "AT",
            };
        final String[] Alaska = new String[] {
               "A\u013caskas ziemas laiks",
               "AKST",
               "A\u013caskas vasaras laiks",
               "AKDT",
               "A\u013caskas laiks",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokas ziemas laiks",
               "VST",
               "Vladivostokas vasaras laiks",
               "VST",
               "Vladivostokas laiks",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskas ziemas laiks",
               "IST",
               "Irkutskas vasaras laiks",
               "IST",
               "Irkutskas laiks",
               "IT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laiks",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Jaungvinejas laiks",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Noronha = new String[] {
               "Fernandu di Noro\u0146as ziemas laiks",
               "FNST",
               "Fernandu di Noro\u0146as vasaras laiks",
               "FNST",
               "Fernandu di Noro\u0146as laiks",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010coibalsanas ziemas laiks",
               "CST",
               "\u010coibalsanas vasaras laiks",
               "CST",
               "\u010coibalsanas laiks",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Braz\u012blijas ziemas laiks",
               "BST",
               "Braz\u012blijas vasaras laiks",
               "BST",
               "Braz\u012blijas laiks",
               "BT",
            };
        final String[] China = new String[] {
               "\u0136\u012bnas ziemas laiks",
               "CST",
               "\u0136\u012bnas vasaras laiks",
               "CDT",
               "\u0136\u012bnas laiks",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Arm\u0113nijas ziemas laiks",
               "AST",
               "Arm\u0113nijas vasaras laiks",
               "AST",
               "Arm\u0113nijas laiks",
               "AT",
            };
        final String[] India = new String[] {
               "Indijas ziemas laiks",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Kuka salu ziemas laiks",
               "CIST",
               "Kuka salu vasaras laiks",
               "CIHST",
               "Kuka salu laiks",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Samoa },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
