complete -c oct -n "__fish_use_subcommand" -l output-format -d 'Produce output in the chosen format' -r -f -a "{json	'',text	'',yaml	''}"
complete -c oct -n "__fish_use_subcommand" -l output-version -d 'Pick output version to use, for non-textual formats' -r
complete -c oct -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c oct -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c oct -n "__fish_use_subcommand" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_use_subcommand" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_use_subcommand" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_use_subcommand" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_use_subcommand" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_use_subcommand" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_use_subcommand" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_use_subcommand" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_use_subcommand" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_use_subcommand" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_use_subcommand" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from list" -s i -l idents-only -d 'Only show card idents'
complete -c oct -n "__fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from status" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from status" -s v -l verbose -d 'Use verbose output'
complete -c oct -n "__fish_seen_subcommand_from status" -s K -l public-key-material -d 'Print public key material for each key slot'
complete -c oct -n "__fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from info" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from ssh" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from ssh" -l key-only -d 'Only print the ssh public key'
complete -c oct -n "__fish_seen_subcommand_from ssh" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from name" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from url" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from signing-pin-validity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from import" -s s -l sig-fp -d 'Optionally, select the subkey to import in the SIG slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from import" -s d -l dec-fp -d 'Optionally, select the subkey to import in the DEC slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from import" -s a -l aut-fp -d 'Optionally, select the subkey to import in the AUT slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from import" -l key-passphrase -d 'Optionally, provide a passphrase for encrypted secret key material in a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -s o -l output -d 'Output file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -l no-dec -d 'Do not create a key in the DEC slot'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -l no-aut -d 'Do not create a key in the AUT slot'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from touch" -s k -l key -d 'Key slot to set the touch policy for' -r -f -a "{SIG	'',DEC	'',AUT	'',ATT	''}"
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from touch" -s p -l policy -d 'Touch policy to set on this key slot' -r -f -a "{Off	'',On	'',Fixed	'',Cached	'',Cached-Fixed	''}"
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from touch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from admin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-user" -s p -l user-pin-old -d 'Optionally, get old User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-user" -s q -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-admin" -s P -l admin-pin-old -d 'Optionally, get old Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-admin" -s Q -l admin-pin-new -d 'Optionally, get new Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-admin" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user-rc" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user-rc" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from reset-user-rc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-reset" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-reset" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from set-reset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from detached" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from detached" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from cleartext" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from cleartext" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from inline" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from inline" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from cert" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from generate" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from generate" -s k -l key -d 'Key slot to use' -r -f -a "{SIG	'',DEC	'',AUT	''}"
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from statement" -s c -l card -d 'Identifier of the card to reset' -r
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from statement" -s k -l key -d 'Key slot to use' -r -f -a "{SIG	'',DEC	'',AUT	''}"
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from statement" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from factory-reset" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from factory-reset" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from set-identity" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from set-identity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from activate-file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_seen_subcommand_from system; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from output-versions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from ssh; and not __fish_seen_subcommand_from pubkey; and not __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from output-versions; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from signing-pin-validity; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from touch" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user; and not __fish_seen_subcommand_from set-admin; and not __fish_seen_subcommand_from reset-user; and not __fish_seen_subcommand_from reset-user-rc; and not __fish_seen_subcommand_from set-reset" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached; and not __fish_seen_subcommand_from cleartext; and not __fish_seen_subcommand_from inline" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from statement" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset; and not __fish_seen_subcommand_from set-identity; and not __fish_seen_subcommand_from activate-file" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
