"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statsCommands = exports.regexForSuggestion = exports.regexForIndex = exports.pipeCommands = exports.numberTypes = exports.firstCommand = exports.STRING_FIELD_AFTER_PARSE = exports.RARE_TOP_FIELD_LOOP = exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = exports.PLUS_MINUS_FIELD_AFTER_SORT = exports.PLUS_MINUS_FIELD_AFTER_FIELDS = exports.PIPE_MATH_AFTER_EXPRESSIONS = exports.PIPE_COMMA_AFTER_INDEX = exports.PIPE_AFTER_WHERE = exports.PIPE_AFTER_STATS_GROUP_BY = exports.PIPE_AFTER_SPAN = exports.PIPE_AFTER_PARSE = exports.PIPE_AFTER_MATCH = exports.PIPE_AFTER_KEEP_EMPTY = exports.PIPE_AFTER_HEAD = exports.PIPE_AFTER_GROUP_BY = exports.PIPE_AFTER_CONSECUTIVE = exports.NUM_FIELD_AFTER_AGGREGATION = exports.MORE_INDEX_AFTER_COMMA = exports.MATH_AFTER_FIELD = exports.MATCH_FIELD_AFTER_WHERE = exports.INDEX_AFTER_EQUAL = exports.FIELD_SPAN_AFTER_GROUP_BY = exports.FIELD_IN_FIELD_LOOP = exports.FIELD_IN_FIELDS_LOOP = exports.FIELD_AFTER_SPAN = exports.FIELD_AFTER_PLUS_MINUS_SORT = exports.FIELD_AFTER_PLUS_MINUS = exports.FIELD_AFTER_EVAL_EQUAL = exports.FIELD_AFTER_COMMAND = exports.FIELD_AFTER_COMMA = exports.FIELD_AFTER_BY = exports.EQUAL_AFTER_WHERE_FIELD = exports.EQUAL_AFTER_SOURCE = exports.EQUAL_AFTER_EVAL_FIELD = exports.EMPTY_REGEX = exports.DATA_AFTER_WHERE_EQUAL = exports.DATA_AFTER_COMMA = exports.COMMA_PIPE_BY_AFTER_FIELD = exports.COMMA_PIPE_BY_AFTER_AGGREGATION = exports.COMMA_PIPE_AFTER_SORT_FIELD = exports.COMMA_PIPE_AFTER_RENAME_FIELD = exports.COMMA_PIPE_AFTER_FIELDS = exports.COMMA_PIPE_AFTER_FIELD = exports.COMMA_AFTER_FIELD = exports.CLOSE_AFTER_SPAN = exports.CLOSE_AFTER_FIELD = exports.CLOSE_AFTER_DATA = exports.AS_AFTER_FIELD = exports.AGGREGATION_FOR_STATS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
/* eslint-disable prettier/prettier */

const firstCommand = exports.firstCommand = [{
  label: 'source'
}];
const pipeCommands = exports.pipeCommands = [{
  label: 'dedup'
}, {
  label: 'eval'
}, {
  label: 'fields'
}, {
  label: 'head'
}, {
  label: 'parse'
}, {
  label: 'rare'
}, {
  label: 'rename'
}, {
  label: 'sort'
}, {
  label: 'stats'
}, {
  label: 'top'
}, {
  label: 'where'
}];
const statsCommands = exports.statsCommands = [{
  label: 'count()'
}, {
  label: 'sum('
}, {
  label: 'avg('
}, {
  label: 'max('
}, {
  label: 'min('
}, {
  label: 'var_samp('
}, {
  label: 'var_pop('
}, {
  label: 'stddev_samp('
}, {
  label: 'stddev_pop('
}];
const numberTypes = exports.numberTypes = ['long', 'integer', 'short', 'byte', 'double', 'float', 'half_float', 'scaled_float', 'unsigned_long'];
const JUST_SEARCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*/;
const SEARCH_WHERE_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+\S+\s*=\s*\S+/;
const SEARCH_MATCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+match\(\S+,\s*\S+\)/;
const EMPTY_REGEX = exports.EMPTY_REGEX = /^\s*\S*$/;
const FIELD_AFTER_COMMAND = exports.FIELD_AFTER_COMMAND = /^\s*(dedup|eval|rare|top|rename|where\s+match\()\s+\S*$/;

// Regex for where command
const MATCH_FIELD_AFTER_WHERE = exports.MATCH_FIELD_AFTER_WHERE = /^\s*where\s+\S*$/;
const EQUAL_AFTER_WHERE_FIELD = exports.EQUAL_AFTER_WHERE_FIELD = /^\s*where\s+(\S+)\s+$/;
const DATA_AFTER_WHERE_EQUAL = exports.DATA_AFTER_WHERE_EQUAL = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
const PIPE_AFTER_WHERE = exports.PIPE_AFTER_WHERE = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const COMMA_AFTER_FIELD = exports.COMMA_AFTER_FIELD = /^\s*where\s+match\(\s*([^\s,]+)\s*$/;
const DATA_AFTER_COMMA = exports.DATA_AFTER_COMMA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
const CLOSE_AFTER_DATA = exports.CLOSE_AFTER_DATA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const PIPE_AFTER_MATCH = exports.PIPE_AFTER_MATCH = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s*\)\s*$/;

// Regex for dedup command
const FIELD_IN_FIELD_LOOP = exports.FIELD_IN_FIELD_LOOP = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*,\s*([^\s,]*)$/;
const COMMA_PIPE_AFTER_FIELD = exports.COMMA_PIPE_AFTER_FIELD = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s+$/;
const PIPE_AFTER_KEEP_EMPTY = exports.PIPE_AFTER_KEEP_EMPTY = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*keepempty=true\s+$/;
const PIPE_AFTER_CONSECUTIVE = exports.PIPE_AFTER_CONSECUTIVE = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*consecutive=true\s+$/;

// Regex for eval command
const EQUAL_AFTER_EVAL_FIELD = exports.EQUAL_AFTER_EVAL_FIELD = /^\s*eval\s+(\S+)\s+$/;
const FIELD_AFTER_EVAL_EQUAL = exports.FIELD_AFTER_EVAL_EQUAL = /^\s*eval\s+\S+\s*=\s*\S*$/;
const MATH_AFTER_FIELD = exports.MATH_AFTER_FIELD = /^\s*eval\s+\S+\s*=\s*\S+\s+$/;
const PIPE_MATH_AFTER_EXPRESSIONS = exports.PIPE_MATH_AFTER_EXPRESSIONS = /^\s*eval\s+(\S+\s*=\s*\S+(\s*(\+|\-|\*|\/)\s*\S+)+)+\s+$/;

// Regex for fields command
const PLUS_MINUS_FIELD_AFTER_FIELDS = exports.PLUS_MINUS_FIELD_AFTER_FIELDS = /^\s*fields\s+\S*$/;
const FIELD_AFTER_PLUS_MINUS = exports.FIELD_AFTER_PLUS_MINUS = /^\s*fields\s+(\+|\-)\s*\S*$/;
const COMMA_PIPE_AFTER_FIELDS = exports.COMMA_PIPE_AFTER_FIELDS = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*\s+$/;
const FIELD_IN_FIELDS_LOOP = exports.FIELD_IN_FIELDS_LOOP = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*,\s*\S*$/;

// Regex for rare/top command
const COMMA_PIPE_BY_AFTER_FIELD = exports.COMMA_PIPE_BY_AFTER_FIELD = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+\S*$/;
const RARE_TOP_FIELD_LOOP = exports.RARE_TOP_FIELD_LOOP = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*,\s*\S*$/;
const FIELD_AFTER_BY = exports.FIELD_AFTER_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S*$/;
const PIPE_AFTER_GROUP_BY = exports.PIPE_AFTER_GROUP_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S+\s+$/;

// Regex for rename command
const AS_AFTER_FIELD = exports.AS_AFTER_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)*\s*(,\s*)?\S+\s+\S*$/;
const COMMA_PIPE_AFTER_RENAME_FIELD = exports.COMMA_PIPE_AFTER_RENAME_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+$/;
const FIELD_AFTER_COMMA = exports.FIELD_AFTER_COMMA = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+\s*,\s+\S*$/;

// Regex for head command
const PIPE_AFTER_HEAD = exports.PIPE_AFTER_HEAD = /^\s*head\s+\d+\s+/;

// Regex for sort command
const PLUS_MINUS_FIELD_AFTER_SORT = exports.PLUS_MINUS_FIELD_AFTER_SORT = /^\s*sort(\s+\d+)?\s+\S*$/;
const FIELD_AFTER_PLUS_MINUS_SORT = exports.FIELD_AFTER_PLUS_MINUS_SORT = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+(\+|\-)\s*\S*$/;
const COMMA_PIPE_AFTER_SORT_FIELD = exports.COMMA_PIPE_AFTER_SORT_FIELD = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+\S+\s+$/;
const PLUS_MINUS_FIELD_IN_FIELDS_LOOP = exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*,\s+\S*$/;

// Regex for stats command
const FIELD_SPAN_AFTER_GROUP_BY = exports.FIELD_SPAN_AFTER_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S*$/;
const NUM_FIELD_AFTER_AGGREGATION = exports.NUM_FIELD_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S*$/;
const FIELD_AFTER_SPAN = exports.FIELD_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*([^\s,]*)\s*$/;
const CLOSE_AFTER_SPAN = exports.CLOSE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const PIPE_AFTER_SPAN = exports.PIPE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')*")|(\d*\.?\d*)|\w*)\s*\)\s*$/;
const CLOSE_AFTER_FIELD = exports.CLOSE_AFTER_FIELD = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s+$/;
const COMMA_PIPE_BY_AFTER_AGGREGATION = exports.COMMA_PIPE_BY_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+\S*$/;
const PIPE_AFTER_STATS_GROUP_BY = exports.PIPE_AFTER_STATS_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S+\s+$/;
const AGGREGATION_FOR_STATS = exports.AGGREGATION_FOR_STATS = /^\s*stats\s+(((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+,\s*)?\S*$/;

// Regex for parse command
const STRING_FIELD_AFTER_PARSE = exports.STRING_FIELD_AFTER_PARSE = /^\s*parse\s+\S*$/;
const PIPE_AFTER_PARSE = exports.PIPE_AFTER_PARSE = /^\s*parse\s+\S+\s+$/;

// Regex for source command
const EQUAL_AFTER_SOURCE = exports.EQUAL_AFTER_SOURCE = /^\s*source\s+$/;
const INDEX_AFTER_EQUAL = exports.INDEX_AFTER_EQUAL = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]*$/;
const PIPE_COMMA_AFTER_INDEX = exports.PIPE_COMMA_AFTER_INDEX = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*\s+$/;
const MORE_INDEX_AFTER_COMMA = exports.MORE_INDEX_AFTER_COMMA = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*,\s*[^\\\/\?\"\<\>\|\s\,\#]*\s*$/;
const regexForSuggestion = exports.regexForSuggestion = [EMPTY_REGEX, FIELD_AFTER_COMMAND, MATCH_FIELD_AFTER_WHERE, EQUAL_AFTER_WHERE_FIELD, DATA_AFTER_WHERE_EQUAL, PIPE_AFTER_WHERE, COMMA_AFTER_FIELD, DATA_AFTER_COMMA, CLOSE_AFTER_DATA, PIPE_AFTER_MATCH, FIELD_IN_FIELD_LOOP, COMMA_PIPE_AFTER_FIELD, PIPE_AFTER_KEEP_EMPTY, PIPE_AFTER_CONSECUTIVE, EQUAL_AFTER_EVAL_FIELD, FIELD_AFTER_EVAL_EQUAL, MATH_AFTER_FIELD, PIPE_MATH_AFTER_EXPRESSIONS, PLUS_MINUS_FIELD_AFTER_FIELDS, FIELD_AFTER_PLUS_MINUS, COMMA_PIPE_AFTER_FIELDS, FIELD_IN_FIELDS_LOOP, COMMA_PIPE_BY_AFTER_FIELD, RARE_TOP_FIELD_LOOP, FIELD_AFTER_BY, PIPE_AFTER_GROUP_BY, COMMA_PIPE_AFTER_RENAME_FIELD, FIELD_AFTER_COMMA, AS_AFTER_FIELD, PIPE_AFTER_HEAD, PLUS_MINUS_FIELD_AFTER_SORT, FIELD_AFTER_PLUS_MINUS_SORT, PLUS_MINUS_FIELD_IN_FIELDS_LOOP, COMMA_PIPE_AFTER_SORT_FIELD, FIELD_SPAN_AFTER_GROUP_BY, NUM_FIELD_AFTER_AGGREGATION, FIELD_AFTER_SPAN, CLOSE_AFTER_SPAN, PIPE_AFTER_SPAN, CLOSE_AFTER_FIELD, COMMA_PIPE_BY_AFTER_AGGREGATION, PIPE_AFTER_STATS_GROUP_BY, AGGREGATION_FOR_STATS, STRING_FIELD_AFTER_PARSE, PIPE_AFTER_PARSE, EQUAL_AFTER_SOURCE, INDEX_AFTER_EQUAL, PIPE_COMMA_AFTER_INDEX, MORE_INDEX_AFTER_COMMA];
const regexForIndex = exports.regexForIndex = [JUST_SEARCH_REGEX, SEARCH_WHERE_REGEX, SEARCH_MATCH_REGEX];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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