"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDslRoute({
  router
}) {
  router.post({
    path: `${_shared.DSL_BASE}${_shared.DSL_SEARCH}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      body: rest
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_CAT}`,
    validate: {
      query: _configSchema.schema.object({
        format: _configSchema.schema.string(),
        index: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', request.query);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_MAPPING}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getMapping', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_SETTINGS}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getSettings', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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