from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.gp import *
from OCC.Core.TopAbs import *
from OCC.Core.IntCurveSurface import *
from OCC.Core.Bnd import *
from OCC.Core.TopTools import *
from OCC.Core.IntCurvesFace import *
from OCC.Core.BRepAdaptor import *

# the following typedef cannot be wrapped as is
BRepClass3d_BndBoxTree = NewType("BRepClass3d_BndBoxTree", Any)

class brepclass3d:
    @staticmethod
    def OuterShell(S: TopoDS_Solid) -> TopoDS_Shell: ...

class BRepClass3d_Intersector3d:
    def __init__(self) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def HasAPoint(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def Perform(self, L: gp_Lin, Prm: float, Tol: float, F: TopoDS_Face) -> None: ...
    def Pnt(self) -> gp_Pnt: ...
    def State(self) -> TopAbs_State: ...
    def Transition(self) -> IntCurveSurface_TransitionOnCurve: ...
    def UParameter(self) -> float: ...
    def VParameter(self) -> float: ...
    def WParameter(self) -> float: ...

class BRepClass3d_SClassifier:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: BRepClass3d_SolidExplorer, P: gp_Pnt, Tol: float) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def IsOnAFace(self) -> bool: ...
    def Perform(self, S: BRepClass3d_SolidExplorer, P: gp_Pnt, Tol: float) -> None: ...
    def PerformInfinitePoint(self, S: BRepClass3d_SolidExplorer, Tol: float) -> None: ...
    def Rejected(self) -> bool: ...
    def State(self) -> TopAbs_State: ...

class BRepClass3d_SolidExplorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    def Box(self) -> Bnd_Box: ...
    def CurrentFace(self) -> TopoDS_Face: ...
    def CurrentShell(self) -> TopoDS_Shell: ...
    def Destroy(self) -> None: ...
    def DumpSegment(self, P: gp_Pnt, L: gp_Lin, Par: float, S: TopAbs_State) -> None: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face, P: gp_Pnt) -> Tuple[bool, float]: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face, P: gp_Pnt) -> Tuple[bool, float, float, float]: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face, P: gp_Pnt, theVecD1U: gp_Vec, theVecD1V: gp_Vec) -> Tuple[bool, float, float, float]: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face, P: gp_Pnt) -> Tuple[bool, float, float]: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face, P: gp_Pnt) -> bool: ...
    @overload
    @staticmethod
    def FindAPointInTheFace(F: TopoDS_Face) -> Tuple[bool, float, float]: ...
    def GetFaceSegmentIndex(self) -> int: ...
    def GetMapEV(self) -> TopTools_IndexedMapOfShape: ...
    def GetShape(self) -> TopoDS_Shape: ...
    def GetTree(self) -> BRepClass3d_BndBoxTree: ...
    def InitFace(self) -> None: ...
    def InitShape(self, S: TopoDS_Shape) -> None: ...
    def InitShell(self) -> None: ...
    def Intersector(self, F: TopoDS_Face) -> IntCurvesFace_Intersector: ...
    def MoreFace(self) -> bool: ...
    def MoreShell(self) -> bool: ...
    def NextFace(self) -> None: ...
    def NextShell(self) -> None: ...
    def OtherSegment(self, P: gp_Pnt, L: gp_Lin) -> Tuple[int, float]: ...
    @overload
    def PointInTheFace(self, F: TopoDS_Face, P: gp_Pnt) -> Tuple[bool, float, float, float, int]: ...
    @overload
    def PointInTheFace(self, F: TopoDS_Face, P: gp_Pnt, surf: BRepAdaptor_Surface, u1: float, v1: float, u2: float, v2: float) -> Tuple[bool, float, float, float, int]: ...
    @overload
    def PointInTheFace(self, F: TopoDS_Face, P: gp_Pnt, surf: BRepAdaptor_Surface, u1: float, v1: float, u2: float, v2: float, theVecD1U: gp_Vec, theVecD1V: gp_Vec) -> Tuple[bool, float, float, float, int]: ...
    def Reject(self, P: gp_Pnt) -> bool: ...
    def RejectFace(self, L: gp_Lin) -> bool: ...
    def RejectShell(self, L: gp_Lin) -> bool: ...
    def Segment(self, P: gp_Pnt, L: gp_Lin) -> Tuple[int, float]: ...

class BRepClass3d_SolidPassiveClassifier:
    def __init__(self) -> None: ...
    def Compare(self, F: TopoDS_Face, Or: TopAbs_Orientation) -> None: ...
    def HasIntersection(self) -> bool: ...
    def Intersector(self) -> BRepClass3d_Intersector3d: ...
    def Parameter(self) -> float: ...
    def Reset(self, L: gp_Lin, P: float, Tol: float) -> None: ...
    def State(self) -> TopAbs_State: ...

class BRepClass3d_SolidClassifier(BRepClass3d_SClassifier):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, P: gp_Pnt, Tol: float) -> None: ...
    def Destroy(self) -> None: ...
    def Load(self, S: TopoDS_Shape) -> None: ...
    def Perform(self, P: gp_Pnt, Tol: float) -> None: ...
    def PerformInfinitePoint(self, Tol: float) -> None: ...

#classnotwrapped
class BRepClass3d_BndBoxTreeSelectorLine: ...

#classnotwrapped
class BRepClass3d_BndBoxTreeSelectorPoint: ...

# harray1 classes
# harray2 classes
# hsequence classes

