# Node.js

Trivy supports four types of Node.js package managers: `npm`, `Yarn`, `pnpm` and `Bun`[^1].

The following scanners are supported.

| Artifact | SBOM | Vulnerability | License |
|----------|:----:|:-------------:|:-------:|
| npm      |  ✓   |       ✓       |    ✓    |
| Yarn     |  ✓   |       ✓       |    ✓    |
| pnpm     |  ✓   |       ✓       |    -    |
| Bun      |  ✓   |       ✓       |    ✓    |

The following table provides an outline of the features Trivy offers.

| Package manager | File              | Transitive dependencies | Dev dependencies  | [Dependency graph][dependency-graph] | Position |
|:---------------:|-------------------|:-----------------------:|:-----------------:|:------------------------------------:|:--------:|
|       npm       | package-lock.json |            ✓            | [Excluded](#npm)  |                  ✓                   |    ✓     |
|      Yarn       | yarn.lock         |            ✓            | [Excluded](#yarn) |                  ✓                   |    ✓     |
|      pnpm       | pnpm-lock.yaml    |            ✓            |     Excluded      |                  ✓                   |    -     |
|       Bun       | yarn.lock         |            ✓            | [Excluded](#yarn) |                  ✓                   |    ✓     |

In addition, Trivy scans installed packages with `package.json`.

| File         | Dependency graph | Position | License |
|--------------|:----------------:|:--------:|:-------:|
| package.json |        -         |    -     |    ✅    |

These may be enabled or disabled depending on the target.
See [here](./index.md) for the detail.

## Package managers
Trivy parses your files generated by package managers in filesystem/repository scanning.

!!! tip
    Please make sure your lock file is up-to-date after modifying `package.json`.

### npm
Trivy parses `package-lock.json`.
To identify licenses, you need to download dependencies to `node_modules` beforehand.
Trivy analyzes `node_modules` for licenses.

By default, Trivy doesn't report development dependencies. Use the `--include-dev-deps` flag to include them.

### Yarn
Trivy parses `yarn.lock`, which doesn't contain information about development dependencies.
Trivy also uses `package.json` file to handle [aliases](https://classic.yarnpkg.com/lang/en/docs/cli/add/#toc-yarn-add-alias).

To exclude devDependencies and allow aliases, `package.json` also needs to be present next to `yarn.lock`.

Trivy analyzes `.yarn` (Yarn 2+) or `node_modules` (Yarn Classic) folder next to the yarn.lock file to detect licenses.

By default, Trivy doesn't report development dependencies. Use the `--include-dev-deps` flag to include them.

### pnpm
Trivy parses `pnpm-lock.yaml`, then finds production dependencies and builds a [tree][dependency-graph] of dependencies with vulnerabilities.

!!! note
    Trivy currently only supports Lockfile [v6][pnpm-lockfile-v6] or earlier.

### Bun
Trivy supports scanning `yarn.lock` files generated by [Bun](https://bun.sh/docs/install/lockfile#how-do-i-inspect-bun-s-lockfile). You can use the command `bun install -y` to generate a Yarn-compatible `yarn.lock`.

!!! note
    `bun.lockb` is not supported.

## Packages
Trivy parses the manifest files of installed packages in container image scanning and so on.

### package.json
Trivy searches for `package.json` files under `node_modules` and identifies installed packages.
It only extracts package names, versions and licenses for those packages.

[dependency-graph]: ../../configuration/reporting.md#show-origins-of-vulnerable-dependencies
[pnpm-lockfile-v6]: https://github.com/pnpm/spec/blob/fd3238639af86c09b7032cc942bab3438b497036/lockfile/6.0.md

[^1]: [yarn.lock](#bun) must be generated
