/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.GetWorkflowRequest;
import org.opensearch.commons.alerting.action.GetWorkflowResponse;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\n \u0018*\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/transport/TransportGetWorkflowAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/commons/alerting/action/GetWorkflowRequest;", "Lorg/opensearch/commons/alerting/action/GetWorkflowResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getWorkflowRequest", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
public final class TransportGetWorkflowAction
extends HandledTransportAction<GetWorkflowRequest, GetWorkflowResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final ClusterService clusterService;
    private final Logger log;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetWorkflowAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/alerting/workflow/get", transportService, actionFilters, GetWorkflowRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.log = LogManager.getLogger(this.getClass());
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetWorkflowRequest getWorkflowRequest, @NotNull ActionListener<GetWorkflowResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)getWorkflowRequest, (String)"getWorkflowRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        User user = this.readUserFromThreadContext(this.client);
        GetRequest getRequest = new GetRequest(".opendistro-alerting-config", getWorkflowRequest.getWorkflowId());
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this, getWorkflowRequest, actionListener, user){
                final /* synthetic */ TransportGetWorkflowAction this$0;
                final /* synthetic */ GetWorkflowRequest $getWorkflowRequest;
                final /* synthetic */ ActionListener<GetWorkflowResponse> $actionListener;
                final /* synthetic */ User $user;
                {
                    this.this$0 = $receiver;
                    this.$getWorkflowRequest = $getWorkflowRequest;
                    this.$actionListener = $actionListener;
                    this.$user = $user;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        TransportGetWorkflowAction.access$getLog$p(this.this$0).error("Workflow with " + this.$getWorkflowRequest.getWorkflowId() + " not found");
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Workflow not found.", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    ScheduledJob workflow = null;
                    if (!response2.isSourceEmpty()) {
                        Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        TransportGetWorkflowAction transportGetWorkflowAction = this.this$0;
                        ActionListener<GetWorkflowResponse> actionListener = this.$actionListener;
                        User user = this.$user;
                        GetWorkflowRequest getWorkflowRequest = this.$getWorkflowRequest;
                        Throwable throwable = null;
                        try {
                            XContentParser xcp = (XContentParser)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                            String string = response2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                            ScheduledJob compositeMonitor = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                            if (!(compositeMonitor instanceof Workflow)) {
                                TransportGetWorkflowAction.access$getLog$p(transportGetWorkflowAction).error("Wrong monitor type returned");
                                actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Workflow not found.", RestStatus.NOT_FOUND, new Object[0])));
                                return;
                            }
                            workflow = compositeMonitor;
                            if (!transportGetWorkflowAction.checkUserPermissionsWithResource(user, ((Workflow)workflow).getUser(), actionListener, "workflow", getWorkflowRequest.getWorkflowId())) {
                                return;
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    this.$actionListener.onResponse((Object)new GetWorkflowResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, (Workflow)workflow));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    TransportGetWorkflowAction.access$getLog$p(this.this$0).error("Getting the workflow failed", (Throwable)t);
                    if (t instanceof IndexNotFoundException) {
                        this.$actionListener.onFailure((Exception)new OpenSearchStatusException("Workflow not found", RestStatus.NOT_FOUND, new Object[0]));
                    } else {
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    public static final /* synthetic */ Logger access$getLog$p(TransportGetWorkflowAction $this) {
        return $this.log;
    }
}

