/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Locale;
import lombok.Generated;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNVectorFieldMapperUtil {
    public static void validateFP16VectorValue(float value) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value < KNNConstants.FP16_MIN_VALUE.floatValue() || value > KNNConstants.FP16_MAX_VALUE.floatValue()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "encoder name is set as [%s] and type is set as [%s] in index mapping. But, KNN vector values are not within in the FP16 range [%f, %f]", "sq", "fp16", KNNConstants.FP16_MIN_VALUE, KNNConstants.FP16_MAX_VALUE));
        }
    }

    public static float clipVectorValueToFP16Range(float value) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value < KNNConstants.FP16_MIN_VALUE.floatValue()) {
            return KNNConstants.FP16_MIN_VALUE.floatValue();
        }
        if (value > KNNConstants.FP16_MAX_VALUE.floatValue()) {
            return KNNConstants.FP16_MAX_VALUE.floatValue();
        }
        return value;
    }

    public static void validateVectorDataTypeWithEngine(ParametrizedFieldMapper.Parameter<VectorDataType> vectorDataType) {
        if (VectorDataType.FLOAT == vectorDataType.getValue()) {
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field with value [%s] is only supported for [%s] engine", "data_type", ((VectorDataType)((Object)vectorDataType.getValue())).getValue(), "lucene"));
    }

    public static void validateVectorDataTypeWithKnnIndexSetting(boolean knnIndexSetting, ParametrizedFieldMapper.Parameter<VectorDataType> vectorDataType) {
        if (VectorDataType.FLOAT == vectorDataType.getValue()) {
            return;
        }
        if (knnIndexSetting) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field with value [%s] is only supported for [%s] engine", "data_type", ((VectorDataType)((Object)vectorDataType.getValue())).getValue(), "lucene"));
        }
    }

    public static FieldType buildDocValuesFieldType(KNNEngine knnEngine) {
        FieldType field = new FieldType();
        field.putAttribute("engine", knnEngine.getName());
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    public static void addStoredFieldForVectorField(ParseContext context, FieldType fieldType, String mapperName, String vectorFieldAsString) {
        if (fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(mapperName, vectorFieldAsString));
        }
    }

    @Generated
    private KNNVectorFieldMapperUtil() {
    }
}

