/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BitSet;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.filtered.FilteredIdsKNNIterator;

public class NestedFilteredIdsKNNIterator
extends FilteredIdsKNNIterator {
    private final BitSet parentBitSet;

    public NestedFilteredIdsKNNIterator(BitSet filterIdsArray, float[] queryVector, BinaryDocValues values, SpaceType spaceType, BitSet parentBitSet) {
        super(filterIdsArray, queryVector, values, spaceType);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.docId);
        int bestChild = -1;
        while (this.docId != Integer.MAX_VALUE && this.docId < currentParent) {
            this.binaryDocValues.advance(this.docId);
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.docId;
                this.currentScore = score;
            }
            this.docId = this.bitSetIterator.nextDoc();
        }
        return bestChild;
    }
}

