/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.text;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;

public final class TextFunction {
    private static String EMPTY_STRING = "";

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(TextFunction.ascii());
        repository.register(TextFunction.concat());
        repository.register(TextFunction.concat_ws());
        repository.register(TextFunction.left());
        repository.register(TextFunction.length());
        repository.register(TextFunction.locate());
        repository.register(TextFunction.lower());
        repository.register(TextFunction.ltrim());
        repository.register(TextFunction.position());
        repository.register(TextFunction.replace());
        repository.register(TextFunction.reverse());
        repository.register(TextFunction.right());
        repository.register(TextFunction.rtrim());
        repository.register(TextFunction.strcmp());
        repository.register(TextFunction.substr());
        repository.register(TextFunction.substring());
        repository.register(TextFunction.trim());
        repository.register(TextFunction.upper());
    }

    private static DefaultFunctionResolver substringSubstr(FunctionName functionName) {
        return FunctionDSL.define(functionName, FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprSubstrStart), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprSubstrStartLength), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver substring() {
        return TextFunction.substringSubstr(BuiltinFunctionName.SUBSTRING.getName());
    }

    private static DefaultFunctionResolver substr() {
        return TextFunction.substringSubstr(BuiltinFunctionName.SUBSTR.getName());
    }

    private static DefaultFunctionResolver ltrim() {
        return FunctionDSL.define(BuiltinFunctionName.LTRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().stripLeading())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver rtrim() {
        return FunctionDSL.define(BuiltinFunctionName.RTRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().stripTrailing())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver trim() {
        return FunctionDSL.define(BuiltinFunctionName.TRIM.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().trim())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver lower() {
        return FunctionDSL.define(BuiltinFunctionName.LOWER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().toLowerCase())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver upper() {
        return FunctionDSL.define(BuiltinFunctionName.UPPER.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(v -> new ExprStringValue(v.stringValue().toUpperCase())), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver concat() {
        FunctionName concatFuncName = BuiltinFunctionName.CONCAT.getName();
        return FunctionDSL.define(concatFuncName, funcName -> Pair.of((Object)new FunctionSignature(concatFuncName, Collections.singletonList(ExprCoreType.ARRAY)), (funcProp, args) -> new FunctionExpression((FunctionName)funcName, args){

            @Override
            public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                List exprValues = args.stream().map(arg -> arg.valueOf(valueEnv)).collect(Collectors.toList());
                if (exprValues.stream().anyMatch(ExprValue::isMissing)) {
                    return ExprValueUtils.missingValue();
                }
                if (exprValues.stream().anyMatch(ExprValue::isNull)) {
                    return ExprValueUtils.nullValue();
                }
                return new ExprStringValue(exprValues.stream().map(ExprValue::stringValue).collect(Collectors.joining()));
            }

            @Override
            public ExprType type() {
                return ExprCoreType.STRING;
            }
        }));
    }

    private static DefaultFunctionResolver concat_ws() {
        return FunctionDSL.define(BuiltinFunctionName.CONCAT_WS.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((sep, str1, str2) -> new ExprStringValue(str1.stringValue() + sep.stringValue() + str2.stringValue())), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver length() {
        return FunctionDSL.define(BuiltinFunctionName.LENGTH.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(str -> new ExprIntegerValue(str.stringValue().getBytes().length)), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver strcmp() {
        return FunctionDSL.define(BuiltinFunctionName.STRCMP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((str1, str2) -> new ExprIntegerValue(Integer.compare(str1.stringValue().compareTo(str2.stringValue()), 0))), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver right() {
        return FunctionDSL.define(BuiltinFunctionName.RIGHT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprRight), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver left() {
        return FunctionDSL.define(BuiltinFunctionName.LEFT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprLeft), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver ascii() {
        return FunctionDSL.define(BuiltinFunctionName.ASCII.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprAscii), ExprCoreType.INTEGER, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver locate() {
        return FunctionDSL.define(BuiltinFunctionName.LOCATE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprLocate), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprLocate), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER));
    }

    private static DefaultFunctionResolver position() {
        return FunctionDSL.define(BuiltinFunctionName.POSITION.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprLocate), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver replace() {
        return FunctionDSL.define(BuiltinFunctionName.REPLACE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprReplace), ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver reverse() {
        return FunctionDSL.define(BuiltinFunctionName.REVERSE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(TextFunction::exprReverse), ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static ExprValue exprSubstrStart(ExprValue exprValue, ExprValue start) {
        int startIdx = start.integerValue();
        if (startIdx == 0) {
            return new ExprStringValue(EMPTY_STRING);
        }
        String str = exprValue.stringValue();
        return TextFunction.exprSubStr(str, startIdx, str.length());
    }

    private static ExprValue exprSubstrStartLength(ExprValue exprValue, ExprValue start, ExprValue length) {
        int startIdx = start.integerValue();
        int len = length.integerValue();
        if (startIdx == 0 || len == 0) {
            return new ExprStringValue(EMPTY_STRING);
        }
        String str = exprValue.stringValue();
        return TextFunction.exprSubStr(str, startIdx, len);
    }

    private static ExprValue exprSubStr(String str, int start, int len) {
        int n = start = start > 0 ? start - 1 : str.length() + start;
        if (start > str.length()) {
            return new ExprStringValue(EMPTY_STRING);
        }
        if (start + len > str.length()) {
            return new ExprStringValue(str.substring(start));
        }
        return new ExprStringValue(str.substring(start, start + len));
    }

    private static ExprValue exprRight(ExprValue str, ExprValue len) {
        if (len.integerValue() <= 0) {
            return new ExprStringValue("");
        }
        String stringValue = str.stringValue();
        int left = Math.max(stringValue.length() - len.integerValue(), 0);
        return new ExprStringValue(str.stringValue().substring(left));
    }

    private static ExprValue exprLeft(ExprValue expr, ExprValue length) {
        String stringValue = expr.stringValue();
        int right = length.integerValue();
        return new ExprStringValue(stringValue.substring(0, Math.min(right, stringValue.length())));
    }

    private static ExprValue exprAscii(ExprValue expr) {
        return new ExprIntegerValue(expr.stringValue().length() == 0 ? 0 : (int)expr.stringValue().charAt(0));
    }

    private static ExprValue exprLocate(ExprValue subStr, ExprValue str) {
        return new ExprIntegerValue(str.stringValue().indexOf(subStr.stringValue()) + 1);
    }

    private static ExprValue exprLocate(ExprValue subStr, ExprValue str, ExprValue pos) {
        return new ExprIntegerValue(str.stringValue().indexOf(subStr.stringValue(), pos.integerValue() - 1) + 1);
    }

    private static ExprValue exprReplace(ExprValue str, ExprValue from, ExprValue to) {
        return new ExprStringValue(str.stringValue().replaceAll(from.stringValue(), to.stringValue()));
    }

    private static ExprValue exprReverse(ExprValue str) {
        return new ExprStringValue(new StringBuilder(str.stringValue()).reverse().toString());
    }

    @Generated
    private TextFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

