import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ActivateOrganizationsAccessCommand, se_ActivateOrganizationsAccessCommand } from "../protocols/Aws_query";
export { $Command };
export class ActivateOrganizationsAccessCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ActivateOrganizationsAccess", {})
    .n("CloudFormationClient", "ActivateOrganizationsAccessCommand")
    .f(void 0, void 0)
    .ser(se_ActivateOrganizationsAccessCommand)
    .de(de_ActivateOrganizationsAccessCommand)
    .build() {
}
