import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribePublisherCommand, se_DescribePublisherCommand } from "../protocols/Aws_query";
export { $Command };
export class DescribePublisherCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DescribePublisher", {})
    .n("CloudFormationClient", "DescribePublisherCommand")
    .f(void 0, void 0)
    .ser(se_DescribePublisherCommand)
    .de(de_DescribePublisherCommand)
    .build() {
}
