import { AwsSdkSigV4AuthInputConfig, AwsSdkSigV4AuthResolvedConfig, AwsSdkSigV4PreviouslyResolved } from "@aws-sdk/core";
import { HandlerExecutionContext, HttpAuthScheme, HttpAuthSchemeParameters, HttpAuthSchemeParametersProvider, HttpAuthSchemeProvider } from "@smithy/types";
import { CloudFormationClientResolvedConfig } from "../CloudFormationClient";
/**
 * @internal
 */
export interface CloudFormationHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
    region?: string;
}
/**
 * @internal
 */
export interface CloudFormationHttpAuthSchemeParametersProvider extends HttpAuthSchemeParametersProvider<CloudFormationClientResolvedConfig, HandlerExecutionContext, CloudFormationHttpAuthSchemeParameters, object> {
}
/**
 * @internal
 */
export declare const defaultCloudFormationHttpAuthSchemeParametersProvider: (config: CloudFormationClientResolvedConfig, context: HandlerExecutionContext, input: object) => Promise<CloudFormationHttpAuthSchemeParameters>;
/**
 * @internal
 */
export interface CloudFormationHttpAuthSchemeProvider extends HttpAuthSchemeProvider<CloudFormationHttpAuthSchemeParameters> {
}
/**
 * @internal
 */
export declare const defaultCloudFormationHttpAuthSchemeProvider: CloudFormationHttpAuthSchemeProvider;
/**
 * @internal
 */
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
    /**
     * experimentalIdentityAndAuth: Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    httpAuthSchemes?: HttpAuthScheme[];
    /**
     * experimentalIdentityAndAuth: Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    httpAuthSchemeProvider?: CloudFormationHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export interface HttpAuthSchemeResolvedConfig extends AwsSdkSigV4AuthResolvedConfig {
    /**
     * experimentalIdentityAndAuth: Configuration of HttpAuthSchemes for a client which provides default identity providers and signers per auth scheme.
     * @internal
     */
    readonly httpAuthSchemes: HttpAuthScheme[];
    /**
     * experimentalIdentityAndAuth: Configuration of an HttpAuthSchemeProvider for a client which resolves which HttpAuthScheme to use.
     * @internal
     */
    readonly httpAuthSchemeProvider: CloudFormationHttpAuthSchemeProvider;
}
/**
 * @internal
 */
export declare const resolveHttpAuthSchemeConfig: <T>(config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved) => T & HttpAuthSchemeResolvedConfig;
