import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
import {
  AutoDeployment,
  CallAs,
  Capability,
  DeploymentTargets,
  ManagedExecution,
  Parameter,
  PermissionModels,
  RegistryType,
  ResourceDefinition,
  RollbackConfiguration,
  StackSetOperationPreferences,
  Tag,
  TemplateConfiguration,
  ThirdPartyType,
} from "./models_0";
export interface SetTypeConfigurationOutput {
  ConfigurationArn?: string;
}
export interface SetTypeDefaultVersionInput {
  Arn?: string;
  Type?: RegistryType;
  TypeName?: string;
  VersionId?: string;
}
export interface SetTypeDefaultVersionOutput {}
export declare const ResourceSignalStatus: {
  readonly FAILURE: "FAILURE";
  readonly SUCCESS: "SUCCESS";
};
export type ResourceSignalStatus =
  (typeof ResourceSignalStatus)[keyof typeof ResourceSignalStatus];
export interface SignalResourceInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
  UniqueId: string | undefined;
  Status: ResourceSignalStatus | undefined;
}
export declare class ResourceScanLimitExceededException extends __BaseException {
  readonly name: "ResourceScanLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceScanLimitExceededException,
      __BaseException
    >
  );
}
export interface StartResourceScanInput {
  ClientRequestToken?: string;
}
export interface StartResourceScanOutput {
  ResourceScanId?: string;
}
export interface StopStackSetOperationInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs;
}
export interface StopStackSetOperationOutput {}
export interface TestTypeInput {
  Arn?: string;
  Type?: ThirdPartyType;
  TypeName?: string;
  VersionId?: string;
  LogDeliveryBucket?: string;
}
export interface TestTypeOutput {
  TypeVersionArn?: string;
}
export interface UpdateGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
  NewGeneratedTemplateName?: string;
  AddResources?: ResourceDefinition[];
  RemoveResources?: string[];
  RefreshAllResources?: boolean;
  TemplateConfiguration?: TemplateConfiguration;
}
export interface UpdateGeneratedTemplateOutput {
  GeneratedTemplateId?: string;
}
export interface UpdateStackInput {
  StackName: string | undefined;
  TemplateBody?: string;
  TemplateURL?: string;
  UsePreviousTemplate?: boolean;
  StackPolicyDuringUpdateBody?: string;
  StackPolicyDuringUpdateURL?: string;
  Parameters?: Parameter[];
  Capabilities?: Capability[];
  ResourceTypes?: string[];
  RoleARN?: string;
  RollbackConfiguration?: RollbackConfiguration;
  StackPolicyBody?: string;
  StackPolicyURL?: string;
  NotificationARNs?: string[];
  Tags?: Tag[];
  DisableRollback?: boolean;
  ClientRequestToken?: string;
  RetainExceptOnCreate?: boolean;
}
export interface UpdateStackOutput {
  StackId?: string;
}
export interface UpdateStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[];
  DeploymentTargets?: DeploymentTargets;
  Regions: string[] | undefined;
  ParameterOverrides?: Parameter[];
  OperationPreferences?: StackSetOperationPreferences;
  OperationId?: string;
  CallAs?: CallAs;
}
export interface UpdateStackInstancesOutput {
  OperationId?: string;
}
export interface UpdateStackSetInput {
  StackSetName: string | undefined;
  Description?: string;
  TemplateBody?: string;
  TemplateURL?: string;
  UsePreviousTemplate?: boolean;
  Parameters?: Parameter[];
  Capabilities?: Capability[];
  Tags?: Tag[];
  OperationPreferences?: StackSetOperationPreferences;
  AdministrationRoleARN?: string;
  ExecutionRoleName?: string;
  DeploymentTargets?: DeploymentTargets;
  PermissionModel?: PermissionModels;
  AutoDeployment?: AutoDeployment;
  OperationId?: string;
  Accounts?: string[];
  Regions?: string[];
  CallAs?: CallAs;
  ManagedExecution?: ManagedExecution;
}
export interface UpdateStackSetOutput {
  OperationId?: string;
}
export interface UpdateTerminationProtectionInput {
  EnableTerminationProtection: boolean | undefined;
  StackName: string | undefined;
}
export interface UpdateTerminationProtectionOutput {
  StackId?: string;
}
export interface ValidateTemplateInput {
  TemplateBody?: string;
  TemplateURL?: string;
}
export interface TemplateParameter {
  ParameterKey?: string;
  DefaultValue?: string;
  NoEcho?: boolean;
  Description?: string;
}
export interface ValidateTemplateOutput {
  Parameters?: TemplateParameter[];
  Description?: string;
  Capabilities?: Capability[];
  CapabilitiesReason?: string;
  DeclaredTransforms?: string[];
}
