/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_de extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Mittlere Greenwich-Zeit",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre-Normalzeit",
               "",
               "Acre-Sommerzeit",
               "",
               "Acre-Zeit",
               "",
            };
        final String[] Apia = new String[] {
               "Apia-Normalzeit",
               "",
               "Apia-Sommerzeit",
               "",
               "Apia-Zeit",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinseln-Normalzeit",
               "",
               "Cookinseln-Sommerzeit",
               "",
               "Cookinseln-Zeit",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubanische Normalzeit",
               "CST",
               "Kubanische Sommerzeit",
               "CDT",
               "Kubanische Zeit",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalzeit",
               "",
               "Fidschi-Sommerzeit",
               "",
               "Fidschi-Zeit",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Chowd-Normalzeit",
               "",
               "Chowd-Sommerzeit",
               "",
               "Chowd-Zeit",
               "",
            };
        final String[] Iran = new String[] {
               "Iranische Normalzeit",
               "",
               "Iranische Sommerzeit",
               "",
               "Iranische Zeit",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsker Normalzeit",
               "",
               "Omsker Sommerzeit",
               "",
               "Omsker Zeit",
               "",
            };
        final String[] Peru = new String[] {
               "Peruanische Normalzeit",
               "",
               "Peruanische Sommerzeit",
               "",
               "Peruanische Zeit",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "Casey-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilenische Normalzeit",
               "",
               "Chilenische Sommerzeit",
               "",
               "Chilenische Zeit",
               "",
            };
        final String[] China = new String[] {
               "Chinesische Normalzeit",
               "CST",
               "Chinesische Sommerzeit",
               "CDT",
               "Chinesische Zeit",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosinseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indische Normalzeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japanische Normalzeit",
               "JST",
               "Japanische Sommerzeit",
               "JDT",
               "Japanische Zeit",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreanische Normalzeit",
               "KST",
               "Koreanische Sommerzeit",
               "KST",
               "Koreanische Zeit",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalesische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalzeit",
               "SST",
               "Samoa-Sommerzeit",
               "SST",
               "Samoa-Zeit",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaische Normalzeit",
               "",
               "Tongaische Sommerzeit",
               "",
               "Tongaische Zeit",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon-Zeit",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalzeit",
               "",
               "Alaska-Sommerzeit",
               "",
               "Alaska-Zeit",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalzeit",
               "",
               "Amazonas-Sommerzeit",
               "",
               "Amazonas-Zeit",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr Normalzeit",
               "",
               "Anadyr Sommerzeit",
               "",
               "Anadyr Zeit",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalzeit",
               "HMT",
               "Azoren-Sommerzeit",
               "HMT",
               "Azoren-Zeit",
               "HMT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei-Darussalam-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Osterinsel-Normalzeit",
               "",
               "Osterinsel-Sommerzeit",
               "",
               "Osterinsel-Zeit",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelische Normalzeit",
               "IST",
               "Israelische Sommerzeit",
               "IDT",
               "Israelische Zeit",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalzeit",
               "MSK",
               "Moskauer Sommerzeit",
               "MSK",
               "Moskauer Zeit",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-Normalzeit",
               "",
               "Samara-Sommerzeit",
               "",
               "Samara-Zeit",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipeh-Normalzeit",
               "CST",
               "Taipeh-Sommerzeit",
               "CDT",
               "Taipeh-Zeit",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis-und-Futuna-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabische Normalzeit",
               "",
               "Arabische Sommerzeit",
               "",
               "Arabische Zeit",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenische Normalzeit",
               "",
               "Armenische Sommerzeit",
               "",
               "Armenische Zeit",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivianische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalzeit",
               "",
               "Chatham-Sommerzeit",
               "",
               "Chatham-Zeit",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordinierte Weltzeit",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgische Normalzeit",
               "",
               "Georgische Sommerzeit",
               "",
               "Georgische Zeit",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsker Normalzeit",
               "",
               "Irkutsker Sommerzeit",
               "",
               "Irkutsker Zeit",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalzeit",
               "",
               "Magadan-Sommerzeit",
               "",
               "Magadan-Zeit",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinsel-Normalzeit",
               "",
               "Norfolkinsel-Sommerzeit",
               "",
               "Norfolkinsel-Zeit",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando-de-Noronha-Normalzeit",
               "",
               "Fernando-de-Noronha-Sommerzeit",
               "",
               "Fernando-de-Noronha-Zeit",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonen-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayische Normalzeit",
               "",
               "Uruguayische Sommerzeit",
               "",
               "Uruguayische Zeit",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalzeit",
               "",
               "Vanuatu-Sommerzeit",
               "",
               "Vanuatu-Zeit",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsker Normalzeit",
               "",
               "Jakutsker Sommerzeit",
               "",
               "Jakutsker Zeit",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalzeit",
               "AST",
               "Atlantik-Sommerzeit",
               "ADT",
               "Atlantik-Zeit",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia-Normalzeit",
               "",
               "Bras\u00edlia-Sommerzeit",
               "",
               "Bras\u00edlia-Zeit",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Zeit",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbianische Normalzeit",
               "",
               "Kolumbianische Sommerzeit",
               "",
               "Kolumbianische Zeit",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinseln-Normalzeit",
               "",
               "Falklandinseln-Sommerzeit",
               "",
               "Falklandinseln-Zeit",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediven-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalzeit",
               "",
               "Ulaanbaatar-Sommerzeit",
               "",
               "Ulaanbaatar-Zeit",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanische Normalzeit",
               "PKT",
               "Pakistanische Sommerzeit",
               "PKST",
               "Pakistanische Zeit",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayische Normalzeit",
               "",
               "Paraguayische Sommerzeit",
               "",
               "Paraguayische Zeit",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-Normalzeit",
               "",
               "Sachalin-Sommerzeit",
               "",
               "Sachalin-Zeit",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinische Normalzeit",
               "",
               "Argentinische Sommerzeit",
               "",
               "Argentinische Zeit",
               "",
            };
        final String[] Christmas = new String[] {
               "Weihnachtsinsel-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-Normalzeit",
               "HKT",
               "Hongkong-Sommerzeit",
               "HKST",
               "Hongkong-Zeit",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochina-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalzeit",
               "",
               "Kamtschatka-Sommerzeit",
               "",
               "Kamtschatka-Zeit",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalzeit",
               "",
               "Lord-Howe-Sommerzeit",
               "",
               "Lord-Howe-Zeit",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalzeit",
               "",
               "Mauritius-Sommerzeit",
               "",
               "Mauritius-Zeit",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapurische Normalzeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograder Normalzeit",
               "MSK",
               "Wolgograder Sommerzeit",
               "MSK",
               "Wolgograder Zeit",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanische Normalzeit",
               "",
               "Aserbaidschanische Sommerzeit",
               "",
               "Aserbaidschanische Zeit",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalzeit",
               "",
               "Bangladesch-Sommerzeit",
               "",
               "Bangladesch-Zeit",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cabo-Verde-Normalzeit",
               "",
               "Cabo-Verde-Sommerzeit",
               "",
               "Cabo-Verde-Zeit",
               "",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalzeit",
               "",
               "Usbekistan-Sommerzeit",
               "",
               "Usbekistan-Zeit",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsker Normalzeit",
               "",
               "Krasnojarsker Sommerzeit",
               "",
               "Krasnojarsker Zeit",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Neuseeland-Normalzeit",
               "NZST",
               "Neuseeland-Sommerzeit",
               "NZDT",
               "Neuseeland-Zeit",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsker Normalzeit",
               "",
               "Nowosibirsker Sommerzeit",
               "",
               "Nowosibirsker Zeit",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippinische Normalzeit",
               "PST",
               "Philippinische Sommerzeit",
               "PDT",
               "Philippinische Zeit",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostoker Normalzeit",
               "",
               "Wladiwostoker Sommerzeit",
               "",
               "Wladiwostoker Zeit",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indischer-Ozean-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linieninseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Neufundland-Normalzeit",
               "NST",
               "Neufundland-Sommerzeit",
               "NDT",
               "Neufundland-Zeit",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalzeit",
               "",
               "Turkmenistan-Sommerzeit",
               "",
               "Turkmenistan-Zeit",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Franz\u00f6sisch-Guayana-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Neukaledonische Normalzeit",
               "",
               "Neukaledonische Sommerzeit",
               "",
               "Neukaledonische Zeit",
               "",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburger Normalzeit",
               "",
               "Jekaterinburger Sommerzeit",
               "",
               "Jekaterinburger Zeit",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Zentralafrikanische Zeit",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanische Zeit",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanische Normalzeit",
               "WAT",
               "Westafrikanische Sommerzeit",
               "WAT",
               "Westafrikanische Zeit",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Mitteleurop\u00e4ische Normalzeit",
               "MEZ",
               "Mitteleurop\u00e4ische Sommerzeit",
               "MESZ",
               "Mitteleurop\u00e4ische Zeit",
               "MEZ",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4ische Normalzeit",
               "OEZ",
               "Osteurop\u00e4ische Sommerzeit",
               "OESZ",
               "Osteurop\u00e4ische Zeit",
               "OEZ",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4ische Normalzeit",
               "WEZ",
               "Westeurop\u00e4ische Sommerzeit",
               "WESZ",
               "Westeurop\u00e4ische Zeit",
               "WEZ",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikanische Pazifik-Normalzeit",
               "MST",
               "Mexikanische Pazifik-Sommerzeit",
               "MDT",
               "Mexikanische Pazifikzeit",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanische Zeit",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanische Zentral-Normalzeit",
               "CST",
               "Nordamerikanische Zentral-Sommerzeit",
               "CDT",
               "Nordamerikanische Zentralzeit",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanische Ostk\u00fcsten-Normalzeit",
               "EST",
               "Nordamerikanische Ostk\u00fcsten-Sommerzeit",
               "EST",
               "Nordamerikanische Ostk\u00fcstenzeit",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanische Westk\u00fcsten-Normalzeit",
               "PST",
               "Nordamerikanische Westk\u00fcsten-Sommerzeit",
               "PDT",
               "Nordamerikanische Westk\u00fcstenzeit",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franz\u00f6sische-S\u00fcd-und-Antarktisgebiete-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalzeit",
               "HST",
               "Hawaii-Aleuten-Sommerzeit",
               "HST",
               "Hawaii-Aleuten-Zeit",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St.-Pierre-und-Miquelon-Normalzeit",
               "",
               "St.-Pierre-und-Miquelon-Sommerzeit",
               "",
               "St.-Pierre-und-Miquelon-Zeit",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Rocky-Mountain-Normalzeit",
               "MST",
               "Rocky-Mountain-Sommerzeit",
               "MDT",
               "Rocky-Mountain-Zeit",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinseln-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Nordwestmexiko-Normalzeit",
               "",
               "Nordwestmexiko-Sommerzeit",
               "",
               "Nordwestmexiko-Zeit",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neuguinea-Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralische Normalzeit",
               "ACST",
               "Zentralaustralische Sommerzeit",
               "ACDT",
               "Zentralaustralische Zeit",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralische Normalzeit",
               "AEST",
               "Ostaustralische Sommerzeit",
               "AEDT",
               "Ostaustralische Zeit",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralische Normalzeit",
               "",
               "Westaustralische Sommerzeit",
               "",
               "Westaustralische Zeit",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ostgr\u00f6nland-Normalzeit",
               "",
               "Ostgr\u00f6nland-Sommerzeit",
               "",
               "Ostgr\u00f6nland-Zeit",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Westgr\u00f6nland-Normalzeit",
               "",
               "Westgr\u00f6nland-Sommerzeit",
               "",
               "Westgr\u00f6nland-Zeit",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesische Zeit",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesische Zeit",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesische Zeit",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ostkasachische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachische Zeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralische Normalzeit",
               "",
               "Zentral-/Westaustralische Sommerzeit",
               "",
               "Zentral-/Westaustralische Zeit",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Mittlere Greenwich-Zeit",
                    "GMT",
                    "Irische Sommerzeit",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Mittlere Greenwich-Zeit",
                    "GMT",
                    "Britische Sommerzeit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Mittlere Greenwich-Zeit",
                    "GMT",
                    "Britische Sommerzeit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Chowd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Chita", "Tschita" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Brunei", "Brunei Darussalam" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho-Chi-Minh-Stadt" },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Unbekannt" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "timezone.excity.Asia/Karachi", "Karatschi" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Eriwan" },
            { "timezone.excity.Europe/Kirov", "Kirow" },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Asia/Ashgabat", "A\u015fgabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Qostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskau" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komoren" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Kaimaninseln" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "timezone.excity.Asia/Pyongyang", "Pj\u00f6ngjang" },
            { "timezone.excity.Asia/Qyzylorda", "Qysylorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Saratov", "Saratow" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Pacific/Easter", "Osterinsel" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Asia/Choibalsan", "Tschoibalsan" },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Atlantic/Canary", "Kanaren" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4r\u00f6er" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Uzhgorod", "Uschgorod" },
            { "timezone.excity.Indian/Maldives", "Malediven" },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Europe/Astrakhan", "Astrachan" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanowsk" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Weihnachtsinsel" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznetsk" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Zaporozhye", "Saporischschja" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reyk\u00adja\u00adv\u00edk" },
            { "timezone.excity.America/Mexico_City", "Mexiko-Stadt" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daressalam" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00fcdgeorgien" },
        };
        return data;
    }
}
