/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.env.Environment;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.configuration.ConfigUpdateAlreadyInProgressException;
import org.opensearch.security.configuration.ConfigurationChangeListener;
import org.opensearch.security.configuration.ConfigurationLoaderSecurity7;
import org.opensearch.security.configuration.InvalidConfigException;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.support.ConfigHelper;
import org.opensearch.security.support.SecurityUtils;
import org.opensearch.threadpool.ThreadPool;

public class ConfigurationRepository {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationRepository.class);
    private final String securityIndex;
    private final Client client;
    private final Cache<CType, SecurityDynamicConfiguration<?>> configCache;
    private final List<ConfigurationChangeListener> configurationChangedListener;
    private final ConfigurationLoaderSecurity7 cl;
    private final Settings settings;
    private final Path configPath;
    private final ClusterService clusterService;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private DynamicConfigFactory dynamicConfigFactory;
    public static final int DEFAULT_CONFIG_VERSION = 2;
    private final CompletableFuture<Void> initalizeConfigTask = new CompletableFuture();
    private final boolean acceptInvalid;
    private final Lock LOCK = new ReentrantLock();

    private ConfigurationRepository(Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog) {
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.settings = settings;
        this.configPath = configPath;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.auditLog = auditLog;
        this.configurationChangedListener = new ArrayList<ConfigurationChangeListener>();
        this.acceptInvalid = settings.getAsBoolean("plugins.security.unsupported.accept_invalid_config", Boolean.valueOf(false));
        this.cl = new ConfigurationLoaderSecurity7(client, threadPool, settings, clusterService);
        this.configCache = CacheBuilder.newBuilder().build();
    }

    private void initalizeClusterConfiguration(boolean installDefaultConfig) {
        try {
            boolean isAuditConfigDocPresentInIndex;
            Set<String> deprecatedAuditKeysInSettings;
            block24: {
                LOGGER.info("Background init thread started. Install default config?: " + installDefaultConfig);
                while (this.clusterService.state().blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
                    LOGGER.info("Wait for cluster to be available ...");
                    TimeUnit.SECONDS.sleep(1L);
                }
                if (installDefaultConfig) {
                    try {
                        String lookupDir = System.getProperty("security.default_init.dir");
                        String cd = lookupDir != null ? lookupDir + "/" : new Environment(this.settings, this.configPath).configFile().toAbsolutePath().toString() + "/opensearch-security/";
                        File confFile = new File(cd + "config.yml");
                        if (confFile.exists()) {
                            ThreadContext threadContext = this.threadPool.getThreadContext();
                            try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                                threadContext.putHeader("_opendistro_security_conf_request", "true");
                                this.createSecurityIndexIfAbsent();
                                this.waitForSecurityIndexToBeAtLeastYellow();
                                int initializationDelaySeconds = this.settings.getAsInt("plugins.security.unsupported.delay_initialization_seconds", Integer.valueOf(0));
                                if (initializationDelaySeconds > 0) {
                                    LOGGER.error("Test setting loaded to delay initialization for {} seconds", (Object)initializationDelaySeconds);
                                    TimeUnit.SECONDS.sleep(initializationDelaySeconds);
                                }
                                ConfigHelper.uploadFile(this.client, cd + "config.yml", this.securityIndex, CType.CONFIG, 2);
                                ConfigHelper.uploadFile(this.client, cd + "roles.yml", this.securityIndex, CType.ROLES, 2);
                                ConfigHelper.uploadFile(this.client, cd + "roles_mapping.yml", this.securityIndex, CType.ROLESMAPPING, 2);
                                ConfigHelper.uploadFile(this.client, cd + "internal_users.yml", this.securityIndex, CType.INTERNALUSERS, 2);
                                ConfigHelper.uploadFile(this.client, cd + "action_groups.yml", this.securityIndex, CType.ACTIONGROUPS, 2);
                                ConfigHelper.uploadFile(this.client, cd + "tenants.yml", this.securityIndex, CType.TENANTS, 2);
                                boolean populateEmptyIfFileMissing = true;
                                ConfigHelper.uploadFile(this.client, cd + "nodes_dn.yml", this.securityIndex, CType.NODESDN, 2, true);
                                ConfigHelper.uploadFile(this.client, cd + "whitelist.yml", this.securityIndex, CType.WHITELIST, 2, true);
                                ConfigHelper.uploadFile(this.client, cd + "allowlist.yml", this.securityIndex, CType.ALLOWLIST, 2, true);
                                String auditConfigPath = cd + "audit.yml";
                                if (new File(auditConfigPath).exists()) {
                                    ConfigHelper.uploadFile(this.client, auditConfigPath, this.securityIndex, CType.AUDIT, 2);
                                }
                                break block24;
                            }
                        }
                        LOGGER.error("{} does not exist", (Object)confFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot apply default config (this is maybe not an error!)", (Throwable)e);
                    }
                }
            }
            while (!this.dynamicConfigFactory.isInitialized()) {
                try {
                    LOGGER.debug("Try to load config ...");
                    this.reloadConfiguration(Arrays.asList(CType.values()), true);
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to load configuration due to {}", (Object)String.valueOf(ExceptionUtils.getRootCause(e)));
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("Thread was interrupted so we cancel initialization");
                    }
                }
                break;
            }
            if (!(deprecatedAuditKeysInSettings = AuditConfig.getDeprecatedKeys(this.settings)).isEmpty()) {
                LOGGER.warn("Following keys {} are deprecated in opensearch settings. They will be removed in plugin v2.0.0.0", deprecatedAuditKeysInSettings);
            }
            if (isAuditConfigDocPresentInIndex = this.cl.isAuditConfigDocPresentInIndex()) {
                if (!deprecatedAuditKeysInSettings.isEmpty()) {
                    LOGGER.warn("Audit configuration settings found in both index and opensearch settings (deprecated)");
                }
                LOGGER.info("Hot-reloading of audit configuration is enabled");
            } else {
                LOGGER.info("Hot-reloading of audit configuration is disabled. Using configuration with defaults from opensearch settings.  Populate the configuration in index using audit.yml or securityadmin to enable it.");
                this.auditLog.setConfig(AuditConfig.from(this.settings));
            }
            LOGGER.info("Node '{}' initialized", (Object)this.clusterService.localNode().getName());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while initializing node " + e, (Throwable)e);
        }
    }

    private boolean createSecurityIndexIfAbsent() {
        try {
            ImmutableMap indexSettings = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-all");
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(this.securityIndex).settings((Map)indexSettings);
            boolean ok = ((CreateIndexResponse)this.client.admin().indices().create(createIndexRequest).actionGet()).isAcknowledged();
            LOGGER.info("Index {} created?: {}", (Object)this.securityIndex, (Object)ok);
            return ok;
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            LOGGER.info("Index {} already exists", (Object)this.securityIndex);
            return false;
        }
    }

    private void waitForSecurityIndexToBeAtLeastYellow() {
        LOGGER.info("Node started, try to initialize it. Wait for at least yellow cluster state....");
        ClusterHealthResponse response = null;
        try {
            response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(new String[]{this.securityIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
        }
        catch (Exception e) {
            LOGGER.debug("Caught a {} but we just try again ...", (Object)e.toString());
        }
        while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
            LOGGER.debug("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)this.securityIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(new String[]{this.securityIndex}).waitForYellowStatus()).actionGet();
            }
            catch (Exception e) {
                LOGGER.debug("Caught again a {} but we just try again ...", (Object)e.toString());
            }
        }
    }

    public CompletableFuture<Boolean> initOnNodeStart() {
        boolean installDefaultConfig = this.settings.getAsBoolean("plugins.security.allow_default_init_securityindex", Boolean.valueOf(false));
        Supplier<CompletableFuture> startInitialization = () -> {
            new Thread(() -> {
                this.initalizeClusterConfiguration(installDefaultConfig);
                this.initalizeConfigTask.complete(null);
            }).start();
            return this.initalizeConfigTask.thenApply(result -> installDefaultConfig);
        };
        try {
            if (installDefaultConfig) {
                LOGGER.info("Will attempt to create index {} and default configs if they are absent", (Object)this.securityIndex);
                return startInitialization.get();
            }
            if (this.settings.getAsBoolean("plugins.security.background_init_if_securityindex_not_exist", Boolean.valueOf(true)).booleanValue()) {
                LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Use securityadmin to initialize cluster", (Object)this.securityIndex);
                return startInitialization.get();
            }
            LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Will not perform background initialization", (Object)this.securityIndex);
            this.initalizeConfigTask.complete(null);
            return this.initalizeConfigTask.thenApply(result -> installDefaultConfig);
        }
        catch (Throwable e2) {
            LOGGER.error("Error during node initialization: {}", (Object)e2, (Object)e2);
            return startInitialization.get();
        }
    }

    public boolean isAuditHotReloadingEnabled() {
        return this.cl.isAuditConfigDocPresentInIndex();
    }

    public static ConfigurationRepository create(Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog) {
        ConfigurationRepository repository = new ConfigurationRepository(settings, configPath, threadPool, client, clusterService, auditLog);
        return repository;
    }

    public void setDynamicConfigFactory(DynamicConfigFactory dynamicConfigFactory) {
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    public SecurityDynamicConfiguration<?> getConfiguration(CType configurationType) {
        SecurityDynamicConfiguration conf = (SecurityDynamicConfiguration)this.configCache.getIfPresent((Object)configurationType);
        if (conf != null) {
            return conf.deepClone();
        }
        return SecurityDynamicConfiguration.empty();
    }

    public boolean reloadConfiguration(Collection<CType> configTypes) throws ConfigUpdateAlreadyInProgressException {
        return this.reloadConfiguration(configTypes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean reloadConfiguration(Collection<CType> configTypes, boolean fromBackgroundThread) throws ConfigUpdateAlreadyInProgressException {
        if (!fromBackgroundThread && !this.initalizeConfigTask.isDone()) {
            LOGGER.warn("Unable to reload configuration, initalization thread has not yet completed.");
            return false;
        }
        if (!this.LOCK.tryLock(60L, TimeUnit.SECONDS)) throw new ConfigUpdateAlreadyInProgressException("A config update is already in progress", new Object[0]);
        try {
            this.reloadConfiguration0(configTypes, this.acceptInvalid);
            boolean bl = true;
            this.LOCK.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.LOCK.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConfigUpdateAlreadyInProgressException("Interrupted config update", new Object[0]);
            }
        }
    }

    private void reloadConfiguration0(Collection<CType> configTypes, boolean acceptInvalid) {
        Map<CType, SecurityDynamicConfiguration<?>> loaded = this.getConfigurationsFromIndex(configTypes, false, acceptInvalid);
        this.configCache.putAll(loaded);
        this.notifyAboutChanges(loaded);
    }

    public synchronized void subscribeOnChange(ConfigurationChangeListener listener) {
        this.configurationChangedListener.add(listener);
    }

    private synchronized void notifyAboutChanges(Map<CType, SecurityDynamicConfiguration<?>> typeToConfig) {
        for (ConfigurationChangeListener listener : this.configurationChangedListener) {
            try {
                LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener);
                listener.onChange(typeToConfig);
            }
            catch (Exception e) {
                LOGGER.error("{} listener errored: " + e, (Object)listener, (Object)e);
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }
    }

    public Map<CType, SecurityDynamicConfiguration<?>> getConfigurationsFromIndex(Collection<CType> configTypes, boolean logComplianceEvent) {
        return this.getConfigurationsFromIndex(configTypes, logComplianceEvent, this.acceptInvalid);
    }

    public Map<CType, SecurityDynamicConfiguration<?>> getConfigurationsFromIndex(Collection<CType> configTypes, boolean logComplianceEvent, boolean acceptInvalid) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        HashMap retVal = new HashMap();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            MappingMetadata mappingMetadata;
            threadContext.putHeader("_opendistro_security_conf_request", "true");
            IndexMetadata securityMetadata = this.clusterService.state().metadata().index(this.securityIndex);
            MappingMetadata mappingMetadata2 = mappingMetadata = securityMetadata == null ? null : securityMetadata.mapping();
            if (securityMetadata != null && mappingMetadata != null) {
                if ("security".equals(mappingMetadata.type())) {
                    LOGGER.debug("security index exists and was created before ES 7 (legacy layout)");
                } else {
                    LOGGER.debug("security index exists and was created with ES 7 (new layout)");
                }
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 10L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            } else {
                LOGGER.debug("security index not exists (yet)");
                retVal.putAll(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 10L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            }
        }
        catch (Exception e) {
            throw new OpenSearchException((Throwable)e);
        }
        if (logComplianceEvent && this.auditLog.getComplianceConfig() != null && this.auditLog.getComplianceConfig().isEnabled()) {
            CType configurationType = configTypes.iterator().next();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put(configurationType.toLCString(), Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)((ToXContent)retVal.get((Object)configurationType))));
            this.auditLog.logDocumentRead(this.securityIndex, configurationType.toLCString(), null, fields);
        }
        return retVal;
    }

    private Map<CType, SecurityDynamicConfiguration<?>> validate(Map<CType, SecurityDynamicConfiguration<?>> conf, int expectedSize) throws InvalidConfigException {
        if (conf == null || conf.size() != expectedSize) {
            throw new InvalidConfigException("Retrieved only partial configuration");
        }
        return conf;
    }

    private static String formatDate(long date) {
        return new SimpleDateFormat("yyyy-MM-dd", SecurityUtils.EN_Locale).format(new Date(date));
    }

    public static int getDefaultConfigVersion() {
        return 2;
    }
}

