/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.InetAddress;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.security.auth.AuthDomain;
import org.opensearch.security.auth.AuthFailureListener;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.Destroyable;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;
import org.opensearch.security.auth.internal.NoOpAuthenticationBackend;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.http.OnBehalfOfAuthenticator;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.support.ReflectionHelper;
import org.opensearch.security.util.AuthTokenUtils;

public class DynamicConfigModelV7
extends DynamicConfigModel {
    private final ConfigV7 config;
    private final Settings opensearchSettings;
    private final Path configPath;
    private SortedSet<AuthDomain> restAuthDomains;
    private Set<AuthorizationBackend> restAuthorizers;
    private List<Destroyable> destroyableComponents;
    private final InternalAuthenticationBackend iab;
    private List<AuthFailureListener> ipAuthFailureListeners;
    private Multimap<String, AuthFailureListener> authBackendFailureListeners;
    private List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;
    private Multimap<String, ClientBlockRegistry<String>> authBackendClientBlockRegistries;
    private final ClusterInfoHolder cih;

    public DynamicConfigModelV7(ConfigV7 config, Settings opensearchSettings, Path configPath, InternalAuthenticationBackend iab, ClusterInfoHolder cih) {
        this.config = config;
        this.opensearchSettings = opensearchSettings;
        this.configPath = configPath;
        this.iab = iab;
        this.cih = cih;
        this.buildAAA();
    }

    @Override
    public SortedSet<AuthDomain> getRestAuthDomains() {
        return Collections.unmodifiableSortedSet(this.restAuthDomains);
    }

    @Override
    public Set<AuthorizationBackend> getRestAuthorizers() {
        return Collections.unmodifiableSet(this.restAuthorizers);
    }

    @Override
    public boolean isAnonymousAuthenticationEnabled() {
        return this.config.dynamic.http.anonymous_auth_enabled;
    }

    @Override
    public boolean isXffEnabled() {
        return this.config.dynamic.http.xff.enabled;
    }

    @Override
    public String getInternalProxies() {
        return this.config.dynamic.http.xff.internalProxies;
    }

    @Override
    public String getRemoteIpHeader() {
        return this.config.dynamic.http.xff.remoteIpHeader;
    }

    @Override
    public boolean isRestAuthDisabled() {
        return this.config.dynamic.disable_rest_auth;
    }

    @Override
    public boolean isInterTransportAuthDisabled() {
        return this.config.dynamic.disable_intertransport_auth;
    }

    @Override
    public boolean isRespectRequestIndicesEnabled() {
        return this.config.dynamic.respect_request_indices_options;
    }

    @Override
    public String getDashboardsServerUsername() {
        return this.config.dynamic.kibana.server_username;
    }

    @Override
    public String getDashboardsOpenSearchRole() {
        return this.config.dynamic.kibana.opendistro_role;
    }

    @Override
    public String getDashboardsIndexname() {
        return this.config.dynamic.kibana.index;
    }

    @Override
    public boolean isDashboardsMultitenancyEnabled() {
        return this.config.dynamic.kibana.multitenancy_enabled;
    }

    @Override
    public boolean isDashboardsPrivateTenantEnabled() {
        return this.config.dynamic.kibana.private_tenant_enabled;
    }

    @Override
    public String getDashboardsDefaultTenant() {
        return this.config.dynamic.kibana.default_tenant;
    }

    @Override
    public boolean isDnfofEnabled() {
        return this.config.dynamic.do_not_fail_on_forbidden;
    }

    @Override
    public boolean isMultiRolespanEnabled() {
        return this.config.dynamic.multi_rolespan_enabled;
    }

    @Override
    public String getFilteredAliasMode() {
        return this.config.dynamic.filtered_alias_mode;
    }

    @Override
    public String getHostsResolverMode() {
        return this.config.dynamic.hosts_resolver_mode;
    }

    @Override
    public boolean isDnfofForEmptyResultsEnabled() {
        return this.config.dynamic.do_not_fail_on_forbidden_empty;
    }

    @Override
    public List<AuthFailureListener> getIpAuthFailureListeners() {
        return Collections.unmodifiableList(this.ipAuthFailureListeners);
    }

    @Override
    public Multimap<String, AuthFailureListener> getAuthBackendFailureListeners() {
        return Multimaps.unmodifiableMultimap(this.authBackendFailureListeners);
    }

    @Override
    public List<ClientBlockRegistry<InetAddress>> getIpClientBlockRegistries() {
        return Collections.unmodifiableList(this.ipClientBlockRegistries);
    }

    @Override
    public Multimap<String, ClientBlockRegistry<String>> getAuthBackendClientBlockRegistries() {
        return Multimaps.unmodifiableMultimap(this.authBackendClientBlockRegistries);
    }

    @Override
    public Settings getDynamicOnBehalfOfSettings() {
        return Settings.builder().put(Settings.builder().loadFromSource(this.config.dynamic.on_behalf_of.configAsJson(), (MediaType)XContentType.JSON).build()).build();
    }

    private void buildAAA() {
        TreeSet<AuthDomain> restAuthDomains0 = new TreeSet<AuthDomain>();
        HashSet<InternalAuthenticationBackend> restAuthorizers0 = new HashSet<InternalAuthenticationBackend>();
        LinkedList<Destroyable> destroyableComponents0 = new LinkedList<Destroyable>();
        ArrayList<AuthFailureListener> ipAuthFailureListeners0 = new ArrayList<AuthFailureListener>();
        ArrayListMultimap authBackendFailureListeners0 = ArrayListMultimap.create();
        ArrayList<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries0 = new ArrayList<ClientBlockRegistry<InetAddress>>();
        ArrayListMultimap authBackendClientBlockRegistries0 = ArrayListMultimap.create();
        ConfigV7.Authz authzDyn = this.config.dynamic.authz;
        for (Map.Entry<String, ConfigV7.AuthzDomain> entry : authzDyn.getDomains().entrySet()) {
            boolean bl = entry.getValue().http_enabled;
            if (!bl) continue;
            try {
                AuthorizationBackend authorizationBackend;
                String authzBackendClazz = entry.getValue().authorization_backend.type;
                if (authzBackendClazz.equals(InternalAuthenticationBackend.class.getName()) || authzBackendClazz.equals("internal") || authzBackendClazz.equals("intern")) {
                    authorizationBackend = this.iab;
                    ReflectionHelper.addLoadedModule(InternalAuthenticationBackend.class);
                } else {
                    authorizationBackend = (AuthorizationBackend)this.newInstance(authzBackendClazz, "z", Settings.builder().put(this.opensearchSettings).put(Settings.builder().loadFromSource(entry.getValue().authorization_backend.configAsJson(), (MediaType)XContentType.JSON).build()).build(), this.configPath);
                }
                if (bl) {
                    restAuthorizers0.add((InternalAuthenticationBackend)authorizationBackend);
                }
                if (!(authorizationBackend instanceof Destroyable)) continue;
                destroyableComponents0.add((Destroyable)((Object)authorizationBackend));
            }
            catch (Exception e) {
                this.log.error("Unable to initialize AuthorizationBackend {} due to {}", entry, (Object)e.toString(), (Object)e);
            }
        }
        ConfigV7.Authc authcDyn = this.config.dynamic.authc;
        for (Map.Entry<String, ConfigV7.AuthcDomain> entry : authcDyn.getDomains().entrySet()) {
            boolean httpEnabled = entry.getValue().http_enabled;
            if (!httpEnabled) continue;
            try {
                AuthenticationBackend authenticationBackend;
                String authBackendClazz = entry.getValue().authentication_backend.type;
                if (authBackendClazz.equals(InternalAuthenticationBackend.class.getName()) || authBackendClazz.equals("internal") || authBackendClazz.equals("intern")) {
                    authenticationBackend = this.iab;
                    ReflectionHelper.addLoadedModule(InternalAuthenticationBackend.class);
                } else {
                    authenticationBackend = (AuthenticationBackend)this.newInstance(authBackendClazz, "c", Settings.builder().put(this.opensearchSettings).put(Settings.builder().loadFromSource(entry.getValue().authentication_backend.configAsJson(), (MediaType)XContentType.JSON).build()).build(), this.configPath);
                }
                String httpAuthenticatorType = entry.getValue().http_authenticator.type;
                HTTPAuthenticator httpAuthenticator = httpAuthenticatorType == null ? null : (HTTPAuthenticator)this.newInstance(httpAuthenticatorType, "h", Settings.builder().put(this.opensearchSettings).put(Settings.builder().loadFromSource(entry.getValue().http_authenticator.configAsJson(), (MediaType)XContentType.JSON).build()).build(), this.configPath);
                AuthDomain _ad = new AuthDomain(authenticationBackend, httpAuthenticator, entry.getValue().http_authenticator.challenge, entry.getValue().order);
                if (httpEnabled && _ad.getHttpAuthenticator() != null) {
                    restAuthDomains0.add(_ad);
                }
                if (httpAuthenticator instanceof Destroyable) {
                    destroyableComponents0.add((Destroyable)((Object)httpAuthenticator));
                }
                if (!(authenticationBackend instanceof Destroyable)) continue;
                destroyableComponents0.add((Destroyable)((Object)authenticationBackend));
            }
            catch (Exception e) {
                this.log.error("Unable to initialize auth domain {} due to {}", entry, (Object)e.toString(), (Object)e);
            }
        }
        Settings settings = this.getDynamicOnBehalfOfSettings();
        if (!AuthTokenUtils.isKeyNull(settings, "signing_key").booleanValue() && !AuthTokenUtils.isKeyNull(settings, "encryption_key").booleanValue()) {
            AuthDomain authDomain = new AuthDomain(new NoOpAuthenticationBackend(Settings.EMPTY, null), new OnBehalfOfAuthenticator(this.getDynamicOnBehalfOfSettings(), this.cih.getClusterName()), false, -1);
            restAuthDomains0.add(authDomain);
        }
        List<Destroyable> list = this.destroyableComponents;
        this.restAuthDomains = Collections.unmodifiableSortedSet(restAuthDomains0);
        this.restAuthorizers = Collections.unmodifiableSet(restAuthorizers0);
        this.destroyableComponents = Collections.unmodifiableList(destroyableComponents0);
        if (list != null) {
            this.destroyDestroyables(list);
        }
        Object var11_17 = null;
        this.createAuthFailureListeners(ipAuthFailureListeners0, (Multimap<String, AuthFailureListener>)authBackendFailureListeners0, ipClientBlockRegistries0, (Multimap<String, ClientBlockRegistry<String>>)authBackendClientBlockRegistries0, destroyableComponents0);
        this.ipAuthFailureListeners = Collections.unmodifiableList(ipAuthFailureListeners0);
        this.ipClientBlockRegistries = Collections.unmodifiableList(ipClientBlockRegistries0);
        this.authBackendClientBlockRegistries = Multimaps.unmodifiableMultimap((Multimap)authBackendClientBlockRegistries0);
        this.authBackendFailureListeners = Multimaps.unmodifiableMultimap((Multimap)authBackendFailureListeners0);
    }

    private void destroyDestroyables(List<Destroyable> destroyableComponents) {
        for (Destroyable destroyable : destroyableComponents) {
            try {
                destroyable.destroy();
            }
            catch (Exception e) {
                this.log.error("Error while destroying " + destroyable, (Throwable)e);
            }
        }
    }

    private <T> T newInstance(String clazzOrShortcut, String type, Settings settings, Path configPath) {
        String clazz = this.authImplMap.computeIfAbsent(clazzOrShortcut + "_" + type, k -> clazzOrShortcut);
        return (T)AccessController.doPrivileged(() -> {
            SpecialPermission.check();
            return ReflectionHelper.instantiateAAA(clazz, settings, configPath);
        });
    }

    private String translateShortcutToClassName(String clazzOrShortcut, String type) {
        if (this.authImplMap.containsKey(clazzOrShortcut + "_" + type)) {
            return (String)this.authImplMap.get(clazzOrShortcut + "_" + type);
        }
        return clazzOrShortcut;
    }

    private void createAuthFailureListeners(List<AuthFailureListener> ipAuthFailureListeners, Multimap<String, AuthFailureListener> authBackendFailureListeners, List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries, Multimap<String, ClientBlockRegistry<String>> authBackendUserClientBlockRegistries, List<Destroyable> destroyableComponents0) {
        for (Map.Entry<String, ConfigV7.AuthFailureListener> entry : this.config.dynamic.auth_failure_listeners.getListeners().entrySet()) {
            ClientBlockRegistry clientBlockRegistry;
            Settings entrySettings = Settings.builder().put(this.opensearchSettings).put(Settings.builder().loadFromSource(entry.getValue().asJson(), (MediaType)XContentType.JSON).build()).build();
            String type = entry.getValue().type;
            String authenticationBackend = entry.getValue().authentication_backend;
            AuthFailureListener authFailureListener = (AuthFailureListener)this.newInstance(type, "authFailureListener", entrySettings, this.configPath);
            if (Strings.isNullOrEmpty((String)authenticationBackend)) {
                ipAuthFailureListeners.add(authFailureListener);
                if (authFailureListener instanceof ClientBlockRegistry) {
                    if (InetAddress.class.isAssignableFrom(((ClientBlockRegistry)((Object)authFailureListener)).getClientIdType())) {
                        clientBlockRegistry = (ClientBlockRegistry)((Object)authFailureListener);
                        ipClientBlockRegistries.add(clientBlockRegistry);
                    } else {
                        this.log.error("Illegal ClientIdType for AuthFailureListener" + entry.getKey() + ": " + ((ClientBlockRegistry)((Object)authFailureListener)).getClientIdType() + "; must be InetAddress.");
                    }
                }
            } else {
                authenticationBackend = this.translateShortcutToClassName(authenticationBackend, "c");
                authBackendFailureListeners.put((Object)authenticationBackend, (Object)authFailureListener);
                if (authFailureListener instanceof ClientBlockRegistry) {
                    if (String.class.isAssignableFrom(((ClientBlockRegistry)((Object)authFailureListener)).getClientIdType())) {
                        clientBlockRegistry = (ClientBlockRegistry)((Object)authFailureListener);
                        authBackendUserClientBlockRegistries.put((Object)authenticationBackend, (Object)clientBlockRegistry);
                    } else {
                        this.log.error("Illegal ClientIdType for AuthFailureListener" + entry.getKey() + ": " + ((ClientBlockRegistry)((Object)authFailureListener)).getClientIdType() + "; must be InetAddress.");
                    }
                }
            }
            if (!(authFailureListener instanceof Destroyable)) continue;
            destroyableComponents0.add((Destroyable)((Object)authFailureListener));
        }
    }
}

